/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import java.io.PrintStream;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.Result;

public final class LDAPCompare
extends ConsoleApplication {
    private BooleanArgument verbose;

    public static void main(String[] args) {
        int retCode = new LDAPCompare().run(args);
        System.exit(Utils.filterExitCode((int)retCode));
    }

    private LDAPCompare() {
    }

    LDAPCompare(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    private int executeCompare(CompareRequest request, Connection connection) {
        this.println(ToolsMessages.INFO_PROCESSING_COMPARE_OPERATION.get((Object)request.getAttributeDescription().toString(), (Object)request.getAssertionValueAsString(), (Object)request.getName().toString()));
        if (connection != null) {
            try {
                CompareResult result = connection.compare(request);
                if (result.getResultCode() == ResultCode.COMPARE_FALSE) {
                    this.println(ToolsMessages.INFO_COMPARE_OPERATION_RESULT_FALSE.get((Object)request.getName().toString()));
                } else {
                    this.println(ToolsMessages.INFO_COMPARE_OPERATION_RESULT_TRUE.get((Object)request.getName().toString()));
                }
            }
            catch (LdapException ere) {
                LocalizableMessage msg = ToolsMessages.INFO_OPERATION_FAILED.get((Object)"COMPARE");
                this.errPrintln(msg);
                Result r = ere.getResult();
                this.errPrintln(ToolsMessages.ERR_TOOL_RESULT_CODE.get((Object)r.getResultCode().intValue(), (Object)r.getResultCode().toString()));
                if (r.getDiagnosticMessage() != null && r.getDiagnosticMessage().length() > 0) {
                    this.errPrintln(LocalizableMessage.raw((CharSequence)r.getDiagnosticMessage(), (Object[])new Object[0]));
                }
                if (r.getMatchedDN() != null && r.getMatchedDN().length() > 0) {
                    this.errPrintln(ToolsMessages.ERR_TOOL_MATCHED_DN.get((Object)r.getMatchedDN()));
                }
                return r.getResultCode().intValue();
            }
        }
        return ResultCode.SUCCESS.intValue();
    }

    /*
     * Exception decompiling
     */
    int run(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[WHILELOOP]], but top level block is 11[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

