/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.codahale.metrics.Metric;
import com.codahale.metrics.RatioGauge;
import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.MultiColumnPrinter;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.tools.DataSource;
import com.forgerock.opendj.ldap.tools.PerformanceRunner;
import com.forgerock.opendj.ldap.tools.PerformanceRunnerOptions;
import com.forgerock.opendj.ldap.tools.StatsThread;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CRAMMD5SASLBindRequest;
import org.forgerock.opendj.ldap.requests.DigestMD5SASLBindRequest;
import org.forgerock.opendj.ldap.requests.ExternalSASLBindRequest;
import org.forgerock.opendj.ldap.requests.GSSAPISASLBindRequest;
import org.forgerock.opendj.ldap.requests.PlainSASLBindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.promise.Promise;

public final class AuthRate
extends ConsoleApplication {
    private BooleanArgument verbose;
    private BooleanArgument scriptFriendly;

    public static void main(String[] args) {
        int retCode = new AuthRate().run(args);
        System.exit(com.forgerock.opendj.cli.Utils.filterExitCode((int)retCode));
    }

    private AuthRate() {
    }

    AuthRate(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isScriptFriendly() {
        return this.scriptFriendly.isPresent();
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    int run(String[] args) {
        ConnectionFactory connectionFactory;
        IntegerArgument invalidCredPercent;
        MultiChoiceArgument dereferencePolicy;
        MultiChoiceArgument searchScope;
        StringArgument baseDN;
        BindPerformanceRunner runner;
        ConnectionFactoryProvider connectionFactoryProvider;
        LocalizableMessage toolDescription = ToolsMessages.INFO_AUTHRATE_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(AuthRate.class.getName(), toolDescription, false, true, 0, 0, "[filter format string] [attributes ...]");
        argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_AUTHRATE.get());
        argParser.setDocToolDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_RATE_TOOLS.get());
        try {
            Utils.setDefaultPerfToolProperties();
            PerformanceRunnerOptions options = new PerformanceRunnerOptions(argParser, this);
            options.setSupportsRebind(false);
            options.setSupportsMultipleThreadsPerConnection(false);
            connectionFactoryProvider = new ConnectionFactoryProvider(argParser, (ConsoleApplication)this);
            runner = new BindPerformanceRunner(options);
            StringArgument propertiesFileArgument = CommonArguments.propertiesFileArgument();
            argParser.addArgument((Argument)propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = CommonArguments.noPropertiesFileArgument();
            argParser.addArgument((Argument)noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            BooleanArgument showUsage = CommonArguments.showUsageArgument();
            argParser.addArgument((Argument)showUsage);
            argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
            baseDN = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"baseDN").shortIdentifier(Character.valueOf('b'))).description(ToolsMessages.INFO_SEARCHRATE_TOOL_DESCRIPTION_BASEDN.get())).valuePlaceholder(ToolsMessages.INFO_BASEDN_PLACEHOLDER.get())).buildAndAddToParser(argParser);
            searchScope = CommonArguments.searchScopeArgument();
            argParser.addArgument((Argument)searchScope);
            dereferencePolicy = (MultiChoiceArgument)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)MultiChoiceArgument.builder((String)"dereferencePolicy").shortIdentifier(Character.valueOf('a'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_DEREFERENCE_POLICY.get())).allowedValues((Collection)DereferenceAliasesPolicy.values()).defaultValue((Object)DereferenceAliasesPolicy.NEVER)).valuePlaceholder(ToolsMessages.INFO_DEREFERENCE_POLICE_PLACEHOLDER.get())).buildAndAddToParser(argParser);
            invalidCredPercent = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"invalidPassword").shortIdentifier(Character.valueOf('I'))).description(LocalizableMessage.raw((CharSequence)"Percent of bind operations with simulated invalid password", (Object[])new Object[0]))).range(0, 100).defaultValue((Object)0)).valuePlaceholder(LocalizableMessage.raw((CharSequence)"{invalidPassword}", (Object[])new Object[0]))).buildAndAddToParser(argParser);
            this.verbose = CommonArguments.verboseArgument();
            argParser.addArgument((Argument)this.verbose);
            this.scriptFriendly = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"scriptFriendly").shortIdentifier(Character.valueOf('S'))).description(ToolsMessages.INFO_DESCRIPTION_SCRIPT_FRIENDLY.get())).buildAndAddToParser(argParser);
        }
        catch (ArgumentException ae) {
            LocalizableMessage message = ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage());
            this.errPrintln(message);
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            argParser.parseArguments(args);
            if (argParser.usageOrVersionDisplayed()) {
                return 0;
            }
            connectionFactory = connectionFactoryProvider.getUnauthenticatedConnectionFactory();
            BindRequest bindRequestTemplate = connectionFactoryProvider.getBindRequest();
            if (bindRequestTemplate == null) {
                throw new ArgumentException(ToolsMessages.ERR_AUTHRATE_NO_BIND_DN_PROVIDED.get());
            }
            runner.setBindRequestTemplate(bindRequestTemplate);
            runner.validate();
        }
        catch (ArgumentException ae) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        LinkedList attributes = new LinkedList();
        ArrayList filterAndAttributeStrings = argParser.getTrailingArguments();
        if (!filterAndAttributeStrings.isEmpty()) {
            runner.filter = (String)filterAndAttributeStrings.remove(0);
            attributes.addAll(filterAndAttributeStrings);
        }
        BindPerformanceRunner.access$402(runner, attributes.toArray(new String[attributes.size()]));
        runner.baseDN = baseDN.getValue();
        try {
            runner.scope = (SearchScope)searchScope.getTypedValue();
            runner.dereferencesAliasesPolicy = (DereferenceAliasesPolicy)dereferencePolicy.getTypedValue();
            runner.invalidCredPercent = invalidCredPercent.getIntValue();
        }
        catch (ArgumentException ex1) {
            this.errPrintln(ex1.getMessageObject());
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        Object[] data = DataSource.generateData(runner.getDataSources(), null);
        try {
            if (runner.baseDN != null && runner.filter != null) {
                String.format(runner.filter, data);
                String.format(runner.baseDN, data);
            }
        }
        catch (Exception ex1) {
            this.errPrintln(LocalizableMessage.raw((CharSequence)("Error formatting filter or base DN: " + ex1), (Object[])new Object[0]));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        return runner.run(connectionFactory);
    }

    private final class BindPerformanceRunner
    extends PerformanceRunner {
        private final StatsThread.IntervalCounter searchWaitRecentTimeNs;
        private String filter;
        private String baseDN;
        private SearchScope scope;
        private DereferenceAliasesPolicy dereferencesAliasesPolicy;
        private String[] attributes;
        private int invalidCredPercent;
        private BindRequest bindRequestTemplate;

        private BindPerformanceRunner(PerformanceRunnerOptions options) throws ArgumentException {
            super(options);
            this.searchWaitRecentTimeNs = StatsThread.newIntervalCounter();
        }

        private void setBindRequestTemplate(BindRequest bindRequestTemplate) {
            this.bindRequestTemplate = bindRequestTemplate;
        }

        @Override
        PerformanceRunner.WorkerThread newWorkerThread(Connection connection, ConnectionFactory connectionFactory) {
            return new BindWorkerThread(connection, connectionFactory);
        }

        @Override
        StatsThread newStatsThread(PerformanceRunner performanceRunner, ConsoleApplication app) {
            return new BindStatsThread(performanceRunner, app, this.filter != null && this.baseDN != null);
        }

        static /* synthetic */ String[] access$402(BindPerformanceRunner x0, String[] x1) {
            x0.attributes = x1;
            return x1;
        }

        private final class BindWorkerThread
        extends PerformanceRunner.WorkerThread {
            private SearchRequest sr;
            private BindRequest br;
            private Object[] data;
            private final char[] invalidPassword;
            private final ThreadLocal<Random> rng;

            private BindWorkerThread(Connection connection, ConnectionFactory connectionFactory) {
                super(connection, connectionFactory);
                this.invalidPassword = "invalid-password".toCharArray();
                this.rng = new ThreadLocal<Random>(){

                    @Override
                    protected Random initialValue() {
                        return new Random();
                    }
                };
            }

            @Override
            public Promise<?, LdapException> performOperation(final Connection connection, DataSource[] dataSources, final long currentTimeNs) {
                LdapPromise returnedPromise;
                if (dataSources != null) {
                    this.data = DataSource.generateData(dataSources, this.data);
                    if (this.data.length == dataSources.length) {
                        Object[] newData = new Object[this.data.length + 1];
                        System.arraycopy(this.data, 0, newData, 0, this.data.length);
                        this.data = newData;
                    }
                }
                if (BindPerformanceRunner.this.filter != null && BindPerformanceRunner.this.baseDN != null) {
                    if (this.sr == null) {
                        if (dataSources != null) {
                            String newBaseDN = String.format(BindPerformanceRunner.this.baseDN, this.data);
                            String newFilter = String.format(BindPerformanceRunner.this.filter, this.data);
                            this.sr = Requests.newSearchRequest((String)newBaseDN, (SearchScope)BindPerformanceRunner.this.scope, (String)newFilter, (String[])BindPerformanceRunner.this.attributes);
                        } else {
                            this.sr = Requests.newSearchRequest((String)BindPerformanceRunner.this.baseDN, (SearchScope)BindPerformanceRunner.this.scope, (String)BindPerformanceRunner.this.filter, (String[])BindPerformanceRunner.this.attributes);
                        }
                        this.sr.setDereferenceAliasesPolicy(BindPerformanceRunner.this.dereferencesAliasesPolicy);
                    } else if (dataSources != null) {
                        this.sr.setFilter(String.format(BindPerformanceRunner.this.filter, this.data));
                        this.sr.setName(String.format(BindPerformanceRunner.this.baseDN, this.data));
                    }
                    returnedPromise = connection.searchSingleEntryAsync(this.sr).thenAsync((AsyncFunction)new AsyncFunction<SearchResultEntry, BindResult, LdapException>(){

                        public Promise<BindResult, LdapException> apply(SearchResultEntry result) throws LdapException {
                            BindPerformanceRunner.this.searchWaitRecentTimeNs.inc(System.nanoTime() - currentTimeNs);
                            if (BindWorkerThread.this.data == null) {
                                BindWorkerThread.access$602(BindWorkerThread.this, new Object[1]);
                            }
                            ((BindWorkerThread)BindWorkerThread.this).data[((BindWorkerThread)BindWorkerThread.this).data.length - 1] = result.getName().toString();
                            return BindWorkerThread.this.performBind(connection, BindWorkerThread.this.data);
                        }
                    });
                } else {
                    returnedPromise = this.performBind(connection, this.data);
                }
                this.incrementIterationCount();
                return returnedPromise.thenOnResult(new PerformanceRunner.UpdateStatsResultHandler(currentTimeNs)).thenOnException(new PerformanceRunner.UpdateStatsResultHandler(currentTimeNs));
            }

            private Promise<BindResult, LdapException> performBind(Connection connection, Object[] data) {
                boolean useInvalidPassword;
                switch (BindPerformanceRunner.this.invalidCredPercent) {
                    case 0: {
                        useInvalidPassword = false;
                        break;
                    }
                    case 100: {
                        useInvalidPassword = true;
                        break;
                    }
                    default: {
                        Random r = this.rng.get();
                        int p = r.nextInt(100);
                        useInvalidPassword = p < BindPerformanceRunner.this.invalidCredPercent;
                    }
                }
                BindRequest bindRequest = BindPerformanceRunner.this.bindRequestTemplate;
                if (bindRequest instanceof SimpleBindRequest) {
                    SimpleBindRequest o = (SimpleBindRequest)bindRequest;
                    if (this.br == null) {
                        this.br = Requests.copyOfSimpleBindRequest((SimpleBindRequest)o);
                    }
                    SimpleBindRequest sbr = (SimpleBindRequest)this.br;
                    if (data != null && o.getName() != null) {
                        sbr.setName(String.format(o.getName(), data));
                    }
                    if (useInvalidPassword) {
                        sbr.setPassword(this.invalidPassword);
                    } else {
                        sbr.setPassword(o.getPassword());
                    }
                } else if (bindRequest instanceof DigestMD5SASLBindRequest) {
                    DigestMD5SASLBindRequest o = (DigestMD5SASLBindRequest)bindRequest;
                    if (this.br == null) {
                        this.br = Requests.copyOfDigestMD5SASLBindRequest((DigestMD5SASLBindRequest)o);
                    }
                    DigestMD5SASLBindRequest sbr = (DigestMD5SASLBindRequest)this.br;
                    if (data != null) {
                        if (o.getAuthenticationID() != null) {
                            sbr.setAuthenticationID(String.format(o.getAuthenticationID(), data));
                        }
                        if (o.getAuthorizationID() != null) {
                            sbr.setAuthorizationID(String.format(o.getAuthorizationID(), data));
                        }
                    }
                    if (useInvalidPassword) {
                        sbr.setPassword(this.invalidPassword);
                    } else {
                        sbr.setPassword(o.getPassword());
                    }
                } else if (bindRequest instanceof CRAMMD5SASLBindRequest) {
                    CRAMMD5SASLBindRequest o = (CRAMMD5SASLBindRequest)bindRequest;
                    if (this.br == null) {
                        this.br = Requests.copyOfCRAMMD5SASLBindRequest((CRAMMD5SASLBindRequest)o);
                    }
                    CRAMMD5SASLBindRequest sbr = (CRAMMD5SASLBindRequest)this.br;
                    if (data != null && o.getAuthenticationID() != null) {
                        sbr.setAuthenticationID(String.format(o.getAuthenticationID(), data));
                    }
                    if (useInvalidPassword) {
                        sbr.setPassword(this.invalidPassword);
                    } else {
                        sbr.setPassword(o.getPassword());
                    }
                } else if (bindRequest instanceof GSSAPISASLBindRequest) {
                    GSSAPISASLBindRequest o = (GSSAPISASLBindRequest)bindRequest;
                    if (this.br == null) {
                        this.br = Requests.copyOfGSSAPISASLBindRequest((GSSAPISASLBindRequest)o);
                    }
                    GSSAPISASLBindRequest sbr = (GSSAPISASLBindRequest)this.br;
                    if (data != null) {
                        if (o.getAuthenticationID() != null) {
                            sbr.setAuthenticationID(String.format(o.getAuthenticationID(), data));
                        }
                        if (o.getAuthorizationID() != null) {
                            sbr.setAuthorizationID(String.format(o.getAuthorizationID(), data));
                        }
                    }
                    if (useInvalidPassword) {
                        sbr.setPassword(this.invalidPassword);
                    } else {
                        sbr.setPassword(o.getPassword());
                    }
                } else if (bindRequest instanceof ExternalSASLBindRequest) {
                    ExternalSASLBindRequest o = (ExternalSASLBindRequest)bindRequest;
                    if (this.br == null) {
                        this.br = Requests.copyOfExternalSASLBindRequest((ExternalSASLBindRequest)o);
                    }
                    ExternalSASLBindRequest sbr = (ExternalSASLBindRequest)this.br;
                    if (data != null && o.getAuthorizationID() != null) {
                        sbr.setAuthorizationID(String.format(o.getAuthorizationID(), data));
                    }
                } else if (bindRequest instanceof PlainSASLBindRequest) {
                    PlainSASLBindRequest o = (PlainSASLBindRequest)bindRequest;
                    if (this.br == null) {
                        this.br = Requests.copyOfPlainSASLBindRequest((PlainSASLBindRequest)o);
                    }
                    PlainSASLBindRequest sbr = (PlainSASLBindRequest)this.br;
                    if (data != null) {
                        if (o.getAuthenticationID() != null) {
                            sbr.setAuthenticationID(String.format(o.getAuthenticationID(), data));
                        }
                        if (o.getAuthorizationID() != null) {
                            sbr.setAuthorizationID(String.format(o.getAuthorizationID(), data));
                        }
                    }
                    if (useInvalidPassword) {
                        sbr.setPassword(this.invalidPassword);
                    } else {
                        sbr.setPassword(o.getPassword());
                    }
                }
                return connection.bindAsync(this.br);
            }

            static /* synthetic */ Object[] access$602(BindWorkerThread x0, Object[] x1) {
                x0.data = x1;
                return x1;
            }
        }

        private final class BindStatsThread
        extends StatsThread {
            private static final int BIND_TIME_PERCENTAGE_COLUMN_WIDTH = 5;
            private static final String BIND_TIME_PERCENTAGE = "org.forgerock.opendj.bind_time_percentage";
            private final boolean computeBindTime;

            private BindStatsThread(PerformanceRunner performanceRunner, ConsoleApplication app, boolean computeBindTime) {
                super(performanceRunner, app);
                this.computeBindTime = computeBindTime;
            }

            @Override
            List<MultiColumnPrinter.Column> registerAdditionalColumns() {
                if (!this.computeBindTime) {
                    return Collections.emptyList();
                }
                this.registry.register(BIND_TIME_PERCENTAGE, (Metric)new RatioGauge(){

                    protected RatioGauge.Ratio getRatio() {
                        long searchWaitTimeIntervalNs = BindPerformanceRunner.this.searchWaitRecentTimeNs.getLastIntervalCount();
                        long waitTimeIntervalNs = BindStatsThread.this.waitDurationNsCount.getLastIntervalCount();
                        return RatioGauge.Ratio.of((double)(100L * (waitTimeIntervalNs - searchWaitTimeIntervalNs)), (double)waitTimeIntervalNs);
                    }
                });
                return Collections.singletonList(MultiColumnPrinter.column((String)BIND_TIME_PERCENTAGE, (String)"bind time %", (int)5, (int)1));
            }
        }
    }
}

