/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.tools.LDAPToolArgumentParser;
import com.forgerock.opendj.ldap.tools.LDAPToolException;
import com.forgerock.opendj.ldap.tools.ToolConsoleApplication;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.forgerock.i18n.LocalizableException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldif.ChangeRecordReader;
import org.forgerock.opendj.ldif.EntryReader;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.opendj.ldif.LDIF;
import org.forgerock.opendj.ldif.LDIFChangeRecordReader;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;
import org.forgerock.opendj.ldif.RejectedChangeRecordListener;
import org.forgerock.util.annotations.VisibleForTesting;

public final class LDIFModify
extends ToolConsoleApplication {
    public static void main(String[] args) {
        Utils.runToolAndExit(new LDIFModify(System.out, System.err), args);
    }

    public static int run(PrintStream out, PrintStream err, String ... args) {
        return Utils.runTool(new LDIFModify(out, err), args);
    }

    @VisibleForTesting
    LDIFModify(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    /*
     * Loose catch block
     */
    @Override
    int run(String ... args) throws LDAPToolException {
        IntegerArgument wrapColumn;
        BooleanArgument continueOnError;
        StringArgument outputFilename;
        LDAPToolArgumentParser argParser = LDAPToolArgumentParser.builder(LDIFModify.class.getName()).toolDescription(ToolsMessages.INFO_LDIFMODIFY_TOOL_DESCRIPTION.get()).trailingArgumentsUnbounded(1, "source_file [changes_files...]").build();
        argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDIFMODIFY.get());
        try {
            outputFilename = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"outputLDIF").shortIdentifier(Character.valueOf('o'))).description(ToolsMessages.INFO_LDIFMODIFY_DESCRIPTION_OUTPUT_FILENAME.get((Object)ToolsMessages.INFO_OUTPUT_LDIF_FILE_PLACEHOLDER.get()))).defaultValue((Object)"stdout")).valuePlaceholder(ToolsMessages.INFO_OUTPUT_LDIF_FILE_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            continueOnError = CommonArguments.continueOnErrorArgument();
            argParser.addArgument((Argument)continueOnError);
            wrapColumn = CommonArguments.wrapColumnArgument();
            argParser.addArgument((Argument)wrapColumn);
            BooleanArgument showUsage = CommonArguments.showUsageArgument();
            argParser.addArgument((Argument)showUsage);
            argParser.setUsageArgument((Argument)showUsage, this.getOutputStream());
        }
        catch (ArgumentException ae) {
            throw LDAPToolException.newToolParamException((Exception)((Object)ae), ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
        }
        Utils.parseArguments(argParser, this.getErrStream(), args);
        if (argParser.usageOrVersionDisplayed()) {
            return ResultCode.SUCCESS.intValue();
        }
        ArrayList trailingArguments = argParser.getTrailingArguments();
        LDIFEntryReader sourceReader = null;
        LDIFChangeRecordReader changesReader = null;
        try (InputStream sourceInputStream = Utils.getLDIFToolInputStream(this, (String)trailingArguments.get(0));
             OutputStream outputStream = Utils.getLDIFToolOutputStream(this, outputFilename);
             LDIFEntryWriter outputWriter = new LDIFEntryWriter(outputStream);){
            boolean readChangesFromStdin;
            outputWriter.setWrapColumn(Utils.computeWrapColumn(wrapColumn));
            int nbTrailingArgs = trailingArguments.size();
            boolean bl = readChangesFromStdin = nbTrailingArgs == 1 || nbTrailingArgs == 2 && "-".equals(trailingArguments.get(1));
            if (this.getInputStream() == sourceInputStream && readChangesFromStdin) {
                throw LDAPToolException.newToolParamException(ToolsMessages.ERR_LDIFMODIFY_MULTIPLE_USES_OF_STDIN.get());
            }
            sourceReader = new LDIFEntryReader(sourceInputStream);
            changesReader = readChangesFromStdin ? new LDIFChangeRecordReader(this.getInputStream()) : new LDIFChangeRecordReader(Utils.getLinesFromFiles(trailingArguments.subList(1, nbTrailingArgs)));
            RejectedChangeRecordListener listener = new RejectedChangeRecordListener(){

                public Entry handleDuplicateEntry(AddRequest change, Entry existingEntry) throws DecodeException {
                    try {
                        RejectedChangeRecordListener.FAIL_FAST.handleDuplicateEntry(change, existingEntry);
                    }
                    catch (DecodeException e) {
                        this.logErrorOrFail(e);
                    }
                    return change;
                }

                public Entry handleDuplicateEntry(ModifyDNRequest change, Entry existingEntry, Entry renamedEntry) throws DecodeException {
                    try {
                        RejectedChangeRecordListener.FAIL_FAST.handleDuplicateEntry(change, existingEntry, renamedEntry);
                    }
                    catch (DecodeException e) {
                        this.logErrorOrFail(e);
                    }
                    return renamedEntry;
                }

                public void handleRejectedChangeRecord(AddRequest change, LocalizableMessage reason) throws DecodeException {
                    try {
                        RejectedChangeRecordListener.FAIL_FAST.handleRejectedChangeRecord(change, reason);
                    }
                    catch (DecodeException e) {
                        this.logErrorOrFail(e);
                    }
                }

                public void handleRejectedChangeRecord(DeleteRequest change, LocalizableMessage reason) throws DecodeException {
                    try {
                        RejectedChangeRecordListener.FAIL_FAST.handleRejectedChangeRecord(change, reason);
                    }
                    catch (DecodeException e) {
                        this.logErrorOrFail(e);
                    }
                }

                public void handleRejectedChangeRecord(ModifyDNRequest change, LocalizableMessage reason) throws DecodeException {
                    try {
                        RejectedChangeRecordListener.FAIL_FAST.handleRejectedChangeRecord(change, reason);
                    }
                    catch (DecodeException e) {
                        this.logErrorOrFail(e);
                    }
                }

                public void handleRejectedChangeRecord(ModifyRequest change, LocalizableMessage reason) throws DecodeException {
                    try {
                        RejectedChangeRecordListener.FAIL_FAST.handleRejectedChangeRecord(change, reason);
                    }
                    catch (DecodeException e) {
                        this.logErrorOrFail(e);
                    }
                }

                private void logErrorOrFail(DecodeException e) throws DecodeException {
                    if (!continueOnError.isPresent()) {
                        throw e;
                    }
                    LDIFModify.this.errPrintln(e.getMessageObject());
                }
            };
            LDIF.copyTo((EntryReader)LDIF.patch((EntryReader)sourceReader, (ChangeRecordReader)changesReader, (RejectedChangeRecordListener)listener), (EntryWriter)outputWriter);
        }
        catch (IOException e) {
            if (e instanceof LocalizableException) {
                this.errPrintln(ToolsMessages.ERR_LDIFMODIFY_PATCH_FAILED.get((Object)((LocalizableException)e).getMessageObject()));
            } else {
                this.errPrintln(ToolsMessages.ERR_LDIFMODIFY_PATCH_FAILED.get((Object)e.getLocalizedMessage()));
            }
            int n = ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue();
            org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceReader, changesReader});
            return n;
        }
        catch (ArgumentException ae) {
            throw LDAPToolException.newToolParamException((Exception)((Object)ae), ae.getMessageObject());
            {
                catch (Throwable throwable) {
                    org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceReader, changesReader});
                    throw throwable;
                }
            }
        }
        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceReader, changesReader});
        return ResultCode.SUCCESS.intValue();
    }
}

