/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.tools.LDAPToolArgumentParser;
import com.forgerock.opendj.ldap.tools.LDAPToolException;
import com.forgerock.opendj.ldap.tools.ToolConsoleApplication;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.SubtreeDeleteRequestControl;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.util.annotations.VisibleForTesting;

public final class LDAPDelete
extends ToolConsoleApplication {
    private BooleanArgument verbose;

    public static void main(String[] args) {
        Utils.runToolAndExit(new LDAPDelete(System.out, System.err), args);
    }

    public static int run(PrintStream out, PrintStream err, String ... args) {
        return Utils.runTool(new LDAPDelete(out, err), args);
    }

    @VisibleForTesting
    LDAPDelete(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    @Override
    int run(String ... args) throws LDAPToolException {
        BooleanArgument dryRun;
        StringArgument controlStr;
        BooleanArgument continueOnError;
        BooleanArgument deleteSubtree;
        ConnectionFactoryProvider connectionFactoryProvider;
        LocalizableMessage toolDescription = ToolsMessages.INFO_LDAPDELETE_TOOL_DESCRIPTION.get();
        LDAPToolArgumentParser argParser = LDAPToolArgumentParser.builder(LDAPDelete.class.getName()).toolDescription(toolDescription).trailingArguments(0, 1, "[DN]").build();
        argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDAPDELETE.get());
        try {
            connectionFactoryProvider = new ConnectionFactoryProvider((ArgumentParser)argParser, (ConsoleApplication)this);
            StringArgument propertiesFileArgument = CommonArguments.propertiesFileArgument();
            argParser.addArgument((Argument)propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = CommonArguments.noPropertiesFileArgument();
            argParser.addArgument((Argument)noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            deleteSubtree = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"deleteSubtree").shortIdentifier(Character.valueOf('x'))).description(ToolsMessages.INFO_DELETE_DESCRIPTION_DELETE_SUBTREE.get())).buildAndAddToParser((ArgumentParser)argParser);
            continueOnError = CommonArguments.continueOnErrorArgument();
            argParser.addArgument((Argument)continueOnError);
            controlStr = CommonArguments.controlArgument();
            argParser.addArgument((Argument)controlStr);
            dryRun = CommonArguments.noOpArgument();
            argParser.addArgument((Argument)dryRun);
            this.verbose = CommonArguments.verboseArgument();
            argParser.addArgument((Argument)this.verbose);
            BooleanArgument showUsage = CommonArguments.showUsageArgument();
            argParser.addArgument((Argument)showUsage);
            argParser.setUsageArgument((Argument)showUsage, this.getOutputStream());
        }
        catch (ArgumentException ae) {
            throw LDAPToolException.newToolParamException((Exception)((Object)ae), ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
        }
        argParser.parseArguments(args, this.getErrStream(), connectionFactoryProvider);
        if (argParser.usageOrVersionDisplayed()) {
            return ResultCode.SUCCESS.intValue();
        }
        List<Control> controls = Utils.readControls(controlStr);
        if (deleteSubtree.isPresent()) {
            controls.add((Control)SubtreeDeleteRequestControl.newControl((boolean)false));
        }
        try (Connection connection = Utils.getConnection(argParser.getConnectionFactory(), argParser.getBindRequest(), dryRun, this);){
            List<DeleteRequest> deleteRequests = this.createDeleteRequests(argParser.getTrailingArguments(), controls);
            for (DeleteRequest deleteRequest : deleteRequests) {
                Result result;
                String dnToRemove = deleteRequest.getName().toString();
                this.println(ToolsMessages.INFO_PROCESSING_OPERATION.get((Object)"DELETE", (Object)dnToRemove));
                if (dryRun.isPresent()) continue;
                try {
                    result = connection.delete(deleteRequest);
                }
                catch (LdapException e) {
                    result = e.getResult();
                }
                ResultCode resultCode = result.getResultCode();
                if (ResultCode.SUCCESS != resultCode && ResultCode.REFERRAL != resultCode) {
                    Utils.printErrorMessage((ConsoleApplication)this, result, ToolsMessages.ERR_LDAP_DELETE_FAILED);
                    this.println();
                    if (continueOnError.isPresent()) continue;
                    int n = resultCode.intValue();
                    return n;
                }
                Utils.printSuccessMessage(this, result, "DELETE", dnToRemove);
                this.println();
            }
        }
        return ResultCode.SUCCESS.intValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DeleteRequest> createDeleteRequests(List<String> trailingArguments, List<Control> controls) throws LDAPToolException {
        try {
            if (!trailingArguments.isEmpty()) {
                if (trailingArguments.size() != 1) return Collections.singletonList(this.createDeleteRequestForDn(trailingArguments.get(0), controls));
                if (!"-".equals(trailingArguments.get(0))) {
                    return Collections.singletonList(this.createDeleteRequestForDn(trailingArguments.get(0), controls));
                }
            }
            ArrayList<DeleteRequest> deleteRequests = new ArrayList<DeleteRequest>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream()));){
                String dn;
                while ((dn = reader.readLine()) != null) {
                    deleteRequests.add(this.createDeleteRequestForDn(dn, controls));
                }
                ArrayList<DeleteRequest> arrayList = deleteRequests;
                return arrayList;
            }
            catch (IOException e) {
                throw LDAPToolException.newToolException(e, ResultCode.UNDEFINED, ToolsMessages.ERR_LDAPDELETE_READING_STDIN.get((Object)e.getLocalizedMessage()));
            }
        }
        catch (IllegalArgumentException iae) {
            throw LDAPToolException.newToolException(iae, ResultCode.INVALID_DN_SYNTAX, LocalizableMessage.raw((CharSequence)iae.getLocalizedMessage(), (Object[])new Object[0]));
        }
    }

    private DeleteRequest createDeleteRequestForDn(String dnToRemove, List<Control> controls) throws LDAPToolException {
        DeleteRequest request = Requests.newDeleteRequest((String)dnToRemove);
        Utils.addControlsToRequest((Request)request, controls);
        return request;
    }
}

