/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.xml;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.forgerock.util.xml.XMLHandler;
import org.xml.sax.SAXException;

public final class XMLUtils {
    private static final Logger LOGGER;
    private static final Object SECURITY_MANAGER;

    static {
        Object securityManager;
        LOGGER = Logger.getLogger(XMLUtils.class.getName());
        try {
            Class<?> securityManagerClass = Class.forName("org.apache.xerces.util.SecurityManager");
            securityManager = securityManagerClass.newInstance();
            Integer limit = Integer.getInteger("org.forgerock.util.xml.entity.expansion.limit", 5000);
            Method setEntityExpansionLimit = securityManagerClass.getMethod("setEntityExpansionLimit", Integer.TYPE);
            setEntityExpansionLimit.invoke(securityManager, limit);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Unable to set expansion limit for Xerces, using default settings", ex);
            securityManager = null;
        }
        SECURITY_MANAGER = securityManager;
    }

    private XMLUtils() {
    }

    public static DocumentBuilder getSafeDocumentBuilder(boolean validating) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validating);
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setExpandEntityReferences(false);
        if (SECURITY_MANAGER != null) {
            dbf.setAttribute("http://apache.org/xml/properties/security-manager", SECURITY_MANAGER);
        }
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(new XMLHandler());
        return db;
    }

    public static SAXParser getSafeSAXParser(boolean validating) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setValidating(validating);
        saxFactory.setNamespaceAware(true);
        saxFactory.setXIncludeAware(false);
        saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SAXParser sp = saxFactory.newSAXParser();
        if (SECURITY_MANAGER != null) {
            sp.setProperty("http://apache.org/xml/properties/security-manager", SECURITY_MANAGER);
        }
        sp.getXMLReader().setEntityResolver(new XMLHandler());
        return sp;
    }
}

