/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.promise;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.promise.RuntimeExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromiseImpl<V, E extends Exception>
implements Promise<V, E>,
ResultHandler<V>,
ExceptionHandler<E>,
RuntimeExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PromiseImpl.class);
    private static final int PENDING = 0;
    private static final int HAS_RESULT = 1;
    private static final int HAS_EXCEPTION = 2;
    private static final int CANCELLED = 3;
    private static final int HAS_RUNTIME_EXCEPTION = 4;
    private volatile int state = 0;
    private V result = null;
    private E exception = null;
    private RuntimeException runtimeException = null;
    private final Queue<StateListener<V, E>> listeners = new ConcurrentLinkedQueue<StateListener<V, E>>();

    public static <V, E extends Exception> PromiseImpl<V, E> create() {
        return new PromiseImpl<V, E>();
    }

    protected PromiseImpl() {
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        E exception = this.tryCancel(mayInterruptIfRunning);
        return exception != null && this.setState(3, null, exception, null);
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        this.await();
        return this.get0();
    }

    @Override
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.await(timeout, unit, false);
        return this.get0();
    }

    @Override
    public final V getOrThrow() throws InterruptedException, E {
        this.await();
        return this.getOrThrow0();
    }

    @Override
    public final V getOrThrow(long timeout, TimeUnit unit) throws InterruptedException, E, TimeoutException {
        this.await(timeout, unit, false);
        return this.getOrThrow0();
    }

    @Override
    public final V getOrThrowUninterruptibly() throws E {
        boolean wasInterrupted = false;
        while (true) {
            try {
                V v = this.getOrThrow();
                return v;
            }
            catch (InterruptedException interruptedException) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public final V getOrThrowUninterruptibly(long timeout, TimeUnit unit) throws E, TimeoutException {
        try {
            this.await(timeout, unit, true);
        }
        catch (InterruptedException interruptedException) {}
        return this.getOrThrow0();
    }

    @Override
    public final void handleException(E exception) {
        this.tryHandleException(exception);
    }

    @Override
    public void handleRuntimeException(RuntimeException exception) {
        this.setState(4, null, null, exception);
    }

    @Override
    public final void handleResult(V result) {
        this.tryHandleResult(result);
    }

    public final boolean tryHandleException(E exception) {
        return this.setState(2, null, exception, null);
    }

    public final boolean tryHandleResult(V result) {
        return this.setState(1, result, null, null);
    }

    @Override
    public final boolean isCancelled() {
        return this.state == 3;
    }

    @Override
    public final boolean isDone() {
        return this.state != 0;
    }

    @Override
    public final Promise<V, E> thenOnException(final ExceptionHandler<? super E> onException) {
        this.addOrFireListener(new StateListener<V, E>(){

            @Override
            public void handleStateChange(int newState, V result, E exception, RuntimeException runtimeException) {
                if (newState == 2 || newState == 3) {
                    try {
                        onException.handleException(exception);
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Ignored unexpected exception thrown by ExceptionHandler", (Throwable)e);
                    }
                }
            }
        });
        return this;
    }

    @Override
    public final Promise<V, E> thenOnResult(final ResultHandler<? super V> onResult) {
        this.addOrFireListener(new StateListener<V, E>(){

            @Override
            public void handleStateChange(int newState, V result, E exception, RuntimeException runtimeException) {
                if (newState == 1) {
                    try {
                        onResult.handleResult(result);
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Ignored unexpected exception thrown by ResultHandler", (Throwable)e);
                    }
                }
            }
        });
        return this;
    }

    @Override
    public final Promise<V, E> thenOnResultOrException(final ResultHandler<? super V> onResult, final ExceptionHandler<? super E> onException) {
        this.addOrFireListener(new StateListener<V, E>(){

            @Override
            public void handleStateChange(int newState, V result, E exception, RuntimeException runtimeException) {
                if (newState == 1) {
                    try {
                        onResult.handleResult(result);
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Ignored unexpected exception thrown by ResultHandler", (Throwable)e);
                    }
                } else if (newState == 2 || newState == 3) {
                    try {
                        onException.handleException(exception);
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Ignored unexpected exception thrown by ExceptionHandler", (Throwable)e);
                    }
                }
            }
        });
        return this;
    }

    @Override
    public final Promise<V, E> thenOnResultOrException(final Runnable onResultOrException) {
        this.addOrFireListener(new StateListener<V, E>(){

            @Override
            public void handleStateChange(int newState, V result, E exception, RuntimeException runtimeException) {
                if (newState != 4) {
                    try {
                        onResultOrException.run();
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Ignored unexpected exception thrown by Runnable", (Throwable)e);
                    }
                }
            }
        });
        return this;
    }

    @Override
    public final <VOUT> Promise<VOUT, E> then(Function<? super V, VOUT, E> onResult) {
        return this.then(onResult, Promises.exceptionIdempotentFunction());
    }

    @Override
    public <EOUT extends Exception> Promise<V, EOUT> thenCatch(Function<? super E, V, EOUT> onException) {
        return this.then(Promises.resultIdempotentFunction(), onException);
    }

    @Override
    public final <VOUT, EOUT extends Exception> Promise<VOUT, EOUT> then(final Function<? super V, VOUT, EOUT> onResult, final Function<? super E, VOUT, EOUT> onException) {
        final PromiseImpl<V, E> chained = new PromiseImpl<V, E>();
        this.addOrFireListener(new StateListener<V, E>(){

            @Override
            public void handleStateChange(int newState, V result, E exception, RuntimeException runtimeException) {
                try {
                    if (newState == 1) {
                        chained.handleResult(onResult.apply(result));
                    } else if (newState == 2 || newState == 3) {
                        chained.handleResult(onException.apply(exception));
                    } else {
                        PromiseImpl.this.tryHandlingRuntimeException(runtimeException, chained);
                    }
                }
                catch (RuntimeException e) {
                    PromiseImpl.this.tryHandlingRuntimeException(e, chained);
                }
                catch (Exception e) {
                    chained.handleException(e);
                }
            }
        });
        return chained;
    }

    private <VOUT, EOUT extends Exception> void tryHandlingRuntimeException(RuntimeException runtimeException, PromiseImpl<VOUT, EOUT> chained) {
        try {
            chained.handleRuntimeException(runtimeException);
        }
        catch (Exception ignored) {
            LOGGER.error("Runtime exception handler threw a RuntimeException which cannot be handled!", (Throwable)ignored);
        }
    }

    @Override
    public final Promise<V, E> thenAlways(final Runnable always) {
        this.addOrFireListener(new StateListener<V, E>(){

            @Override
            public void handleStateChange(int newState, V result, E exception, RuntimeException runtimeException) {
                try {
                    always.run();
                }
                catch (RuntimeException e) {
                    LOGGER.error("Ignored unexpected exception thrown by Runnable", (Throwable)e);
                }
            }
        });
        return this;
    }

    @Override
    public final Promise<V, E> thenFinally(Runnable onFinally) {
        return this.thenAlways(onFinally);
    }

    @Override
    public final <VOUT> Promise<VOUT, E> thenAsync(AsyncFunction<? super V, VOUT, E> onResult) {
        return this.thenAsync(onResult, Promises.exceptionIdempotentAsyncFunction());
    }

    @Override
    public final <EOUT extends Exception> Promise<V, EOUT> thenCatchAsync(AsyncFunction<? super E, V, EOUT> onException) {
        return this.thenAsync(Promises.resultIdempotentAsyncFunction(), onException);
    }

    @Override
    public final <VOUT, EOUT extends Exception> Promise<VOUT, EOUT> thenAsync(final AsyncFunction<? super V, VOUT, EOUT> onResult, final AsyncFunction<? super E, VOUT, EOUT> onException) {
        final PromiseImpl<V, E> chained = new PromiseImpl<V, E>();
        this.addOrFireListener(new StateListener<V, E>(){

            @Override
            public void handleStateChange(int newState, V result, E exception, RuntimeException runtimeException) {
                try {
                    if (newState == 1) {
                        this.callNestedPromise(onResult.apply(result));
                    } else if (newState == 2 || newState == 3) {
                        this.callNestedPromise(onException.apply(exception));
                    } else {
                        PromiseImpl.this.tryHandlingRuntimeException(runtimeException, chained);
                    }
                }
                catch (RuntimeException e) {
                    PromiseImpl.this.tryHandlingRuntimeException(e, chained);
                }
                catch (Exception e) {
                    chained.handleException(e);
                }
            }

            private void callNestedPromise(Promise<? extends VOUT, ? extends EOUT> nestedPromise) {
                nestedPromise.thenOnResult(chained).thenOnException(chained).thenOnRuntimeException(chained);
            }
        });
        return chained;
    }

    @Override
    public final Promise<V, E> thenOnRuntimeException(final RuntimeExceptionHandler onRuntimeException) {
        this.addOrFireListener(new StateListener<V, E>(){

            @Override
            public void handleStateChange(int newState, V result, E exception, RuntimeException runtimeException) {
                if (newState == 4) {
                    try {
                        onRuntimeException.handleRuntimeException(runtimeException);
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("Ignored unexpected exception thrown by RuntimeExceptionHandler", (Throwable)e);
                    }
                }
            }
        });
        return this;
    }

    protected E tryCancel(boolean mayInterruptIfRunning) {
        return null;
    }

    private void addOrFireListener(StateListener<V, E> listener) {
        int stateBefore = this.state;
        if (stateBefore != 0) {
            this.handleCompletion(listener, stateBefore);
        } else {
            this.listeners.add(listener);
            int stateAfter = this.state;
            if (stateAfter != 0 && this.listeners.remove(listener)) {
                this.handleCompletion(listener, stateAfter);
            }
        }
    }

    private void handleCompletion(StateListener<V, E> listener, int completedState) {
        try {
            listener.handleStateChange(completedState, this.result, this.exception, this.runtimeException);
        }
        catch (RuntimeException ignored) {
            LOGGER.error("State change listener threw a RuntimeException which cannot be handled!", (Throwable)ignored);
        }
    }

    private V get0() throws ExecutionException {
        if (this.runtimeException != null) {
            throw new ExecutionException(this.runtimeException);
        }
        if (this.exception != null) {
            throw new ExecutionException((Throwable)this.exception);
        }
        return this.result;
    }

    private V getOrThrow0() throws E {
        if (this.runtimeException != null) {
            throw this.runtimeException;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean setState(int newState, V result, E exception, RuntimeException runtimeException) {
        var5_5 = this;
        synchronized (var5_5) {
            block5: {
                if (this.state == 0) break block5;
                return false;
            }
            this.result = result;
            this.exception = exception;
            this.runtimeException = runtimeException;
            this.state = newState;
            this.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var5_5
            if (true) ** GOTO lbl19
        }
        do {
            this.handleCompletion(listener, newState);
lbl19:
            // 2 sources

        } while ((listener = this.listeners.poll()) != null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void await() throws InterruptedException {
        if (this.state == 0) {
            PromiseImpl promiseImpl = this;
            synchronized (promiseImpl) {
                while (this.state == 0) {
                    this.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void await(long timeout, TimeUnit unit, boolean isUninterruptibly) throws InterruptedException, TimeoutException {
        if (this.state != 0) return;
        long timeoutMS = unit.toMillis(timeout);
        long endTimeMS = System.currentTimeMillis() + timeoutMS;
        boolean wasInterrupted = false;
        try {
            PromiseImpl promiseImpl = this;
            synchronized (promiseImpl) {
                while (true) {
                    if (this.state != 0) {
                        return;
                    }
                    long remainingTimeMS = endTimeMS - System.currentTimeMillis();
                    if (remainingTimeMS <= 0L) {
                        throw new TimeoutException();
                    }
                    try {
                        this.wait(remainingTimeMS);
                    }
                    catch (InterruptedException e) {
                        if (!isUninterruptibly) throw e;
                        wasInterrupted = true;
                    }
                }
            }
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static interface StateListener<V, E extends Exception> {
        public void handleStateChange(int var1, V var2, E var3, RuntimeException var4);
    }
}

