/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.Syntax;

final class GenerateCoreSchema {
    private static final Set<String> ABBREVIATIONS = new HashSet<String>(Arrays.asList("SASL", "LDAP", "DN", "DIT", "RDN", "JPEG", "OID", "UUID", "IA5", "UID", "UTC", "X500", "X121", "C", "CN", "O", "OU", "L", "DC", "ISDN", "SN", "ST"));

    public static void main(String[] args) {
        String description;
        GenerateCoreSchema.testSplitNameIntoWords();
        Schema schema = Schema.getCoreSchema();
        TreeMap<String, Syntax> syntaxes = new TreeMap<String, Syntax>();
        for (Syntax syntax : schema.getSyntaxes()) {
            if (GenerateCoreSchema.isOpenDSOID(syntax.getOID())) continue;
            String name = syntax.getDescription().replaceAll(" Syntax$", "");
            String fieldName = name.replace(" ", "_").replaceAll("[.-]", "").toUpperCase(Locale.ENGLISH).concat("_SYNTAX");
            syntaxes.put(fieldName, syntax);
        }
        TreeMap<String, MatchingRule> matchingRules = new TreeMap<String, MatchingRule>();
        for (MatchingRule matchingRule : schema.getMatchingRules()) {
            if (GenerateCoreSchema.isOpenDSOID(matchingRule.getOID()) || GenerateCoreSchema.isCollationMatchingRule(matchingRule.getOID())) continue;
            String name = matchingRule.getNameOrOID().replaceAll("Match$", "");
            String fieldName = GenerateCoreSchema.splitNameIntoWords(name).concat("_MATCHING_RULE");
            matchingRules.put(fieldName, matchingRule);
        }
        TreeMap<String, AttributeType> attributeTypes = new TreeMap<String, AttributeType>();
        for (AttributeType attributeType : schema.getAttributeTypes()) {
            if (GenerateCoreSchema.isOpenDSOID(attributeType.getOID())) continue;
            String name = attributeType.getNameOrOID();
            String fieldName = GenerateCoreSchema.splitNameIntoWords(name).concat("_ATTRIBUTE_TYPE");
            attributeTypes.put(fieldName, attributeType);
        }
        TreeMap<String, ObjectClass> objectClasses = new TreeMap<String, ObjectClass>();
        for (ObjectClass objectClass : schema.getObjectClasses()) {
            if (GenerateCoreSchema.isOpenDSOID(objectClass.getOID())) continue;
            String name = objectClass.getNameOrOID();
            String fieldName = GenerateCoreSchema.splitNameIntoWords(name.replace("-", "")).concat("_OBJECT_CLASS");
            objectClasses.put(fieldName, objectClass);
        }
        System.out.println("/*");
        System.out.println(" * CDDL HEADER START");
        System.out.println(" *");
        System.out.println(" * The contents of this file are subject to the terms of the");
        System.out.println(" * Common Development and Distribution License, Version 1.0 only");
        System.out.println(" * (the \"License\").  You may not use this file except in compliance");
        System.out.println(" * with the License.");
        System.out.println(" *");
        System.out.println(" * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt");
        System.out.println(" * or http://forgerock.org/license/CDDLv1.0.html.");
        System.out.println(" * See the License for the specific language governing permissions");
        System.out.println(" * and limitations under the License.");
        System.out.println(" *");
        System.out.println(" * When distributing Covered Code, include this CDDL HEADER in each");
        System.out.println(" * file and include the License file at legal-notices/CDDLv1_0.txt.");
        System.out.println(" * If applicable, add the following below this CDDL HEADER, with the");
        System.out.println(" * fields enclosed by brackets \"[]\" replaced with your own identifying");
        System.out.println(" * information:");
        System.out.println(" *      Portions Copyright [yyyy] [name of copyright owner]");
        System.out.println(" *");
        System.out.println(" * CDDL HEADER END");
        System.out.println(" *");
        System.out.println(" *");
        System.out.println(" *      Copyright 2009 Sun Microsystems, Inc.");
        int year = Calendar.getInstance().get(1);
        System.out.println(" *      Portions copyright 2014" + (year > 2014 ? "-" + year : "") + " ForgeRock AS");
        System.out.println(" */");
        System.out.println("package org.forgerock.opendj.ldap.schema;");
        System.out.println();
        System.out.println();
        System.out.println("// DON'T EDIT THIS FILE!");
        System.out.println("// It is automatically generated using GenerateCoreSchema class.");
        System.out.println();
        System.out.println("/**");
        System.out.println(" * The OpenDJ SDK core schema contains standard LDAP RFC schema elements. These include:");
        System.out.println(" * <ul>");
        System.out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4512\">RFC 4512 -");
        System.out.println(" * Lightweight Directory Access Protocol (LDAP): Directory Information");
        System.out.println(" * Models </a>");
        System.out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4517\">RFC 4517 -");
        System.out.println(" * Lightweight Directory Access Protocol (LDAP): Syntaxes and Matching");
        System.out.println(" * Rules </a>");
        System.out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4519\">RFC 4519 -");
        System.out.println(" * Lightweight Directory Access Protocol (LDAP): Schema for User");
        System.out.println(" * Applications </a>");
        System.out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4530\">RFC 4530 -");
        System.out.println(" * Lightweight Directory Access Protocol (LDAP): entryUUID Operational");
        System.out.println(" * Attribute </a>");
        System.out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc3045\">RFC 3045 - Storing");
        System.out.println(" * Vendor Information in the LDAP Root DSE </a>");
        System.out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc3112\">RFC 3112 - LDAP");
        System.out.println(" * Authentication Password Schema </a>");
        System.out.println(" * </ul>");
        System.out.println(" * <p>");
        System.out.println(" * The core schema is non-strict: attempts to retrieve");
        System.out.println(" * non-existent Attribute Types will return a temporary");
        System.out.println(" * Attribute Type having the Octet String syntax.");
        System.out.println(" */");
        System.out.println("public final class CoreSchema {");
        System.out.println("    // Core Syntaxes");
        for (Map.Entry syntax : syntaxes.entrySet()) {
            System.out.println("    private static final Syntax " + (String)syntax.getKey() + " =");
            System.out.println("        CoreSchemaImpl.getInstance().getSyntax(\"" + ((Syntax)syntax.getValue()).getOID() + "\");");
        }
        System.out.println();
        System.out.println("    // Core Matching Rules");
        for (Map.Entry matchingRule : matchingRules.entrySet()) {
            System.out.println("    private static final MatchingRule " + (String)matchingRule.getKey() + " =");
            System.out.println("        CoreSchemaImpl.getInstance().getMatchingRule(\"" + ((MatchingRule)matchingRule.getValue()).getOID() + "\");");
        }
        System.out.println();
        System.out.println("    // Core Attribute Types");
        for (Map.Entry attributeType : attributeTypes.entrySet()) {
            System.out.println("    private static final AttributeType " + (String)attributeType.getKey() + " =");
            System.out.println("        CoreSchemaImpl.getInstance().getAttributeType(\"" + ((AttributeType)attributeType.getValue()).getOID() + "\");");
        }
        System.out.println();
        System.out.println("    // Core Object Classes");
        for (Map.Entry objectClass : objectClasses.entrySet()) {
            System.out.println("    private static final ObjectClass " + (String)objectClass.getKey() + " =");
            System.out.println("        CoreSchemaImpl.getInstance().getObjectClass(\"" + ((ObjectClass)objectClass.getValue()).getOID() + "\");");
        }
        System.out.println();
        System.out.println("    // Prevent instantiation");
        System.out.println("    private CoreSchema() {");
        System.out.println("      // Nothing to do.");
        System.out.println("    }");
        System.out.println();
        System.out.println("    /**");
        System.out.println("     * Returns a reference to the singleton core schema.");
        System.out.println("     *");
        System.out.println("     * @return The core schema.");
        System.out.println("     */");
        System.out.println("    public static Schema getInstance() {");
        System.out.println("        return CoreSchemaImpl.getInstance();");
        System.out.println("    }");
        for (Map.Entry syntax : syntaxes.entrySet()) {
            System.out.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((Syntax)syntax.getValue()).getDescription().replaceAll(" Syntax$", "") + " Syntax");
            System.out.println("    /**");
            System.out.println("     * Returns a reference to the " + description);
            System.out.println("     * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((Syntax)syntax.getValue()).getOID()) + ".");
            System.out.println("     *");
            System.out.println("     * @return A reference to the " + description + ".");
            System.out.println("     */");
            System.out.println("    public static Syntax get" + GenerateCoreSchema.toJavaName((String)syntax.getKey()) + "() {");
            System.out.println("        return " + (String)syntax.getKey() + ";");
            System.out.println("    }");
        }
        for (Map.Entry matchingRule : matchingRules.entrySet()) {
            System.out.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((MatchingRule)matchingRule.getValue()).getNameOrOID());
            System.out.println("    /**");
            System.out.println("     * Returns a reference to the " + description + " Matching Rule");
            System.out.println("     * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((MatchingRule)matchingRule.getValue()).getOID()) + ".");
            System.out.println("     *");
            System.out.println("     * @return A reference to the " + description + " Matching Rule.");
            System.out.println("     */");
            System.out.println("    public static MatchingRule get" + GenerateCoreSchema.toJavaName((String)matchingRule.getKey()) + "() {");
            System.out.println("        return " + (String)matchingRule.getKey() + ";");
            System.out.println("    }");
        }
        for (Map.Entry attributeType : attributeTypes.entrySet()) {
            System.out.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((AttributeType)attributeType.getValue()).getNameOrOID());
            System.out.println("    /**");
            System.out.println("     * Returns a reference to the " + description + " Attribute Type");
            System.out.println("     * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((AttributeType)attributeType.getValue()).getOID()) + ".");
            System.out.println("     *");
            System.out.println("     * @return A reference to the " + description + " Attribute Type.");
            System.out.println("     */");
            System.out.println("    public static AttributeType get" + GenerateCoreSchema.toJavaName((String)attributeType.getKey()) + "() {");
            System.out.println("        return " + (String)attributeType.getKey() + ";");
            System.out.println("    }");
        }
        for (Map.Entry objectClass : objectClasses.entrySet()) {
            System.out.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((ObjectClass)objectClass.getValue()).getNameOrOID());
            System.out.println("    /**");
            System.out.println("     * Returns a reference to the " + description + " Object Class");
            System.out.println("     * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((ObjectClass)objectClass.getValue()).getOID()) + ".");
            System.out.println("     *");
            System.out.println("     * @return A reference to the " + description + " Object Class.");
            System.out.println("     */");
            System.out.println("    public static ObjectClass get" + GenerateCoreSchema.toJavaName((String)objectClass.getKey()) + "() {");
            System.out.println("        return " + (String)objectClass.getKey() + ";");
            System.out.println("    }");
        }
        System.out.println("}");
    }

    private static boolean isOpenDSOID(String oid) {
        return oid.startsWith("1.3.6.1.4.1.26027.1.");
    }

    private static boolean isCollationMatchingRule(String oid) {
        return oid.startsWith("1.3.6.1.4.1.42.2.27.9.4.");
    }

    private static String splitNameIntoWords(String name) {
        String splitName = name.replaceAll("([A-Z][a-z])", "_$1");
        splitName = splitName.replaceAll("([a-z])([A-Z])", "$1_$2");
        splitName = splitName.replaceAll("[-.]", "");
        return splitName.toUpperCase(Locale.ENGLISH);
    }

    private static void testSplitNameIntoWords() {
        String[][] values;
        for (String[] test : values = new String[][]{{"oneTwoThree", "ONE_TWO_THREE"}, {"oneTWOThree", "ONE_TWO_THREE"}, {"oneX500Three", "ONE_X500_THREE"}, {"oneTwoX500", "ONE_TWO_X500"}, {"oneTwoX500", "ONE_TWO_X500"}, {"x500TwoThree", "X500_TWO_THREE"}}) {
            String expected;
            String actual = GenerateCoreSchema.splitNameIntoWords(test[0]);
            if (actual.equals(expected = test[1])) continue;
            System.out.println("Test Split Failure: " + test[0] + " -> " + actual + " != " + expected);
        }
    }

    private static String toCodeJavaDoc(String text) {
        return String.format("{@code %s}", text);
    }

    private static String toJavaName(String splitName) {
        StringBuilder builder = new StringBuilder();
        for (String word : splitName.split("_")) {
            if (ABBREVIATIONS.contains(word)) {
                builder.append(word);
                continue;
            }
            builder.append(word.charAt(0));
            if (word.length() <= 1) continue;
            builder.append(word.substring(1).toLowerCase(Locale.ENGLISH));
        }
        return builder.toString();
    }

    private GenerateCoreSchema() {
    }
}

