/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class PasswordExpiredResponseControl
implements Control {
    public static final String OID = "2.16.840.1.113730.3.4.4";
    private final boolean isCritical;
    private static final PasswordExpiredResponseControl CRITICAL_INSTANCE = new PasswordExpiredResponseControl(true);
    private static final PasswordExpiredResponseControl NONCRITICAL_INSTANCE = new PasswordExpiredResponseControl(false);
    public static final ControlDecoder<PasswordExpiredResponseControl> DECODER = new ControlDecoder<PasswordExpiredResponseControl>(){

        @Override
        public PasswordExpiredResponseControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull((Object)control);
            if (control instanceof PasswordExpiredResponseControl) {
                return (PasswordExpiredResponseControl)control;
            }
            if (!control.getOID().equals(PasswordExpiredResponseControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_PWEXPIRED_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)PasswordExpiredResponseControl.OID);
                throw DecodeException.error(message);
            }
            if (control.hasValue()) {
                try {
                    Integer.parseInt(control.getValue().toString());
                }
                catch (Exception e) {
                    LocalizableMessage message = CoreMessages.ERR_PWEXPIRED_CONTROL_INVALID_VALUE.get();
                    throw DecodeException.error(message);
                }
            }
            return control.isCritical() ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
        }

        @Override
        public String getOID() {
            return PasswordExpiredResponseControl.OID;
        }
    };
    private static final ByteString CONTROL_VALUE = ByteString.valueOfUtf8("0");

    public static PasswordExpiredResponseControl newControl() {
        return NONCRITICAL_INSTANCE;
    }

    private PasswordExpiredResponseControl(boolean isCritical) {
        this.isCritical = isCritical;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return CONTROL_VALUE;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PasswordExpiredResponseControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(")");
        return builder.toString();
    }
}

