/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.opendj.ldap.AbstractLoadBalancingAlgorithm;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.util.Options;

final class RoundRobinLoadBalancingAlgorithm
extends AbstractLoadBalancingAlgorithm {
    private final int maxIndex;
    private final AtomicInteger nextIndex = new AtomicInteger(-1);

    RoundRobinLoadBalancingAlgorithm(Collection<? extends ConnectionFactory> factories, Options options) {
        super(factories, options);
        this.maxIndex = factories.size();
    }

    @Override
    String getAlgorithmName() {
        return "RoundRobin";
    }

    @Override
    int getInitialConnectionFactoryIndex() {
        int newNextIndex;
        int oldNextIndex;
        if (this.maxIndex == 1) {
            return 0;
        }
        do {
            if ((newNextIndex = (oldNextIndex = this.nextIndex.get()) + 1) != this.maxIndex) continue;
            newNextIndex = 0;
        } while (!this.nextIndex.compareAndSet(oldNextIndex, newNextIndex));
        return newNextIndex;
    }
}

