/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.StaticUtils;
import java.util.ArrayList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.FilterVisitor;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleUse;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class Matcher {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final MatcherImpl FALSE = new FalseMatcherImpl();
    private static final MatcherImpl TRUE = new TrueMatcherImpl();
    private static final MatcherImpl UNDEFINED = new UndefinedMatcherImpl();
    private static final FilterVisitor<MatcherImpl, Schema> VISITOR = new Visitor();
    private final MatcherImpl impl;

    private static ConditionResult matches(Attribute a, MatchingRule rule, Assertion assertion) {
        ConditionResult r = ConditionResult.FALSE;
        if (a != null) {
            for (ByteString v : a) {
                switch (Matcher.matches(v, rule, assertion)) {
                    case TRUE: {
                        return ConditionResult.TRUE;
                    }
                    case FALSE: {
                        break;
                    }
                    case UNDEFINED: {
                        r = ConditionResult.UNDEFINED;
                    }
                }
            }
        }
        return r;
    }

    private static ConditionResult matches(ByteString v, MatchingRule rule, Assertion assertion) {
        try {
            ByteString normalizedValue = rule.normalizeAttributeValue(v);
            return assertion.matches(normalizedValue);
        }
        catch (DecodeException de) {
            logger.warn(LocalizableMessage.raw((CharSequence)"The attribute value %s is invalid for matching rule %s. Possible schema error?", (Object[])new Object[]{v, rule.getNameOrOID(), de}));
            return ConditionResult.UNDEFINED;
        }
    }

    Matcher(Filter filter, Schema schema) {
        this.impl = filter.accept(VISITOR, schema);
    }

    public ConditionResult matches(Entry entry) {
        return this.impl.matches(entry);
    }

    private static final class Visitor
    implements FilterVisitor<MatcherImpl, Schema> {
        private Visitor() {
        }

        @Override
        public MatcherImpl visitAndFilter(Schema schema, List<Filter> subFilters) {
            if (subFilters.isEmpty()) {
                logger.trace(LocalizableMessage.raw((CharSequence)"Empty add filter component. Will always return TRUE", (Object[])new Object[0]));
                return TRUE;
            }
            ArrayList<MatcherImpl> subMatchers = new ArrayList<MatcherImpl>(subFilters.size());
            for (Filter f : subFilters) {
                subMatchers.add(f.accept(this, schema));
            }
            return new AndMatcherImpl(subMatchers);
        }

        @Override
        public MatcherImpl visitApproxMatchFilter(Schema schema, String attributeDescription, ByteString assertionValue) {
            Assertion assertion;
            AttributeDescription ad;
            try {
                ad = AttributeDescription.valueOf(attributeDescription, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                logger.warn(LocalizableMessage.raw((CharSequence)"Attribute description %s is not recognized", (Object[])new Object[]{attributeDescription, e}));
                return UNDEFINED;
            }
            MatchingRule rule = ad.getAttributeType().getApproximateMatchingRule();
            if (rule == null) {
                logger.warn(LocalizableMessage.raw((CharSequence)"The attribute type %s does not define an approximate matching rule", (Object[])new Object[]{attributeDescription}));
                return UNDEFINED;
            }
            try {
                assertion = rule.getAssertion(assertionValue);
            }
            catch (DecodeException de) {
                logger.warn(LocalizableMessage.raw((CharSequence)"The assertion value %s is invalid", (Object[])new Object[]{assertionValue, de}));
                return UNDEFINED;
            }
            return new AssertionMatcherImpl(ad, rule, null, assertion, false);
        }

        @Override
        public MatcherImpl visitEqualityMatchFilter(Schema schema, String attributeDescription, ByteString assertionValue) {
            Assertion assertion;
            AttributeDescription ad;
            try {
                ad = AttributeDescription.valueOf(attributeDescription, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                logger.warn(LocalizableMessage.raw((CharSequence)"Attribute description %s is not recognized", (Object[])new Object[]{attributeDescription, e}));
                return UNDEFINED;
            }
            MatchingRule rule = ad.getAttributeType().getEqualityMatchingRule();
            if (rule == null) {
                logger.warn(LocalizableMessage.raw((CharSequence)"The attribute type %s does not define an equality matching rule", (Object[])new Object[]{attributeDescription}));
                return UNDEFINED;
            }
            try {
                assertion = rule.getAssertion(assertionValue);
            }
            catch (DecodeException de) {
                logger.warn(LocalizableMessage.raw((CharSequence)"The assertion value %s is invalid", (Object[])new Object[]{assertionValue, de}));
                return UNDEFINED;
            }
            return new AssertionMatcherImpl(ad, rule, null, assertion, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public MatcherImpl visitExtensibleMatchFilter(Schema schema, String matchingRule, String attributeDescription, ByteString assertionValue, boolean dnAttributes) {
            MatchingRuleUse ruleUse;
            MatchingRule rule;
            AttributeDescription ad;
            block15: {
                block16: {
                    ad = null;
                    rule = null;
                    ruleUse = null;
                    if (matchingRule != null) {
                        try {
                            rule = schema.getMatchingRule(matchingRule);
                        }
                        catch (UnknownSchemaElementException e) {
                            logger.warn(LocalizableMessage.raw((CharSequence)"Matching rule %s is not recognized", (Object[])new Object[]{matchingRule}));
                            return UNDEFINED;
                        }
                    }
                    if (attributeDescription == null) break block16;
                    try {
                        ad = AttributeDescription.valueOf(attributeDescription, schema);
                    }
                    catch (LocalizedIllegalArgumentException e) {
                        logger.warn(LocalizableMessage.raw((CharSequence)"Attribute description %s is not recognized", (Object[])new Object[]{attributeDescription, e}));
                        return UNDEFINED;
                    }
                    if (rule == null) {
                        rule = ad.getAttributeType().getEqualityMatchingRule();
                        if (rule == null) {
                            logger.warn(LocalizableMessage.raw((CharSequence)"The attribute type %s does not define an equality matching rule", (Object[])new Object[]{attributeDescription}));
                            return UNDEFINED;
                        }
                        break block15;
                    } else {
                        try {
                            ruleUse = schema.getMatchingRuleUse(rule);
                            if (!ruleUse.hasAttribute(ad.getAttributeType())) {
                                logger.warn(LocalizableMessage.raw((CharSequence)"The matching rule %s is not valid for attribute type %s", (Object[])new Object[]{matchingRule, attributeDescription}));
                                return UNDEFINED;
                            }
                            break block15;
                        }
                        catch (UnknownSchemaElementException e) {
                            logger.warn(LocalizableMessage.raw((CharSequence)"No matching rule use is defined for matching rule %s", (Object[])new Object[]{matchingRule}));
                            return UNDEFINED;
                        }
                    }
                }
                try {
                    ruleUse = schema.getMatchingRuleUse(rule);
                }
                catch (UnknownSchemaElementException e) {
                    logger.warn(LocalizableMessage.raw((CharSequence)"No matching rule use is defined for matching rule %s", (Object[])new Object[]{matchingRule}));
                    return UNDEFINED;
                }
            }
            try {
                Assertion assertion = rule.getAssertion(assertionValue);
                return new AssertionMatcherImpl(ad, rule, ruleUse, assertion, dnAttributes);
            }
            catch (DecodeException de) {
                logger.warn(LocalizableMessage.raw((CharSequence)"The assertion value %s is invalid", (Object[])new Object[]{assertionValue, de}));
                return UNDEFINED;
            }
        }

        @Override
        public MatcherImpl visitGreaterOrEqualFilter(Schema schema, String attributeDescription, ByteString assertionValue) {
            Assertion assertion;
            AttributeDescription ad;
            try {
                ad = AttributeDescription.valueOf(attributeDescription, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                logger.warn(LocalizableMessage.raw((CharSequence)"Attribute description %s is not recognized", (Object[])new Object[]{attributeDescription, e}));
                return UNDEFINED;
            }
            MatchingRule rule = ad.getAttributeType().getOrderingMatchingRule();
            if (rule == null) {
                logger.warn(LocalizableMessage.raw((CharSequence)"The attribute type %s does not define an ordering matching rule", (Object[])new Object[]{attributeDescription}));
                return UNDEFINED;
            }
            try {
                assertion = rule.getGreaterOrEqualAssertion(assertionValue);
            }
            catch (DecodeException de) {
                logger.warn(LocalizableMessage.raw((CharSequence)"The assertion value %s is invalid", (Object[])new Object[]{assertionValue, de}));
                return UNDEFINED;
            }
            return new AssertionMatcherImpl(ad, rule, null, assertion, false);
        }

        @Override
        public MatcherImpl visitLessOrEqualFilter(Schema schema, String attributeDescription, ByteString assertionValue) {
            Assertion assertion;
            AttributeDescription ad;
            try {
                ad = AttributeDescription.valueOf(attributeDescription, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                logger.warn(LocalizableMessage.raw((CharSequence)"Attribute description %s is not recognized", (Object[])new Object[]{attributeDescription, e}));
                return UNDEFINED;
            }
            MatchingRule rule = ad.getAttributeType().getOrderingMatchingRule();
            if (rule == null) {
                logger.warn(LocalizableMessage.raw((CharSequence)"The attribute type %s does not define an ordering matching rule", (Object[])new Object[]{attributeDescription}));
                return UNDEFINED;
            }
            try {
                assertion = rule.getLessOrEqualAssertion(assertionValue);
            }
            catch (DecodeException de) {
                logger.warn(LocalizableMessage.raw((CharSequence)"The assertion value %s is invalid", (Object[])new Object[]{assertionValue, de}));
                return UNDEFINED;
            }
            return new AssertionMatcherImpl(ad, rule, null, assertion, false);
        }

        @Override
        public MatcherImpl visitNotFilter(Schema schema, Filter subFilter) {
            MatcherImpl subMatcher = subFilter.accept(this, schema);
            return new NotMatcherImpl(subMatcher);
        }

        @Override
        public MatcherImpl visitOrFilter(Schema schema, List<Filter> subFilters) {
            if (subFilters.isEmpty()) {
                logger.trace(LocalizableMessage.raw((CharSequence)"Empty or filter component. Will always return FALSE", (Object[])new Object[0]));
                return FALSE;
            }
            ArrayList<MatcherImpl> subMatchers = new ArrayList<MatcherImpl>(subFilters.size());
            for (Filter f : subFilters) {
                subMatchers.add(f.accept(this, schema));
            }
            return new OrMatcherImpl(subMatchers);
        }

        @Override
        public MatcherImpl visitPresentFilter(Schema schema, String attributeDescription) {
            AttributeDescription ad;
            try {
                ad = AttributeDescription.valueOf(attributeDescription, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                logger.warn(LocalizableMessage.raw((CharSequence)"Attribute description %s is not recognized", (Object[])new Object[]{attributeDescription, e}));
                return UNDEFINED;
            }
            return new PresentMatcherImpl(ad);
        }

        @Override
        public MatcherImpl visitSubstringsFilter(Schema schema, String attributeDescription, ByteString initialSubstring, List<ByteString> anySubstrings, ByteString finalSubstring) {
            Assertion assertion;
            AttributeDescription ad;
            try {
                ad = AttributeDescription.valueOf(attributeDescription, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                logger.warn(LocalizableMessage.raw((CharSequence)"Attribute description %s is not recognized", (Object[])new Object[]{attributeDescription, e}));
                return UNDEFINED;
            }
            MatchingRule rule = ad.getAttributeType().getSubstringMatchingRule();
            if (rule == null) {
                logger.warn(LocalizableMessage.raw((CharSequence)"The attribute type %s does not define an substring matching rule", (Object[])new Object[]{attributeDescription}));
                return UNDEFINED;
            }
            try {
                assertion = rule.getSubstringAssertion(initialSubstring, anySubstrings, finalSubstring);
            }
            catch (DecodeException de) {
                logger.warn(LocalizableMessage.raw((CharSequence)"The substring assertion values contain an invalid value", (Object[])new Object[]{de}));
                return UNDEFINED;
            }
            return new AssertionMatcherImpl(ad, rule, null, assertion, false);
        }

        @Override
        public MatcherImpl visitUnrecognizedFilter(Schema schema, byte filterTag, ByteString filterBytes) {
            logger.warn(LocalizableMessage.raw((CharSequence)"The type of filtering requested with tag %s is not implemented", (Object[])new Object[]{StaticUtils.byteToHex(filterTag)}));
            return UNDEFINED;
        }
    }

    private static class UndefinedMatcherImpl
    extends MatcherImpl {
        private UndefinedMatcherImpl() {
        }

        @Override
        public ConditionResult matches(Entry entry) {
            return ConditionResult.UNDEFINED;
        }
    }

    private static class TrueMatcherImpl
    extends MatcherImpl {
        private TrueMatcherImpl() {
        }

        @Override
        public ConditionResult matches(Entry entry) {
            return ConditionResult.TRUE;
        }
    }

    private static final class PresentMatcherImpl
    extends MatcherImpl {
        private final AttributeDescription attribute;

        private PresentMatcherImpl(AttributeDescription attribute) {
            this.attribute = attribute;
        }

        @Override
        public ConditionResult matches(Entry entry) {
            return entry.getAttribute(this.attribute) == null ? ConditionResult.FALSE : ConditionResult.TRUE;
        }
    }

    private static final class OrMatcherImpl
    extends MatcherImpl {
        private final List<MatcherImpl> subMatchers;

        private OrMatcherImpl(List<MatcherImpl> subMatchers) {
            this.subMatchers = subMatchers;
        }

        @Override
        public ConditionResult matches(Entry entry) {
            ConditionResult r = ConditionResult.FALSE;
            for (MatcherImpl m : this.subMatchers) {
                ConditionResult p = m.matches(entry);
                if (p == ConditionResult.TRUE) {
                    return p;
                }
                r = ConditionResult.or(r, p);
            }
            return r;
        }
    }

    private static final class NotMatcherImpl
    extends MatcherImpl {
        private final MatcherImpl subFilter;

        private NotMatcherImpl(MatcherImpl subFilter) {
            this.subFilter = subFilter;
        }

        @Override
        public ConditionResult matches(Entry entry) {
            return ConditionResult.not(this.subFilter.matches(entry));
        }
    }

    private static abstract class MatcherImpl {
        private MatcherImpl() {
        }

        public abstract ConditionResult matches(Entry var1);
    }

    private static class FalseMatcherImpl
    extends MatcherImpl {
        private FalseMatcherImpl() {
        }

        @Override
        public ConditionResult matches(Entry entry) {
            return ConditionResult.FALSE;
        }
    }

    private static final class AssertionMatcherImpl
    extends MatcherImpl {
        private final Assertion assertion;
        private final AttributeDescription attributeDescription;
        private final boolean dnAttributes;
        private final MatchingRule rule;
        private final MatchingRuleUse ruleUse;

        private AssertionMatcherImpl(AttributeDescription attributeDescription, MatchingRule rule, MatchingRuleUse ruleUse, Assertion assertion, boolean dnAttributes) {
            this.attributeDescription = attributeDescription;
            this.rule = rule;
            this.ruleUse = ruleUse;
            this.assertion = assertion;
            this.dnAttributes = dnAttributes;
        }

        @Override
        public ConditionResult matches(Entry entry) {
            ConditionResult r = ConditionResult.FALSE;
            if (this.attributeDescription != null) {
                ConditionResult p = Matcher.matches(entry.getAttribute(this.attributeDescription), this.rule, this.assertion);
                if (p == ConditionResult.TRUE) {
                    return p;
                }
                r = ConditionResult.or(r, p);
            } else {
                for (Attribute a : entry.getAllAttributes()) {
                    if (!this.ruleUse.hasAttribute(a.getAttributeDescription().getAttributeType())) continue;
                    ConditionResult p = Matcher.matches(a, this.rule, this.assertion);
                    if (p == ConditionResult.TRUE) {
                        return p;
                    }
                    r = ConditionResult.or(r, p);
                }
            }
            if (this.dnAttributes) {
                DN dn = entry.getName();
                for (RDN rdn : dn) {
                    for (AVA ava : rdn) {
                        if (!this.ruleUse.hasAttribute(ava.getAttributeType())) continue;
                        ConditionResult p = Matcher.matches(ava.getAttributeValue(), this.rule, this.assertion);
                        if (p == ConditionResult.TRUE) {
                            return p;
                        }
                        r = ConditionResult.or(r, p);
                    }
                }
            }
            return r;
        }
    }

    private static final class AndMatcherImpl
    extends MatcherImpl {
        private final List<MatcherImpl> subMatchers;

        private AndMatcherImpl(List<MatcherImpl> subMatchers) {
            this.subMatchers = subMatchers;
        }

        @Override
        public ConditionResult matches(Entry entry) {
            ConditionResult r = ConditionResult.TRUE;
            for (MatcherImpl m : this.subMatchers) {
                ConditionResult p = m.matches(entry);
                if (p == ConditionResult.FALSE) {
                    return p;
                }
                r = ConditionResult.and(r, p);
            }
            return r;
        }
    }
}

