/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.i18n.slf4j;

import java.util.Locale;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageDescriptor;
import org.forgerock.i18n.slf4j.LocalizedMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public final class LocalizedLogger {
    private static final String LOCALIZED_LOGGER_CLASSNAME = LocalizedLogger.class.getName();
    private static final String THREAD_CLASS_NAME = Thread.class.getName();
    private final Locale locale;
    private final Logger logger;

    public static LocalizedLogger getLocalizedLogger(Class<?> clazz) {
        Logger logger = LoggerFactory.getLogger(clazz);
        return new LocalizedLogger(logger, Locale.getDefault());
    }

    public static LocalizedLogger getLocalizedLogger(Logger logger) {
        return new LocalizedLogger(logger, Locale.getDefault());
    }

    public static LocalizedLogger getLocalizedLogger(String name) {
        Logger logger = LoggerFactory.getLogger((String)name);
        return new LocalizedLogger(logger, Locale.getDefault());
    }

    public static LocalizedLogger getLoggerForThisClass() {
        String name = LocalizedLogger.getClassNameOfCaller();
        if (name == null) {
            name = "ROOT";
        }
        return LocalizedLogger.getLocalizedLogger(name);
    }

    static String getClassNameOfCaller() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            for (StackTraceElement aStackTrace : stackTrace) {
                String name = aStackTrace.getClassName();
                if (name.equals(THREAD_CLASS_NAME) || name.equals(LOCALIZED_LOGGER_CLASSNAME)) continue;
                return aStackTrace.getClassName();
            }
        }
        return null;
    }

    LocalizedLogger(Logger logger, Locale locale) {
        this.locale = locale;
        this.logger = logger;
    }

    public void debug(LocalizableMessageDescriptor.Arg0 d) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get();
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void debug(LocalizableMessageDescriptor.Arg0 d, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get();
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1> void debug(LocalizableMessageDescriptor.Arg1<T1> d, T1 a1) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1> void debug(LocalizableMessageDescriptor.Arg1<T1> d, T1 a1, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2> void debug(LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2> void debug(LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3> void debug(LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3> void debug(LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4> void debug(LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4> void debug(LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5> void debug(LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5> void debug(LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6> void debug(LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6> void debug(LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void debug(LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void debug(LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void debug(LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void debug(LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void debug(LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void debug(LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void debug(LocalizableMessageDescriptor.ArgN d, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(args);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void debug(LocalizableMessageDescriptor.ArgN d, Throwable t, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            LocalizableMessage message = d.get(args);
            this.logger.debug((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void debug(LocalizableMessage m) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Marker)new LocalizedMarker(m), m.toString(this.locale));
        }
    }

    public void debug(LocalizableMessage m, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Marker)new LocalizedMarker(m), m.toString(this.locale), t);
        }
    }

    public void debug(Marker m, LocalizableMessageDescriptor.Arg0 d) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get().toString(this.locale));
        }
    }

    public void debug(Marker m, LocalizableMessageDescriptor.Arg0 d, Throwable t) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get().toString(this.locale), t);
        }
    }

    public <T1> void debug(Marker m, LocalizableMessageDescriptor.Arg1<T1> d, T1 a1) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1).toString(this.locale));
        }
    }

    public <T1> void debug(Marker m, LocalizableMessageDescriptor.Arg1<T1> d, T1 a1, Throwable t) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1).toString(this.locale), t);
        }
    }

    public <T1, T2> void debug(Marker m, LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2).toString(this.locale));
        }
    }

    public <T1, T2> void debug(Marker m, LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2, Throwable t) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2).toString(this.locale), t);
        }
    }

    public <T1, T2, T3> void debug(Marker m, LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3).toString(this.locale));
        }
    }

    public <T1, T2, T3> void debug(Marker m, LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3, Throwable t) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4> void debug(Marker m, LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3, a4).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4> void debug(Marker m, LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4, Throwable t) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3, a4).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5> void debug(Marker m, LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3, a4, a5).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5> void debug(Marker m, LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, Throwable t) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3, a4, a5).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6> void debug(Marker m, LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3, a4, a5, a6).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6> void debug(Marker m, LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, Throwable t) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3, a4, a5, a6).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void debug(Marker m, LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3, a4, a5, a6, a7).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void debug(Marker m, LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, Throwable t) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3, a4, a5, a6, a7).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void debug(Marker m, LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void debug(Marker m, LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, Throwable t) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void debug(Marker m, LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void debug(Marker m, LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, Throwable t) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9).toString(this.locale), t);
        }
    }

    public void debug(Marker m, LocalizableMessageDescriptor.ArgN d, Object ... args) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(args).toString(this.locale));
        }
    }

    public void debug(Marker m, LocalizableMessageDescriptor.ArgN d, Throwable t, Object ... args) {
        if (this.logger.isDebugEnabled(m)) {
            this.logger.debug(m, d.get(args).toString(this.locale), t);
        }
    }

    public void error(LocalizableMessageDescriptor.Arg0 d) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get();
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void error(LocalizableMessageDescriptor.Arg0 d, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get();
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1> void error(LocalizableMessageDescriptor.Arg1<T1> d, T1 a1) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1> void error(LocalizableMessageDescriptor.Arg1<T1> d, T1 a1, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2> void error(LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2> void error(LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3> void error(LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3> void error(LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4> void error(LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4> void error(LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5> void error(LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5> void error(LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6> void error(LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6> void error(LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void error(LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void error(LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void error(LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void error(LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void error(LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void error(LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void error(LocalizableMessageDescriptor.ArgN d, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(args);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void error(LocalizableMessageDescriptor.ArgN d, Throwable t, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            LocalizableMessage message = d.get(args);
            this.logger.error((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void error(LocalizableMessage m) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Marker)new LocalizedMarker(m), m.toString(this.locale));
        }
    }

    public void error(LocalizableMessage m, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Marker)new LocalizedMarker(m), m.toString(this.locale), t);
        }
    }

    public void error(Marker m, LocalizableMessageDescriptor.Arg0 d) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get().toString(this.locale));
        }
    }

    public void error(Marker m, LocalizableMessageDescriptor.Arg0 d, Throwable t) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get().toString(this.locale), t);
        }
    }

    public <T1> void error(Marker m, LocalizableMessageDescriptor.Arg1<T1> d, T1 a1) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1).toString(this.locale));
        }
    }

    public <T1> void error(Marker m, LocalizableMessageDescriptor.Arg1<T1> d, T1 a1, Throwable t) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1).toString(this.locale), t);
        }
    }

    public <T1, T2> void error(Marker m, LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2).toString(this.locale));
        }
    }

    public <T1, T2> void error(Marker m, LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2, Throwable t) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2).toString(this.locale), t);
        }
    }

    public <T1, T2, T3> void error(Marker m, LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3).toString(this.locale));
        }
    }

    public <T1, T2, T3> void error(Marker m, LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3, Throwable t) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4> void error(Marker m, LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3, a4).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4> void error(Marker m, LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4, Throwable t) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3, a4).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5> void error(Marker m, LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3, a4, a5).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5> void error(Marker m, LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, Throwable t) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3, a4, a5).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6> void error(Marker m, LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3, a4, a5, a6).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6> void error(Marker m, LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, Throwable t) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3, a4, a5, a6).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void error(Marker m, LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3, a4, a5, a6, a7).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void error(Marker m, LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, Throwable t) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3, a4, a5, a6, a7).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void error(Marker m, LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void error(Marker m, LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, Throwable t) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void error(Marker m, LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void error(Marker m, LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, Throwable t) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9).toString(this.locale), t);
        }
    }

    public void error(Marker m, LocalizableMessageDescriptor.ArgN d, Object ... args) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(args).toString(this.locale));
        }
    }

    public void error(Marker m, LocalizableMessageDescriptor.ArgN d, Throwable t, Object ... args) {
        if (this.logger.isErrorEnabled(m)) {
            this.logger.error(m, d.get(args).toString(this.locale), t);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public void info(LocalizableMessageDescriptor.Arg0 d) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get();
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void info(LocalizableMessageDescriptor.Arg0 d, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get();
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1> void info(LocalizableMessageDescriptor.Arg1<T1> d, T1 a1) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1> void info(LocalizableMessageDescriptor.Arg1<T1> d, T1 a1, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2> void info(LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2> void info(LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3> void info(LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3> void info(LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4> void info(LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4> void info(LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5> void info(LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5> void info(LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6> void info(LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6> void info(LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void info(LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void info(LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void info(LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void info(LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void info(LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void info(LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void info(LocalizableMessageDescriptor.ArgN d, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(args);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void info(LocalizableMessageDescriptor.ArgN d, Throwable t, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            LocalizableMessage message = d.get(args);
            this.logger.info((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void info(LocalizableMessage m) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Marker)new LocalizedMarker(m), m.toString(this.locale));
        }
    }

    public void info(LocalizableMessage m, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Marker)new LocalizedMarker(m), m.toString(this.locale), t);
        }
    }

    public void info(Marker m, LocalizableMessageDescriptor.Arg0 d) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get().toString(this.locale));
        }
    }

    public void info(Marker m, LocalizableMessageDescriptor.Arg0 d, Throwable t) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get().toString(this.locale), t);
        }
    }

    public <T1> void info(Marker m, LocalizableMessageDescriptor.Arg1<T1> d, T1 a1) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1).toString(this.locale));
        }
    }

    public <T1> void info(Marker m, LocalizableMessageDescriptor.Arg1<T1> d, T1 a1, Throwable t) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1).toString(this.locale), t);
        }
    }

    public <T1, T2> void info(Marker m, LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2).toString(this.locale));
        }
    }

    public <T1, T2> void info(Marker m, LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2, Throwable t) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2).toString(this.locale), t);
        }
    }

    public <T1, T2, T3> void info(Marker m, LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3).toString(this.locale));
        }
    }

    public <T1, T2, T3> void info(Marker m, LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3, Throwable t) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4> void info(Marker m, LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3, a4).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4> void info(Marker m, LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4, Throwable t) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3, a4).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5> void info(Marker m, LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3, a4, a5).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5> void info(Marker m, LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, Throwable t) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3, a4, a5).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6> void info(Marker m, LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3, a4, a5, a6).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6> void info(Marker m, LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, Throwable t) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3, a4, a5, a6).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void info(Marker m, LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3, a4, a5, a6, a7).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void info(Marker m, LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, Throwable t) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3, a4, a5, a6, a7).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void info(Marker m, LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void info(Marker m, LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, Throwable t) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void info(Marker m, LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void info(Marker m, LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, Throwable t) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9).toString(this.locale), t);
        }
    }

    public void info(Marker m, LocalizableMessageDescriptor.ArgN d, Object ... args) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(args).toString(this.locale));
        }
    }

    public void info(Marker m, LocalizableMessageDescriptor.ArgN d, Throwable t, Object ... args) {
        if (this.logger.isInfoEnabled(m)) {
            this.logger.info(m, d.get(args).toString(this.locale), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker m) {
        return this.logger.isDebugEnabled(m);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker m) {
        return this.logger.isErrorEnabled(m);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker m) {
        return this.logger.isInfoEnabled(m);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker m) {
        return this.logger.isTraceEnabled(m);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker m) {
        return this.logger.isWarnEnabled(m);
    }

    public void trace(LocalizableMessageDescriptor.Arg0 d) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get();
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void trace(String msg) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Marker)new LocalizedMarker(LocalizableMessage.raw((CharSequence)msg, (Object[])new Object[0])), msg);
        }
    }

    public void traceException(Throwable t) {
        this.traceException(t, t.getMessage() == null ? "" : t.getMessage());
    }

    public void trace(LocalizableMessageDescriptor.Arg0 d, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get();
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void traceException(Throwable t, String msg) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Marker)new LocalizedMarker(LocalizableMessage.raw((CharSequence)msg, (Object[])new Object[0])), msg, t);
        }
    }

    public <T1> void trace(LocalizableMessageDescriptor.Arg1<T1> d, T1 a1) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void trace(String format, Object a1) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = LocalizableMessage.raw((CharSequence)format, (Object[])new Object[]{a1});
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString());
        }
    }

    public <T1> void trace(LocalizableMessageDescriptor.Arg1<T1> d, T1 a1, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void traceException(Throwable t, String format, Object a1) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = LocalizableMessage.raw((CharSequence)format, (Object[])new Object[]{a1});
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(), t);
        }
    }

    public <T1, T2> void trace(LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void trace(String format, Object a1, Object a2) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = LocalizableMessage.raw((CharSequence)format, (Object[])new Object[]{a1, a2});
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString());
        }
    }

    public <T1, T2> void trace(LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void traceException(Throwable t, String format, Object a1, Object a2) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = LocalizableMessage.raw((CharSequence)format, (Object[])new Object[]{a1, a2});
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(), t);
        }
    }

    public <T1, T2, T3> void trace(LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void trace(String format, Object a1, Object a2, Object a3) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = LocalizableMessage.raw((CharSequence)format, (Object[])new Object[]{a1, a2, a3});
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString());
        }
    }

    public <T1, T2, T3> void trace(LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void traceException(Throwable t, String format, Object a1, Object a2, Object a3) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = LocalizableMessage.raw((CharSequence)format, (Object[])new Object[]{a1, a2, a3});
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(), t);
        }
    }

    public <T1, T2, T3, T4> void trace(LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4> void trace(LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5> void trace(LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5> void trace(LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6> void trace(LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6> void trace(LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void trace(LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void trace(LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void trace(LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void trace(LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void trace(LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void trace(LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void trace(LocalizableMessageDescriptor.ArgN d, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(args);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void trace(LocalizableMessageDescriptor.ArgN d, Throwable t, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = d.get(args);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void trace(String format, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = LocalizableMessage.raw((CharSequence)format, (Object[])args);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString());
        }
    }

    public void traceException(Throwable t, String format, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            LocalizableMessage message = LocalizableMessage.raw((CharSequence)format, (Object[])args);
            this.logger.trace((Marker)new LocalizedMarker(message), message.toString(), t);
        }
    }

    public void trace(LocalizableMessage m) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Marker)new LocalizedMarker(m), m.toString(this.locale));
        }
    }

    public void trace(LocalizableMessage m, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Marker)new LocalizedMarker(m), m.toString(this.locale), t);
        }
    }

    public void trace(Marker m, LocalizableMessageDescriptor.Arg0 d) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get().toString(this.locale));
        }
    }

    public void trace(Marker m, LocalizableMessageDescriptor.Arg0 d, Throwable t) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get().toString(this.locale), t);
        }
    }

    public <T1> void trace(Marker m, LocalizableMessageDescriptor.Arg1<T1> d, T1 a1) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1).toString(this.locale));
        }
    }

    public <T1> void trace(Marker m, LocalizableMessageDescriptor.Arg1<T1> d, T1 a1, Throwable t) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1).toString(this.locale), t);
        }
    }

    public <T1, T2> void trace(Marker m, LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2).toString(this.locale));
        }
    }

    public <T1, T2> void trace(Marker m, LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2, Throwable t) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2).toString(this.locale), t);
        }
    }

    public <T1, T2, T3> void trace(Marker m, LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3).toString(this.locale));
        }
    }

    public <T1, T2, T3> void trace(Marker m, LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3, Throwable t) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4> void trace(Marker m, LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3, a4).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4> void trace(Marker m, LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4, Throwable t) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3, a4).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5> void trace(Marker m, LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3, a4, a5).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5> void trace(Marker m, LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, Throwable t) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3, a4, a5).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6> void trace(Marker m, LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3, a4, a5, a6).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6> void trace(Marker m, LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, Throwable t) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3, a4, a5, a6).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void trace(Marker m, LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3, a4, a5, a6, a7).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void trace(Marker m, LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, Throwable t) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3, a4, a5, a6, a7).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void trace(Marker m, LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void trace(Marker m, LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, Throwable t) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void trace(Marker m, LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void trace(Marker m, LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, Throwable t) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9).toString(this.locale), t);
        }
    }

    public void trace(Marker m, LocalizableMessageDescriptor.ArgN d, Object ... args) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(args).toString(this.locale));
        }
    }

    public void trace(Marker m, LocalizableMessageDescriptor.ArgN d, Throwable t, Object ... args) {
        if (this.logger.isTraceEnabled(m)) {
            this.logger.trace(m, d.get(args).toString(this.locale), t);
        }
    }

    public void warn(LocalizableMessageDescriptor.Arg0 d) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get();
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void warn(LocalizableMessageDescriptor.Arg0 d, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get();
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1> void warn(LocalizableMessageDescriptor.Arg1<T1> d, T1 a1) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1> void warn(LocalizableMessageDescriptor.Arg1<T1> d, T1 a1, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2> void warn(LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2> void warn(LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3> void warn(LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3> void warn(LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4> void warn(LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4> void warn(LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5> void warn(LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5> void warn(LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6> void warn(LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6> void warn(LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void warn(LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void warn(LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void warn(LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void warn(LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void warn(LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void warn(LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void warn(LocalizableMessageDescriptor.ArgN d, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(args);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale));
        }
    }

    public void warn(LocalizableMessageDescriptor.ArgN d, Throwable t, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            LocalizableMessage message = d.get(args);
            this.logger.warn((Marker)new LocalizedMarker(message), message.toString(this.locale), t);
        }
    }

    public void warn(LocalizableMessage m) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Marker)new LocalizedMarker(m), m.toString(this.locale));
        }
    }

    public void warn(LocalizableMessage m, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Marker)new LocalizedMarker(m), m.toString(this.locale), t);
        }
    }

    public void warn(Marker m, LocalizableMessageDescriptor.Arg0 d) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get().toString(this.locale));
        }
    }

    public void warn(Marker m, LocalizableMessageDescriptor.Arg0 d, Throwable t) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get().toString(this.locale), t);
        }
    }

    public <T1> void warn(Marker m, LocalizableMessageDescriptor.Arg1<T1> d, T1 a1) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1).toString(this.locale));
        }
    }

    public <T1> void warn(Marker m, LocalizableMessageDescriptor.Arg1<T1> d, T1 a1, Throwable t) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1).toString(this.locale), t);
        }
    }

    public <T1, T2> void warn(Marker m, LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2).toString(this.locale));
        }
    }

    public <T1, T2> void warn(Marker m, LocalizableMessageDescriptor.Arg2<T1, T2> d, T1 a1, T2 a2, Throwable t) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2).toString(this.locale), t);
        }
    }

    public <T1, T2, T3> void warn(Marker m, LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3).toString(this.locale));
        }
    }

    public <T1, T2, T3> void warn(Marker m, LocalizableMessageDescriptor.Arg3<T1, T2, T3> d, T1 a1, T2 a2, T3 a3, Throwable t) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4> void warn(Marker m, LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3, a4).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4> void warn(Marker m, LocalizableMessageDescriptor.Arg4<T1, T2, T3, T4> d, T1 a1, T2 a2, T3 a3, T4 a4, Throwable t) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3, a4).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5> void warn(Marker m, LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3, a4, a5).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5> void warn(Marker m, LocalizableMessageDescriptor.Arg5<T1, T2, T3, T4, T5> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, Throwable t) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3, a4, a5).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6> void warn(Marker m, LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3, a4, a5, a6).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6> void warn(Marker m, LocalizableMessageDescriptor.Arg6<T1, T2, T3, T4, T5, T6> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, Throwable t) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3, a4, a5, a6).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void warn(Marker m, LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3, a4, a5, a6, a7).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7> void warn(Marker m, LocalizableMessageDescriptor.Arg7<T1, T2, T3, T4, T5, T6, T7> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, Throwable t) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3, a4, a5, a6, a7).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void warn(Marker m, LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> void warn(Marker m, LocalizableMessageDescriptor.Arg8<T1, T2, T3, T4, T5, T6, T7, T8> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, Throwable t) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8).toString(this.locale), t);
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void warn(Marker m, LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9).toString(this.locale));
        }
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> void warn(Marker m, LocalizableMessageDescriptor.Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9> d, T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, Throwable t) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(a1, a2, a3, a4, a5, a6, a7, a8, a9).toString(this.locale), t);
        }
    }

    public void warn(Marker m, LocalizableMessageDescriptor.ArgN d, Object ... args) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(args).toString(this.locale));
        }
    }

    public void warn(Marker m, LocalizableMessageDescriptor.ArgN d, Throwable t, Object ... args) {
        if (this.logger.isWarnEnabled(m)) {
            this.logger.warn(m, d.get(args).toString(this.locale), t);
        }
    }
}

