/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.util.OperatingSystem;
import com.forgerock.opendj.util.StaticUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.NamingSecurityException;
import javax.naming.NoPermissionException;
import javax.net.ssl.SSLHandshakeException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.LocalizableMessageDescriptor;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.RDN;

public final class Utils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String OBFUSCATED_VALUE = "******";
    public static final int CONFIRMATION_MAX_TRIES = 5;
    public static final String DATE_FORMAT_LOCAL_TIME = "dd/MMM/yyyy:HH:mm:ss Z";
    private static final String COMMENT_SHELL_UNIX = "# ";
    private static final String COMMENT_BATCH_WINDOWS = "rem ";
    public static final String SHELL_COMMENT_SEPARATOR = OperatingSystem.isWindows() ? "rem " : "# ";
    public static final int MAX_LINE_WIDTH;

    public static String getCurrentOperationDateMessage() {
        String date = Utils.formatDateTimeStringForEquivalentCommand(new Date());
        return CliMessages.INFO_OPERATION_START_TIME_MESSAGE.get((Object)date).toString();
    }

    public static String formatDateTimeStringForEquivalentCommand(Date date) {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_LOCAL_TIME);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat.format(date);
        }
        return null;
    }

    public static int filterExitCode(int exitCode) {
        if (exitCode < 0) {
            return 255;
        }
        if (exitCode > 255) {
            return 255;
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesFromFile(String filePath) throws IOException {
        byte[] val = null;
        try (FileInputStream fis = null;){
            int offset;
            File file = new File(filePath);
            fis = new FileInputStream(file);
            long length = file.length();
            val = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < val.length && (numRead = fis.read(val, offset, val.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < val.length) {
                throw new IOException("Could not completely read file " + filePath);
            }
            byte[] byArray = val;
            return byArray;
        }
    }

    public static LocalizableMessage secondsToTimeString(int numSeconds) {
        if (numSeconds < 60) {
            return CliMessages.INFO_TIME_IN_SECONDS.get((Object)numSeconds);
        }
        if (numSeconds < 3600) {
            int m = numSeconds / 60;
            int s = numSeconds % 60;
            return CliMessages.INFO_TIME_IN_MINUTES_SECONDS.get((Object)m, (Object)s);
        }
        if (numSeconds < 86400) {
            int h = numSeconds / 3600;
            int m = numSeconds % 3600 / 60;
            int s = numSeconds % 3600 % 60;
            return CliMessages.INFO_TIME_IN_HOURS_MINUTES_SECONDS.get((Object)h, (Object)m, (Object)s);
        }
        int d = numSeconds / 86400;
        int h = numSeconds % 86400 / 3600;
        int m = numSeconds % 86400 % 3600 / 60;
        int s = numSeconds % 86400 % 3600 % 60;
        return CliMessages.INFO_TIME_IN_DAYS_HOURS_MINUTES_SECONDS.get((Object)d, (Object)h, (Object)m, (Object)s);
    }

    public static String wrapText(LocalizableMessage message, int width) {
        return Utils.wrapText(message.toString(), width, 0);
    }

    public static String wrapText(LocalizableMessage message, int width, int indent) {
        return Utils.wrapText(message.toString(), width, indent);
    }

    public static String wrapText(String text, int width) {
        return Utils.wrapText(text, width, 0);
    }

    public static String wrapText(String text, int width, int indent) {
        if (text == null) {
            return "";
        }
        width -= indent;
        StringBuilder pb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            pb.append(' ');
        }
        String padding = pb.toString();
        StringBuilder buffer = new StringBuilder();
        StringTokenizer lineTokenizer = new StringTokenizer(text, "\r\n", true);
        while (lineTokenizer.hasMoreTokens()) {
            String line = lineTokenizer.nextToken();
            if ("\r".equals(line) || "\n".equals(line)) {
                buffer.append(line);
                continue;
            }
            if (line.length() <= width) {
                buffer.append(padding);
                buffer.append(line);
                continue;
            }
            StringBuilder lineBuffer = new StringBuilder();
            StringBuilder delimBuffer = new StringBuilder();
            StringTokenizer wordTokenizer = new StringTokenizer(line, " ", true);
            while (wordTokenizer.hasMoreTokens()) {
                String word = wordTokenizer.nextToken();
                if (" ".equals(word)) {
                    if (lineBuffer.length() <= 0) continue;
                    delimBuffer.append(word);
                    continue;
                }
                if (word.length() > width) {
                    if (lineBuffer.length() > 0) {
                        buffer.append(padding).append((CharSequence)lineBuffer).append(StaticUtils.EOL);
                        lineBuffer = new StringBuilder();
                    }
                    buffer.append(padding);
                    buffer.append(word);
                    if (wordTokenizer.hasMoreTokens()) {
                        wordTokenizer.nextToken();
                        if (wordTokenizer.hasMoreTokens()) {
                            buffer.append(StaticUtils.EOL);
                        }
                    }
                    if (delimBuffer.length() <= 0) continue;
                    delimBuffer = new StringBuilder();
                    continue;
                }
                int newLineLength = lineBuffer.length() + delimBuffer.length() + word.length();
                if (newLineLength < width) {
                    lineBuffer.append((CharSequence)delimBuffer).append(word);
                    if (delimBuffer.length() <= 0) continue;
                    delimBuffer = new StringBuilder();
                    continue;
                }
                buffer.append(padding).append((CharSequence)lineBuffer).append(StaticUtils.EOL);
                lineBuffer = new StringBuilder();
                lineBuffer.append(word);
                if (delimBuffer.length() <= 0) continue;
                delimBuffer = new StringBuilder();
            }
            buffer.append(padding);
            buffer.append((CharSequence)lineBuffer);
        }
        return buffer.toString();
    }

    public static void checkJavaVersion() throws ClientException {
        String version = System.getProperty("java.specification.version");
        if (Float.valueOf(version).floatValue() < 1.7f) {
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            throw new ClientException(ReturnCode.JAVA_VERSION_INCOMPATIBLE, CliMessages.ERR_INCOMPATIBLE_JAVA_VERSION.get((Object)Float.valueOf(1.7f), (Object)version, (Object)javaBin), null);
        }
    }

    public static String getDefaultHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            String host = System.getenv("COMPUTERNAME");
            if (host != null) {
                return host;
            }
            host = System.getenv("HOSTNAME");
            if (host != null) {
                return host;
            }
            return "";
        }
    }

    public static boolean isCertificateException(Throwable t) {
        while (t != null) {
            if (t instanceof SSLHandshakeException || t instanceof GeneralSecurityException) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    public static LocalizableMessage getMessageForException(NamingException ne, String hostPort) {
        String arg = ne.getLocalizedMessage() != null ? ne.getLocalizedMessage() : (ne.getExplanation() != null ? ne.getExplanation() : ne.toString(true));
        if (Utils.isCertificateException(ne)) {
            return CliMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE_SERVER.get((Object)hostPort, (Object)arg);
        }
        if (ne instanceof AuthenticationException) {
            return CliMessages.INFO_CANNOT_CONNECT_TO_REMOTE_AUTHENTICATION.get((Object)hostPort, (Object)arg);
        }
        if (ne instanceof NoPermissionException) {
            return CliMessages.INFO_CANNOT_CONNECT_TO_REMOTE_PERMISSIONS.get((Object)hostPort, (Object)arg);
        }
        if (ne instanceof NamingSecurityException) {
            return CliMessages.INFO_CANNOT_CONNECT_TO_REMOTE_PERMISSIONS.get((Object)hostPort, (Object)arg);
        }
        if (ne instanceof CommunicationException) {
            return CliMessages.ERR_CANNOT_CONNECT_TO_REMOTE_COMMUNICATION.get((Object)hostPort, (Object)arg);
        }
        return CliMessages.INFO_CANNOT_CONNECT_TO_REMOTE_GENERIC.get((Object)hostPort, (Object)arg);
    }

    public static LocalizableMessage getThrowableMsg(LocalizableMessage message, Throwable t) {
        LocalizableMessageDescriptor.Arg1<Object> tag = Utils.isOutOfMemory(t) ? CliMessages.INFO_EXCEPTION_OUT_OF_MEMORY_DETAILS : CliMessages.INFO_EXCEPTION_DETAILS;
        LocalizableMessageBuilder mb = new LocalizableMessageBuilder(message);
        String detail = t.toString();
        if (detail != null) {
            mb.append((CharSequence)"  ").append(tag.get((Object)detail));
        }
        return mb.toMessage();
    }

    public static boolean canWrite(String path) {
        File file = new File(path);
        if (file.exists()) {
            return file.canWrite();
        }
        File parentFile = file.getParentFile();
        return parentFile != null && parentFile.canWrite();
    }

    private Utils() {
    }

    public static boolean isDN(String dn) {
        try {
            DN.valueOf((String)dn);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getAdministratorDN(String uid) {
        return RDN.valueOf((String)("cn=" + uid)) + ",cn=Administrators, cn=admin data";
    }

    private static boolean isOutOfMemory(Throwable t) {
        boolean isOutOfMemory = false;
        while (!isOutOfMemory && t != null) {
            String msg;
            if (t instanceof OutOfMemoryError) {
                isOutOfMemory = true;
            } else if (t instanceof IOException && (msg = t.toString()) != null) {
                isOutOfMemory = msg.contains("Not enough space");
            }
            t = t.getCause();
        }
        return isOutOfMemory;
    }

    public static String getHostNameForLdapUrl(String host) {
        if (host != null && host.contains(":")) {
            if (!(host = host.trim()).startsWith("[")) {
                host = "[" + host;
            }
            if (!host.endsWith("]")) {
                host = host + "]";
            }
        }
        return host;
    }

    public static void printWrappedText(PrintStream stream, String message) {
        if (stream != null && message != null && !message.isEmpty()) {
            stream.println(Utils.wrapText(message, MAX_LINE_WIDTH));
        }
    }

    public static void printWrappedText(PrintStream stream, LocalizableMessage message) {
        Utils.printWrappedText(stream, message != null ? message.toString() : null);
    }

    static {
        int columns = 80;
        try {
            String s = System.getenv("COLUMNS");
            if (s != null) {
                columns = Integer.parseInt(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MAX_LINE_WIDTH = columns - 1;
    }
}

