/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.DocDescriptionSupplement;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import com.forgerock.opendj.util.StaticUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.forgerock.i18n.LocalizableMessage;

public class SubCommand
implements DocDescriptionSupplement {
    private boolean isHidden;
    private final HashMap<Character, Argument> shortIDMap = new HashMap();
    private final HashMap<String, Argument> longIDMap = new HashMap();
    private final LinkedList<Argument> arguments = new LinkedList();
    private LocalizableMessage description;
    private String name;
    private SubCommandArgumentParser parser;
    private boolean allowsTrailingArguments;
    private int maxTrailingArguments;
    private int minTrailingArguments;
    private String trailingArgsDisplayName;
    private LocalizableMessage docDescriptionSupplement;

    public SubCommand(SubCommandArgumentParser parser, String name, LocalizableMessage description) throws ArgumentException {
        this(parser, name, false, 0, 0, null, description);
    }

    public SubCommand(SubCommandArgumentParser parser, String name, boolean allowsTrailingArguments, int minTrailingArguments, int maxTrailingArguments, String trailingArgsDisplayName, LocalizableMessage description) throws ArgumentException {
        this.parser = parser;
        this.name = name;
        this.description = description;
        this.allowsTrailingArguments = allowsTrailingArguments;
        this.minTrailingArguments = minTrailingArguments;
        this.maxTrailingArguments = maxTrailingArguments;
        this.trailingArgsDisplayName = trailingArgsDisplayName;
        this.isHidden = false;
        String nameToCheck = name;
        if (parser.longArgumentsCaseSensitive()) {
            nameToCheck = StaticUtils.toLowerCase((String)name);
        }
        if (parser.hasSubCommand(nameToCheck)) {
            LocalizableMessage message = CliMessages.ERR_ARG_SUBCOMMAND_DUPLICATE_SUBCOMMAND.get((Object)name);
            throw new ArgumentException(message);
        }
        parser.addSubCommand(this);
    }

    public String getName() {
        return this.name;
    }

    public LocalizableMessage getDescription() {
        return this.description;
    }

    @Override
    public LocalizableMessage getDocDescriptionSupplement() {
        return this.docDescriptionSupplement != null ? this.docDescriptionSupplement : LocalizableMessage.EMPTY;
    }

    @Override
    public void setDocDescriptionSupplement(LocalizableMessage docDescriptionSupplement) {
        this.docDescriptionSupplement = docDescriptionSupplement;
    }

    public LinkedList<Argument> getArguments() {
        return this.arguments;
    }

    public Argument getArgument(Character shortID) {
        return this.shortIDMap.get(shortID);
    }

    public Argument getArgument(String longID) {
        return this.longIDMap.get(longID);
    }

    public Argument getArgumentForName(String name) {
        for (Argument a : this.arguments) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public void addArgument(Argument argument) throws ArgumentException {
        String longID;
        String argumentName = argument.getName();
        for (Argument a : this.arguments) {
            if (!argumentName.equals(a.getName())) continue;
            LocalizableMessage message = CliMessages.ERR_ARG_SUBCOMMAND_DUPLICATE_ARGUMENT_NAME.get((Object)this.name, (Object)argumentName);
            throw new ArgumentException(message);
        }
        if (this.parser.hasGlobalArgument(argumentName)) {
            LocalizableMessage message = CliMessages.ERR_ARG_SUBCOMMAND_ARGUMENT_GLOBAL_CONFLICT.get((Object)argumentName, (Object)this.name);
            throw new ArgumentException(message);
        }
        Character shortID = argument.getShortIdentifier();
        if (shortID != null) {
            if (this.shortIDMap.containsKey(shortID)) {
                LocalizableMessage message = CliMessages.ERR_ARG_SUBCOMMAND_DUPLICATE_SHORT_ID.get((Object)argumentName, (Object)this.name, (Object)String.valueOf(shortID), (Object)this.shortIDMap.get(shortID).getName());
                throw new ArgumentException(message);
            }
            Argument arg = this.parser.getGlobalArgumentForShortID(shortID);
            if (arg != null) {
                LocalizableMessage message = CliMessages.ERR_ARG_SUBCOMMAND_ARGUMENT_SHORT_ID_GLOBAL_CONFLICT.get((Object)argumentName, (Object)this.name, (Object)String.valueOf(shortID), (Object)arg.getName());
                throw new ArgumentException(message);
            }
        }
        if ((longID = argument.getLongIdentifier()) != null) {
            if (!this.parser.longArgumentsCaseSensitive()) {
                longID = StaticUtils.toLowerCase((String)longID);
            }
            if (this.longIDMap.containsKey(longID)) {
                LocalizableMessage message = CliMessages.ERR_ARG_SUBCOMMAND_DUPLICATE_LONG_ID.get((Object)argumentName, (Object)this.name, (Object)argument.getLongIdentifier(), (Object)this.longIDMap.get(longID).getName());
                throw new ArgumentException(message);
            }
            Argument arg = this.parser.getGlobalArgumentForLongID(longID);
            if (arg != null) {
                LocalizableMessage message = CliMessages.ERR_ARG_SUBCOMMAND_ARGUMENT_LONG_ID_GLOBAL_CONFLICT.get((Object)argumentName, (Object)this.name, (Object)argument.getLongIdentifier(), (Object)arg.getName());
                throw new ArgumentException(message);
            }
        }
        this.arguments.add(argument);
        if (shortID != null) {
            this.shortIDMap.put(shortID, argument);
        }
        if (longID != null) {
            this.longIDMap.put(longID, argument);
        }
    }

    public boolean allowsTrailingArguments() {
        return this.allowsTrailingArguments;
    }

    public int getMinTrailingArguments() {
        return this.minTrailingArguments;
    }

    public int getMaxTrailingArguments() {
        return this.maxTrailingArguments;
    }

    public String getTrailingArgumentsDisplayName() {
        return this.trailingArgsDisplayName;
    }

    public ArrayList<String> getTrailingArguments() {
        return this.parser.getTrailingArguments();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("(").append("name=").append(this.name);
        if (!this.longIDMap.isEmpty()) {
            sb.append(", longIDs=").append(this.longIDMap.keySet());
        }
        if (!this.shortIDMap.isEmpty()) {
            sb.append(", shortIDs=").append(this.shortIDMap.keySet());
        }
        sb.append(")");
        return sb.toString();
    }
}

