/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.DocDescriptionSupplement;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Iterator;
import java.util.LinkedList;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;

public abstract class Argument
implements DocDescriptionSupplement {
    private boolean isHidden;
    private boolean isMultiValued;
    private boolean isPresent;
    private boolean isRequired;
    private boolean needsValue;
    private String defaultValue;
    private final Character shortIdentifier;
    private final String longIdentifier;
    private final LocalizableMessage description;
    private final LinkedList<String> values = new LinkedList();
    private final String name;
    private String propertyName;
    private LocalizableMessage valuePlaceholder;
    private boolean isValueSetByProperty;
    private LocalizableMessage docDescriptionSupplement;

    protected Argument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, boolean needsValue, LocalizableMessage valuePlaceholder, String defaultValue, String propertyName, LocalizableMessage description) throws ArgumentException {
        this.name = name;
        this.shortIdentifier = shortIdentifier;
        this.longIdentifier = longIdentifier;
        this.isRequired = isRequired;
        this.isMultiValued = isMultiValued;
        this.needsValue = needsValue;
        this.valuePlaceholder = valuePlaceholder;
        this.defaultValue = defaultValue;
        this.propertyName = propertyName;
        this.description = description;
        this.isValueSetByProperty = false;
        if (shortIdentifier == null && longIdentifier == null) {
            throw new ArgumentException(CliMessages.ERR_ARG_NO_IDENTIFIER.get((Object)name));
        }
        if (needsValue && valuePlaceholder == null) {
            throw new ArgumentException(CliMessages.ERR_ARG_NO_VALUE_PLACEHOLDER.get((Object)name));
        }
        this.isPresent = false;
        this.isHidden = false;
    }

    public void addValue(String valueString) {
        if (!this.isMultiValued) {
            this.clearValues();
        }
        this.values.add(valueString);
    }

    public void clearValues() {
        this.values.clear();
    }

    public boolean getBooleanValue() throws ArgumentException {
        if (this.values.isEmpty()) {
            throw new ArgumentException(CliMessages.ERR_ARG_NO_BOOLEAN_VALUE.get((Object)this.name));
        }
        Iterator iterator = this.values.iterator();
        String valueString = StaticUtils.toLowerCase((String)((String)iterator.next()));
        if (iterator.hasNext()) {
            throw new ArgumentException(CliMessages.ERR_ARG_BOOLEAN_MULTIPLE_VALUES.get((Object)this.name));
        }
        if ("true".equals(valueString) || "yes".equals(valueString) || "on".equals(valueString) || "1".equals(valueString)) {
            return true;
        }
        if ("false".equals(valueString) || "no".equals(valueString) || "off".equals(valueString) || "0".equals(valueString)) {
            return false;
        }
        throw new ArgumentException(CliMessages.ERR_ARG_CANNOT_DECODE_AS_BOOLEAN.get((Object)valueString, (Object)this.name));
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public LocalizableMessage getDescription() {
        return this.description != null ? this.description : LocalizableMessage.EMPTY;
    }

    @Override
    public LocalizableMessage getDocDescriptionSupplement() {
        return this.docDescriptionSupplement != null ? this.docDescriptionSupplement : LocalizableMessage.EMPTY;
    }

    @Override
    public void setDocDescriptionSupplement(LocalizableMessage docDescriptionSupplement) {
        this.docDescriptionSupplement = docDescriptionSupplement;
    }

    public double getDoubleValue() throws ArgumentException {
        if (this.values.isEmpty()) {
            throw new ArgumentException(CliMessages.ERR_ARG_NO_INT_VALUE.get((Object)this.name));
        }
        Iterator iterator = this.values.iterator();
        String valueString = (String)iterator.next();
        if (iterator.hasNext()) {
            throw new ArgumentException(CliMessages.ERR_ARG_INT_MULTIPLE_VALUES.get((Object)this.name));
        }
        try {
            return Double.parseDouble(valueString);
        }
        catch (Exception e) {
            throw new ArgumentException(CliMessages.ERR_ARG_CANNOT_DECODE_AS_INT.get((Object)valueString, (Object)this.name), (Throwable)e);
        }
    }

    public LinkedList<Double> getDoubleValues() throws ArgumentException {
        LinkedList<Double> results = new LinkedList<Double>();
        for (String valueString : this.values) {
            try {
                results.add(Double.valueOf(valueString));
            }
            catch (Exception e) {
                throw new ArgumentException(CliMessages.ERR_ARG_CANNOT_DECODE_AS_DOUBLE.get((Object)valueString, (Object)this.name), (Throwable)e);
            }
        }
        return results;
    }

    public int getIntValue() throws ArgumentException {
        if (this.values.isEmpty()) {
            throw new ArgumentException(CliMessages.ERR_ARG_NO_INT_VALUE.get((Object)this.name));
        }
        Iterator iterator = this.values.iterator();
        String valueString = (String)iterator.next();
        if (iterator.hasNext()) {
            throw new ArgumentException(CliMessages.ERR_ARG_INT_MULTIPLE_VALUES.get((Object)this.name));
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (Exception e) {
            throw new ArgumentException(CliMessages.ERR_ARG_CANNOT_DECODE_AS_INT.get((Object)valueString, (Object)this.name), (Throwable)e);
        }
    }

    public LinkedList<Integer> getIntValues() throws ArgumentException {
        LinkedList<Integer> results = new LinkedList<Integer>();
        for (String valueString : this.values) {
            try {
                results.add(Integer.valueOf(valueString));
            }
            catch (Exception e) {
                throw new ArgumentException(CliMessages.ERR_ARG_CANNOT_DECODE_AS_INT.get((Object)valueString, (Object)this.name), (Throwable)e);
            }
        }
        return results;
    }

    public String getLongIdentifier() {
        return this.longIdentifier;
    }

    public String getName() {
        return this.name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Character getShortIdentifier() {
        return this.shortIdentifier;
    }

    public String getValue() {
        return !this.values.isEmpty() ? this.values.getFirst() : this.defaultValue;
    }

    public LocalizableMessage getValuePlaceholder() {
        return this.valuePlaceholder;
    }

    public LinkedList<String> getValues() {
        return this.values;
    }

    public boolean hasValue() {
        return !this.values.isEmpty();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isValueSetByProperty() {
        return this.isValueSetByProperty;
    }

    public boolean needsValue() {
        return this.needsValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public void setMultiValued(boolean isMultiValued) {
        this.isMultiValued = isMultiValued;
    }

    public void setNeedsValue(boolean needsValue) {
        this.needsValue = needsValue;
    }

    public void setPresent(boolean isPresent) {
        this.isPresent = isPresent;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public void setValuePlaceholder(LocalizableMessage valuePlaceholder) {
        this.valuePlaceholder = valuePlaceholder;
    }

    public void setValueSetByProperty(boolean isValueSetByProperty) {
        this.isValueSetByProperty = isValueSetByProperty;
    }

    public abstract boolean valueIsAcceptable(String var1, LocalizableMessageBuilder var2);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        if (this.longIdentifier != null) {
            sb.append("longID=");
            sb.append(this.longIdentifier);
        }
        if (this.shortIdentifier != null) {
            if (this.longIdentifier != null) {
                sb.append(", ");
            }
            sb.append("shortID=");
            sb.append(this.shortIdentifier);
        }
        sb.append(", values=").append(this.values);
        sb.append(")");
        return sb.toString();
    }
}

