/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.VersionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class SdkVersionHandler
implements VersionHandler {
    public void printVersion() {
        System.out.println(this.getVersion());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getVersion() + ")";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getVersion() {
        try {
            URL manifestUrl;
            Enumeration<URL> manifests = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            do {
                if (!manifests.hasMoreElements()) return null;
            } while (!(manifestUrl = manifests.nextElement()).toString().contains("/opendj-core-"));
            try (InputStream manifestStream = manifestUrl.openStream();){
                Attributes attrs = new Manifest(manifestStream).getMainAttributes();
                String string = attrs.getValue("Bundle-Version") + " (revision " + attrs.getValue("SCM-Revision") + ")";
                return string;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while determining SDK version", e);
        }
    }
}

