/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiColumnPrinter;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.ldap.tools.DataSource;
import com.forgerock.opendj.ldap.tools.PerformanceRunnerOptions;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.util.promise.Promise;

abstract class PerformanceRunner
implements ConnectionEventListener {
    private static final String[] EMPTY_STRINGS = new String[0];
    private final AtomicInteger operationRecentCount = new AtomicInteger();
    protected final AtomicInteger successRecentCount = new AtomicInteger();
    protected final AtomicInteger failedRecentCount = new AtomicInteger();
    private final AtomicLong waitRecentTimeNs = new AtomicLong();
    private final ResponseTimeBuckets eTimesBuckets = new ResponseTimeBuckets();
    private final ConsoleApplication app;
    private DataSource[] dataSourcePrototypes;
    private final ThreadLocal<DataSource[]> dataSources = new ThreadLocal<DataSource[]>(){

        @Override
        protected DataSource[] initialValue() {
            DataSource[] prototypes = PerformanceRunner.this.getDataSources();
            int sz = prototypes.length;
            DataSource[] threadLocalCopy = new DataSource[sz];
            for (int i = 0; i < sz; ++i) {
                threadLocalCopy[i] = prototypes[i].duplicate();
            }
            return threadLocalCopy;
        }
    };
    int numThreads;
    int numConnections;
    volatile boolean stopRequested;
    private volatile boolean isWarmingUp;
    private int targetThroughput;
    private int maxIterations;
    private long warmUpDuration;
    private long maxDurationTime;
    private boolean isAsync;
    private boolean noRebind;
    private BindRequest bindRequest;
    private int statsInterval;
    private final IntegerArgument numThreadsArgument;
    private final IntegerArgument maxDurationArgument;
    private final IntegerArgument statsIntervalArgument;
    private final IntegerArgument targetThroughputArgument;
    private final IntegerArgument numConnectionsArgument;
    private final IntegerArgument percentilesArgument;
    private final BooleanArgument keepConnectionsOpen;
    private final BooleanArgument noRebindArgument;
    private final BooleanArgument asyncArgument;
    private final StringArgument arguments;
    protected final IntegerArgument maxIterationsArgument;
    protected final IntegerArgument warmUpArgument;
    private final List<Thread> workerThreads = new ArrayList<Thread>();

    static ResponseTimeBuckets getResponseTimeBuckets() {
        return new ResponseTimeBuckets();
    }

    PerformanceRunner(PerformanceRunnerOptions options) throws ArgumentException {
        ArgumentParser argParser = options.getArgumentParser();
        this.app = options.getConsoleApplication();
        this.numThreadsArgument = new IntegerArgument("numThreads", Character.valueOf('t'), "numThreads", false, false, true, LocalizableMessage.raw((CharSequence)"{numThreads}", (Object[])new Object[0]), 1, null, true, 1, false, 0, LocalizableMessage.raw((CharSequence)"Number of worker threads per connection", (Object[])new Object[0]));
        this.numThreadsArgument.setPropertyName("numThreads");
        if (options.supportsMultipleThreadsPerConnection()) {
            argParser.addArgument((Argument)this.numThreadsArgument);
        } else {
            this.numThreadsArgument.addValue("1");
        }
        this.numConnectionsArgument = new IntegerArgument("numConnections", Character.valueOf('c'), "numConnections", false, false, true, LocalizableMessage.raw((CharSequence)"{numConnections}", (Object[])new Object[0]), 1, null, true, 1, false, 0, LocalizableMessage.raw((CharSequence)"Number of connections", (Object[])new Object[0]));
        this.numConnectionsArgument.setPropertyName("numConnections");
        argParser.addArgument((Argument)this.numConnectionsArgument);
        this.maxIterationsArgument = new IntegerArgument("maxIterations", Character.valueOf('m'), "maxIterations", false, false, true, LocalizableMessage.raw((CharSequence)"{maxIterations}", (Object[])new Object[0]), 0, null, LocalizableMessage.raw((CharSequence)"Max iterations, 0 for unlimited", (Object[])new Object[0]));
        this.maxIterationsArgument.setPropertyName("maxIterations");
        argParser.addArgument((Argument)this.maxIterationsArgument);
        this.maxDurationArgument = new IntegerArgument("maxDuration", Character.valueOf('d'), "maxDuration", false, false, true, LocalizableMessage.raw((CharSequence)"{maxDuration}", (Object[])new Object[0]), 0, null, true, 1, false, 0, LocalizableMessage.raw((CharSequence)"Maximum duration in seconds, 0 for unlimited", (Object[])new Object[0]));
        argParser.addArgument((Argument)this.maxDurationArgument);
        this.warmUpArgument = new IntegerArgument("warmUpDuration", Character.valueOf('B'), "warmUpDuration", false, false, true, LocalizableMessage.raw((CharSequence)"{warmUpDuration}", (Object[])new Object[0]), 0, null, LocalizableMessage.raw((CharSequence)"Warm up duration in seconds", (Object[])new Object[0]));
        argParser.addArgument((Argument)this.warmUpArgument);
        this.statsIntervalArgument = new IntegerArgument("statInterval", Character.valueOf('i'), "statInterval", false, false, true, LocalizableMessage.raw((CharSequence)"{statInterval}", (Object[])new Object[0]), 5, null, true, 1, false, 0, LocalizableMessage.raw((CharSequence)"Display results each specified number of seconds", (Object[])new Object[0]));
        this.statsIntervalArgument.setPropertyName("statInterval");
        argParser.addArgument((Argument)this.statsIntervalArgument);
        this.targetThroughputArgument = new IntegerArgument("targetThroughput", Character.valueOf('M'), "targetThroughput", false, false, true, LocalizableMessage.raw((CharSequence)"{targetThroughput}", (Object[])new Object[0]), 0, null, LocalizableMessage.raw((CharSequence)"Target average throughput to achieve", (Object[])new Object[0]));
        this.targetThroughputArgument.setPropertyName("targetThroughput");
        argParser.addArgument((Argument)this.targetThroughputArgument);
        this.percentilesArgument = new IntegerArgument("percentile", Character.valueOf('e'), "percentile", false, true, LocalizableMessage.raw((CharSequence)"{percentile}", (Object[])new Object[0]), true, 0, true, 100, LocalizableMessage.raw((CharSequence)"Calculate max response time for a percentile of operations", (Object[])new Object[0]));
        this.percentilesArgument.setPropertyName("percentile");
        this.percentilesArgument.setMultiValued(true);
        argParser.addArgument((Argument)this.percentilesArgument);
        this.keepConnectionsOpen = new BooleanArgument("keepConnectionsOpen", Character.valueOf('f'), "keepConnectionsOpen", LocalizableMessage.raw((CharSequence)"Keep connections open", (Object[])new Object[0]));
        this.keepConnectionsOpen.setPropertyName("keepConnectionsOpen");
        argParser.addArgument((Argument)this.keepConnectionsOpen);
        this.noRebindArgument = new BooleanArgument("noRebind", Character.valueOf('F'), "noRebind", LocalizableMessage.raw((CharSequence)"Keep connections open and do not rebind", (Object[])new Object[0]));
        this.noRebindArgument.setPropertyName("noRebind");
        if (options.supportsRebind()) {
            argParser.addArgument((Argument)this.noRebindArgument);
        }
        this.asyncArgument = new BooleanArgument("asynchronous", Character.valueOf('A'), "asynchronous", LocalizableMessage.raw((CharSequence)"Use asynchronous mode and do not wait for results before sending the next request", (Object[])new Object[0]));
        this.asyncArgument.setPropertyName("asynchronous");
        if (options.supportsAsynchronousRequests()) {
            argParser.addArgument((Argument)this.asyncArgument);
        }
        this.arguments = new StringArgument("argument", Character.valueOf('g'), "argument", false, true, true, LocalizableMessage.raw((CharSequence)"{generator function or static string}", (Object[])new Object[0]), null, null, LocalizableMessage.raw((CharSequence)("Argument used to evaluate the Java style format strings in program parameters (ie. Base DN, Search Filter). The set of all arguments provided form the the argument list in order. Besides static string arguments, they can be generated per iteration with the following functions: " + StaticUtils.EOL + DataSource.getUsage()), (Object[])new Object[0]));
        if (options.supportsGeneratorArgument()) {
            argParser.addArgument((Argument)this.arguments);
        }
    }

    @Override
    public void handleConnectionClosed() {
    }

    @Override
    public synchronized void handleConnectionError(boolean isDisconnectNotification, LdapException error) {
        if (!this.stopRequested) {
            this.app.errPrintln(LocalizableMessage.raw((CharSequence)("Error occurred on one or more connections: " + error.getResult()), (Object[])new Object[0]));
            if (error.getCause() != null && this.app.isVerbose()) {
                error.getCause().printStackTrace(this.app.getErrorStream());
            }
            this.stopRequested = true;
        }
    }

    @Override
    public void handleUnsolicitedNotification(ExtendedResult notification) {
    }

    public final void validate() throws ArgumentException {
        this.numConnections = this.numConnectionsArgument.getIntValue();
        this.numThreads = this.numThreadsArgument.getIntValue();
        this.warmUpDuration = (long)this.warmUpArgument.getIntValue() * 1000L;
        this.maxIterations = this.maxIterationsArgument.getIntValue() / this.numConnections / this.numThreads;
        this.maxDurationTime = (long)this.maxDurationArgument.getIntValue() * 1000L;
        this.statsInterval = this.statsIntervalArgument.getIntValue() * 1000;
        this.targetThroughput = this.targetThroughputArgument.getIntValue();
        this.isAsync = this.asyncArgument.isPresent();
        this.noRebind = this.noRebindArgument.isPresent();
        if (!this.noRebindArgument.isPresent() && this.numThreads > 1) {
            throw new ArgumentException(ToolsMessages.ERR_TOOL_ARG_MUST_BE_USED_WHEN_ARG_CONDITION.get((Object)("--" + this.noRebindArgument.getLongIdentifier()), (Object)("--" + this.numThreadsArgument.getLongIdentifier()), (Object)"> 1"));
        }
        if (!this.noRebindArgument.isPresent() && this.asyncArgument.isPresent()) {
            throw new ArgumentException(ToolsMessages.ERR_TOOL_ARG_NEEDED_WHEN_USING_ARG.get((Object)("--" + this.noRebindArgument.getLongIdentifier()), (Object)this.asyncArgument.getLongIdentifier()));
        }
        if (this.maxIterationsArgument.isPresent() && this.maxIterations <= 0) {
            throw new ArgumentException(ToolsMessages.ERR_TOOL_NOT_ENOUGH_ITERATIONS.get((Object)("--" + this.maxIterationsArgument.getLongIdentifier()), (Object)(this.numConnections * this.numThreads), (Object)this.numConnectionsArgument.getLongIdentifier(), (Object)this.numThreadsArgument.getLongIdentifier()));
        }
        this.dataSourcePrototypes = DataSource.parse(this.arguments.getValues());
    }

    final DataSource[] getDataSources() {
        if (this.dataSourcePrototypes == null) {
            throw new IllegalStateException("dataSources are null - validate() must be called first");
        }
        return this.dataSourcePrototypes;
    }

    abstract WorkerThread newWorkerThread(Connection var1, ConnectionFactory var2);

    abstract StatsThread newStatsThread();

    TimerThread newEndTimerThread(long timeTowait) {
        return new TimerThread(timeTowait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int run(ConnectionFactory connectionFactory) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        Connection connection = null;
        try {
            this.isWarmingUp = this.warmUpDuration > 0L;
            for (int i = 0; i < this.numConnections; ++i) {
                if (this.keepConnectionsOpen.isPresent() || this.noRebindArgument.isPresent()) {
                    connection = connectionFactory.getConnectionAsync().getOrThrow();
                    connection.addConnectionEventListener(this);
                    connections.add(connection);
                }
                for (int j = 0; j < this.numThreads; ++j) {
                    WorkerThread thread = this.newWorkerThread(connection, connectionFactory);
                    this.workerThreads.add(thread);
                    thread.start();
                }
            }
            if (this.maxDurationTime > 0L) {
                this.newEndTimerThread(this.maxDurationTime).start();
            }
            StatsThread statsThread = this.newStatsThread();
            if (this.isWarmingUp) {
                if (!this.app.isScriptFriendly()) {
                    this.app.println(ToolsMessages.INFO_TOOL_WARMING_UP.get((Object)(this.warmUpDuration / 1000L)));
                }
                Thread.sleep(this.warmUpDuration);
                statsThread.resetStats();
                this.isWarmingUp = false;
            }
            statsThread.start();
            this.joinAllWorkerThreads();
            this.stopRequested = true;
            statsThread.join();
        }
        catch (InterruptedException e) {
            this.stopRequested = true;
        }
        catch (LdapException e) {
            this.stopRequested = true;
            Utils.printErrorMessage(this.app, e);
            int n = e.getResult().getResultCode().intValue();
            return n;
        }
        finally {
            org.forgerock.util.Utils.closeSilently(connections);
        }
        return 0;
    }

    void setBindRequest(BindRequest request) {
        this.bindRequest = request;
    }

    BindRequest getBindRequest() {
        return this.bindRequest;
    }

    protected void joinAllWorkerThreads() throws InterruptedException {
        for (Thread t : this.workerThreads) {
            t.join();
        }
    }

    abstract class WorkerThread
    extends Thread {
        private int count;
        private final Connection connection;
        private final ConnectionFactory connectionFactory;
        boolean localStopRequested;

        WorkerThread(Connection connection, ConnectionFactory connectionFactory) {
            super("Worker Thread");
            this.connection = connection;
            this.connectionFactory = connectionFactory;
        }

        public abstract Promise<?, LdapException> performOperation(Connection var1, DataSource[] var2, long var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            double targetTimeMs = 1000.0 / ((double)PerformanceRunner.this.targetThroughput / (double)(PerformanceRunner.this.numThreads * PerformanceRunner.this.numConnections));
            double sleepTimeMs = 0.0;
            while (!PerformanceRunner.this.stopRequested) {
                long oneMinuteMs;
                long startTimeNs;
                block25: {
                    Connection connection;
                    block23: {
                        if (this.localStopRequested) return;
                        if (PerformanceRunner.this.maxIterations > 0) {
                            if (this.count >= PerformanceRunner.this.maxIterations) return;
                        }
                        if (this.connection == null) {
                            try {
                                connection = this.connectionFactory.getConnectionAsync().getOrThrow();
                                break block23;
                            }
                            catch (InterruptedException e) {
                                continue;
                            }
                            catch (LdapException e) {
                                PerformanceRunner.this.app.errPrintln(LocalizableMessage.raw((CharSequence)e.getResult().getDiagnosticMessage(), (Object[])new Object[0]));
                                if (e.getCause() != null && PerformanceRunner.this.app.isVerbose()) {
                                    e.getCause().printStackTrace(PerformanceRunner.this.app.getErrorStream());
                                }
                                PerformanceRunner.this.stopRequested = true;
                                return;
                            }
                        }
                        connection = this.connection;
                        if (!PerformanceRunner.this.noRebind && PerformanceRunner.this.bindRequest != null) {
                            try {
                                connection.bindAsync(PerformanceRunner.this.bindRequest).getOrThrow();
                            }
                            catch (InterruptedException e) {
                                continue;
                            }
                            catch (LdapException e) {
                                PerformanceRunner.this.app.errPrintln(LocalizableMessage.raw((CharSequence)e.getResult().toString(), (Object[])new Object[0]));
                                if (e.getCause() != null && PerformanceRunner.this.app.isVerbose()) {
                                    e.getCause().printStackTrace(PerformanceRunner.this.app.getErrorStream());
                                }
                                PerformanceRunner.this.stopRequested = true;
                                return;
                            }
                        }
                    }
                    startTimeNs = System.nanoTime();
                    Promise<?, LdapException> promise = this.performOperation(connection, (DataSource[])PerformanceRunner.this.dataSources.get(), startTimeNs);
                    PerformanceRunner.this.operationRecentCount.getAndIncrement();
                    if (!PerformanceRunner.this.isAsync) {
                        try {
                            promise.getOrThrow();
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        catch (LdapException e) {
                            if (e.getCause() instanceof IOException) {
                                e.getCause().printStackTrace(PerformanceRunner.this.app.getErrorStream());
                                PerformanceRunner.this.stopRequested = true;
                                return;
                            }
                        }
                        finally {
                            if (this.connection != null) continue;
                            connection.close();
                            continue;
                        }
                    }
                    if (PerformanceRunner.this.targetThroughput <= 0) continue;
                    try {
                        if (!(sleepTimeMs > 1.0)) break block25;
                        WorkerThread.sleep((long)Math.floor(sleepTimeMs));
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                }
                if (!((sleepTimeMs += targetTimeMs - (double)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs)) + (double)(oneMinuteMs = TimeUnit.MINUTES.toMillis(1L)) < 0.0)) continue;
                sleepTimeMs = -oneMinuteMs;
            }
        }

        void incrementIterationCount() {
            ++this.count;
        }
    }

    class UpdateStatsResultHandler<S extends Result>
    implements LdapResultHandler<S> {
        protected final long currentTime;

        UpdateStatsResultHandler(long currentTime) {
            this.currentTime = currentTime;
        }

        @Override
        public void handleException(LdapException exception) {
            PerformanceRunner.this.failedRecentCount.getAndIncrement();
            this.updateStats();
            PerformanceRunner.this.app.errPrintVerboseMessage(LocalizableMessage.raw((CharSequence)exception.getResult().toString(), (Object[])new Object[0]));
        }

        @Override
        public void handleResult(S result) {
            PerformanceRunner.this.successRecentCount.getAndIncrement();
            this.updateStats();
        }

        private void updateStats() {
            if (!PerformanceRunner.this.isWarmingUp) {
                long eTime = System.nanoTime() - this.currentTime;
                PerformanceRunner.this.waitRecentTimeNs.getAndAdd(eTime);
                PerformanceRunner.this.eTimesBuckets.addTimeToInterval(eTime);
            }
        }
    }

    class TimerThread
    extends Thread {
        private final long timeToWait;

        TimerThread(long timeToWait) {
            this.timeToWait = timeToWait;
        }

        void performStopOperations() {
            PerformanceRunner.this.stopRequested = true;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.timeToWait);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            finally {
                this.performStopOperations();
            }
        }
    }

    class StatsThread
    extends Thread {
        protected long totalResultCount;
        protected long totalOperationCount;
        protected double totalDurationSec;
        protected long totalWaitTimeNs;
        protected int intervalSuccessCount;
        protected int intervalOperationCount;
        protected int intervalFailedCount;
        protected double intervalDurationSec;
        protected long intervalWaitTimeNs;
        protected long lastStatTimeMs;
        protected long lastGCDurationMs;
        private final int numColumns;
        private final String[] additionalColumns;
        private final double[] percentiles;
        private final List<GarbageCollectorMXBean> gcBeans;
        private final boolean isScriptFriendly;
        private MultiColumnPrinter printer;

        public StatsThread(String ... additionalColumns) {
            super("Stats Thread");
            this.isScriptFriendly = PerformanceRunner.this.app.isScriptFriendly();
            this.additionalColumns = additionalColumns;
            if (!PerformanceRunner.this.percentilesArgument.isPresent()) {
                this.percentiles = new double[]{99.9, 99.99, 99.999};
            } else {
                this.percentiles = new double[PerformanceRunner.this.percentilesArgument.getValues().size()];
                int index = 0;
                for (String percentile : PerformanceRunner.this.percentilesArgument.getValues()) {
                    this.percentiles[index++] = Double.parseDouble(percentile);
                }
                Arrays.sort(this.percentiles);
            }
            this.numColumns = 5 + this.percentiles.length + additionalColumns.length + (PerformanceRunner.this.isAsync ? 1 : 0);
            this.gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        }

        private void printResultsTitle() {
            if (this.isScriptFriendly) {
                this.printResultsTitleScriptFriendly();
                return;
            }
            this.printer = new MultiColumnPrinter(this.numColumns, 2, "-", 2, PerformanceRunner.this.app);
            this.printer.setTitleAlign(2);
            this.printResultTitleHeaders();
            this.printResultTitleDetails();
        }

        /*
         * WARNING - void declaration
         */
        private void printResultTitleHeaders() {
            void var5_8;
            String[][] titleHeaders;
            for (Object[] objectArray : titleHeaders = new String[2][this.numColumns]) {
                Arrays.fill(objectArray, "");
            }
            titleHeaders[0][0] = "Throughput";
            titleHeaders[0][2] = "Response Time";
            titleHeaders[1][0] = "(ops/second)";
            titleHeaders[1][2] = "(milliseconds)";
            int[] span = new int[this.numColumns];
            span[0] = 2;
            span[1] = 0;
            span[2] = 2 + this.percentiles.length;
            Arrays.fill(span, 3, 4 + this.percentiles.length, 0);
            Arrays.fill(span, 4 + this.percentiles.length, span.length, 1);
            String[][] arr$ = titleHeaders;
            int len$ = arr$.length;
            boolean bl = false;
            while (var5_8 < len$) {
                String[] titleLine = arr$[var5_8];
                this.printer.addTitle(titleLine, span);
                ++var5_8;
            }
        }

        private void printResultTitleDetails() {
            String[] titleDetails = new String[this.numColumns];
            titleDetails[0] = "recent";
            titleDetails[1] = "average";
            titleDetails[2] = "recent";
            titleDetails[3] = "average";
            int i = 4;
            for (double percentile : this.percentiles) {
                titleDetails[i++] = percentile + "%";
            }
            titleDetails[i++] = "err/sec";
            if (PerformanceRunner.this.isAsync) {
                titleDetails[i++] = "req/res";
            }
            for (String column : this.additionalColumns) {
                titleDetails[i++] = column;
            }
            int[] nArray = new int[this.numColumns];
            Arrays.fill(nArray, 1);
            this.printer.addTitle(titleDetails, nArray);
            this.printer.printTitle();
        }

        private void printResultsTitleScriptFriendly() {
            PrintStream out = PerformanceRunner.this.app.getOutputStream();
            out.print("Time (seconds)");
            out.print(",");
            out.print("Recent throughput (ops/second)");
            out.print(",");
            out.print("Average throughput (ops/second)");
            out.print(",");
            out.print("Recent response time (milliseconds)");
            out.print(",");
            out.print("Average response time (milliseconds)");
            for (double percentile : this.percentiles) {
                out.print(",");
                out.print(percentile);
                out.print("% response time (milliseconds)");
            }
            out.print(",");
            out.print("Errors/second");
            if (PerformanceRunner.this.isAsync) {
                out.print(",");
                out.print("Requests/response");
            }
            for (String column : this.additionalColumns) {
                out.print(",");
                out.print(column);
            }
            out.println();
        }

        @Override
        public void run() {
            this.printResultsTitle();
            long totalStatTimeMs = System.currentTimeMillis();
            long gcDurationMs = this.getGCDuration();
            while (!PerformanceRunner.this.stopRequested) {
                try {
                    StatsThread.sleep(PerformanceRunner.this.statsInterval);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.lastStatTimeMs = totalStatTimeMs;
                totalStatTimeMs = System.currentTimeMillis();
                this.lastGCDurationMs = gcDurationMs;
                gcDurationMs = this.getGCDuration();
                long gcIntervalDurationMs = gcDurationMs - this.lastGCDurationMs;
                this.computeStatsForInterval(totalStatTimeMs, gcIntervalDurationMs);
                long intervalResultCount = this.intervalSuccessCount + this.intervalFailedCount;
                Object[] printableStats = new String[this.numColumns];
                Arrays.fill(printableStats, "-");
                printableStats[0] = this.getDivisionResult(intervalResultCount, this.intervalDurationSec, 1);
                printableStats[1] = this.getDivisionResult(this.totalResultCount, this.totalDurationSec, 1);
                long intervalWaitTimeMs = TimeUnit.NANOSECONDS.toMillis(this.intervalWaitTimeNs) - gcIntervalDurationMs;
                printableStats[2] = this.getDivisionResult(intervalWaitTimeMs, intervalResultCount, 3);
                long totalWaitTimeMs = TimeUnit.NANOSECONDS.toMillis(this.totalWaitTimeNs) - gcDurationMs;
                printableStats[3] = this.getDivisionResult(totalWaitTimeMs, this.totalResultCount, 3);
                int i = 4;
                List<Long> computedPercentiles = PerformanceRunner.this.eTimesBuckets.getPercentile(this.percentiles, this.totalOperationCount);
                for (int j = computedPercentiles.size() - 1; j >= 0; --j) {
                    printableStats[i++] = this.getDivisionResult(computedPercentiles.get(j), 1000.0, 2);
                }
                i = 4 + this.percentiles.length;
                Object object = printableStats[i++] = this.intervalFailedCount == 0 ? "0.0" : this.getDivisionResult(this.intervalFailedCount, this.intervalDurationSec, 1);
                if (PerformanceRunner.this.isAsync) {
                    printableStats[i++] = this.getDivisionResult(this.intervalOperationCount, intervalResultCount, 1);
                }
                for (String column : this.getAdditionalColumns()) {
                    printableStats[i++] = column;
                }
                if (this.isScriptFriendly) {
                    this.printScriptFriendlyStats((String[])printableStats);
                    continue;
                }
                this.printer.printRow((String[])printableStats);
            }
        }

        private void computeStatsForInterval(long statTime, long gcIntervalDurationMs) {
            this.intervalOperationCount = PerformanceRunner.this.operationRecentCount.getAndSet(0);
            this.intervalSuccessCount = PerformanceRunner.this.successRecentCount.getAndSet(0);
            this.intervalFailedCount = PerformanceRunner.this.failedRecentCount.getAndSet(0);
            this.intervalWaitTimeNs = PerformanceRunner.this.waitRecentTimeNs.getAndSet(0L);
            this.totalOperationCount += (long)this.intervalOperationCount;
            this.totalResultCount += (long)(this.intervalSuccessCount + this.intervalFailedCount);
            this.totalWaitTimeNs += this.intervalWaitTimeNs;
            long intervalDurationMs = statTime - this.lastStatTimeMs;
            this.intervalDurationSec = (double)(intervalDurationMs - gcIntervalDurationMs) / 1000.0;
            this.totalDurationSec += this.intervalDurationSec;
        }

        private long getGCDuration() {
            long gcDuration = 0L;
            for (GarbageCollectorMXBean bean : this.gcBeans) {
                gcDuration += bean.getCollectionTime();
            }
            return gcDuration;
        }

        private String getDivisionResult(long numerator, double denominator, int precision) {
            return this.getDivisionResult(numerator, denominator, precision, "-");
        }

        protected String getDivisionResult(long numerator, double denominator, int precision, String fallBack) {
            return denominator > 0.0 ? String.format(Locale.ENGLISH, "%." + precision + "f", (double)numerator / denominator) : fallBack;
        }

        private void printScriptFriendlyStats(String[] printableStats) {
            PrintStream out = PerformanceRunner.this.app.getOutputStream();
            out.print(String.format(Locale.ENGLISH, "%.3f", this.totalDurationSec));
            for (String s : printableStats) {
                out.print(",");
                out.print(s);
            }
            out.println();
        }

        String[] getAdditionalColumns() {
            return EMPTY_STRINGS;
        }

        void resetStats() {
            this.intervalFailedCount = 0;
            this.intervalOperationCount = 0;
            this.intervalSuccessCount = 0;
            PerformanceRunner.this.operationRecentCount.set(0);
            PerformanceRunner.this.successRecentCount.set(0);
            PerformanceRunner.this.failedRecentCount.set(0);
            PerformanceRunner.this.waitRecentTimeNs.set(0L);
        }
    }

    static final class ResponseTimeBuckets {
        private static final long NS_1_US = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MICROSECONDS);
        private static final long NS_100_US = TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MICROSECONDS);
        private static final long NS_1_MS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
        private static final long NS_10_MS = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.MILLISECONDS);
        private static final long NS_100_MS = TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MILLISECONDS);
        private static final long NS_1_S = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
        private static final long NS_5_S = TimeUnit.NANOSECONDS.convert(5L, TimeUnit.SECONDS);
        private static final int NB_INDEX = 2120;
        private static final int RANGE_100_MICROSECONDS_START_INDEX = 1000;
        private static final int RANGE_1_MILLISECOND_START_INDEX = 1090;
        private static final int RANGE_100_MILLISECONDS_START_INDEX = 2080;
        private final AtomicLong[] index2Frequency = new AtomicLong[2120];
        private final long[] index2Etime = new long[2120];
        private final ConcurrentSkipListMap<Long, AtomicLong> bigEtimes = new ConcurrentSkipListMap();

        private ResponseTimeBuckets() {
            long rangeStart = 0L;
            long initialTimeMicroSecs = 0L;
            for (int i = 0; i < 2120; ++i) {
                long rangeWidthMicroSecs;
                this.index2Frequency[i] = new AtomicLong();
                if (i < 1000) {
                    rangeWidthMicroSecs = 1L;
                } else if (i < 1090) {
                    rangeWidthMicroSecs = 100L;
                    rangeStart = 1000L;
                    initialTimeMicroSecs = TimeUnit.MICROSECONDS.convert(1L, TimeUnit.MILLISECONDS);
                } else if (i < 2080) {
                    rangeWidthMicroSecs = TimeUnit.MICROSECONDS.convert(1L, TimeUnit.MILLISECONDS);
                    rangeStart = 1090L;
                    initialTimeMicroSecs = TimeUnit.MICROSECONDS.convert(10L, TimeUnit.MILLISECONDS);
                } else {
                    rangeWidthMicroSecs = TimeUnit.MICROSECONDS.convert(100L, TimeUnit.MILLISECONDS);
                    rangeStart = 2080L;
                    initialTimeMicroSecs = TimeUnit.MICROSECONDS.convert(1L, TimeUnit.SECONDS);
                }
                this.index2Etime[i] = ((long)i - rangeStart) * rangeWidthMicroSecs + initialTimeMicroSecs;
            }
        }

        List<Long> getPercentile(double[] percentiles, long nbData) {
            ArrayList<Long> responseTimes = new ArrayList<Long>();
            LinkedList<Long> nbDataThresholds = new LinkedList<Long>();
            long nbDataSum = nbData;
            for (int i = percentiles.length - 1; i >= 0; --i) {
                nbDataThresholds.add((long)(percentiles[i] * (double)nbData) / 100L);
            }
            Iterator iter = this.bigEtimes.descendingMap().entrySet().iterator();
            while (iter.hasNext() && !nbDataThresholds.isEmpty()) {
                Map.Entry currentETime = iter.next();
                this.computePercentiles(nbDataThresholds, responseTimes, nbDataSum -= ((AtomicLong)currentETime.getValue()).get(), (Long)currentETime.getKey());
            }
            for (int stdTimeIndex = 2119; stdTimeIndex >= 0 && !nbDataThresholds.isEmpty(); --stdTimeIndex) {
                long currentETime = this.index2Etime[stdTimeIndex];
                this.computePercentiles(nbDataThresholds, responseTimes, nbDataSum -= this.index2Frequency[stdTimeIndex].get(), currentETime);
            }
            return responseTimes;
        }

        private void computePercentiles(Queue<Long> currentDataThreshold, List<Long> responseTimes, long currentSum, long currentETime) {
            while (currentDataThreshold.peek() != null && currentDataThreshold.peek() >= currentSum) {
                responseTimes.add(currentETime);
                currentDataThreshold.poll();
            }
        }

        void addTimeToInterval(long responseTimeNanoSecs) {
            int startRangeIndex;
            long rangeWidthNanoSecs;
            if (responseTimeNanoSecs >= NS_5_S) {
                long matchingKey = responseTimeNanoSecs / NS_100_MS;
                matchingKey -= matchingKey % 5L;
                AtomicLong existingKey = this.bigEtimes.putIfAbsent(matchingKey *= TimeUnit.MICROSECONDS.convert(100L, TimeUnit.MILLISECONDS), new AtomicLong(1L));
                if (existingKey != null) {
                    existingKey.getAndIncrement();
                }
                return;
            }
            if (responseTimeNanoSecs < NS_1_MS) {
                rangeWidthNanoSecs = NS_1_US;
                startRangeIndex = 0;
            } else if (responseTimeNanoSecs < NS_10_MS) {
                rangeWidthNanoSecs = NS_100_US;
                startRangeIndex = 990;
            } else if (responseTimeNanoSecs < NS_1_S) {
                rangeWidthNanoSecs = NS_1_MS;
                startRangeIndex = 1080;
            } else {
                rangeWidthNanoSecs = NS_100_MS;
                startRangeIndex = 2070;
            }
            int intervalIndex = (int)(responseTimeNanoSecs / rangeWidthNanoSecs) + startRangeIndex;
            this.index2Frequency[intervalIndex].getAndIncrement();
        }
    }
}

