/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.cli.VersionHandler;
import com.forgerock.opendj.ldap.tools.SdkVersionHandler;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldif.LDIF;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class LDIFSearch
extends ConsoleApplication {
    public static void main(String[] args) {
        int retCode = new LDIFSearch().run(args);
        System.exit(Utils.filterExitCode((int)retCode));
    }

    private LDIFSearch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int run(String[] args) {
        LDIFEntryWriter outputWriter;
        LDIFEntryReader sourceReader;
        OutputStream outputStream;
        InputStream sourceInputStream;
        SearchRequest search;
        block36: {
            StringArgument outputFilename;
            block35: {
                IntegerArgument timeLimit;
                IntegerArgument sizeLimit;
                BooleanArgument typesOnly;
                StringArgument filename;
                MultiChoiceArgument searchScope;
                StringArgument baseDN;
                LocalizableMessage toolDescription = ToolsMessages.INFO_LDIFSEARCH_TOOL_DESCRIPTION.get();
                ArgumentParser argParser = new ArgumentParser(LDIFSearch.class.getName(), toolDescription, false, true, 1, 0, "source [filter] [attributes ...]");
                argParser.setVersionHandler((VersionHandler)new SdkVersionHandler());
                argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDIFSEARCH.get());
                try {
                    outputFilename = new StringArgument("outputFilename", Character.valueOf('o'), "outputLDIF", false, false, true, ToolsMessages.INFO_OUTPUT_LDIF_FILE_PLACEHOLDER.get(), "stdout", null, ToolsMessages.INFO_LDIFSEARCH_DESCRIPTION_OUTPUT_FILENAME.get((Object)ToolsMessages.INFO_OUTPUT_LDIF_FILE_PLACEHOLDER.get()));
                    argParser.addArgument((Argument)outputFilename);
                    baseDN = new StringArgument("baseDN", Character.valueOf('b'), "baseDN", true, false, true, ToolsMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_SEARCH_DESCRIPTION_BASEDN.get());
                    baseDN.setPropertyName("baseDN");
                    argParser.addArgument((Argument)baseDN);
                    searchScope = CommonArguments.getSearchScope();
                    argParser.addArgument((Argument)searchScope);
                    filename = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, ToolsMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_SEARCH_DESCRIPTION_FILENAME.get());
                    searchScope.setPropertyName("filename");
                    argParser.addArgument((Argument)filename);
                    typesOnly = new BooleanArgument("typesOnly", Character.valueOf('A'), "typesOnly", ToolsMessages.INFO_DESCRIPTION_TYPES_ONLY.get());
                    typesOnly.setPropertyName("typesOnly");
                    argParser.addArgument((Argument)typesOnly);
                    sizeLimit = new IntegerArgument("sizeLimit", Character.valueOf('z'), "sizeLimit", false, false, true, ToolsMessages.INFO_SIZE_LIMIT_PLACEHOLDER.get(), 0, null, ToolsMessages.INFO_SEARCH_DESCRIPTION_SIZE_LIMIT.get());
                    sizeLimit.setPropertyName("sizeLimit");
                    argParser.addArgument((Argument)sizeLimit);
                    timeLimit = new IntegerArgument("timeLimit", Character.valueOf('l'), "timeLimit", false, false, true, ToolsMessages.INFO_TIME_LIMIT_PLACEHOLDER.get(), 0, null, ToolsMessages.INFO_SEARCH_DESCRIPTION_TIME_LIMIT.get());
                    timeLimit.setPropertyName("timeLimit");
                    argParser.addArgument((Argument)timeLimit);
                    BooleanArgument showUsage = CommonArguments.getShowUsage();
                    argParser.addArgument((Argument)showUsage);
                    argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
                }
                catch (ArgumentException ae) {
                    LocalizableMessage message = ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage());
                    this.errPrintln(message);
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                try {
                    argParser.parseArguments(args);
                    if (argParser.usageOrVersionDisplayed()) {
                        return ResultCode.SUCCESS.intValue();
                    }
                }
                catch (ArgumentException ae) {
                    argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                LinkedList<Filter> filters = new LinkedList<Filter>();
                LinkedList attributes = new LinkedList();
                ArrayList trailingArguments = argParser.getTrailingArguments();
                if (trailingArguments.size() > 1) {
                    List filterAndAttributeStrings = trailingArguments.subList(1, trailingArguments.size());
                    if (!filename.isPresent()) {
                        String filterString = (String)filterAndAttributeStrings.remove(0);
                        try {
                            filters.add(Filter.valueOf(filterString));
                        }
                        catch (LocalizedIllegalArgumentException e2) {
                            this.errPrintln(e2.getMessageObject());
                            return ResultCode.CLIENT_SIDE_FILTER_ERROR.intValue();
                        }
                    }
                    attributes.addAll(filterAndAttributeStrings);
                }
                if (filename.isPresent()) {
                    BufferedReader in = null;
                    try {
                        in = new BufferedReader(new FileReader(filename.getValue()));
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            if ("".equals(line.trim())) continue;
                            filters.add(Filter.valueOf(line));
                        }
                    }
                    catch (LocalizedIllegalArgumentException e) {
                        this.errPrintln(e.getMessageObject());
                        int e2 = ResultCode.CLIENT_SIDE_FILTER_ERROR.intValue();
                        org.forgerock.util.Utils.closeSilently(in);
                        return e2;
                    }
                    catch (IOException e3) {
                        this.errPrintln(LocalizableMessage.raw((CharSequence)e3.toString(), (Object[])new Object[0]));
                        int e2 = ResultCode.CLIENT_SIDE_FILTER_ERROR.intValue();
                        {
                            catch (Throwable throwable) {
                                org.forgerock.util.Utils.closeSilently(in);
                                throw throwable;
                            }
                        }
                        org.forgerock.util.Utils.closeSilently(in);
                        return e2;
                    }
                    org.forgerock.util.Utils.closeSilently(in);
                }
                if (filters.isEmpty()) {
                    argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_SEARCH_NO_FILTERS.get());
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                try {
                    SearchScope scope = (SearchScope)searchScope.getTypedValue();
                    search = Requests.newSearchRequest(DN.valueOf(baseDN.getValue()), scope, (Filter)filters.get(0), attributes.toArray(new String[attributes.size()])).setTypesOnly(typesOnly.isPresent()).setTimeLimit(timeLimit.getIntValue()).setSizeLimit(sizeLimit.getIntValue());
                }
                catch (ArgumentException | LocalizedIllegalArgumentException e) {
                    this.errPrintln(((LocalizableException)e).getMessageObject());
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                sourceInputStream = null;
                outputStream = null;
                sourceReader = null;
                outputWriter = null;
                if ("-".equals(trailingArguments.get(0))) break block35;
                try {
                    sourceInputStream = new FileInputStream((String)trailingArguments.get(0));
                }
                catch (FileNotFoundException e) {
                    LocalizableMessage message = ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_READ.get(trailingArguments.get(0), (Object)e.getLocalizedMessage());
                    this.errPrintln(message);
                    int n = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                    org.forgerock.util.Utils.closeSilently(sourceReader, outputWriter);
                    org.forgerock.util.Utils.closeSilently(sourceInputStream, outputStream);
                    return n;
                }
            }
            if (!outputFilename.isPresent() || "-".equals(outputFilename.getValue())) break block36;
            try {
                outputStream = new FileOutputStream(outputFilename.getValue());
            }
            catch (FileNotFoundException e) {
                LocalizableMessage message = ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_WRITE.get((Object)outputFilename.getValue(), (Object)e.getLocalizedMessage());
                this.errPrintln(message);
                int n = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                org.forgerock.util.Utils.closeSilently(sourceReader, outputWriter);
                org.forgerock.util.Utils.closeSilently(sourceInputStream, outputStream);
                return n;
            }
        }
        try {
            if (sourceInputStream == null) {
                sourceInputStream = System.in;
            }
            if (outputStream == null) {
                outputStream = System.out;
            }
            sourceReader = new LDIFEntryReader(sourceInputStream);
            outputWriter = new LDIFEntryWriter(outputStream);
            LDIF.copyTo(LDIF.search(sourceReader, search), outputWriter);
        }
        catch (IOException e) {
            int n;
            try {
                if (e instanceof LocalizableException) {
                    this.errPrintln(ToolsMessages.ERR_LDIFSEARCH_FAILED.get((Object)((LocalizableException)e).getMessageObject()));
                } else {
                    this.errPrintln(ToolsMessages.ERR_LDIFSEARCH_FAILED.get((Object)e.getLocalizedMessage()));
                }
                n = ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue();
            }
            catch (Throwable throwable) {
                org.forgerock.util.Utils.closeSilently(sourceReader, outputWriter);
                org.forgerock.util.Utils.closeSilently(sourceInputStream, outputStream);
                throw throwable;
            }
            org.forgerock.util.Utils.closeSilently(sourceReader, outputWriter);
            org.forgerock.util.Utils.closeSilently(sourceInputStream, outputStream);
            return n;
        }
        org.forgerock.util.Utils.closeSilently(sourceReader, outputWriter);
        org.forgerock.util.Utils.closeSilently(sourceInputStream, outputStream);
        return ResultCode.SUCCESS.intValue();
    }
}

