/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.cli.VersionHandler;
import com.forgerock.opendj.ldap.tools.SdkVersionHandler;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.forgerock.i18n.LocalizableException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldif.LDIF;
import org.forgerock.opendj.ldif.LDIFChangeRecordWriter;
import org.forgerock.opendj.ldif.LDIFEntryReader;

public final class LDIFDiff
extends ConsoleApplication {
    public static void main(String[] args) {
        int retCode = new LDIFDiff().run(args);
        System.exit(Utils.filterExitCode((int)retCode));
    }

    private LDIFDiff() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] args) {
        LDIFChangeRecordWriter outputWriter;
        LDIFEntryReader targetReader;
        LDIFEntryReader sourceReader;
        OutputStream outputStream;
        InputStream targetInputStream;
        InputStream sourceInputStream;
        block27: {
            block26: {
                StringArgument outputFilename;
                block25: {
                    ArrayList trailingArguments;
                    block24: {
                        LocalizableMessage toolDescription = ToolsMessages.INFO_LDIFDIFF_TOOL_DESCRIPTION.get();
                        ArgumentParser argParser = new ArgumentParser(LDIFDiff.class.getName(), toolDescription, false, true, 2, 2, "source target");
                        argParser.setVersionHandler((VersionHandler)new SdkVersionHandler());
                        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDIFDIFF.get());
                        try {
                            outputFilename = new StringArgument("outputFilename", Character.valueOf('o'), "outputLDIF", false, false, true, ToolsMessages.INFO_OUTPUT_LDIF_FILE_PLACEHOLDER.get(), "stdout", null, ToolsMessages.INFO_LDIFDIFF_DESCRIPTION_OUTPUT_FILENAME.get((Object)ToolsMessages.INFO_OUTPUT_LDIF_FILE_PLACEHOLDER.get()));
                            argParser.addArgument((Argument)outputFilename);
                            BooleanArgument showUsage = CommonArguments.getShowUsage();
                            argParser.addArgument((Argument)showUsage);
                            argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
                        }
                        catch (ArgumentException ae) {
                            LocalizableMessage message = ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage());
                            this.errPrintln(message);
                            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                        }
                        try {
                            argParser.parseArguments(args);
                            if (argParser.usageOrVersionDisplayed()) {
                                return ResultCode.SUCCESS.intValue();
                            }
                        }
                        catch (ArgumentException ae) {
                            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
                            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                        }
                        sourceInputStream = null;
                        targetInputStream = null;
                        outputStream = null;
                        sourceReader = null;
                        targetReader = null;
                        outputWriter = null;
                        trailingArguments = argParser.getTrailingArguments();
                        if ("-".equals(trailingArguments.get(0))) break block24;
                        try {
                            sourceInputStream = new FileInputStream((String)trailingArguments.get(0));
                        }
                        catch (FileNotFoundException e) {
                            LocalizableMessage message = ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_READ.get(trailingArguments.get(0), (Object)e.getLocalizedMessage());
                            this.errPrintln(message);
                            int n = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                            org.forgerock.util.Utils.closeSilently(sourceReader, targetReader, outputWriter);
                            org.forgerock.util.Utils.closeSilently(sourceInputStream, targetInputStream, outputStream);
                            return n;
                        }
                    }
                    if ("-".equals(trailingArguments.get(1))) break block25;
                    try {
                        targetInputStream = new FileInputStream((String)trailingArguments.get(1));
                    }
                    catch (FileNotFoundException e) {
                        LocalizableMessage message = ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_READ.get(trailingArguments.get(1), (Object)e.getLocalizedMessage());
                        this.errPrintln(message);
                        int n = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                        org.forgerock.util.Utils.closeSilently(sourceReader, targetReader, outputWriter);
                        org.forgerock.util.Utils.closeSilently(sourceInputStream, targetInputStream, outputStream);
                        return n;
                    }
                }
                if (!outputFilename.isPresent() || "-".equals(outputFilename.getValue())) break block26;
                try {
                    outputStream = new FileOutputStream(outputFilename.getValue());
                }
                catch (FileNotFoundException e) {
                    LocalizableMessage message = ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_WRITE.get((Object)outputFilename.getValue(), (Object)e.getLocalizedMessage());
                    this.errPrintln(message);
                    int n = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                    org.forgerock.util.Utils.closeSilently(sourceReader, targetReader, outputWriter);
                    org.forgerock.util.Utils.closeSilently(sourceInputStream, targetInputStream, outputStream);
                    return n;
                }
            }
            if (sourceInputStream == null) {
                sourceInputStream = System.in;
            }
            if (targetInputStream == null) {
                targetInputStream = System.in;
            }
            if (outputStream == null) {
                outputStream = System.out;
            }
            if (sourceInputStream != targetInputStream) break block27;
            LocalizableMessage message = ToolsMessages.ERR_LDIFDIFF_MULTIPLE_USES_OF_STDIN.get();
            this.errPrintln(message);
            int n = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            org.forgerock.util.Utils.closeSilently(sourceReader, targetReader, outputWriter);
            org.forgerock.util.Utils.closeSilently(sourceInputStream, targetInputStream, outputStream);
            return n;
        }
        try {
            sourceReader = new LDIFEntryReader(sourceInputStream);
            targetReader = new LDIFEntryReader(targetInputStream);
            outputWriter = new LDIFChangeRecordWriter(outputStream);
            LDIF.copyTo(LDIF.diff(sourceReader, targetReader), outputWriter);
        }
        catch (IOException e) {
            int n;
            try {
                if (e instanceof LocalizableException) {
                    this.errPrintln(ToolsMessages.ERR_LDIFDIFF_DIFF_FAILED.get((Object)((LocalizableException)e).getMessageObject()));
                } else {
                    this.errPrintln(ToolsMessages.ERR_LDIFDIFF_DIFF_FAILED.get((Object)e.getLocalizedMessage()));
                }
                n = ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue();
            }
            catch (Throwable throwable) {
                org.forgerock.util.Utils.closeSilently(sourceReader, targetReader, outputWriter);
                org.forgerock.util.Utils.closeSilently(sourceInputStream, targetInputStream, outputStream);
                throw throwable;
            }
            org.forgerock.util.Utils.closeSilently(sourceReader, targetReader, outputWriter);
            org.forgerock.util.Utils.closeSilently(sourceInputStream, targetInputStream, outputStream);
            return n;
        }
        org.forgerock.util.Utils.closeSilently(sourceReader, targetReader, outputWriter);
        org.forgerock.util.Utils.closeSilently(sourceInputStream, targetInputStream, outputStream);
        return ResultCode.SUCCESS.intValue();
    }
}

