/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.VersionHandler;
import com.forgerock.opendj.ldap.controls.AccountUsabilityResponseControl;
import com.forgerock.opendj.ldap.tools.SdkVersionHandler;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import com.forgerock.opendj.util.StaticUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.AssertionRequestControl;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.EntryChangeNotificationResponseControl;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.controls.GetEffectiveRightsRequestControl;
import org.forgerock.opendj.ldap.controls.MatchedValuesRequestControl;
import org.forgerock.opendj.ldap.controls.PersistentSearchChangeType;
import org.forgerock.opendj.ldap.controls.PersistentSearchRequestControl;
import org.forgerock.opendj.ldap.controls.ProxiedAuthV2RequestControl;
import org.forgerock.opendj.ldap.controls.ServerSideSortRequestControl;
import org.forgerock.opendj.ldap.controls.ServerSideSortResponseControl;
import org.forgerock.opendj.ldap.controls.SimplePagedResultsControl;
import org.forgerock.opendj.ldap.controls.VirtualListViewRequestControl;
import org.forgerock.opendj.ldap.controls.VirtualListViewResponseControl;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class LDAPSearch
extends ConsoleApplication {
    private BooleanArgument verbose;
    private EntryWriter ldifWriter;

    public static void main(String[] args) {
        int retCode = new LDAPSearch().run(args, false);
        System.exit(com.forgerock.opendj.cli.Utils.filterExitCode((int)retCode));
    }

    private LDAPSearch() {
    }

    LDAPSearch(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int run(String[] args, boolean returnMatchingEntries) {
        SearchRequest search;
        SearchScope scope;
        BindRequest bindRequest;
        ConnectionFactory connectionFactory;
        BooleanArgument noop;
        BooleanArgument countEntries;
        BooleanArgument dontWrap;
        IntegerArgument timeLimit;
        IntegerArgument sizeLimit;
        BooleanArgument typesOnly;
        MultiChoiceArgument dereferencePolicy;
        IntegerArgument version;
        StringArgument effectiveRightsAttrs;
        StringArgument effectiveRightsUser;
        StringArgument controlStr;
        StringArgument vlvDescriptor;
        StringArgument sortOrder;
        StringArgument matchedValuesFilter;
        StringArgument assertionFilter;
        IntegerArgument simplePageSize;
        StringArgument pSearchInfo;
        StringArgument proxyAuthzID;
        StringArgument filename;
        MultiChoiceArgument searchScope;
        StringArgument baseDN;
        ConnectionFactoryProvider connectionFactoryProvider;
        LocalizableMessage toolDescription = ToolsMessages.INFO_LDAPSEARCH_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(LDAPSearch.class.getName(), toolDescription, false, true, 0, 0, "[filter] [attributes ...]");
        argParser.setVersionHandler((VersionHandler)new SdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDAPSEARCH.get());
        try {
            connectionFactoryProvider = new ConnectionFactoryProvider(argParser, (ConsoleApplication)this);
            StringArgument propertiesFileArgument = CommonArguments.getPropertiesFile();
            argParser.addArgument((Argument)propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = CommonArguments.getNoPropertiesFile();
            argParser.addArgument((Argument)noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            baseDN = new StringArgument("baseDN", Character.valueOf('b'), "baseDN", true, false, true, ToolsMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_SEARCH_DESCRIPTION_BASEDN.get());
            baseDN.setPropertyName("baseDN");
            argParser.addArgument((Argument)baseDN);
            searchScope = CommonArguments.getSearchScope();
            argParser.addArgument((Argument)searchScope);
            filename = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, ToolsMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_SEARCH_DESCRIPTION_FILENAME.get());
            searchScope.setPropertyName("filename");
            argParser.addArgument((Argument)filename);
            proxyAuthzID = new StringArgument("proxy_authzid", Character.valueOf('Y'), "proxyAs", false, false, true, ToolsMessages.INFO_PROXYAUTHID_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_DESCRIPTION_PROXY_AUTHZID.get());
            proxyAuthzID.setPropertyName("proxyAs");
            argParser.addArgument((Argument)proxyAuthzID);
            pSearchInfo = new StringArgument("psearchinfo", Character.valueOf('C'), "persistentSearch", false, false, true, ToolsMessages.INFO_PSEARCH_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_DESCRIPTION_PSEARCH_INFO.get());
            pSearchInfo.setPropertyName("persistentSearch");
            pSearchInfo.setDocDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_PSEARCH_INFO.get());
            argParser.addArgument((Argument)pSearchInfo);
            simplePageSize = new IntegerArgument("simplepagesize", null, "simplePageSize", false, false, true, ToolsMessages.INFO_NUM_ENTRIES_PLACEHOLDER.get(), 1000, null, true, 1, false, 0, ToolsMessages.INFO_DESCRIPTION_SIMPLE_PAGE_SIZE.get());
            simplePageSize.setPropertyName("simplePageSize");
            argParser.addArgument((Argument)simplePageSize);
            assertionFilter = new StringArgument("assertionfilter", null, "assertionFilter", false, false, true, ToolsMessages.INFO_ASSERTION_FILTER_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_DESCRIPTION_ASSERTION_FILTER.get());
            assertionFilter.setPropertyName("assertionFilter");
            argParser.addArgument((Argument)assertionFilter);
            matchedValuesFilter = new StringArgument("matchedvalues", null, "matchedValuesFilter", false, true, true, ToolsMessages.INFO_FILTER_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_DESCRIPTION_MATCHED_VALUES_FILTER.get());
            matchedValuesFilter.setPropertyName("matchedValuesFilter");
            argParser.addArgument((Argument)matchedValuesFilter);
            sortOrder = new StringArgument("sortorder", Character.valueOf('S'), "sortOrder", false, false, true, ToolsMessages.INFO_SORT_ORDER_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_DESCRIPTION_SORT_ORDER.get());
            sortOrder.setPropertyName("sortOrder");
            argParser.addArgument((Argument)sortOrder);
            vlvDescriptor = new StringArgument("vlvdescriptor", Character.valueOf('G'), "virtualListView", false, false, true, ToolsMessages.INFO_VLV_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_DESCRIPTION_VLV.get());
            vlvDescriptor.setPropertyName("virtualListView");
            argParser.addArgument((Argument)vlvDescriptor);
            controlStr = new StringArgument("control", Character.valueOf('J'), "control", false, true, true, ToolsMessages.INFO_LDAP_CONTROL_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_DESCRIPTION_CONTROLS.get());
            controlStr.setPropertyName("control");
            controlStr.setDocDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_CONTROLS.get());
            argParser.addArgument((Argument)controlStr);
            effectiveRightsUser = new StringArgument("effectiveRightsUser", Character.valueOf('g'), "getEffectiveRightsAuthzid", false, false, true, ToolsMessages.INFO_PROXYAUTHID_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_DESCRIPTION_EFFECTIVERIGHTS_USER.get());
            effectiveRightsUser.setPropertyName("getEffectiveRightsAuthzid");
            argParser.addArgument((Argument)effectiveRightsUser);
            effectiveRightsAttrs = new StringArgument("effectiveRightsAttrs", Character.valueOf('e'), "getEffectiveRightsAttribute", false, true, true, ToolsMessages.INFO_ATTRIBUTE_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_DESCRIPTION_EFFECTIVERIGHTS_ATTR.get());
            effectiveRightsAttrs.setPropertyName("getEffectiveRightsAttribute");
            argParser.addArgument((Argument)effectiveRightsAttrs);
            version = CommonArguments.getLdapVersion();
            argParser.addArgument((Argument)version);
            StringArgument encodingStr = new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, ToolsMessages.INFO_ENCODING_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_DESCRIPTION_ENCODING.get());
            encodingStr.setPropertyName("encoding");
            argParser.addArgument((Argument)encodingStr);
            dereferencePolicy = new MultiChoiceArgument("derefpolicy", Character.valueOf('a'), "dereferencePolicy", false, true, ToolsMessages.INFO_DEREFERENCE_POLICE_PLACEHOLDER.get(), DereferenceAliasesPolicy.values(), false, ToolsMessages.INFO_SEARCH_DESCRIPTION_DEREFERENCE_POLICY.get());
            dereferencePolicy.setPropertyName("dereferencePolicy");
            dereferencePolicy.setDefaultValue((Object)DereferenceAliasesPolicy.NEVER);
            argParser.addArgument((Argument)dereferencePolicy);
            typesOnly = new BooleanArgument("typesOnly", Character.valueOf('A'), "typesOnly", ToolsMessages.INFO_DESCRIPTION_TYPES_ONLY.get());
            typesOnly.setPropertyName("typesOnly");
            argParser.addArgument((Argument)typesOnly);
            sizeLimit = new IntegerArgument("sizeLimit", Character.valueOf('z'), "sizeLimit", false, false, true, ToolsMessages.INFO_SIZE_LIMIT_PLACEHOLDER.get(), 0, null, ToolsMessages.INFO_SEARCH_DESCRIPTION_SIZE_LIMIT.get());
            sizeLimit.setPropertyName("sizeLimit");
            argParser.addArgument((Argument)sizeLimit);
            timeLimit = new IntegerArgument("timeLimit", Character.valueOf('l'), "timeLimit", false, false, true, ToolsMessages.INFO_TIME_LIMIT_PLACEHOLDER.get(), 0, null, ToolsMessages.INFO_SEARCH_DESCRIPTION_TIME_LIMIT.get());
            timeLimit.setPropertyName("timeLimit");
            argParser.addArgument((Argument)timeLimit);
            dontWrap = new BooleanArgument("dontwrap", Character.valueOf('t'), "dontWrap", ToolsMessages.INFO_DESCRIPTION_DONT_WRAP.get());
            dontWrap.setPropertyName("dontWrap");
            argParser.addArgument((Argument)dontWrap);
            countEntries = new BooleanArgument("countentries", null, "countEntries", ToolsMessages.INFO_DESCRIPTION_COUNT_ENTRIES.get());
            countEntries.setPropertyName("countEntries");
            argParser.addArgument((Argument)countEntries);
            BooleanArgument continueOnError = CommonArguments.getContinueOnError();
            argParser.addArgument((Argument)continueOnError);
            noop = CommonArguments.getNoOp();
            argParser.addArgument((Argument)noop);
            this.verbose = CommonArguments.getVerbose();
            argParser.addArgument((Argument)this.verbose);
            BooleanArgument showUsage = CommonArguments.getShowUsage();
            argParser.addArgument((Argument)showUsage);
            argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
        }
        catch (ArgumentException ae) {
            this.errPrintln(ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            argParser.parseArguments(args);
            if (argParser.usageOrVersionDisplayed()) {
                return 0;
            }
            connectionFactory = connectionFactoryProvider.getUnauthenticatedConnectionFactory();
            bindRequest = connectionFactoryProvider.getBindRequest();
        }
        catch (ArgumentException ae) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        LinkedList<Filter> filters = new LinkedList<Filter>();
        LinkedList attributes = new LinkedList();
        ArrayList filterAndAttributeStrings = argParser.getTrailingArguments();
        if (!filterAndAttributeStrings.isEmpty()) {
            if (!filename.isPresent()) {
                String filterString = (String)filterAndAttributeStrings.remove(0);
                try {
                    filters.add(Filter.valueOf(filterString));
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.errPrintln(e.getMessageObject());
                    return ResultCode.CLIENT_SIDE_FILTER_ERROR.intValue();
                }
            }
            attributes.addAll(filterAndAttributeStrings);
        }
        if (filename.isPresent()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(filename.getValue()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if ("".equals(line.trim())) continue;
                    Filter ldapFilter = Filter.valueOf(line);
                    filters.add(ldapFilter);
                }
            }
            catch (LocalizedIllegalArgumentException e) {
                this.errPrintln(e.getMessageObject());
                int ldapFilter = ResultCode.CLIENT_SIDE_FILTER_ERROR.intValue();
                return ldapFilter;
            }
            catch (IOException e) {
                this.errPrintln(LocalizableMessage.raw((CharSequence)e.toString(), (Object[])new Object[0]));
                int ldapFilter = ResultCode.CLIENT_SIDE_FILTER_ERROR.intValue();
                return ldapFilter;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (filters.isEmpty()) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_SEARCH_NO_FILTERS.get());
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            scope = (SearchScope)searchScope.getTypedValue();
        }
        catch (ArgumentException ex1) {
            this.errPrintln(ex1.getMessageObject());
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            search = Requests.newSearchRequest(DN.valueOf(baseDN.getValue()), scope, (Filter)filters.get(0), attributes.toArray(new String[attributes.size()]));
        }
        catch (LocalizedIllegalArgumentException e) {
            this.errPrintln(e.getMessageObject());
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            int versionNumber = version.getIntValue();
            if (versionNumber != 2 && versionNumber != 3) {
                this.errPrintln(ToolsMessages.ERR_DESCRIPTION_INVALID_VERSION.get((Object)String.valueOf(versionNumber)));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
        }
        catch (ArgumentException ae) {
            this.errPrintln(ToolsMessages.ERR_DESCRIPTION_INVALID_VERSION.get((Object)version.getValue()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        search.setTypesOnly(typesOnly.isPresent());
        try {
            search.setTimeLimit(timeLimit.getIntValue());
            search.setSizeLimit(sizeLimit.getIntValue());
        }
        catch (ArgumentException ex1) {
            this.errPrintln(ex1.getMessageObject());
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            search.setDereferenceAliasesPolicy((DereferenceAliasesPolicy)dereferencePolicy.getTypedValue());
        }
        catch (ArgumentException ex1) {
            this.errPrintln(ex1.getMessageObject());
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        if (controlStr.isPresent()) {
            for (String ctrlString : controlStr.getValues()) {
                try {
                    GenericControl ctrl = Utils.getControl(ctrlString);
                    search.addControl(ctrl);
                }
                catch (DecodeException de) {
                    this.errPrintln(ToolsMessages.ERR_TOOL_INVALID_CONTROL_STRING.get((Object)ctrlString));
                    ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            }
        }
        if (effectiveRightsUser.isPresent()) {
            String authzID = effectiveRightsUser.getValue();
            if (!authzID.startsWith("dn:")) {
                this.errPrintln(ToolsMessages.ERR_EFFECTIVERIGHTS_INVALID_AUTHZID.get((Object)authzID));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            GetEffectiveRightsRequestControl effectiveRightsControl = GetEffectiveRightsRequestControl.newControl(false, authzID.substring(3), effectiveRightsAttrs.getValues().toArray(new String[effectiveRightsAttrs.getValues().size()]));
            search.addControl(effectiveRightsControl);
        }
        if (proxyAuthzID.isPresent()) {
            ProxiedAuthV2RequestControl proxyControl = ProxiedAuthV2RequestControl.newControl(proxyAuthzID.getValue());
            search.addControl(proxyControl);
        }
        if (pSearchInfo.isPresent()) {
            String token;
            String infoString = StaticUtils.toLowerCase(pSearchInfo.getValue().trim());
            boolean changesOnly = true;
            boolean returnECs = true;
            StringTokenizer tokenizer = new StringTokenizer(infoString, ":");
            if (!tokenizer.hasMoreTokens()) {
                this.errPrintln(ToolsMessages.ERR_PSEARCH_MISSING_DESCRIPTOR.get());
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            String token2 = tokenizer.nextToken();
            if (!"ps".equals(token2)) {
                this.errPrintln(ToolsMessages.ERR_PSEARCH_DOESNT_START_WITH_PS.get((Object)infoString));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            ArrayList<PersistentSearchChangeType> ct = new ArrayList<PersistentSearchChangeType>(4);
            if (tokenizer.hasMoreTokens()) {
                StringTokenizer st = new StringTokenizer(tokenizer.nextToken(), ", ");
                if (!st.hasMoreTokens()) {
                    ct.add(PersistentSearchChangeType.ADD);
                    ct.add(PersistentSearchChangeType.DELETE);
                    ct.add(PersistentSearchChangeType.MODIFY);
                    ct.add(PersistentSearchChangeType.MODIFY_DN);
                } else {
                    do {
                        String token3;
                        if ("add".equals(token3 = st.nextToken())) {
                            ct.add(PersistentSearchChangeType.ADD);
                            continue;
                        }
                        if ("delete".equals(token3) || "del".equals(token3)) {
                            ct.add(PersistentSearchChangeType.DELETE);
                            continue;
                        }
                        if ("modify".equals(token3) || "mod".equals(token3)) {
                            ct.add(PersistentSearchChangeType.MODIFY);
                            continue;
                        }
                        if ("modifydn".equals(token3) || "moddn".equals(token3) || "modrdn".equals(token3)) {
                            ct.add(PersistentSearchChangeType.MODIFY_DN);
                            continue;
                        }
                        if ("any".equals(token3) || "all".equals(token3)) {
                            ct.add(PersistentSearchChangeType.ADD);
                            ct.add(PersistentSearchChangeType.DELETE);
                            ct.add(PersistentSearchChangeType.MODIFY);
                            ct.add(PersistentSearchChangeType.MODIFY_DN);
                            continue;
                        }
                        this.errPrintln(ToolsMessages.ERR_PSEARCH_INVALID_CHANGE_TYPE.get((Object)token3));
                        return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                    } while (st.hasMoreTokens());
                }
            }
            if (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if ("1".equals(token) || "true".equals(token) || "yes".equals(token)) {
                    changesOnly = true;
                } else if ("0".equals(token) || "false".equals(token) || "no".equals(token)) {
                    changesOnly = false;
                } else {
                    this.errPrintln(ToolsMessages.ERR_PSEARCH_INVALID_CHANGESONLY.get((Object)token));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            }
            if (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if ("1".equals(token) || "true".equals(token) || "yes".equals(token)) {
                    returnECs = true;
                } else if ("0".equals(token) || "false".equals(token) || "no".equals(token)) {
                    returnECs = false;
                } else {
                    this.errPrintln(ToolsMessages.ERR_PSEARCH_INVALID_RETURN_ECS.get((Object)token));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            }
            PersistentSearchRequestControl psearchControl = PersistentSearchRequestControl.newControl(true, changesOnly, returnECs, ct.toArray(new PersistentSearchChangeType[ct.size()]));
            search.addControl(psearchControl);
        }
        if (assertionFilter.isPresent()) {
            String filterString = assertionFilter.getValue();
            try {
                Filter filter = Filter.valueOf(filterString);
                AssertionRequestControl assertionControl = AssertionRequestControl.newControl(true, filter);
                search.addControl(assertionControl);
            }
            catch (LocalizedIllegalArgumentException le) {
                this.errPrintln(ToolsMessages.ERR_LDAP_ASSERTION_INVALID_FILTER.get((Object)le.getMessage()));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
        }
        if (matchedValuesFilter.isPresent()) {
            LinkedList mvFilterStrings = matchedValuesFilter.getValues();
            ArrayList<Filter> mvFilters = new ArrayList<Filter>();
            for (String s : mvFilterStrings) {
                try {
                    Filter f = Filter.valueOf(s);
                    mvFilters.add(f);
                }
                catch (LocalizedIllegalArgumentException le) {
                    this.errPrintln(ToolsMessages.ERR_LDAP_MATCHEDVALUES_INVALID_FILTER.get((Object)le.getMessage()));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            }
            MatchedValuesRequestControl mvc = MatchedValuesRequestControl.newControl(true, mvFilters);
            search.addControl(mvc);
        }
        if (sortOrder.isPresent()) {
            try {
                search.addControl(ServerSideSortRequestControl.newControl(false, sortOrder.getValue()));
            }
            catch (LocalizedIllegalArgumentException le) {
                this.errPrintln(ToolsMessages.ERR_LDAP_SORTCONTROL_INVALID_ORDER.get((Object)le.getMessageObject()));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
        }
        if (vlvDescriptor.isPresent()) {
            if (!sortOrder.isPresent()) {
                LocalizableMessage message = ToolsMessages.ERR_LDAPSEARCH_VLV_REQUIRES_SORT.get((Object)vlvDescriptor.getLongIdentifier(), (Object)sortOrder.getLongIdentifier());
                this.errPrintln(message);
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            StringTokenizer tokenizer = new StringTokenizer(vlvDescriptor.getValue(), ":");
            int numTokens = tokenizer.countTokens();
            if (numTokens == 3) {
                try {
                    int beforeCount = Integer.parseInt(tokenizer.nextToken());
                    int afterCount = Integer.parseInt(tokenizer.nextToken());
                    ByteString assertionValue = ByteString.valueOfUtf8(tokenizer.nextToken());
                    search.addControl(VirtualListViewRequestControl.newAssertionControl(true, assertionValue, beforeCount, afterCount, null));
                }
                catch (Exception e) {
                    this.errPrintln(ToolsMessages.ERR_LDAPSEARCH_VLV_INVALID_DESCRIPTOR.get());
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            } else if (numTokens == 4) {
                try {
                    int beforeCount = Integer.parseInt(tokenizer.nextToken());
                    int afterCount = Integer.parseInt(tokenizer.nextToken());
                    int offset = Integer.parseInt(tokenizer.nextToken());
                    int contentCount = Integer.parseInt(tokenizer.nextToken());
                    search.addControl(VirtualListViewRequestControl.newOffsetControl(true, offset, contentCount, beforeCount, afterCount, null));
                }
                catch (Exception e) {
                    this.errPrintln(ToolsMessages.ERR_LDAPSEARCH_VLV_INVALID_DESCRIPTOR.get());
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            } else {
                this.errPrintln(ToolsMessages.ERR_LDAPSEARCH_VLV_INVALID_DESCRIPTOR.get());
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
        }
        int pageSize = 0;
        if (simplePageSize.isPresent()) {
            if (filters.size() > 1) {
                this.errPrintln(ToolsMessages.ERR_PAGED_RESULTS_REQUIRES_SINGLE_FILTER.get());
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            try {
                pageSize = simplePageSize.getIntValue();
                search.addControl(SimplePagedResultsControl.newControl(true, pageSize, ByteString.empty()));
            }
            catch (ArgumentException ae) {
                this.errPrintln(ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
        }
        int wrapColumn = 80;
        if (dontWrap.isPresent()) {
            wrapColumn = 0;
        }
        if (noop.isPresent()) {
            return 0;
        }
        Connection connection = null;
        try {
            connection = connectionFactory.getConnection();
            if (bindRequest != null) {
                Utils.printPasswordPolicyResults(this, connection.bind(bindRequest));
            }
            int filterIndex = 0;
            this.ldifWriter = new LDIFEntryWriter(this.getOutputStream()).setWrapColumn(wrapColumn);
            LDAPSearchResultHandler resultHandler = new LDAPSearchResultHandler();
            while (true) {
                Control control;
                Result result = connection.search(search, resultHandler);
                try {
                    control = result.getControl(ServerSideSortResponseControl.DECODER, new DecodeOptions());
                    if (control != null && ((ServerSideSortResponseControl)control).getResult() != ResultCode.SUCCESS) {
                        this.println(ToolsMessages.WARN_LDAPSEARCH_SORT_ERROR.get((Object)((ServerSideSortResponseControl)control).getResult().toString()));
                    }
                }
                catch (DecodeException e) {
                    this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
                }
                try {
                    control = result.getControl(VirtualListViewResponseControl.DECODER, new DecodeOptions());
                    if (control != null) {
                        LocalizableMessage msg;
                        if (((VirtualListViewResponseControl)control).getResult() == ResultCode.SUCCESS) {
                            msg = ToolsMessages.INFO_LDAPSEARCH_VLV_TARGET_OFFSET.get((Object)((VirtualListViewResponseControl)control).getTargetPosition());
                            this.println(msg);
                            msg = ToolsMessages.INFO_LDAPSEARCH_VLV_CONTENT_COUNT.get((Object)((VirtualListViewResponseControl)control).getContentCount());
                            this.println(msg);
                        } else {
                            msg = ToolsMessages.WARN_LDAPSEARCH_VLV_ERROR.get((Object)((VirtualListViewResponseControl)control).getResult().toString());
                            this.println(msg);
                        }
                    }
                }
                catch (DecodeException e) {
                    this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
                }
                try {
                    control = result.getControl(SimplePagedResultsControl.DECODER, new DecodeOptions());
                    if (control != null && ((SimplePagedResultsControl)control).getCookie().length() > 0) {
                        if (!this.isQuiet()) {
                            this.pressReturnToContinue();
                        }
                        Iterator<Control> iterator = search.getControls().iterator();
                        while (iterator.hasNext()) {
                            if (!"1.2.840.113556.1.4.319".equals(iterator.next().getOID())) continue;
                            iterator.remove();
                        }
                        control = SimplePagedResultsControl.newControl(true, pageSize, ((SimplePagedResultsControl)control).getCookie());
                        search.addControl(control);
                        continue;
                    }
                }
                catch (DecodeException e) {
                    this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
                }
                this.errPrintln();
                this.errPrintln(ToolsMessages.ERR_TOOL_RESULT_CODE.get((Object)result.getResultCode().intValue(), (Object)result.getResultCode().toString()));
                if (result.getDiagnosticMessage() != null && result.getDiagnosticMessage().length() > 0) {
                    this.errPrintln(LocalizableMessage.raw((CharSequence)result.getDiagnosticMessage(), (Object[])new Object[0]));
                }
                if (result.getMatchedDN() != null && result.getMatchedDN().length() > 0) {
                    this.errPrintln(ToolsMessages.ERR_TOOL_MATCHED_DN.get((Object)result.getMatchedDN()));
                }
                if (++filterIndex >= filters.size()) break;
                search.setFilter((Filter)filters.get(filterIndex));
            }
            if (countEntries.isPresent() && !this.isQuiet()) {
                this.println(ToolsMessages.INFO_LDAPSEARCH_MATCHING_ENTRY_COUNT.get((Object)resultHandler.entryCount));
                this.println();
            }
        }
        catch (LdapException ere) {
            int n;
            try {
                n = Utils.printErrorMessage(this, ere);
            }
            catch (Throwable throwable) {
                org.forgerock.util.Utils.closeSilently(this.ldifWriter, connection);
                throw throwable;
            }
            org.forgerock.util.Utils.closeSilently(this.ldifWriter, connection);
            return n;
        }
        org.forgerock.util.Utils.closeSilently(this.ldifWriter, connection);
        return 0;
    }

    private class LDAPSearchResultHandler
    implements SearchResultHandler {
        private int entryCount;

        private LDAPSearchResultHandler() {
        }

        @Override
        public boolean handleEntry(SearchResultEntry entry) {
            Control control;
            ++this.entryCount;
            try {
                control = entry.getControl(EntryChangeNotificationResponseControl.DECODER, new DecodeOptions());
                if (control != null) {
                    LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_PSEARCH_CHANGE_TYPE.get((Object)((EntryChangeNotificationResponseControl)control).getChangeType().toString()));
                    DN previousDN = ((EntryChangeNotificationResponseControl)control).getPreviousName();
                    if (previousDN != null) {
                        LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_PSEARCH_PREVIOUS_DN.get((Object)previousDN.toString()));
                    }
                }
            }
            catch (DecodeException de) {
                LDAPSearch.this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)de.getLocalizedMessage()));
            }
            try {
                control = entry.getControl(AccountUsabilityResponseControl.DECODER, new DecodeOptions());
                if (control != null) {
                    LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_HEADER.get());
                    if (((AccountUsabilityResponseControl)control).isUsable()) {
                        LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_IS_USABLE.get());
                        if (((AccountUsabilityResponseControl)control).getSecondsBeforeExpiration() > 0) {
                            int timeToExp = ((AccountUsabilityResponseControl)control).getSecondsBeforeExpiration();
                            LocalizableMessage timeToExpStr = com.forgerock.opendj.cli.Utils.secondsToTimeString((int)timeToExp);
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_TIME_UNTIL_EXPIRATION.get((Object)timeToExpStr));
                        }
                    } else {
                        LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_NOT_USABLE.get());
                        if (((AccountUsabilityResponseControl)control).isInactive()) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_ACCT_INACTIVE.get());
                        }
                        if (((AccountUsabilityResponseControl)control).isReset()) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_PW_RESET.get());
                        }
                        if (((AccountUsabilityResponseControl)control).isExpired()) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_PW_EXPIRED.get());
                            if (((AccountUsabilityResponseControl)control).getRemainingGraceLogins() > 0) {
                                LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_REMAINING_GRACE.get((Object)((AccountUsabilityResponseControl)control).getRemainingGraceLogins()));
                            }
                        }
                        if (((AccountUsabilityResponseControl)control).isLocked()) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_LOCKED.get());
                            if (((AccountUsabilityResponseControl)control).getSecondsBeforeUnlock() > 0) {
                                int timeToUnlock = ((AccountUsabilityResponseControl)control).getSecondsBeforeUnlock();
                                LocalizableMessage timeToUnlockStr = com.forgerock.opendj.cli.Utils.secondsToTimeString((int)timeToUnlock);
                                LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_TIME_UNTIL_UNLOCK.get((Object)timeToUnlockStr));
                            }
                        }
                    }
                }
            }
            catch (DecodeException de) {
                LDAPSearch.this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)de.getLocalizedMessage()));
            }
            try {
                LDAPSearch.this.ldifWriter.writeEntry(entry);
                LDAPSearch.this.ldifWriter.flush();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return true;
        }

        @Override
        public boolean handleReference(SearchResultReference reference) {
            LDAPSearch.this.println(LocalizableMessage.raw((CharSequence)reference.toString(), (Object[])new Object[0]));
            return true;
        }
    }
}

