/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.VersionHandler;
import com.forgerock.opendj.ldap.tools.DataSource;
import com.forgerock.opendj.ldap.tools.PerformanceRunner;
import com.forgerock.opendj.ldap.tools.PerformanceRunnerOptions;
import com.forgerock.opendj.ldap.tools.SdkVersionHandler;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;

public final class SearchRate
extends ConsoleApplication {
    private BooleanArgument verbose;
    private BooleanArgument scriptFriendly;
    private final AtomicInteger entryRecentCount = new AtomicInteger();

    public static void main(String[] args) {
        int retCode = new SearchRate().run(args);
        System.exit(com.forgerock.opendj.cli.Utils.filterExitCode((int)retCode));
    }

    private SearchRate() {
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isScriptFriendly() {
        return this.scriptFriendly.isPresent();
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    private int run(String[] args) {
        ConnectionFactory connectionFactory;
        MultiChoiceArgument dereferencePolicy;
        MultiChoiceArgument searchScope;
        StringArgument baseDN;
        SearchPerformanceRunner runner;
        ConnectionFactoryProvider connectionFactoryProvider;
        LocalizableMessage toolDescription = ToolsMessages.INFO_SEARCHRATE_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(SearchRate.class.getName(), toolDescription, false, true, 1, 0, "[filter format string] [attributes ...]");
        argParser.setVersionHandler((VersionHandler)new SdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_SEARCHRATE.get());
        argParser.setDocToolDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_RATE_TOOLS.get());
        try {
            Utils.setDefaultPerfToolProperties();
            connectionFactoryProvider = new ConnectionFactoryProvider(argParser, (ConsoleApplication)this);
            runner = new SearchPerformanceRunner(new PerformanceRunnerOptions(argParser, this));
            StringArgument propertiesFileArgument = CommonArguments.getPropertiesFile();
            argParser.addArgument((Argument)propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = CommonArguments.getNoPropertiesFile();
            argParser.addArgument((Argument)noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            BooleanArgument showUsage = CommonArguments.getShowUsage();
            argParser.addArgument((Argument)showUsage);
            argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
            baseDN = new StringArgument("baseDN", Character.valueOf('b'), "baseDN", true, false, true, ToolsMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_SEARCHRATE_TOOL_DESCRIPTION_BASEDN.get());
            baseDN.setPropertyName("baseDN");
            argParser.addArgument((Argument)baseDN);
            searchScope = CommonArguments.getSearchScope();
            argParser.addArgument((Argument)searchScope);
            dereferencePolicy = new MultiChoiceArgument("derefpolicy", Character.valueOf('a'), "dereferencePolicy", false, true, ToolsMessages.INFO_DEREFERENCE_POLICE_PLACEHOLDER.get(), (Collection)DereferenceAliasesPolicy.values(), false, ToolsMessages.INFO_SEARCH_DESCRIPTION_DEREFERENCE_POLICY.get());
            dereferencePolicy.setPropertyName("dereferencePolicy");
            dereferencePolicy.setDefaultValue((Object)DereferenceAliasesPolicy.NEVER);
            argParser.addArgument((Argument)dereferencePolicy);
            this.verbose = CommonArguments.getVerbose();
            argParser.addArgument((Argument)this.verbose);
            this.scriptFriendly = new BooleanArgument("scriptFriendly", Character.valueOf('S'), "scriptFriendly", ToolsMessages.INFO_DESCRIPTION_SCRIPT_FRIENDLY.get());
            this.scriptFriendly.setPropertyName("scriptFriendly");
            argParser.addArgument((Argument)this.scriptFriendly);
        }
        catch (ArgumentException ae) {
            LocalizableMessage message = ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage());
            this.errPrintln(message);
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            argParser.parseArguments(args);
            if (argParser.usageOrVersionDisplayed()) {
                return 0;
            }
            connectionFactory = connectionFactoryProvider.getAuthenticatedConnectionFactory();
            runner.setBindRequest(connectionFactoryProvider.getBindRequest());
            runner.validate();
        }
        catch (ArgumentException ae) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        LinkedList attributes = new LinkedList();
        ArrayList filterAndAttributeStrings = argParser.getTrailingArguments();
        if (!filterAndAttributeStrings.isEmpty()) {
            runner.filter = (String)filterAndAttributeStrings.remove(0);
            attributes.addAll(filterAndAttributeStrings);
        }
        SearchPerformanceRunner.access$402(runner, attributes.toArray(new String[attributes.size()]));
        runner.baseDN = baseDN.getValue();
        try {
            runner.scope = (SearchScope)searchScope.getTypedValue();
            runner.dereferencesAliasesPolicy = (DereferenceAliasesPolicy)dereferencePolicy.getTypedValue();
        }
        catch (ArgumentException ex1) {
            this.errPrintln(ex1.getMessageObject());
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            Object[] data = DataSource.generateData(runner.getDataSources(), null);
            String.format(runner.filter, data);
            String.format(runner.baseDN, data);
        }
        catch (Exception ex1) {
            this.errPrintln(LocalizableMessage.raw((CharSequence)("Error formatting filter or base DN: " + ex1), (Object[])new Object[0]));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        return runner.run(connectionFactory);
    }

    private final class SearchPerformanceRunner
    extends PerformanceRunner {
        private String filter;
        private String baseDN;
        private SearchScope scope;
        private DereferenceAliasesPolicy dereferencesAliasesPolicy;
        private String[] attributes;

        private SearchPerformanceRunner(PerformanceRunnerOptions options) throws ArgumentException {
            super(options);
        }

        @Override
        PerformanceRunner.WorkerThread newWorkerThread(Connection connection, ConnectionFactory connectionFactory) {
            return new SearchWorkerThread(connection, connectionFactory);
        }

        @Override
        PerformanceRunner.StatsThread newStatsThread() {
            return new SearchStatsThread();
        }

        static /* synthetic */ String[] access$402(SearchPerformanceRunner x0, String[] x1) {
            x0.attributes = x1;
            return x1;
        }

        private final class SearchWorkerThread
        extends PerformanceRunner.WorkerThread {
            private SearchRequest sr;
            private Object[] data;

            private SearchWorkerThread(Connection connection, ConnectionFactory connectionFactory) {
                super(SearchPerformanceRunner.this, connection, connectionFactory);
            }

            @Override
            public Promise<?, LdapException> performOperation(Connection connection, DataSource[] dataSources, long startTime) {
                if (this.sr == null) {
                    if (dataSources == null) {
                        this.sr = Requests.newSearchRequest((String)SearchPerformanceRunner.this.baseDN, (SearchScope)SearchPerformanceRunner.this.scope, (String)SearchPerformanceRunner.this.filter, (String[])SearchPerformanceRunner.this.attributes);
                    } else {
                        this.data = DataSource.generateData(dataSources, this.data);
                        this.sr = Requests.newSearchRequest((String)String.format(SearchPerformanceRunner.this.baseDN, this.data), (SearchScope)SearchPerformanceRunner.this.scope, (String)String.format(SearchPerformanceRunner.this.filter, this.data), (String[])SearchPerformanceRunner.this.attributes);
                    }
                    this.sr.setDereferenceAliasesPolicy(SearchPerformanceRunner.this.dereferencesAliasesPolicy);
                } else if (dataSources != null) {
                    this.data = DataSource.generateData(dataSources, this.data);
                    this.sr.setFilter(String.format(SearchPerformanceRunner.this.filter, this.data));
                    this.sr.setName(String.format(SearchPerformanceRunner.this.baseDN, this.data));
                }
                SearchStatsHandler handler = new SearchStatsHandler(startTime);
                this.incrementIterationCount();
                return connection.searchAsync(this.sr, (SearchResultHandler)handler).thenOnResult((ResultHandler)handler).thenOnException((ExceptionHandler)handler);
            }
        }

        private final class SearchStatsThread
        extends PerformanceRunner.StatsThread {
            private final String[] extraColumn;

            private SearchStatsThread() {
                super(SearchPerformanceRunner.this, "Entries/Srch");
                this.extraColumn = new String[1];
            }

            @Override
            void resetStats() {
                super.resetStats();
                SearchRate.this.entryRecentCount.set(0);
            }

            @Override
            String[] getAdditionalColumns() {
                int entryCount = SearchRate.this.entryRecentCount.getAndSet(0);
                this.extraColumn[0] = this.getDivisionResult(entryCount, this.intervalSuccessCount, 1, "0.0");
                return this.extraColumn;
            }
        }

        private final class SearchStatsHandler
        extends PerformanceRunner.UpdateStatsResultHandler<Result>
        implements SearchResultHandler {
            private SearchStatsHandler(long startTime) {
                super(SearchPerformanceRunner.this, startTime);
            }

            public boolean handleEntry(SearchResultEntry entry) {
                SearchRate.this.entryRecentCount.getAndIncrement();
                return true;
            }

            public boolean handleReference(SearchResultReference reference) {
                return true;
            }
        }
    }
}

