/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.cli.VersionHandler;
import com.forgerock.opendj.ldap.tools.SdkVersionHandler;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.forgerock.i18n.LocalizableException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldif.ChangeRecordReader;
import org.forgerock.opendj.ldif.EntryReader;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.opendj.ldif.LDIF;
import org.forgerock.opendj.ldif.LDIFChangeRecordReader;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;
import org.forgerock.opendj.ldif.RejectedChangeRecordListener;

public final class LDIFModify
extends ConsoleApplication {
    public static void main(String[] args) {
        int retCode = new LDIFModify().run(args);
        System.exit(Utils.filterExitCode((int)retCode));
    }

    private LDIFModify() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] args) {
        LDIFEntryWriter outputWriter;
        LDIFChangeRecordReader changesReader;
        LDIFEntryReader sourceReader;
        OutputStream outputStream;
        InputStream changesInputStream;
        InputStream sourceInputStream;
        BooleanArgument continueOnError;
        block27: {
            block26: {
                StringArgument outputFilename;
                block25: {
                    ArrayList trailingArguments;
                    block24: {
                        LocalizableMessage toolDescription = ToolsMessages.INFO_LDIFMODIFY_TOOL_DESCRIPTION.get();
                        ArgumentParser argParser = new ArgumentParser(LDIFModify.class.getName(), toolDescription, false, true, 1, 2, "source [changes]");
                        argParser.setVersionHandler((VersionHandler)new SdkVersionHandler());
                        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDIFMODIFY.get());
                        try {
                            outputFilename = new StringArgument("outputFilename", Character.valueOf('o'), "outputLDIF", false, false, true, ToolsMessages.INFO_OUTPUT_LDIF_FILE_PLACEHOLDER.get(), "stdout", null, ToolsMessages.INFO_LDIFMODIFY_DESCRIPTION_OUTPUT_FILENAME.get((Object)ToolsMessages.INFO_OUTPUT_LDIF_FILE_PLACEHOLDER.get()));
                            argParser.addArgument((Argument)outputFilename);
                            continueOnError = CommonArguments.getContinueOnError();
                            argParser.addArgument((Argument)continueOnError);
                            BooleanArgument showUsage = CommonArguments.getShowUsage();
                            argParser.addArgument((Argument)showUsage);
                            argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
                        }
                        catch (ArgumentException ae) {
                            LocalizableMessage message = ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage());
                            this.errPrintln(message);
                            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                        }
                        try {
                            argParser.parseArguments(args);
                            if (argParser.usageOrVersionDisplayed()) {
                                return ResultCode.SUCCESS.intValue();
                            }
                        }
                        catch (ArgumentException ae) {
                            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
                            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                        }
                        sourceInputStream = null;
                        changesInputStream = null;
                        outputStream = null;
                        sourceReader = null;
                        changesReader = null;
                        outputWriter = null;
                        trailingArguments = argParser.getTrailingArguments();
                        if ("-".equals(trailingArguments.get(0))) break block24;
                        try {
                            sourceInputStream = new FileInputStream((String)trailingArguments.get(0));
                        }
                        catch (FileNotFoundException e) {
                            LocalizableMessage message = ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_READ.get(trailingArguments.get(0), (Object)e.getLocalizedMessage());
                            this.errPrintln(message);
                            int n = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                            org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceReader, changesReader, outputWriter});
                            org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceInputStream, changesInputStream, outputStream});
                            return n;
                        }
                    }
                    if (trailingArguments.size() <= 1 || "-".equals(trailingArguments.get(1))) break block25;
                    try {
                        changesInputStream = new FileInputStream((String)trailingArguments.get(1));
                    }
                    catch (FileNotFoundException e) {
                        LocalizableMessage message = ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_READ.get(trailingArguments.get(1), (Object)e.getLocalizedMessage());
                        this.errPrintln(message);
                        int n = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceReader, changesReader, outputWriter});
                        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceInputStream, changesInputStream, outputStream});
                        return n;
                    }
                }
                if (!outputFilename.isPresent() || "-".equals(outputFilename.getValue())) break block26;
                try {
                    outputStream = new FileOutputStream(outputFilename.getValue());
                }
                catch (FileNotFoundException e) {
                    LocalizableMessage message = ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_WRITE.get((Object)outputFilename.getValue(), (Object)e.getLocalizedMessage());
                    this.errPrintln(message);
                    int n = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                    org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceReader, changesReader, outputWriter});
                    org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceInputStream, changesInputStream, outputStream});
                    return n;
                }
            }
            if (sourceInputStream == null) {
                sourceInputStream = System.in;
            }
            if (changesInputStream == null) {
                changesInputStream = System.in;
            }
            if (outputStream == null) {
                outputStream = System.out;
            }
            if (sourceInputStream != changesInputStream) break block27;
            LocalizableMessage message = ToolsMessages.ERR_LDIFMODIFY_MULTIPLE_USES_OF_STDIN.get();
            this.errPrintln(message);
            int n = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceReader, changesReader, outputWriter});
            org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceInputStream, changesInputStream, outputStream});
            return n;
        }
        try {
            sourceReader = new LDIFEntryReader(sourceInputStream);
            changesReader = new LDIFChangeRecordReader(changesInputStream);
            outputWriter = new LDIFEntryWriter(outputStream);
            RejectedChangeRecordListener listener = new RejectedChangeRecordListener(){

                public Entry handleDuplicateEntry(AddRequest change, Entry existingEntry) throws DecodeException {
                    try {
                        RejectedChangeRecordListener.FAIL_FAST.handleDuplicateEntry(change, existingEntry);
                    }
                    catch (DecodeException e) {
                        this.logErrorOrFail(e);
                    }
                    return change;
                }

                public Entry handleDuplicateEntry(ModifyDNRequest change, Entry existingEntry, Entry renamedEntry) throws DecodeException {
                    try {
                        RejectedChangeRecordListener.FAIL_FAST.handleDuplicateEntry(change, existingEntry, renamedEntry);
                    }
                    catch (DecodeException e) {
                        this.logErrorOrFail(e);
                    }
                    return renamedEntry;
                }

                public void handleRejectedChangeRecord(AddRequest change, LocalizableMessage reason) throws DecodeException {
                    try {
                        RejectedChangeRecordListener.FAIL_FAST.handleRejectedChangeRecord(change, reason);
                    }
                    catch (DecodeException e) {
                        this.logErrorOrFail(e);
                    }
                }

                public void handleRejectedChangeRecord(DeleteRequest change, LocalizableMessage reason) throws DecodeException {
                    try {
                        RejectedChangeRecordListener.FAIL_FAST.handleRejectedChangeRecord(change, reason);
                    }
                    catch (DecodeException e) {
                        this.logErrorOrFail(e);
                    }
                }

                public void handleRejectedChangeRecord(ModifyDNRequest change, LocalizableMessage reason) throws DecodeException {
                    try {
                        RejectedChangeRecordListener.FAIL_FAST.handleRejectedChangeRecord(change, reason);
                    }
                    catch (DecodeException e) {
                        this.logErrorOrFail(e);
                    }
                }

                public void handleRejectedChangeRecord(ModifyRequest change, LocalizableMessage reason) throws DecodeException {
                    try {
                        RejectedChangeRecordListener.FAIL_FAST.handleRejectedChangeRecord(change, reason);
                    }
                    catch (DecodeException e) {
                        this.logErrorOrFail(e);
                    }
                }

                private void logErrorOrFail(DecodeException e) throws DecodeException {
                    if (!continueOnError.isPresent()) {
                        throw e;
                    }
                    LDIFModify.this.errPrintln(e.getMessageObject());
                }
            };
            LDIF.copyTo((EntryReader)LDIF.patch((EntryReader)sourceReader, (ChangeRecordReader)changesReader, (RejectedChangeRecordListener)listener), (EntryWriter)outputWriter);
        }
        catch (IOException e) {
            int n;
            try {
                if (e instanceof LocalizableException) {
                    this.errPrintln(ToolsMessages.ERR_LDIFMODIFY_PATCH_FAILED.get((Object)((LocalizableException)e).getMessageObject()));
                } else {
                    this.errPrintln(ToolsMessages.ERR_LDIFMODIFY_PATCH_FAILED.get((Object)e.getLocalizedMessage()));
                }
                n = ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue();
            }
            catch (Throwable throwable) {
                org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceReader, changesReader, outputWriter});
                org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceInputStream, changesInputStream, outputStream});
                throw throwable;
            }
            org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceReader, changesReader, outputWriter});
            org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceInputStream, changesInputStream, outputStream});
            return n;
        }
        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceReader, changesReader, outputWriter});
        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceInputStream, changesInputStream, outputStream});
        return ResultCode.SUCCESS.intValue();
    }
}

