/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.FileBasedArgument;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.VersionHandler;
import com.forgerock.opendj.ldap.tools.SdkVersionHandler;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.OutputStream;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.PasswordModifyExtendedRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.PasswordModifyExtendedResult;

public final class LDAPPasswordModify
extends ConsoleApplication {
    private BooleanArgument verbose;

    public static void main(String[] args) {
        int retCode = new LDAPPasswordModify().run(args);
        System.exit(com.forgerock.opendj.cli.Utils.filterExitCode((int)retCode));
    }

    private LDAPPasswordModify() {
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    private int run(String[] args) {
        PasswordModifyExtendedResult result;
        Connection connection;
        ConnectionFactory connectionFactory;
        IntegerArgument version;
        StringArgument controlStr;
        StringArgument proxyAuthzID;
        FileBasedArgument currentPWFile;
        StringArgument currentPW;
        FileBasedArgument newPWFile;
        StringArgument newPW;
        ConnectionFactoryProvider connectionFactoryProvider;
        LocalizableMessage toolDescription = ToolsMessages.INFO_LDAPPWMOD_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(LDAPPasswordModify.class.getName(), toolDescription, false);
        argParser.setVersionHandler((VersionHandler)new SdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDAPPASSWORDMODIFY.get());
        try {
            connectionFactoryProvider = new ConnectionFactoryProvider(argParser, (ConsoleApplication)this);
            StringArgument propertiesFileArgument = CommonArguments.getPropertiesFile();
            argParser.addArgument((Argument)propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = CommonArguments.getNoPropertiesFile();
            argParser.addArgument((Argument)noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            newPW = new StringArgument("newpw", Character.valueOf('n'), "newPassword", false, false, true, ToolsMessages.INFO_NEW_PASSWORD_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_LDAPPWMOD_DESCRIPTION_NEWPW.get());
            newPW.setPropertyName("newPassword");
            argParser.addArgument((Argument)newPW);
            newPWFile = new FileBasedArgument("newpwfile", Character.valueOf('F'), "newPasswordFile", false, false, ToolsMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_LDAPPWMOD_DESCRIPTION_NEWPWFILE.get());
            newPWFile.setPropertyName("newPasswordFile");
            argParser.addArgument((Argument)newPWFile);
            currentPW = new StringArgument("currentpw", Character.valueOf('c'), "currentPassword", false, false, true, ToolsMessages.INFO_CURRENT_PASSWORD_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_LDAPPWMOD_DESCRIPTION_CURRENTPW.get());
            currentPW.setPropertyName("currentPassword");
            argParser.addArgument((Argument)currentPW);
            currentPWFile = new FileBasedArgument("currentpwfile", Character.valueOf('C'), "currentPasswordFile", false, false, ToolsMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_LDAPPWMOD_DESCRIPTION_CURRENTPWFILE.get());
            currentPWFile.setPropertyName("currentPasswordFile");
            argParser.addArgument((Argument)currentPWFile);
            proxyAuthzID = new StringArgument("authzid", Character.valueOf('a'), "authzID", false, false, true, ToolsMessages.INFO_PROXYAUTHID_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_LDAPPWMOD_DESCRIPTION_AUTHZID.get());
            proxyAuthzID.setPropertyName("authzID");
            argParser.addArgument((Argument)proxyAuthzID);
            controlStr = new StringArgument("control", Character.valueOf('J'), "control", false, true, true, ToolsMessages.INFO_LDAP_CONTROL_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_DESCRIPTION_CONTROLS.get());
            controlStr.setPropertyName("control");
            argParser.addArgument((Argument)controlStr);
            version = CommonArguments.getLdapVersion();
            argParser.addArgument((Argument)version);
            this.verbose = CommonArguments.getVerbose();
            argParser.addArgument((Argument)this.verbose);
            BooleanArgument showUsage = CommonArguments.getShowUsage();
            argParser.addArgument((Argument)showUsage);
            argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
        }
        catch (ArgumentException ae) {
            this.errPrintln(ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            argParser.parseArguments(args);
            if (argParser.usageOrVersionDisplayed()) {
                return 0;
            }
            connectionFactory = connectionFactoryProvider.getAuthenticatedConnectionFactory();
        }
        catch (ArgumentException ae) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        PasswordModifyExtendedRequest request = Requests.newPasswordModifyExtendedRequest();
        try {
            int versionNumber = version.getIntValue();
            if (versionNumber != 2 && versionNumber != 3) {
                this.errPrintln(ToolsMessages.ERR_DESCRIPTION_INVALID_VERSION.get((Object)String.valueOf(versionNumber)));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
        }
        catch (ArgumentException ae) {
            this.errPrintln(ToolsMessages.ERR_DESCRIPTION_INVALID_VERSION.get((Object)version.getValue()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        if (controlStr.isPresent()) {
            for (String ctrlString : controlStr.getValues()) {
                try {
                    GenericControl ctrl = Utils.getControl(ctrlString);
                    request.addControl((Control)ctrl);
                }
                catch (DecodeException de) {
                    this.errPrintln(ToolsMessages.ERR_TOOL_INVALID_CONTROL_STRING.get((Object)ctrlString));
                    ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            }
        }
        if (newPW.isPresent() && newPWFile.isPresent()) {
            LocalizableMessage message = ToolsMessages.ERR_LDAPPWMOD_CONFLICTING_ARGS.get((Object)newPW.getLongIdentifier(), (Object)newPWFile.getLongIdentifier());
            this.errPrintln(message);
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        if (currentPW.isPresent() && currentPWFile.isPresent()) {
            LocalizableMessage message = ToolsMessages.ERR_LDAPPWMOD_CONFLICTING_ARGS.get((Object)currentPW.getLongIdentifier(), (Object)currentPWFile.getLongIdentifier());
            this.errPrintln(message);
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            connection = connectionFactory.getConnection();
        }
        catch (LdapException ere) {
            return Utils.printErrorMessage(this, ere);
        }
        if (proxyAuthzID.isPresent()) {
            request.setUserIdentity((Object)proxyAuthzID.getValue());
        }
        if (currentPW.isPresent()) {
            request.setOldPassword(currentPW.getValue().toCharArray());
        } else if (currentPWFile.isPresent()) {
            request.setOldPassword(currentPWFile.getValue().toCharArray());
        }
        if (newPW.isPresent()) {
            request.setNewPassword(newPW.getValue().toCharArray());
        } else if (newPWFile.isPresent()) {
            request.setNewPassword(newPWFile.getValue().toCharArray());
        }
        try {
            result = (PasswordModifyExtendedResult)connection.extendedRequest((ExtendedRequest)request);
        }
        catch (LdapException e) {
            String matchedDN;
            LocalizableMessage message = ToolsMessages.ERR_LDAPPWMOD_FAILED.get((Object)e.getResult().getResultCode().intValue(), (Object)e.getResult().getResultCode().toString());
            this.errPrintln(message);
            String errorMessage = e.getResult().getDiagnosticMessage();
            if (errorMessage != null && errorMessage.length() > 0) {
                message = ToolsMessages.ERR_LDAPPWMOD_FAILURE_ERROR_MESSAGE.get((Object)errorMessage);
                this.errPrintln(message);
            }
            if ((matchedDN = e.getResult().getMatchedDN()) != null && matchedDN.length() > 0) {
                message = ToolsMessages.ERR_LDAPPWMOD_FAILURE_MATCHED_DN.get((Object)matchedDN);
                this.errPrintln(message);
            }
            return e.getResult().getResultCode().intValue();
        }
        this.println(ToolsMessages.INFO_LDAPPWMOD_SUCCESSFUL.get());
        String additionalInfo = result.getDiagnosticMessage();
        if (additionalInfo != null && additionalInfo.length() > 0) {
            this.println(ToolsMessages.INFO_LDAPPWMOD_ADDITIONAL_INFO.get((Object)additionalInfo));
        }
        if (result.getGeneratedPassword() != null) {
            this.println(ToolsMessages.INFO_LDAPPWMOD_GENERATED_PASSWORD.get((Object)ByteString.valueOfBytes((byte[])result.getGeneratedPassword()).toString()));
        }
        return 0;
    }
}

