/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.VersionHandler;
import com.forgerock.opendj.ldap.tools.DataSource;
import com.forgerock.opendj.ldap.tools.MakeLDIF;
import com.forgerock.opendj.ldap.tools.PerformanceRunner;
import com.forgerock.opendj.ldap.tools.PerformanceRunnerOptions;
import com.forgerock.opendj.ldap.tools.SdkVersionHandler;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldif.EntryGenerator;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

public class AddRate
extends ConsoleApplication {
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int DEFAULT_SIZE_THRESHOLD = 10000;
    private static final int AGE_THRESHOLD_LOWERBOUND = 1;
    private static final int SIZE_THRESHOLD_LOWERBOUND = 1;
    private BooleanArgument verbose;
    private BooleanArgument scriptFriendly;

    public static void main(String[] args) {
        int retCode = new AddRate().run(args);
        System.exit(com.forgerock.opendj.cli.Utils.filterExitCode((int)retCode));
    }

    private AddRate() {
    }

    AddRate(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isScriptFriendly() {
        return this.scriptFriendly.isPresent();
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    int run(String[] args) {
        ConnectionFactory connectionFactory;
        BooleanArgument noPurgeArgument;
        IntegerArgument deleteAgeThreshold;
        IntegerArgument deleteSizeThreshold;
        MultiChoiceArgument deleteMode;
        StringArgument constantsArg;
        IntegerArgument randomSeedArg;
        StringArgument resourcePathArg;
        AddPerformanceRunner runner;
        ConnectionFactoryProvider connectionFactoryProvider;
        LocalizableMessage toolDescription = ToolsMessages.INFO_ADDRATE_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(AddRate.class.getName(), toolDescription, false, true, 1, 1, "template-file-path");
        argParser.setVersionHandler((VersionHandler)new SdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_ADDRATE.get());
        argParser.setDocToolDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_RATE_TOOLS.get());
        try {
            Utils.setDefaultPerfToolProperties();
            PerformanceRunnerOptions options = new PerformanceRunnerOptions(argParser, this);
            options.setSupportsGeneratorArgument(false);
            connectionFactoryProvider = new ConnectionFactoryProvider(argParser, (ConsoleApplication)this);
            runner = new AddPerformanceRunner(options);
            this.addCommonArguments(argParser);
            resourcePathArg = new StringArgument("resourcepath", Character.valueOf('r'), "resourcePath", false, false, true, ToolsMessages.INFO_PATH_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_ADDRATE_DESCRIPTION_RESOURCE_PATH.get());
            resourcePathArg.setDocDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_RESOURCE_PATH.get());
            argParser.addArgument((Argument)resourcePathArg);
            randomSeedArg = new IntegerArgument("randomseed", Character.valueOf('R'), "randomSeed", false, false, true, ToolsMessages.INFO_SEED_PLACEHOLDER.get(), 0, null, ToolsMessages.INFO_ADDRATE_DESCRIPTION_SEED.get());
            argParser.addArgument((Argument)randomSeedArg);
            constantsArg = new StringArgument("constant", Character.valueOf('g'), "constant", false, true, true, ToolsMessages.INFO_CONSTANT_PLACEHOLDER.get(), null, null, ToolsMessages.INFO_ADDRATE_DESCRIPTION_CONSTANT.get());
            argParser.addArgument((Argument)constantsArg);
            deleteMode = new MultiChoiceArgument("deletemode", Character.valueOf('C'), "deleteMode", false, true, ToolsMessages.INFO_DELETEMODE_PLACEHOLDER.get(), Arrays.asList(DeleteStrategy.values()), false, ToolsMessages.INFO_ADDRATE_DESCRIPTION_DELETEMODE.get());
            deleteMode.setDefaultValue(DeleteStrategy.FIFO.toString());
            argParser.addArgument((Argument)deleteMode);
            deleteSizeThreshold = new IntegerArgument("deletesizethreshold", Character.valueOf('s'), "deleteSizeThreshold", false, false, true, ToolsMessages.INFO_DELETESIZETHRESHOLD_PLACEHOLDER.get(), 10000, "deleteSizeThreshold", true, 1, false, Integer.MAX_VALUE, ToolsMessages.INFO_ADDRATE_DESCRIPTION_DELETESIZETHRESHOLD.get());
            argParser.addArgument((Argument)deleteSizeThreshold);
            deleteAgeThreshold = new IntegerArgument("deleteagethreshold", Character.valueOf('a'), "deleteAgeThreshold", false, true, ToolsMessages.INFO_DELETEAGETHRESHOLD_PLACEHOLDER.get(), true, 1, false, Integer.MAX_VALUE, ToolsMessages.INFO_ADDRATE_DESCRIPTION_DELETEAGETHRESHOLD.get());
            deleteAgeThreshold.setPropertyName(deleteAgeThreshold.getLongIdentifier());
            argParser.addArgument((Argument)deleteAgeThreshold);
            noPurgeArgument = new BooleanArgument("nopurge", Character.valueOf('n'), "noPurge", ToolsMessages.INFO_ADDRATE_DESCRIPTION_NOPURGE.get());
            argParser.addArgument((Argument)noPurgeArgument);
        }
        catch (ArgumentException ae) {
            this.errPrintln(ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            argParser.parseArguments(args);
            if (argParser.usageOrVersionDisplayed()) {
                return 0;
            }
            connectionFactory = connectionFactoryProvider.getAuthenticatedConnectionFactory();
            runner.setBindRequest(connectionFactoryProvider.getBindRequest());
            runner.validate((MultiChoiceArgument<DeleteStrategy>)deleteMode, deleteSizeThreshold, deleteAgeThreshold, noPurgeArgument);
        }
        catch (ArgumentException ae) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        String templatePath = (String)argParser.getTrailingArguments().get(0);
        runner.generator = MakeLDIF.createGenerator(templatePath, resourcePathArg, randomSeedArg, constantsArg, false, this);
        if (runner.generator == null) {
            return ResultCode.OPERATIONS_ERROR.intValue();
        }
        Runtime.getRuntime().addShutdownHook(runner.newPurgerThread());
        return runner.run(connectionFactory);
    }

    private void addCommonArguments(ArgumentParser argParser) throws ArgumentException {
        StringArgument propertiesFileArgument = CommonArguments.getPropertiesFile();
        argParser.addArgument((Argument)propertiesFileArgument);
        argParser.setFilePropertiesArgument(propertiesFileArgument);
        BooleanArgument noPropertiesFileArgument = CommonArguments.getNoPropertiesFile();
        argParser.addArgument((Argument)noPropertiesFileArgument);
        argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
        BooleanArgument showUsage = CommonArguments.getShowUsage();
        argParser.addArgument((Argument)showUsage);
        argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
        this.verbose = CommonArguments.getVerbose();
        argParser.addArgument((Argument)this.verbose);
        this.scriptFriendly = new BooleanArgument("scriptFriendly", Character.valueOf('S'), "scriptFriendly", ToolsMessages.INFO_DESCRIPTION_SCRIPT_FRIENDLY.get());
        this.scriptFriendly.setPropertyName("scriptFriendly");
        argParser.addArgument((Argument)this.scriptFriendly);
    }

    private static enum DeleteThreshold {
        SIZE_THRESHOLD,
        AGE_THRESHOLD,
        OFF;

    }

    private static enum DeleteStrategy {
        OFF,
        RANDOM,
        FIFO;

    }

    private final class AddPerformanceRunner
    extends PerformanceRunner {
        private final ConcurrentSkipListMap<Long, String> dnEntriesAdded;
        private final ThreadLocal<Random> randomSeq;
        private EntryGenerator generator;
        private DeleteStrategy delStrategy;
        private DeleteThreshold delThreshold;
        private int sizeThreshold;
        private volatile boolean toggleDelete;
        private long timeToWait;
        private int maxNbAddIterations;
        private boolean purgeEnabled;
        private final AtomicInteger recentAdds;
        private final AtomicInteger recentDeletes;
        private final AtomicInteger totalAdds;
        private final AtomicInteger entryCount;
        private final AtomicBoolean isPurgeBranchRunning;

        private AddPerformanceRunner(PerformanceRunnerOptions options) throws ArgumentException {
            super(options);
            this.dnEntriesAdded = new ConcurrentSkipListMap();
            this.randomSeq = new ThreadLocal<Random>(){

                @Override
                protected Random initialValue() {
                    return new Random();
                }
            };
            this.recentAdds = new AtomicInteger();
            this.recentDeletes = new AtomicInteger();
            this.totalAdds = new AtomicInteger();
            this.entryCount = new AtomicInteger();
            this.isPurgeBranchRunning = new AtomicBoolean();
            this.maxIterationsArgument.setPropertyName("maxNumberOfAdd");
        }

        @Override
        PerformanceRunner.WorkerThread newWorkerThread(Connection connection, ConnectionFactory connectionFactory) {
            return new AddDeleteWorkerThread(connection, connectionFactory);
        }

        @Override
        PerformanceRunner.StatsThread newStatsThread() {
            return new AddRateStatsThread();
        }

        @Override
        PerformanceRunner.TimerThread newEndTimerThread(long timeTowait) {
            return new AddRateTimerThread(timeTowait);
        }

        PerformanceRunner.TimerThread newPurgerThread() {
            return this.newEndTimerThread(0L);
        }

        public void validate(MultiChoiceArgument<DeleteStrategy> delModeArg, IntegerArgument delSizeThresholdArg, IntegerArgument delAgeThresholdArg, BooleanArgument noPurgeArgument) throws ArgumentException {
            super.validate();
            this.delStrategy = (DeleteStrategy)((Object)delModeArg.getTypedValue());
            this.maxNbAddIterations = this.maxIterationsArgument.getIntValue();
            boolean bl = this.purgeEnabled = !noPurgeArgument.isPresent();
            if (delSizeThresholdArg.isPresent() && delAgeThresholdArg.isPresent()) {
                throw new ArgumentException(ToolsMessages.ERR_ADDRATE_THRESHOLD_SIZE_AND_AGE.get());
            }
            if (this.delStrategy == DeleteStrategy.OFF && (delSizeThresholdArg.isPresent() || delAgeThresholdArg.isPresent())) {
                throw new ArgumentException(ToolsMessages.ERR_ADDRATE_DELMODE_OFF_THRESHOLD_ON.get());
            }
            if (this.delStrategy == DeleteStrategy.RANDOM && delAgeThresholdArg.isPresent()) {
                throw new ArgumentException(ToolsMessages.ERR_ADDRATE_DELMODE_RAND_THRESHOLD_AGE.get());
            }
            if (this.delStrategy != DeleteStrategy.OFF) {
                DeleteThreshold deleteThreshold = this.delThreshold = delAgeThresholdArg.isPresent() ? DeleteThreshold.AGE_THRESHOLD : DeleteThreshold.SIZE_THRESHOLD;
                if (this.delThreshold == DeleteThreshold.SIZE_THRESHOLD) {
                    this.setSizeThreshold(delSizeThresholdArg.getIntValue());
                    if (0 < this.maxNbAddIterations && this.maxNbAddIterations < this.sizeThreshold) {
                        throw new ArgumentException(ToolsMessages.ERR_ADDRATE_SIZE_THRESHOLD_LOWER_THAN_ITERATIONS.get());
                    }
                } else {
                    this.timeToWait = TimeUnit.NANOSECONDS.convert(delAgeThresholdArg.getIntValue(), TimeUnit.SECONDS);
                }
            }
        }

        private void setSizeThreshold(int entriesSizeThreshold) {
            this.sizeThreshold = entriesSizeThreshold;
            this.toggleDelete = true;
        }

        private final class AddRateTimerThread
        extends PerformanceRunner.TimerThread {
            private AddRateTimerThread(long timeToWait) {
                super(AddPerformanceRunner.this, timeToWait);
            }

            @Override
            void performStopOperations() {
                if (AddPerformanceRunner.this.purgeEnabled && AddPerformanceRunner.this.isPurgeBranchRunning.compareAndSet(false, true)) {
                    if (!AddRate.this.isScriptFriendly()) {
                        AddRate.this.println(LocalizableMessage.raw((CharSequence)"Purge phase...", (Object[])new Object[0]));
                    }
                    try {
                        AddPerformanceRunner.this.joinAllWorkerThreads();
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException();
                    }
                } else if (!AddPerformanceRunner.this.purgeEnabled) {
                    AddPerformanceRunner.this.stopRequested = true;
                }
            }
        }

        private final class AddDeleteWorkerThread
        extends PerformanceRunner.WorkerThread {
            private AddDeleteWorkerThread(Connection connection, ConnectionFactory connectionFactory) {
                super(AddPerformanceRunner.this, connection, connectionFactory);
            }

            @Override
            public Promise<?, LdapException> performOperation(Connection connection, DataSource[] dataSources, long currentTime) {
                this.startPurgeIfMaxNumberAddReached();
                this.startToggleDeleteIfAgeThresholdReached(currentTime);
                try {
                    String entryToRemove = this.getEntryToRemove(currentTime);
                    if (entryToRemove != null) {
                        return this.doDelete(connection, currentTime, entryToRemove);
                    }
                    return this.doAdd(connection, currentTime);
                }
                catch (AddRateExecutionEndedException a) {
                    return Promises.newResultPromise((Object)ResultCode.OTHER);
                }
                catch (IOException e) {
                    return Promises.newExceptionPromise((Exception)((Object)LdapException.newLdapException((ResultCode)ResultCode.OTHER, (Throwable)e)));
                }
            }

            private void startToggleDeleteIfAgeThresholdReached(long currentTime) {
                if (!AddPerformanceRunner.this.toggleDelete && AddPerformanceRunner.this.delThreshold == DeleteThreshold.AGE_THRESHOLD && !AddPerformanceRunner.this.dnEntriesAdded.isEmpty() && (Long)AddPerformanceRunner.this.dnEntriesAdded.firstKey() + AddPerformanceRunner.this.timeToWait < currentTime) {
                    AddPerformanceRunner.this.setSizeThreshold(AddPerformanceRunner.this.entryCount.get());
                }
            }

            private void startPurgeIfMaxNumberAddReached() {
                AtomicBoolean purgeLatch = new AtomicBoolean();
                if (!AddPerformanceRunner.this.isPurgeBranchRunning.get() && 0 < AddPerformanceRunner.this.maxNbAddIterations && AddPerformanceRunner.this.maxNbAddIterations < AddPerformanceRunner.this.totalAdds.get() && purgeLatch.compareAndSet(false, true)) {
                    AddPerformanceRunner.this.newPurgerThread().start();
                }
            }

            private String getEntryToRemove(long currentTime) throws AddRateExecutionEndedException {
                if (AddPerformanceRunner.this.isPurgeBranchRunning.get()) {
                    return this.purgeEntry();
                }
                if (AddPerformanceRunner.this.toggleDelete && AddPerformanceRunner.this.entryCount.get() > AddPerformanceRunner.this.sizeThreshold) {
                    return this.removeFirstAddedEntry();
                }
                return null;
            }

            private String purgeEntry() throws AddRateExecutionEndedException {
                if (!AddPerformanceRunner.this.dnEntriesAdded.isEmpty()) {
                    return this.removeFirstAddedEntry();
                }
                this.localStopRequested = true;
                throw new AddRateExecutionEndedException();
            }

            private String removeFirstAddedEntry() {
                Map.Entry entry = AddPerformanceRunner.this.dnEntriesAdded.pollFirstEntry();
                return entry != null ? (String)entry.getValue() : null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Promise<Result, LdapException> doAdd(Connection connection, long currentTime) throws IOException {
                Entry entry;
                EntryGenerator entryGenerator = AddPerformanceRunner.this.generator;
                synchronized (entryGenerator) {
                    entry = AddPerformanceRunner.this.generator.readEntry();
                }
                AddStatsHandler addHandler = new AddStatsHandler(currentTime, entry.getName().toString());
                return connection.addAsync(Requests.newAddRequest((Entry)entry)).thenOnResult((ResultHandler)addHandler).thenOnException((ExceptionHandler)addHandler);
            }

            private Promise<?, LdapException> doDelete(Connection connection, long currentTime, String entryToRemove) {
                DeleteStatsHandler deleteHandler = new DeleteStatsHandler(currentTime);
                return connection.deleteAsync(Requests.newDeleteRequest((String)entryToRemove)).thenOnResult((ResultHandler)deleteHandler).thenOnException((ExceptionHandler)deleteHandler);
            }
        }

        private final class AddRateStatsThread
        extends PerformanceRunner.StatsThread {
            private final String[] extraColumn;

            private AddRateStatsThread() {
                super(AddPerformanceRunner.this, "Add%");
                this.extraColumn = new String[1];
            }

            @Override
            void resetStats() {
                super.resetStats();
                AddPerformanceRunner.this.recentAdds.set(0);
                AddPerformanceRunner.this.recentDeletes.set(0);
            }

            @Override
            String[] getAdditionalColumns() {
                int adds = AddPerformanceRunner.this.recentAdds.getAndSet(0);
                int deleteStat = AddPerformanceRunner.this.recentDeletes.getAndSet(0);
                int total = adds + deleteStat;
                this.extraColumn[0] = String.format(Locale.ENGLISH, "%.2f", total > 0 ? (double)adds / (double)total * 100.0 : 0.0);
                return this.extraColumn;
            }
        }

        private final class DeleteStatsHandler
        extends PerformanceRunner.UpdateStatsResultHandler<Result> {
            private DeleteStatsHandler(long startTime) {
                super(AddPerformanceRunner.this, startTime);
            }

            @Override
            public void handleResult(Result result) {
                super.handleResult(result);
                AddPerformanceRunner.this.recentDeletes.getAndIncrement();
                AddPerformanceRunner.this.entryCount.getAndDecrement();
            }
        }

        private final class AddStatsHandler
        extends PerformanceRunner.UpdateStatsResultHandler<Result> {
            private final String entryDN;

            private AddStatsHandler(long currentTime, String entryDN) {
                super(AddPerformanceRunner.this, currentTime);
                this.entryDN = entryDN;
            }

            @Override
            public void handleResult(Result result) {
                super.handleResult(result);
                switch (AddPerformanceRunner.this.delStrategy) {
                    case RANDOM: {
                        long newKey;
                        do {
                            newKey = ((Random)AddPerformanceRunner.this.randomSeq.get()).nextInt();
                        } while (AddPerformanceRunner.this.dnEntriesAdded.putIfAbsent(newKey, this.entryDN) != null);
                        break;
                    }
                    case FIFO: {
                        long uniqueTime = this.currentTime;
                        while (AddPerformanceRunner.this.dnEntriesAdded.putIfAbsent(uniqueTime, this.entryDN) != null) {
                            ++uniqueTime;
                        }
                        break;
                    }
                }
                AddPerformanceRunner.this.recentAdds.getAndIncrement();
                AddPerformanceRunner.this.totalAdds.getAndIncrement();
                AddPerformanceRunner.this.entryCount.getAndIncrement();
            }
        }
    }

    private static final class AddRateExecutionEndedException
    extends LdapException {
        private AddRateExecutionEndedException() {
            super(Responses.newResult((ResultCode)ResultCode.OTHER));
        }
    }
}

