/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.promise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.promise.RuntimeExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Promises {
    private static final AsyncFunction<Exception, Object, Exception> EXCEPTION_IDEM_ASYNC_FUNC = new AsyncFunction<Exception, Object, Exception>(){

        @Override
        public Promise<Object, Exception> apply(Exception exception) throws Exception {
            return Promises.newExceptionPromise(exception);
        }
    };
    private static final Function<Exception, Object, Exception> EXCEPTION_IDEM_FUNC = new Function<Exception, Object, Exception>(){

        @Override
        public Object apply(Exception exception) throws Exception {
            throw exception;
        }
    };
    private static final AsyncFunction<RuntimeException, Object, Exception> RUNTIME_EXCEPTION_IDEM_ASYNC_FUNC = new AsyncFunction<RuntimeException, Object, Exception>(){

        @Override
        public Promise<Object, Exception> apply(RuntimeException runtimeException) throws Exception {
            return Promises.newRuntimeExceptionPromise(runtimeException);
        }
    };
    private static final Function<RuntimeException, Object, Exception> RUNTIME_EXCEPTION_IDEM_FUNC = new Function<RuntimeException, Object, Exception>(){

        @Override
        public Object apply(RuntimeException runtimeException) {
            throw runtimeException;
        }
    };
    private static final AsyncFunction<Object, Object, Exception> RESULT_IDEM_ASYNC_FUNC = new AsyncFunction<Object, Object, Exception>(){

        @Override
        public Promise<Object, Exception> apply(Object object) throws Exception {
            return Promises.newResultPromise(object);
        }
    };
    private static final Function<Object, Object, Exception> RESULT_IDEM_FUNC = new Function<Object, Object, Exception>(){

        @Override
        public Object apply(Object value) throws Exception {
            return value;
        }
    };

    public static <V, E extends Exception> Promise<V, E> newRuntimeExceptionPromise(RuntimeException exception) {
        return new RuntimeExceptionPromise(exception);
    }

    public static <V, E extends Exception> Promise<V, E> newExceptionPromise(E exception) {
        return new ExceptionPromise(exception, null);
    }

    public static <V, E extends Exception> Promise<V, E> newResultPromise(V result) {
        return new ResultPromise(result);
    }

    public static <V, E extends Exception> Promise<List<V>, E> when(List<Promise<V, E>> promises) {
        int size = promises.size();
        final AtomicInteger remaining = new AtomicInteger(size);
        final ArrayList results = new ArrayList(size);
        final PromiseImpl composite = PromiseImpl.create();
        for (Promise<V, E> promise : promises) {
            promise.thenOnResult(new ResultHandler<V>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleResult(V value) {
                    List list = results;
                    synchronized (list) {
                        results.add(value);
                    }
                    if (remaining.decrementAndGet() == 0) {
                        composite.handleResult(results);
                    }
                }
            }).thenOnException(new ExceptionHandler<E>(){

                @Override
                public void handleException(E exception) {
                    composite.handleException(exception);
                }
            }).thenOnRuntimeException(new RuntimeExceptionHandler(){

                @Override
                public void handleRuntimeException(RuntimeException exception) {
                    composite.handleRuntimeException(exception);
                }
            });
        }
        if (promises.isEmpty()) {
            composite.handleResult(results);
        }
        return composite;
    }

    @SafeVarargs
    public static <V, E extends Exception> Promise<List<V>, E> when(Promise<V, E> ... promises) {
        return Promises.when(Arrays.asList(promises));
    }

    static <VOUT, E extends Exception> AsyncFunction<E, VOUT, E> exceptionIdempotentAsyncFunction() {
        return EXCEPTION_IDEM_ASYNC_FUNC;
    }

    static <VOUT, E extends Exception> Function<E, VOUT, E> exceptionIdempotentFunction() {
        return EXCEPTION_IDEM_FUNC;
    }

    static <VOUT, E extends Exception> AsyncFunction<RuntimeException, VOUT, E> runtimeExceptionIdempotentAsyncFunction() {
        return RUNTIME_EXCEPTION_IDEM_ASYNC_FUNC;
    }

    static <VOUT, E extends Exception> Function<RuntimeException, VOUT, E> runtimeExceptionIdempotentFunction() {
        return RUNTIME_EXCEPTION_IDEM_FUNC;
    }

    static <V, E extends Exception> AsyncFunction<V, V, E> resultIdempotentAsyncFunction() {
        return RESULT_IDEM_ASYNC_FUNC;
    }

    static <V, E extends Exception> Function<V, V, E> resultIdempotentFunction() {
        return RESULT_IDEM_FUNC;
    }

    private Promises() {
    }

    private static abstract class CompletedPromise<V, E extends Exception>
    implements Promise<V, E> {
        private static final Logger LOGGER = LoggerFactory.getLogger(CompletedPromise.class);

        private CompletedPromise() {
        }

        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public final V get() throws ExecutionException {
            if (this.hasResult()) {
                return this.getResult();
            }
            if (this.hasException()) {
                throw new ExecutionException((Throwable)this.getException());
            }
            throw new ExecutionException(this.getRuntimeException());
        }

        @Override
        public final V get(long timeout, TimeUnit unit) throws ExecutionException {
            return this.get();
        }

        @Override
        public final V getOrThrow() throws E {
            if (this.hasResult()) {
                return this.getResult();
            }
            if (this.hasException()) {
                throw this.getException();
            }
            throw this.getRuntimeException();
        }

        @Override
        public final V getOrThrow(long timeout, TimeUnit unit) throws E {
            return this.getOrThrow();
        }

        @Override
        public final V getOrThrowUninterruptibly() throws E {
            return this.getOrThrow();
        }

        @Override
        public final V getOrThrowUninterruptibly(long timeout, TimeUnit unit) throws E {
            return this.getOrThrow();
        }

        @Override
        public final boolean isCancelled() {
            return false;
        }

        @Override
        public final boolean isDone() {
            return true;
        }

        @Override
        public final Promise<V, E> thenOnException(ExceptionHandler<? super E> onException) {
            if (this.hasException()) {
                try {
                    onException.handleException(this.getException());
                }
                catch (RuntimeException e) {
                    LOGGER.error("Ignored unexpected exception thrown by ExceptionHandler", e);
                }
            }
            return this;
        }

        @Override
        public final Promise<V, E> thenOnResult(ResultHandler<? super V> onResult) {
            if (this.hasResult()) {
                try {
                    onResult.handleResult(this.getResult());
                }
                catch (RuntimeException e) {
                    LOGGER.error("Ignored unexpected exception thrown by ResultHandler", e);
                }
            }
            return this;
        }

        @Override
        public final Promise<V, E> thenOnResultOrException(ResultHandler<? super V> onResult, ExceptionHandler<? super E> onException) {
            return this.thenOnResult(onResult).thenOnException(onException);
        }

        @Override
        public final Promise<V, E> thenOnResultOrException(Runnable onResultOrException) {
            if (this.hasResult() || this.hasException()) {
                try {
                    onResultOrException.run();
                }
                catch (RuntimeException e) {
                    LOGGER.error("Ignored unexpected exception thrown by Runnable", e);
                }
            }
            return this;
        }

        @Override
        public final <VOUT> Promise<VOUT, E> then(Function<? super V, VOUT, E> onResult) {
            return this.then(onResult, Promises.exceptionIdempotentFunction());
        }

        @Override
        public <EOUT extends Exception> Promise<V, EOUT> thenCatch(Function<? super E, V, EOUT> onException) {
            return this.then(Promises.resultIdempotentFunction(), onException);
        }

        @Override
        public Promise<V, E> thenCatchRuntimeException(Function<? super RuntimeException, V, E> onRuntimeException) {
            return this.then(Promises.resultIdempotentFunction(), Promises.exceptionIdempotentFunction(), onRuntimeException);
        }

        @Override
        public final <VOUT, EOUT extends Exception> Promise<VOUT, EOUT> then(Function<? super V, VOUT, EOUT> onResult, Function<? super E, VOUT, EOUT> onException) {
            return this.then(onResult, onException, Promises.runtimeExceptionIdempotentFunction());
        }

        @Override
        public final <VOUT, EOUT extends Exception> Promise<VOUT, EOUT> then(Function<? super V, VOUT, EOUT> onResult, Function<? super E, VOUT, EOUT> onException, Function<? super RuntimeException, VOUT, EOUT> onRuntimeException) {
            try {
                if (this.hasResult()) {
                    return Promises.newResultPromise(onResult.apply(this.getResult()));
                }
                if (this.hasException()) {
                    return Promises.newResultPromise(onException.apply(this.getException()));
                }
                if (this.hasRuntimeException()) {
                    return Promises.newResultPromise(onRuntimeException.apply(this.getRuntimeException()));
                }
                throw new IllegalStateException("Unexpected state");
            }
            catch (RuntimeException e) {
                return new RuntimeExceptionPromise(e);
            }
            catch (Exception e) {
                return Promises.newExceptionPromise(e);
            }
        }

        @Override
        public final Promise<V, E> thenAlways(Runnable always) {
            try {
                always.run();
            }
            catch (RuntimeException e) {
                LOGGER.error("Ignored unexpected exception thrown by Runnable", e);
            }
            return this;
        }

        @Override
        public Promise<V, E> thenFinally(Runnable onFinally) {
            return this.thenAlways(onFinally);
        }

        @Override
        public final <VOUT> Promise<VOUT, E> thenAsync(AsyncFunction<? super V, VOUT, E> onResult) {
            return this.thenAsync(onResult, Promises.exceptionIdempotentAsyncFunction());
        }

        @Override
        public final <EOUT extends Exception> Promise<V, EOUT> thenCatchAsync(AsyncFunction<? super E, V, EOUT> onException) {
            return this.thenAsync(Promises.resultIdempotentAsyncFunction(), onException);
        }

        @Override
        public Promise<V, E> thenCatchRuntimeExceptionAsync(AsyncFunction<? super RuntimeException, V, E> onRuntimeException) {
            return this.thenAsync(Promises.resultIdempotentAsyncFunction(), Promises.exceptionIdempotentAsyncFunction(), onRuntimeException);
        }

        @Override
        public final <VOUT, EOUT extends Exception> Promise<VOUT, EOUT> thenAsync(AsyncFunction<? super V, VOUT, EOUT> onResult, AsyncFunction<? super E, VOUT, EOUT> onException) {
            return this.thenAsync(onResult, onException, Promises.runtimeExceptionIdempotentAsyncFunction());
        }

        @Override
        public final <VOUT, EOUT extends Exception> Promise<VOUT, EOUT> thenAsync(AsyncFunction<? super V, VOUT, EOUT> onResult, AsyncFunction<? super E, VOUT, EOUT> onException, AsyncFunction<? super RuntimeException, VOUT, EOUT> onRuntimeException) {
            try {
                if (this.hasResult()) {
                    return onResult.apply(this.getResult());
                }
                if (this.hasException()) {
                    return onException.apply(this.getException());
                }
                if (this.hasRuntimeException()) {
                    return onRuntimeException.apply(this.getRuntimeException());
                }
                throw new IllegalStateException("Unexpected state");
            }
            catch (RuntimeException e) {
                return new RuntimeExceptionPromise(e);
            }
            catch (Exception e) {
                return Promises.newExceptionPromise(e);
            }
        }

        @Override
        public Promise<V, E> thenOnRuntimeException(RuntimeExceptionHandler onRuntimeException) {
            if (this.getRuntimeException() != null) {
                try {
                    onRuntimeException.handleRuntimeException(this.getRuntimeException());
                }
                catch (RuntimeException e) {
                    LOGGER.error("Ignored unexpected exception thrown by RuntimeExceptionHandler", e);
                }
            }
            return this;
        }

        abstract RuntimeException getRuntimeException();

        abstract E getException();

        abstract V getResult();

        abstract boolean hasRuntimeException();

        abstract boolean hasException();

        abstract boolean hasResult();
    }

    private static final class ExceptionPromise<V, E extends Exception>
    extends CompletedPromise<V, E> {
        private final E exception;

        private ExceptionPromise(E exception) {
            this.exception = exception;
        }

        @Override
        RuntimeException getRuntimeException() {
            return null;
        }

        @Override
        E getException() {
            return this.exception;
        }

        @Override
        V getResult() {
            throw new IllegalStateException();
        }

        @Override
        boolean hasRuntimeException() {
            return false;
        }

        @Override
        boolean hasException() {
            return true;
        }

        @Override
        boolean hasResult() {
            return false;
        }

        /* synthetic */ ExceptionPromise(Exception exception, ExceptionPromise exceptionPromise) {
            this(exception);
        }
    }

    private static final class ResultPromise<V, E extends Exception>
    extends CompletedPromise<V, E> {
        private final V value;

        private ResultPromise(V value) {
            this.value = value;
        }

        @Override
        RuntimeException getRuntimeException() {
            return null;
        }

        @Override
        E getException() {
            throw new IllegalStateException();
        }

        @Override
        V getResult() {
            return this.value;
        }

        @Override
        boolean hasRuntimeException() {
            return false;
        }

        @Override
        boolean hasException() {
            return false;
        }

        @Override
        boolean hasResult() {
            return true;
        }
    }

    private static final class RuntimeExceptionPromise<V, E extends Exception>
    extends CompletedPromise<V, E> {
        private final RuntimeException runtimeException;

        private RuntimeExceptionPromise(RuntimeException runtimeException) {
            this.runtimeException = runtimeException;
        }

        @Override
        RuntimeException getRuntimeException() {
            return this.runtimeException;
        }

        @Override
        E getException() {
            return null;
        }

        @Override
        V getResult() {
            return null;
        }

        @Override
        boolean hasRuntimeException() {
            return true;
        }

        @Override
        boolean hasException() {
            return false;
        }

        @Override
        boolean hasResult() {
            return false;
        }
    }
}

