/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.MemoryBackend;
import org.forgerock.opendj.ldap.RequestContext;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldif.LDIF;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;
import org.forgerock.opendj.security.KeyStoreImpl;
import org.forgerock.opendj.security.KeyStoreObject;
import org.forgerock.opendj.security.KeyStoreObjectCache;
import org.forgerock.opendj.security.KeyStoreParameters;
import org.forgerock.opendj.security.OpenDJProviderSchema;
import org.forgerock.util.Factory;
import org.forgerock.util.Options;

public final class OpenDJProvider
extends Provider {
    private static final long serialVersionUID = -1L;
    private static final String PREFIX = "org.forgerock.opendj.security.";
    private static final String LDIF_PROPERTY = "org.forgerock.opendj.security.ldif";
    private static final String HOST_PROPERTY = "org.forgerock.opendj.security.host";
    private static final String PORT_PROPERTY = "org.forgerock.opendj.security.port";
    private static final String BIND_DN_PROPERTY = "org.forgerock.opendj.security.bindDN";
    private static final String BIND_PASSWORD_PROPERTY = "org.forgerock.opendj.security.bindPassword";
    private static final String KEYSTORE_BASE_DN_PROPERTY = "org.forgerock.opendj.security.keyStoreBaseDN";
    private static final String KEYSTORE_PASSWORD_PROPERTY = "org.forgerock.opendj.security.keyStorePassword";
    private final KeyStoreParameters defaultConfig;

    public OpenDJProvider() {
        this((KeyStoreParameters)null);
    }

    public OpenDJProvider(String configFile) {
        this(new File(configFile).toURI());
    }

    public OpenDJProvider(URI configFile) {
        this(configFile != null ? OpenDJProvider.parseConfig(configFile) : null);
    }

    OpenDJProvider(KeyStoreParameters defaultConfig) {
        super("OpenDJ", 1.0, "OpenDJ LDAP security provider");
        this.defaultConfig = defaultConfig;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                OpenDJProvider.this.putService(new KeyStoreService());
                return null;
            }
        });
    }

    public static KeyStore newLDAPKeyStore(ConnectionFactory factory, DN baseDN) {
        return OpenDJProvider.newLDAPKeyStore(factory, baseDN, Options.defaultOptions());
    }

    public static KeyStore newLDAPKeyStore(ConnectionFactory factory, DN baseDN, Options options) {
        try {
            KeyStore keyStore = KeyStore.getInstance("LDAP", new OpenDJProvider());
            keyStore.load(KeyStoreParameters.newKeyStoreParameters(factory, baseDN, options));
            return keyStore;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyStore newLDIFKeyStore(File ldifFile, DN baseDN) throws IOException {
        return OpenDJProvider.newLDIFKeyStore(ldifFile, baseDN, Options.defaultOptions());
    }

    public static KeyStore newLDIFKeyStore(File ldifFile, DN baseDN, Options options) throws IOException {
        return OpenDJProvider.newLDAPKeyStore(OpenDJProvider.newLDIFConnectionFactory(ldifFile), baseDN, options);
    }

    private static ConnectionFactory newLDIFConnectionFactory(File ldifFile) throws IOException {
        try (LDIFEntryReader reader = new LDIFEntryReader(new FileReader(ldifFile)).setSchema(OpenDJProviderSchema.SCHEMA);){
            MemoryBackend backend = new MemoryBackend(OpenDJProviderSchema.SCHEMA, reader).enableVirtualAttributes(true);
            ConnectionFactory connectionFactory = Connections.newInternalConnectionFactory(new WriteLDIFOnUpdateRequestHandler(backend, ldifFile));
            return connectionFactory;
        }
    }

    public static KeyStoreObjectCache newKeyStoreObjectCacheFromMap(final Map<String, KeyStoreObject> map) {
        return new KeyStoreObjectCache(){

            @Override
            public void put(KeyStoreObject keyStoreObject) {
                map.put(keyStoreObject.getAlias(), keyStoreObject);
            }

            @Override
            public KeyStoreObject get(String alias) {
                return (KeyStoreObject)map.get(alias);
            }
        };
    }

    public static KeyStoreObjectCache newCapacityBasedKeyStoreObjectCache(final int capacity) {
        return OpenDJProvider.newKeyStoreObjectCacheFromMap(Collections.synchronizedMap(new LinkedHashMap<String, KeyStoreObject>(){
            private static final long serialVersionUID = -1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, KeyStoreObject> eldest) {
                return this.size() > capacity;
            }
        }));
    }

    public static Factory<char[]> newClearTextPasswordFactory(final char[] password) {
        return new Factory<char[]>(){
            private final char[] clonedPassword;
            {
                this.clonedPassword = password != null ? (char[])password.clone() : null;
            }

            @Override
            public char[] newInstance() {
                return this.clonedPassword != null ? (char[])this.clonedPassword.clone() : null;
            }
        };
    }

    KeyStoreParameters getDefaultConfig() {
        return this.defaultConfig;
    }

    private static KeyStoreParameters parseConfig(URI configFile) {
        KeyStoreParameters keyStoreParameters;
        InputStreamReader configFileReader = new InputStreamReader(configFile.toURL().openStream());
        try {
            ConnectionFactory factory;
            String ldif;
            Properties properties = new Properties();
            properties.load(configFileReader);
            String keyStoreBaseDNProperty = properties.getProperty(KEYSTORE_BASE_DN_PROPERTY);
            if (keyStoreBaseDNProperty == null) {
                throw new IllegalArgumentException("missing key store base DN");
            }
            DN keyStoreBaseDN = DN.valueOf(keyStoreBaseDNProperty);
            Options keystoreOptions = Options.defaultOptions();
            String keystorePassword = properties.getProperty(KEYSTORE_PASSWORD_PROPERTY);
            if (keystorePassword != null) {
                keystoreOptions.set(KeyStoreParameters.GLOBAL_PASSWORD, OpenDJProvider.newClearTextPasswordFactory(keystorePassword.toCharArray()));
            }
            if ((ldif = properties.getProperty(LDIF_PROPERTY)) != null) {
                factory = OpenDJProvider.newLDIFConnectionFactory(new File(ldif));
            } else {
                String host = properties.getProperty(HOST_PROPERTY, "localhost");
                int port = Integer.parseInt(properties.getProperty(PORT_PROPERTY, "389"));
                DN bindDN = DN.valueOf(properties.getProperty(BIND_DN_PROPERTY, ""));
                String bindPassword = properties.getProperty(BIND_PASSWORD_PROPERTY);
                Options factoryOptions = Options.defaultOptions();
                if (!bindDN.isRootDN()) {
                    factoryOptions.set(LDAPConnectionFactory.AUTHN_BIND_REQUEST, Requests.newSimpleBindRequest(bindDN.toString(), bindPassword.toCharArray()));
                }
                factory = Connections.newCachedConnectionPool(new LDAPConnectionFactory(host, port, factoryOptions));
            }
            keyStoreParameters = KeyStoreParameters.newKeyStoreParameters(factory, keyStoreBaseDN, keystoreOptions);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)configFileReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ProviderException("Error parsing configuration in file '" + configFile + "'", e);
            }
        }
        ((Reader)configFileReader).close();
        return keyStoreParameters;
    }

    private final class KeyStoreService
    extends Provider.Service {
        private KeyStoreService() {
            super(OpenDJProvider.this, "KeyStore", "LDAP", KeyStoreImpl.class.getName(), Collections.singletonList("OpenDJ"), null);
        }

        @Override
        public Object newInstance(Object constructorParameter) {
            return new KeyStoreImpl(OpenDJProvider.this);
        }
    }

    private static final class WriteLDIFOnUpdateRequestHandler
    implements RequestHandler<RequestContext> {
        private final MemoryBackend backend;
        private final File ldifFile;

        private WriteLDIFOnUpdateRequestHandler(MemoryBackend backend, File ldifFile) {
            this.backend = backend;
            this.ldifFile = ldifFile;
        }

        @Override
        public void handleAdd(RequestContext requestContext, AddRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            this.backend.handleAdd(requestContext, request, intermediateResponseHandler, this.saveAndForwardTo(resultHandler));
        }

        @Override
        public void handleBind(RequestContext requestContext, int version, BindRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<BindResult> resultHandler) {
            this.backend.handleBind(requestContext, version, request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleCompare(RequestContext requestContext, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<CompareResult> resultHandler) {
            this.backend.handleCompare(requestContext, request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleDelete(RequestContext requestContext, DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            this.backend.handleDelete(requestContext, request, intermediateResponseHandler, this.saveAndForwardTo(resultHandler));
        }

        @Override
        public <R extends ExtendedResult> void handleExtendedRequest(RequestContext requestContext, ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<R> resultHandler) {
            this.backend.handleExtendedRequest(requestContext, request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleModify(RequestContext requestContext, ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            this.backend.handleModify(requestContext, request, intermediateResponseHandler, this.saveAndForwardTo(resultHandler));
        }

        @Override
        public void handleModifyDN(RequestContext requestContext, ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            this.backend.handleModifyDN(requestContext, request, intermediateResponseHandler, this.saveAndForwardTo(resultHandler));
        }

        @Override
        public void handleSearch(RequestContext requestContext, SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler, LdapResultHandler<Result> resultHandler) {
            this.backend.handleSearch(requestContext, request, intermediateResponseHandler, entryHandler, resultHandler);
        }

        private LdapResultHandler<Result> saveAndForwardTo(final LdapResultHandler<Result> resultHandler) {
            return new LdapResultHandler<Result>(){

                @Override
                public void handleException(LdapException exception) {
                    resultHandler.handleException(exception);
                }

                @Override
                public void handleResult(Result result) {
                    try {
                        WriteLDIFOnUpdateRequestHandler.writeLDIF(WriteLDIFOnUpdateRequestHandler.this.backend, WriteLDIFOnUpdateRequestHandler.this.ldifFile);
                        resultHandler.handleResult(result);
                    }
                    catch (IOException e) {
                        LdapException ldapException = LdapException.newLdapException(ResultCode.OTHER, "Unable to write LDIF file " + WriteLDIFOnUpdateRequestHandler.this.ldifFile, e);
                        resultHandler.handleException(ldapException);
                    }
                }
            };
        }

        private static void writeLDIF(MemoryBackend backend, File ldifFile) throws IOException {
            try (FileWriter fileWriter = new FileWriter(ldifFile);
                 BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                 LDIFEntryWriter entryWriter = new LDIFEntryWriter(bufferedWriter);){
                LDIF.copyTo(LDIF.newEntryIteratorReader(backend.getAll().iterator()), entryWriter);
            }
        }
    }
}

