/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import com.forgerock.opendj.security.KeystoreMessages;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Functions;
import org.forgerock.opendj.ldap.GeneralizedTime;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.security.KeyProtector;
import org.forgerock.opendj.security.LocalizedKeyStoreException;

public final class KeyStoreObject {
    private final String alias;
    private final Date creationDate;
    private final Impl impl;

    static KeyStoreObject newTrustedCertificateObject(String alias, Certificate certificate) {
        return new KeyStoreObject(alias, new Date(), new TrustedCertificateImpl(certificate));
    }

    static KeyStoreObject newKeyObject(String alias, Key key, Certificate[] chain, KeyProtector protector, char[] keyPassword) throws LocalizedKeyStoreException {
        ByteString protectedKey = protector.encodeKey(key, keyPassword);
        Impl impl = key instanceof PrivateKey ? new PrivateKeyImpl(key.getAlgorithm(), protectedKey, chain) : new SecretKeyImpl(key.getAlgorithm(), protectedKey);
        return new KeyStoreObject(alias, new Date(), impl);
    }

    static KeyStoreObject valueOf(Entry ldapEntry) throws LocalizedKeyStoreException {
        try {
            Impl impl;
            Date creationDate;
            String alias = ldapEntry.parseAttribute("ds-keystore-alias").requireValue().asString();
            GeneralizedTime timeStamp = ldapEntry.parseAttribute("modifyTimeStamp").asGeneralizedTime();
            if (timeStamp == null) {
                timeStamp = ldapEntry.parseAttribute("createTimeStamp").asGeneralizedTime();
            }
            Date date = creationDate = timeStamp != null ? timeStamp.toDate() : new Date();
            if (ldapEntry.containsAttribute("objectClass", "ds-keystore-trusted-certificate")) {
                impl = KeyStoreObject.valueOfTrustedCertificate(ldapEntry);
            } else if (ldapEntry.containsAttribute("objectClass", "ds-keystore-private-key")) {
                impl = KeyStoreObject.valueOfPrivateKey(ldapEntry);
            } else if (ldapEntry.containsAttribute("objectClass", "ds-keystore-secret-key")) {
                impl = KeyStoreObject.valueOfSecretKey(ldapEntry);
            } else {
                throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_UNRECOGNIZED_OBJECT_CLASS.get(ldapEntry.getName()));
            }
            return new KeyStoreObject(alias, creationDate, impl);
        }
        catch (IOException | LocalizedIllegalArgumentException e) {
            throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_ENTRY_MALFORMED.get(ldapEntry.getName()), (Throwable)e);
        }
    }

    private static Impl valueOfSecretKey(Entry ldapEntry) {
        String algorithm = ldapEntry.parseAttribute("ds-keystore-key-algorithm").requireValue().asString();
        ByteString protectedKey = ldapEntry.parseAttribute("ds-keystore-key").requireValue().asByteString();
        return new SecretKeyImpl(algorithm, protectedKey);
    }

    private static Impl valueOfPrivateKey(Entry ldapEntry) throws IOException {
        String algorithm = ldapEntry.parseAttribute("ds-keystore-key-algorithm").requireValue().asString();
        ByteString protectedKey = ldapEntry.parseAttribute("ds-keystore-key").requireValue().asByteString();
        ArrayList<X509Certificate> certificateChainList = new ArrayList<X509Certificate>();
        X509Certificate publicKeyCertificate = ldapEntry.parseAttribute("ds-keystore-certificate;binary").requireValue().asCertificate();
        certificateChainList.add(publicKeyCertificate);
        ByteString encodedCertificateChain = ldapEntry.parseAttribute("ds-keystore-certificate-chain").asByteString();
        if (encodedCertificateChain != null) {
            ASN1Reader reader = ASN1.getReader(encodedCertificateChain);
            reader.readStartSequence();
            while (reader.hasNextElement()) {
                ByteString certificate = reader.readOctetString();
                certificateChainList.add(Functions.byteStringToCertificate().apply(certificate));
            }
            reader.readEndSequence();
        }
        Certificate[] certificateChain = certificateChainList.toArray(new Certificate[0]);
        return new PrivateKeyImpl(algorithm, protectedKey, certificateChain);
    }

    private static Impl valueOfTrustedCertificate(Entry ldapEntry) {
        X509Certificate trustedCertificate = ldapEntry.parseAttribute("ds-keystore-certificate;binary").requireValue().asCertificate();
        return new TrustedCertificateImpl(trustedCertificate);
    }

    private static ByteString encodeCertificate(Certificate certificate) {
        try {
            return ByteString.wrap(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStoreObject(String alias, Date creationDate, Impl impl) {
        this.alias = alias;
        this.creationDate = creationDate;
        this.impl = impl;
    }

    Date getCreationDate() {
        return this.creationDate;
    }

    public String getAlias() {
        return this.alias;
    }

    Certificate[] getCertificateChain() {
        return this.impl.getCertificateChain();
    }

    boolean isTrustedCertificate() {
        return this.impl instanceof TrustedCertificateImpl;
    }

    Entry toLDAPEntry(DN baseDN) {
        LinkedHashMapEntry entry = new LinkedHashMapEntry(KeyStoreObject.dnOf(baseDN, this.alias));
        entry.addAttribute("ds-keystore-alias", this.alias);
        this.impl.addAttributes(entry);
        return entry;
    }

    Certificate getCertificate() {
        return this.impl.getCertificate();
    }

    Key getKey(KeyProtector protector, char[] keyPassword) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            return this.impl.toKey(protector, keyPassword);
        }
        catch (NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new UnrecoverableKeyException(e.getMessage());
        }
    }

    static DN dnOf(DN baseDN, String alias) {
        return baseDN.child("ds-keystore-alias", alias);
    }

    private static final class SecretKeyImpl
    implements Impl {
        private final String algorithm;
        private final ByteString protectedKey;

        private SecretKeyImpl(String algorithm, ByteString protectedKey) {
            this.algorithm = algorithm;
            this.protectedKey = protectedKey;
        }

        @Override
        public void addAttributes(Entry entry) {
            entry.addAttribute("objectClass", "top", "ds-keystore-object", "ds-keystore-secret-key");
            entry.addAttribute("ds-keystore-key-algorithm", this.algorithm);
            entry.addAttribute("ds-keystore-key", this.protectedKey);
        }

        @Override
        public Certificate[] getCertificateChain() {
            return null;
        }

        @Override
        public Certificate getCertificate() {
            return null;
        }

        @Override
        public Key toKey(KeyProtector protector, char[] keyPassword) throws GeneralSecurityException {
            return protector.decodeSecretKey(this.protectedKey, this.algorithm, keyPassword);
        }
    }

    private static final class PrivateKeyImpl
    implements Impl {
        private final String algorithm;
        private final ByteString protectedKey;
        private final Certificate[] certificateChain;

        private PrivateKeyImpl(String algorithm, ByteString protectedKey, Certificate[] chain) {
            this.algorithm = algorithm;
            this.protectedKey = protectedKey;
            this.certificateChain = (Certificate[])chain.clone();
        }

        @Override
        public void addAttributes(Entry entry) {
            entry.addAttribute("objectClass", "top", "ds-keystore-object", "ds-keystore-private-key");
            entry.addAttribute("ds-keystore-key-algorithm", this.algorithm);
            entry.addAttribute("ds-keystore-key", this.protectedKey);
            entry.addAttribute("ds-keystore-certificate;binary", KeyStoreObject.encodeCertificate(this.certificateChain[0]));
            if (this.certificateChain.length > 1) {
                entry.addAttribute("ds-keystore-certificate-chain", this.encodeCertificateChain());
            }
        }

        private ByteString encodeCertificateChain() {
            ByteStringBuilder builder = new ByteStringBuilder();
            ASN1Writer writer = ASN1.getWriter(builder);
            try {
                writer.writeStartSequence();
                for (int i = 1; i < this.certificateChain.length; ++i) {
                    writer.writeOctetString(KeyStoreObject.encodeCertificate(this.certificateChain[i]));
                }
                writer.writeEndSequence();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return builder.toByteString();
        }

        @Override
        public Certificate[] getCertificateChain() {
            return (Certificate[])this.certificateChain.clone();
        }

        @Override
        public Certificate getCertificate() {
            return this.certificateChain.length > 0 ? this.certificateChain[0] : null;
        }

        @Override
        public Key toKey(KeyProtector protector, char[] keyPassword) throws GeneralSecurityException {
            return protector.decodePrivateKey(this.protectedKey, this.algorithm, keyPassword);
        }
    }

    private static final class TrustedCertificateImpl
    implements Impl {
        private final Certificate trustedCertificate;

        private TrustedCertificateImpl(Certificate trustedCertificate) {
            this.trustedCertificate = trustedCertificate;
        }

        @Override
        public void addAttributes(Entry entry) {
            entry.addAttribute("objectClass", "top", "ds-keystore-object", "ds-keystore-trusted-certificate");
            entry.addAttribute("ds-keystore-certificate;binary", KeyStoreObject.encodeCertificate(this.trustedCertificate));
        }

        @Override
        public Certificate[] getCertificateChain() {
            return null;
        }

        @Override
        public Certificate getCertificate() {
            return this.trustedCertificate;
        }

        @Override
        public Key toKey(KeyProtector protector, char[] keyPassword) {
            return null;
        }
    }

    private static interface Impl {
        public void addAttributes(Entry var1);

        public Certificate[] getCertificateChain();

        public Certificate getCertificate();

        public Key toKey(KeyProtector var1, char[] var2) throws GeneralSecurityException;
    }
}

