/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import com.forgerock.opendj.security.KeystoreMessages;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.security.ExternalKeyWrappingStrategy;
import org.forgerock.opendj.security.KeyStoreParameters;
import org.forgerock.opendj.security.LocalizedKeyStoreException;
import org.forgerock.util.Options;

final class KeyProtector {
    private static final int ENCODING_VERSION_V1 = 1;
    private static final byte PLAIN_KEY = -96;
    private static final byte KEYSTORE_WRAPPED_KEY = -95;
    private static final byte EXTERNALLY_WRAPPED_KEY = -94;
    private static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final int PBKDF2_KEY_SIZE = 128;
    private static final String CIPHER_ALGORITHM = "AESWrap";
    private static final String DUMMY_KEY_ALGORITHM = "PADDED";
    private final SecureRandom prng = new SecureRandom();
    private final Options options;

    KeyProtector(Options options) {
        this.options = options;
    }

    ByteString encodeKey(Key key, char[] keyPassword) throws LocalizedKeyStoreException {
        char[] keyStorePassword = this.options.get(KeyStoreParameters.GLOBAL_PASSWORD).newInstance();
        char[] concatenatedPasswords = KeyProtector.concatenate(keyStorePassword, keyPassword);
        ByteStringBuilder builder = new ByteStringBuilder();
        try (ASN1Writer asn1Writer = ASN1.getWriter(builder);){
            asn1Writer.writeStartSequence();
            asn1Writer.writeInteger(1);
            ExternalKeyWrappingStrategy strategy = this.options.get(KeyStoreParameters.EXTERNAL_KEY_WRAPPING_STRATEGY);
            if (strategy == null) {
                this.encodePlainOrWrappedKey(key, concatenatedPasswords, asn1Writer);
            } else {
                ByteStringBuilder externalBuilder = new ByteStringBuilder();
                try (ASN1Writer externalAsn1Writer = ASN1.getWriter(externalBuilder);){
                    this.encodePlainOrWrappedKey(key, concatenatedPasswords, externalAsn1Writer);
                }
                ByteSequence externallyWrappedKey = strategy.wrapKey(externalBuilder.toByteString());
                asn1Writer.writeOctetString((byte)-94, externallyWrappedKey);
            }
            asn1Writer.writeEndSequence();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            KeyProtector.destroyCharArray(concatenatedPasswords);
            KeyProtector.destroyCharArray(keyStorePassword);
        }
        return builder.toByteString();
    }

    private void encodePlainOrWrappedKey(Key key, char[] concatenatedPasswords, ASN1Writer asn1Writer) throws IOException, LocalizedKeyStoreException {
        if (concatenatedPasswords == null) {
            asn1Writer.writeOctetString((byte)-96, key.getEncoded());
        } else {
            asn1Writer.writeStartSequence((byte)-95);
            byte[] salt = new byte[this.options.get(KeyStoreParameters.PBKDF2_SALT_SIZE).intValue()];
            this.prng.nextBytes(salt);
            asn1Writer.writeOctetString(salt);
            Integer iterations = this.options.get(KeyStoreParameters.PBKDF2_ITERATIONS);
            SecretKey aesKey = KeyProtector.createAESSecretKey(concatenatedPasswords, salt, iterations);
            Cipher cipher = KeyProtector.getCipher(3, aesKey);
            try {
                byte[] wrappedKey = cipher.wrap(KeyProtector.pad(key));
                asn1Writer.writeOctetString(wrappedKey);
            }
            catch (InvalidKeyException | IllegalBlockSizeException e) {
                throw new IllegalStateException(e);
            }
            asn1Writer.writeEndSequence();
        }
    }

    Key decodeSecretKey(ByteSequence encodedKey, String algorithm, char[] keyPassword) throws LocalizedKeyStoreException {
        return this.decodeKey(encodedKey, algorithm, keyPassword, false);
    }

    Key decodePrivateKey(ByteSequence encodedKey, String algorithm, char[] keyPassword) throws LocalizedKeyStoreException {
        return this.decodeKey(encodedKey, algorithm, keyPassword, true);
    }

    private Key decodeKey(ByteSequence encodedKey, String algorithm, char[] keyPassword, boolean isPrivateKey) throws LocalizedKeyStoreException {
        Key key;
        block11: {
            ASN1Reader asn1Reader = ASN1.getReader(encodedKey);
            try {
                Key key2;
                asn1Reader.readStartSequence();
                int version = (int)asn1Reader.readInteger();
                switch (version) {
                    case 1: {
                        key2 = this.decodeKeyV1(asn1Reader, algorithm, keyPassword, isPrivateKey);
                        break;
                    }
                    default: {
                        throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_DECODE_UNSUPPORTED_VERSION.get(version));
                    }
                }
                asn1Reader.readEndSequence();
                key = key2;
                if (asn1Reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (asn1Reader != null) {
                        try {
                            asn1Reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_DECODE_MALFORMED.get(), (Throwable)e);
                }
            }
            asn1Reader.close();
        }
        return key;
    }

    private Key decodeKeyV1(ASN1Reader asn1Reader, String algorithm, char[] keyPassword, boolean isPrivateKey) throws IOException, LocalizedKeyStoreException {
        switch (asn1Reader.peekType()) {
            case -96: {
                byte[] plainKey = asn1Reader.readOctetString((byte)-96).toByteArray();
                return KeyProtector.newKeyFromBytes(plainKey, algorithm, isPrivateKey);
            }
            case -95: {
                char[] keyStorePassword = this.options.get(KeyStoreParameters.GLOBAL_PASSWORD).newInstance();
                char[] concatenatedPasswords = KeyProtector.concatenate(keyStorePassword, keyPassword);
                if (concatenatedPasswords == null) {
                    throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_DECODE_KEY_MISSING_PWD.get());
                }
                asn1Reader.readStartSequence((byte)-95);
                try {
                    byte[] salt = asn1Reader.readOctetString().toByteArray();
                    byte[] wrappedKey = asn1Reader.readOctetString().toByteArray();
                    Integer iterations = this.options.get(KeyStoreParameters.PBKDF2_ITERATIONS);
                    SecretKey aesKey = KeyProtector.createAESSecretKey(concatenatedPasswords, salt, iterations);
                    Cipher cipher = KeyProtector.getCipher(4, aesKey);
                    Key paddedKey = cipher.unwrap(wrappedKey, DUMMY_KEY_ALGORITHM, 3);
                    Key key = KeyProtector.unpad(paddedKey, algorithm, isPrivateKey);
                    return key;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvalidKeyException e) {
                    throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_DECODE_KEYSTORE_DECRYPT_FAILURE.get(), (Throwable)e);
                }
                finally {
                    KeyProtector.destroyCharArray(concatenatedPasswords);
                    KeyProtector.destroyCharArray(keyStorePassword);
                    asn1Reader.readEndSequence();
                }
            }
            case -94: {
                ExternalKeyWrappingStrategy strategy = this.options.get(KeyStoreParameters.EXTERNAL_KEY_WRAPPING_STRATEGY);
                if (strategy == null) {
                    throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_DECODE_KEY_MISSING_KEYSTORE_EXT.get());
                }
                ByteString externallyWrappedKey = asn1Reader.readOctetString((byte)-94);
                try (ASN1Reader externalAsn1Reader = ASN1.getReader(strategy.unwrapKey(externallyWrappedKey));){
                    Key key = this.decodeKeyV1(externalAsn1Reader, algorithm, keyPassword, isPrivateKey);
                    return key;
                }
            }
        }
        throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_DECODE_MALFORMED.get());
    }

    private static char[] concatenate(char[] keyStorePassword, char[] keyPassword) {
        if (keyStorePassword == null && keyPassword == null) {
            return null;
        }
        if (keyStorePassword == null) {
            return (char[])keyPassword.clone();
        }
        if (keyPassword == null) {
            return (char[])keyStorePassword.clone();
        }
        char[] concat = new char[keyStorePassword.length + keyPassword.length];
        System.arraycopy(keyStorePassword, 0, concat, 0, keyStorePassword.length);
        System.arraycopy(keyPassword, 0, concat, keyStorePassword.length, keyPassword.length);
        return concat;
    }

    private static Cipher getCipher(int cipherMode, SecretKey aesKey) throws LocalizedKeyStoreException {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(cipherMode, aesKey);
            return cipher;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_UNSUPPORTED_CIPHER.get(CIPHER_ALGORITHM), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("key is incompatible with the cipher", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecretKey createAESSecretKey(char[] password, byte[] salt, Integer iterations) throws LocalizedKeyStoreException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password, salt, iterations, 128);
        try {
            SecretKey pbeKey = factory.generateSecret(pbeKeySpec);
            SecretKeySpec secretKeySpec = new SecretKeySpec(pbeKey.getEncoded(), "AES");
            pbeKeySpec.clearPassword();
            return secretKeySpec;
        }
        catch (Throwable throwable) {
            try {
                pbeKeySpec.clearPassword();
                throw throwable;
            }
            catch (NoSuchAlgorithmException e) {
                throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_UNSUPPORTED_KF.get(PBKDF2_ALGORITHM), (Throwable)e);
            }
            catch (InvalidKeySpecException e) {
                throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_UNSUPPORTED_KF_ARGS.get(PBKDF2_ALGORITHM, iterations, 128), (Throwable)e);
            }
        }
    }

    private static Key pad(Key key) {
        byte[] keyBytes = key.getEncoded();
        int keySize = keyBytes.length;
        int paddingSize = 8 - keySize % 8;
        byte[] paddedKeyBytes = Arrays.copyOf(keyBytes, keySize + paddingSize);
        for (int i = 0; i < paddingSize; ++i) {
            paddedKeyBytes[keySize + i] = (byte)(i + 1);
        }
        return new SecretKeySpec(paddedKeyBytes, DUMMY_KEY_ALGORITHM);
    }

    private static Key unpad(Key paddedKey, String algorithm, boolean isPrivateKey) throws LocalizedKeyStoreException {
        byte[] paddedKeyBytes = paddedKey.getEncoded();
        int paddedKeySize = paddedKeyBytes.length;
        if (paddedKeySize < 8) {
            throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_DECODE_BAD_PADDING.get());
        }
        int paddingSize = paddedKeyBytes[paddedKeySize - 1];
        if (paddingSize < 1 || paddingSize > 8) {
            throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_DECODE_BAD_PADDING.get());
        }
        int keySize = paddedKeySize - paddingSize;
        for (int i = 0; i < paddingSize; ++i) {
            if (paddedKeyBytes[keySize + i] == i + 1) continue;
            throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_DECODE_BAD_PADDING.get());
        }
        byte[] keyBytes = Arrays.copyOf(paddedKeyBytes, keySize);
        return KeyProtector.newKeyFromBytes(keyBytes, algorithm, isPrivateKey);
    }

    private static Key newKeyFromBytes(byte[] plainKey, String algorithm, boolean isPrivateKey) throws LocalizedKeyStoreException {
        if (isPrivateKey) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(plainKey));
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new LocalizedKeyStoreException(KeystoreMessages.KEYSTORE_UNSUPPORTED_KF.get(algorithm), (Throwable)e);
            }
        }
        return new SecretKeySpec(plainKey, algorithm);
    }

    private static void destroyCharArray(char[] chars) {
        if (chars != null) {
            Arrays.fill(chars, ' ');
        }
    }
}

