/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;

public interface RejectedChangeRecordListener {
    public static final RejectedChangeRecordListener FAIL_FAST = new RejectedChangeRecordListener(){

        @Override
        public Entry handleDuplicateEntry(AddRequest change, Entry existingEntry) throws DecodeException {
            throw DecodeException.error(CoreMessages.REJECTED_CHANGE_FAIL_ADD_DUPE.get(change.getName()));
        }

        @Override
        public Entry handleDuplicateEntry(ModifyDNRequest change, Entry existingEntry, Entry renamedEntry) throws DecodeException {
            throw DecodeException.error(CoreMessages.REJECTED_CHANGE_FAIL_MODIFYDN_DUPE.get(renamedEntry.getName()));
        }

        @Override
        public void handleRejectedChangeRecord(AddRequest change, LocalizableMessage reason) throws DecodeException {
            throw DecodeException.error(reason);
        }

        @Override
        public void handleRejectedChangeRecord(DeleteRequest change, LocalizableMessage reason) throws DecodeException {
            throw DecodeException.error(reason);
        }

        @Override
        public void handleRejectedChangeRecord(ModifyRequest change, LocalizableMessage reason) throws DecodeException {
            throw DecodeException.error(reason);
        }

        @Override
        public void handleRejectedChangeRecord(ModifyDNRequest change, LocalizableMessage reason) throws DecodeException {
            throw DecodeException.error(reason);
        }
    };
    public static final RejectedChangeRecordListener OVERWRITE = new RejectedChangeRecordListener(){

        @Override
        public Entry handleDuplicateEntry(AddRequest change, Entry existingEntry) throws DecodeException {
            return change;
        }

        @Override
        public Entry handleDuplicateEntry(ModifyDNRequest change, Entry existingEntry, Entry renamedEntry) throws DecodeException {
            return renamedEntry;
        }

        @Override
        public void handleRejectedChangeRecord(AddRequest change, LocalizableMessage reason) throws DecodeException {
        }

        @Override
        public void handleRejectedChangeRecord(DeleteRequest change, LocalizableMessage reason) throws DecodeException {
        }

        @Override
        public void handleRejectedChangeRecord(ModifyRequest change, LocalizableMessage reason) throws DecodeException {
        }

        @Override
        public void handleRejectedChangeRecord(ModifyDNRequest change, LocalizableMessage reason) throws DecodeException {
        }
    };

    public Entry handleDuplicateEntry(AddRequest var1, Entry var2) throws DecodeException;

    public Entry handleDuplicateEntry(ModifyDNRequest var1, Entry var2, Entry var3) throws DecodeException;

    public void handleRejectedChangeRecord(AddRequest var1, LocalizableMessage var2) throws DecodeException;

    public void handleRejectedChangeRecord(DeleteRequest var1, LocalizableMessage var2) throws DecodeException;

    public void handleRejectedChangeRecord(ModifyRequest var1, LocalizableMessage var2) throws DecodeException;

    public void handleRejectedChangeRecord(ModifyDNRequest var1, LocalizableMessage var2) throws DecodeException;
}

