/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.io.IOException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordVisitorWriter;
import org.forgerock.opendj.ldif.ChangeRecordWriter;
import org.forgerock.util.Reject;

public final class ConnectionChangeRecordWriter
implements ChangeRecordWriter {
    private final Connection connection;

    public ConnectionChangeRecordWriter(Connection connection) {
        Reject.ifNull(connection);
        this.connection = connection;
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public void flush() {
    }

    @Override
    public ConnectionChangeRecordWriter writeChangeRecord(AddRequest change) throws LdapException {
        Reject.ifNull(change);
        this.connection.add(change);
        return this;
    }

    @Override
    public ConnectionChangeRecordWriter writeChangeRecord(ChangeRecord change) throws LdapException {
        Reject.ifNull(change);
        IOException e = change.accept(ChangeRecordVisitorWriter.getInstance(), this);
        try {
            if (e != null) {
                throw e;
            }
        }
        catch (LdapException e1) {
            throw e1;
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        return this;
    }

    @Override
    public ConnectionChangeRecordWriter writeChangeRecord(DeleteRequest change) throws LdapException {
        Reject.ifNull(change);
        this.connection.delete(change);
        return this;
    }

    @Override
    public ConnectionChangeRecordWriter writeChangeRecord(ModifyDNRequest change) throws LdapException {
        Reject.ifNull(change);
        this.connection.modifyDN(change);
        return this;
    }

    @Override
    public ConnectionChangeRecordWriter writeChangeRecord(ModifyRequest change) throws LdapException {
        Reject.ifNull(change);
        this.connection.modify(change);
        return this;
    }

    @Override
    public ConnectionChangeRecordWriter writeComment(CharSequence comment) {
        Reject.ifNull(comment);
        return this;
    }
}

