/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.opendj.ldif.AbstractLDIFStream;
import org.forgerock.opendj.ldif.RejectedLDIFListener;
import org.forgerock.util.Reject;

abstract class AbstractLDIFReader
extends AbstractLDIFStream {
    RejectedLDIFListener rejectedRecordListener = RejectedLDIFListener.FAIL_FAST;
    Schema schema = Schema.getDefaultSchema().asNonStrictSchema();
    SchemaValidationPolicy schemaValidationPolicy = SchemaValidationPolicy.ignoreAll();
    private final LDIFReaderImpl impl;
    private long lineNumber;

    AbstractLDIFReader(InputStream in) {
        this(new InputStreamReader(in));
    }

    AbstractLDIFReader(List<String> ldifLines) {
        Reject.ifNull(ldifLines);
        this.impl = new LDIFReaderListImpl(ldifLines);
    }

    AbstractLDIFReader(Reader reader) {
        this.impl = new LDIFReaderInputStreamImpl(reader);
    }

    final void close0() throws IOException {
        this.impl.close();
    }

    final void handleMalformedRecord(LDIFRecord record, LocalizableMessage message) throws DecodeException {
        this.rejectedRecordListener.handleMalformedRecord(record.lineNumber, record.ldifLines, message);
    }

    final void handleSchemaValidationFailure(LDIFRecord record, List<LocalizableMessage> messages) throws DecodeException {
        this.rejectedRecordListener.handleSchemaValidationFailure(record.lineNumber, record.ldifLines, messages);
    }

    final void handleSchemaValidationWarning(LDIFRecord record, List<LocalizableMessage> messages) throws DecodeException {
        this.rejectedRecordListener.handleSchemaValidationWarning(record.lineNumber, record.ldifLines, messages);
    }

    final void handleSkippedRecord(LDIFRecord record, LocalizableMessage message) throws DecodeException {
        this.rejectedRecordListener.handleSkippedRecord(record.lineNumber, record.ldifLines, message);
    }

    final int parseColonPosition(LDIFRecord record, String ldifLine) throws DecodeException {
        int colonPos = ldifLine.indexOf(":");
        if (colonPos <= 0) {
            LocalizableMessage message = CoreMessages.ERR_LDIF_NO_ATTR_NAME.get(record.lineNumber, ldifLine);
            throw DecodeException.error(message);
        }
        return colonPos;
    }

    final ByteString parseSingleValue(LDIFRecord record, String ldifLine, DN entryDN, int colonPos, String attrName) throws DecodeException {
        ByteString value;
        block20: {
            int length = ldifLine.length();
            if (colonPos == length - 1) {
                value = ByteString.empty();
            } else {
                int pos;
                char c = ldifLine.charAt(colonPos + 1);
                if (c == ':') {
                    int pos2;
                    for (pos2 = colonPos + 2; pos2 < length && ldifLine.charAt(pos2) == ' '; ++pos2) {
                    }
                    try {
                        value = ByteString.valueOfBase64(ldifLine.substring(pos2));
                    }
                    catch (LocalizedIllegalArgumentException e) {
                        LocalizableMessage message = CoreMessages.ERR_LDIF_COULD_NOT_BASE64_DECODE_ATTR.get(entryDN.toString(), record.lineNumber, ldifLine, e.getMessageObject());
                        throw DecodeException.error(message);
                    }
                }
                if (c == '<') {
                    URL contentURL;
                    int pos3;
                    for (pos3 = colonPos + 2; pos3 < length && ldifLine.charAt(pos3) == ' '; ++pos3) {
                    }
                    try {
                        contentURL = new URL(ldifLine.substring(pos3));
                    }
                    catch (Exception e) {
                        LocalizableMessage message = CoreMessages.ERR_LDIF_INVALID_URL.get(entryDN.toString(), record.lineNumber, attrName, String.valueOf(e));
                        throw DecodeException.error(message);
                    }
                    ByteStringBuilder builder = null;
                    try (InputStream inputStream = contentURL.openConnection().getInputStream();){
                        int bytesRead;
                        builder = new ByteStringBuilder();
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = inputStream.read(buffer)) > 0) {
                            builder.appendBytes(buffer, 0, bytesRead);
                        }
                        value = builder.toByteString();
                        break block20;
                    }
                    catch (Exception e) {
                        LocalizableMessage message = CoreMessages.ERR_LDIF_URL_IO_ERROR.get(entryDN.toString(), record.lineNumber, attrName, String.valueOf(contentURL), String.valueOf(e));
                        throw DecodeException.error(message);
                    }
                }
                for (pos = colonPos + 1; pos < length && ldifLine.charAt(pos) == ' '; ++pos) {
                }
                value = ByteString.valueOfUtf8(ldifLine.substring(pos));
            }
        }
        return value;
    }

    final LDIFRecord readLDIFRecord() throws IOException {
        StringBuilder lastLineBuilder = new StringBuilder();
        LinkedList<String> ldifLines = new LinkedList<String>();
        long recordLineNumber = 0L;
        boolean stateStart = false;
        boolean stateStartCommentLine = true;
        int stateGotLDIFLine = 2;
        int stateGotCommentLine = 3;
        int appendingLDIFLine = 4;
        int state = 0;
        block6: while (true) {
            String line = this.readLine();
            switch (state) {
                case 0: {
                    if (line == null) {
                        return null;
                    }
                    if (line.length() == 0) continue block6;
                    if (line.charAt(0) == '#') {
                        state = 1;
                        break;
                    }
                    if (this.isContinuationLine(line)) {
                        LocalizableMessage message = CoreMessages.ERR_LDIF_INVALID_LEADING_SPACE.get(this.lineNumber, line);
                        throw DecodeException.fatalError(message);
                    }
                    ldifLines.add(line);
                    recordLineNumber = this.lineNumber;
                    state = 2;
                    break;
                }
                case 1: {
                    if (line == null) {
                        return null;
                    }
                    if (line.length() == 0) {
                        state = 0;
                        break;
                    }
                    if (line.charAt(0) == '#' || this.isContinuationLine(line)) continue block6;
                    ldifLines.add(line);
                    recordLineNumber = this.lineNumber;
                    state = 2;
                    break;
                }
                case 2: {
                    if (line == null) {
                        return new LDIFRecord(recordLineNumber, ldifLines);
                    }
                    if (line.length() == 0) {
                        return new LDIFRecord(recordLineNumber, ldifLines);
                    }
                    if (line.charAt(0) == '#') {
                        state = 3;
                        break;
                    }
                    if (this.isContinuationLine(line)) {
                        lastLineBuilder.setLength(0);
                        lastLineBuilder.append((String)ldifLines.removeLast());
                        lastLineBuilder.append(line.substring(1));
                        state = 4;
                        break;
                    }
                    ldifLines.add(line);
                    state = 2;
                    break;
                }
                case 3: {
                    if (line == null) {
                        return new LDIFRecord(recordLineNumber, ldifLines);
                    }
                    if (line.length() == 0) {
                        return new LDIFRecord(recordLineNumber, ldifLines);
                    }
                    if (line.charAt(0) == '#') {
                        state = 3;
                        break;
                    }
                    if (this.isContinuationLine(line)) continue block6;
                    ldifLines.add(line);
                    state = 2;
                    break;
                }
                default: {
                    if (line == null) {
                        ldifLines.add(lastLineBuilder.toString());
                        return new LDIFRecord(recordLineNumber, ldifLines);
                    }
                    if (line.length() == 0) {
                        ldifLines.add(lastLineBuilder.toString());
                        return new LDIFRecord(recordLineNumber, ldifLines);
                    }
                    if (line.charAt(0) == '#') {
                        ldifLines.add(lastLineBuilder.toString());
                        state = 3;
                        break;
                    }
                    if (this.isContinuationLine(line)) {
                        lastLineBuilder.append(line.substring(1));
                        break;
                    }
                    ldifLines.add(lastLineBuilder.toString());
                    ldifLines.add(line);
                    state = 2;
                }
            }
        }
    }

    final boolean readLDIFRecordAttributeValue(LDIFRecord record, String ldifLine, Entry entry, List<LocalizableMessage> schemaErrors) throws DecodeException {
        Attribute attribute;
        LocalizableMessageBuilder builder;
        boolean checkAttributeValues;
        AttributeDescription attributeDescription;
        int colonPos = this.parseColonPosition(record, ldifLine);
        String attrDescr = ldifLine.substring(0, colonPos);
        try {
            attributeDescription = AttributeDescription.valueOf(attrDescr, this.schema);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_LDIF_UNKNOWN_ATTRIBUTE_TYPE.get(record.lineNumber, entry.getName().toString(), attrDescr);
            switch (this.schemaValidationPolicy.checkAttributesAndObjectClasses()) {
                case REJECT: {
                    schemaErrors.add(message);
                    return false;
                }
                case WARN: {
                    schemaErrors.add(message);
                    return true;
                }
            }
            throw new IllegalStateException("Schema is not consistent with policy", e);
        }
        catch (LocalizedIllegalArgumentException e) {
            LocalizableMessage message = CoreMessages.ERR_LDIF_MALFORMED_ATTRIBUTE_NAME.get(record.lineNumber, entry.getName().toString(), attrDescr);
            throw DecodeException.error(message);
        }
        ByteString value = this.parseSingleValue(record, ldifLine, entry.getName(), colonPos, attrDescr);
        if (this.isAttributeExcluded(attributeDescription)) {
            return true;
        }
        Syntax syntax = attributeDescription.getAttributeType().getSyntax();
        if (!syntax.isBEREncodingRequired()) {
            if (this.schemaValidationPolicy.checkAttributeValues().needsChecking() && attributeDescription.hasOption("binary")) {
                LocalizableMessage message = CoreMessages.ERR_LDIF_UNEXPECTED_BINARY_OPTION.get(record.lineNumber, entry.getName().toString(), attrDescr);
                schemaErrors.add(message);
                return !this.schemaValidationPolicy.checkAttributeValues().isReject();
            }
        } else {
            attributeDescription = attributeDescription.withOption("binary");
        }
        if ((checkAttributeValues = this.schemaValidationPolicy.checkAttributeValues().needsChecking()) && !syntax.valueIsAcceptable(value, builder = new LocalizableMessageBuilder())) {
            schemaErrors.add(builder.toMessage());
            if (this.schemaValidationPolicy.checkAttributeValues().isReject()) {
                return false;
            }
        }
        if ((attribute = entry.getAttribute(attributeDescription)) == null) {
            attribute = new LinkedAttribute(attributeDescription, (Object)value);
            entry.addAttribute(attribute);
        } else if (checkAttributeValues) {
            if (!attribute.add(value)) {
                LocalizableMessage message = CoreMessages.WARN_LDIF_DUPLICATE_ATTRIBUTE_VALUE.get(record.lineNumber, entry.getName().toString(), attrDescr, value.toString());
                schemaErrors.add(message);
                if (this.schemaValidationPolicy.checkAttributeValues().isReject()) {
                    return false;
                }
            } else if (attributeDescription.getAttributeType().isSingleValue()) {
                LocalizableMessage message = CoreMessages.ERR_LDIF_MULTI_VALUED_SINGLE_VALUED_ATTRIBUTE.get(record.lineNumber, entry.getName().toString(), attrDescr);
                schemaErrors.add(message);
                if (this.schemaValidationPolicy.checkAttributeValues().isReject()) {
                    return false;
                }
            }
        } else {
            attribute.add(value);
        }
        return true;
    }

    final DN readLDIFRecordDN(LDIFRecord record) throws DecodeException {
        int pos;
        String ldifLine = record.iterator.next();
        int colonPos = ldifLine.indexOf(":");
        if (colonPos <= 0) {
            throw DecodeException.error(CoreMessages.ERR_LDIF_NO_ATTR_NAME.get(record.lineNumber, ldifLine));
        }
        String attrName = StaticUtils.toLowerCase(ldifLine.substring(0, colonPos));
        if ("version".equals(attrName)) {
            if (!record.iterator.hasNext()) {
                return null;
            }
            ldifLine = record.iterator.next();
            colonPos = ldifLine.indexOf(":");
            if (colonPos <= 0) {
                throw DecodeException.error(CoreMessages.ERR_LDIF_NO_ATTR_NAME.get(record.lineNumber, ldifLine));
            }
            attrName = StaticUtils.toLowerCase(ldifLine.substring(0, colonPos));
        }
        if (!"dn".equals(attrName)) {
            throw DecodeException.error(CoreMessages.ERR_LDIF_NO_DN.get(record.lineNumber, ldifLine));
        }
        int length = ldifLine.length();
        if (colonPos == length - 1) {
            return DN.rootDN();
        }
        String dnString = null;
        if (ldifLine.charAt(colonPos + 1) == ':') {
            for (pos = colonPos + 2; pos < length && ldifLine.charAt(pos) == ' '; ++pos) {
            }
            String base64DN = ldifLine.substring(pos);
            try {
                dnString = ByteString.valueOfBase64(base64DN).toString();
            }
            catch (LocalizedIllegalArgumentException e) {
                LocalizableMessage message = CoreMessages.ERR_LDIF_COULD_NOT_BASE64_DECODE_DN.get(record.lineNumber, ldifLine, e.getMessageObject());
                throw DecodeException.error(message);
            }
        } else {
            for (pos = colonPos + 1; pos < length && ldifLine.charAt(pos) == ' '; ++pos) {
            }
            dnString = ldifLine.substring(pos);
        }
        try {
            return DN.valueOf(dnString, this.schema);
        }
        catch (LocalizedIllegalArgumentException e) {
            LocalizableMessage message = CoreMessages.ERR_LDIF_INVALID_DN.get(record.lineNumber, ldifLine, e.getMessageObject());
            throw DecodeException.error(message);
        }
    }

    final String readLDIFRecordKeyValuePair(LDIFRecord record, KeyValuePair pair, boolean allowBase64) {
        String ldifLine = record.iterator.next();
        int colonPos = ldifLine.indexOf(":");
        if (colonPos <= 0) {
            pair.key = null;
            return ldifLine;
        }
        pair.key = ldifLine.substring(0, colonPos);
        int length = ldifLine.length();
        if (colonPos == length - 1) {
            pair.value = "";
            return ldifLine;
        }
        if (allowBase64 && ldifLine.charAt(colonPos + 1) == ':') {
            int pos;
            for (pos = colonPos + 2; pos < length && ldifLine.charAt(pos) == ' '; ++pos) {
            }
            try {
                pair.value = ByteString.valueOfBase64(ldifLine.substring(pos)).toString();
            }
            catch (LocalizedIllegalArgumentException e) {
                pair.key = null;
                return ldifLine;
            }
        } else {
            int pos;
            for (pos = colonPos + 1; pos < length && ldifLine.charAt(pos) == ' '; ++pos) {
            }
            pair.value = ldifLine.substring(pos);
        }
        return ldifLine;
    }

    private boolean isContinuationLine(String line) {
        return line.charAt(0) == ' ' || line.charAt(0) == '\t';
    }

    private String readLine() throws IOException {
        String line = this.impl.readLine();
        if (line != null) {
            ++this.lineNumber;
        }
        return line;
    }

    private static final class LDIFReaderListImpl
    implements LDIFReaderImpl {
        private final Iterator<String> iterator;

        LDIFReaderListImpl(List<String> ldifLines) {
            this.iterator = ldifLines.iterator();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public String readLine() throws IOException {
            if (this.iterator.hasNext()) {
                return this.iterator.next();
            }
            return null;
        }
    }

    private static final class LDIFReaderInputStreamImpl
    implements LDIFReaderImpl {
        private BufferedReader reader;

        LDIFReaderInputStreamImpl(Reader reader) {
            this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        }

        @Override
        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }

        @Override
        public String readLine() throws IOException {
            String line = null;
            if (this.reader != null && (line = this.reader.readLine()) == null) {
                this.close();
            }
            return line;
        }
    }

    static final class LDIFRecord {
        final Iterator<String> iterator;
        final LinkedList<String> ldifLines;
        final long lineNumber;

        private LDIFRecord(long lineNumber, LinkedList<String> ldifLines) {
            this.lineNumber = lineNumber;
            this.ldifLines = ldifLines;
            this.iterator = ldifLines.iterator();
        }
    }

    static interface LDIFReaderImpl {
        public void close() throws IOException;

        public String readLine() throws IOException;
    }

    static final class KeyValuePair {
        String key;
        String value;

        KeyValuePair() {
        }
    }
}

