/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaOptions;

final class TelephoneNumberSyntaxImpl
extends AbstractSyntaxImpl {
    TelephoneNumberSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.20";
    }

    @Override
    public String getName() {
        return "TelephoneNumber";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.21";
    }

    @Override
    public boolean isHumanReadable() {
        return false;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String valueStr;
        if (value == null || (valueStr = value.toString().trim()).length() == 0) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELEPHONE_EMPTY.get());
            return false;
        }
        int length = valueStr.length();
        if (!schema.getOption(SchemaOptions.ALLOW_NON_STANDARD_TELEPHONE_NUMBERS).booleanValue()) {
            if (valueStr.charAt(0) != '+') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TELEPHONE_NO_PLUS.get(valueStr);
                invalidReason.append(message);
                return false;
            }
            boolean digitSeen = false;
            for (int i = 1; i < length; ++i) {
                char c = valueStr.charAt(i);
                if (StaticUtils.isDigit(c)) {
                    digitSeen = true;
                    continue;
                }
                if (this.isSeparator(c)) continue;
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TELEPHONE_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), i);
                invalidReason.append(message);
                return false;
            }
            if (!digitSeen) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TELEPHONE_NO_DIGITS.get(valueStr);
                invalidReason.append(message);
                return false;
            }
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (!StaticUtils.isDigit(valueStr.charAt(i))) continue;
            return true;
        }
        LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_TELEPHONE_NO_DIGITS.get(valueStr);
        invalidReason.append(message);
        return false;
    }

    private boolean isSeparator(char c) {
        switch (c) {
            case ' ': 
            case '-': {
                return true;
            }
        }
        return false;
    }
}

