/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class ObjectClassSyntaxImpl
extends AbstractSyntaxImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();

    ObjectClassSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.30";
    }

    @Override
    public String getName() {
        return "ObjectClassDescription";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String definition = value.toString();
        try {
            String tokenName;
            char c;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                SchemaUtils.throwDecodeException(logger, CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_EMPTY_VALUE1.get(definition));
            }
            if ((c = reader.read()) != '(') {
                SchemaUtils.throwDecodeException(logger, CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_EXPECTED_OPEN_PARENTHESIS1.get(definition, reader.pos() - 1, Character.valueOf(c)));
            }
            reader.skipWhitespaces();
            boolean allowMalformedNamesAndOptions = schema.getOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS);
            SchemaUtils.readOID(reader, allowMalformedNamesAndOptions);
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readNameDescriptors(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) continue;
                if ("sup".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readOIDs(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("abstract".equalsIgnoreCase(tokenName) || "structural".equalsIgnoreCase(tokenName) || "auxiliary".equalsIgnoreCase(tokenName)) continue;
                if ("must".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readOIDs(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("may".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readOIDs(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    SchemaUtils.readExtensions(reader);
                    continue;
                }
                SchemaUtils.throwDecodeException(logger, CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_TOKEN1.get(definition, tokenName));
            }
            return true;
        }
        catch (DecodeException de) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_INVALID1.get(definition, de.getMessageObject()));
            return false;
        }
    }
}

