/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.SubstringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class LDAPSyntaxDescriptionSyntaxImpl
extends AbstractSyntaxImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();

    LDAPSyntaxDescriptionSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.30";
    }

    @Override
    public String getName() {
        return "LDAPSyntaxDescription";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String definition = value.toString();
        try {
            String tokenName;
            char c;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                SchemaUtils.throwDecodeException(logger, CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EMPTY_VALUE1.get(definition));
            }
            if ((c = reader.read()) != '(') {
                SchemaUtils.throwDecodeException(logger, CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_OPEN_PARENTHESIS.get(definition, reader.pos() - 1, Character.valueOf(c)));
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOID(reader, schema.getOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS));
            Map<String, List<String>> extraProperties = Collections.emptyMap();
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("desc".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    if (extraProperties.isEmpty()) {
                        extraProperties = new HashMap();
                    }
                    extraProperties.put(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                SchemaUtils.throwDecodeException(logger, CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_ILLEGAL_TOKEN1.get(definition, tokenName));
            }
            for (Map.Entry property : extraProperties.entrySet()) {
                Iterator values;
                if ("x-pattern".equalsIgnoreCase((String)property.getKey())) {
                    values = ((List)property.getValue()).iterator();
                    if (!values.hasNext()) continue;
                    String pattern = (String)values.next();
                    try {
                        Pattern.compile(pattern);
                    }
                    catch (Exception e) {
                        SchemaUtils.throwDecodeException(logger, CoreMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_INVALID_PATTERN.get(oid, pattern));
                    }
                    break;
                }
                if (!"x-enum".equalsIgnoreCase((String)property.getKey())) continue;
                values = (List)property.getValue();
                for (int i = 0; i < values.size() - 1; ++i) {
                    String entry = (String)values.get(i);
                    for (int j = i + 1; j < values.size(); ++j) {
                        if (!entry.equals(values.get(j))) continue;
                        SchemaUtils.throwDecodeException(logger, CoreMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_ENUM_DUPLICATE_VALUE.get(oid, entry, j));
                    }
                }
            }
            return true;
        }
        catch (DecodeException de) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_INVALID1.get(definition, de.getMessageObject()));
            return false;
        }
    }
}

