/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class DeliveryMethodSyntaxImpl
extends AbstractSyntaxImpl {
    private static final HashSet<String> ALLOWED_VALUES = new HashSet();

    DeliveryMethodSyntaxImpl() {
        ALLOWED_VALUES.add("any");
        ALLOWED_VALUES.add("mhs");
        ALLOWED_VALUES.add("physical");
        ALLOWED_VALUES.add("telex");
        ALLOWED_VALUES.add("teletex");
        ALLOWED_VALUES.add("g3fax");
        ALLOWED_VALUES.add("g4fax");
        ALLOWED_VALUES.add("ia5");
        ALLOWED_VALUES.add("videotex");
        ALLOWED_VALUES.add("telephone");
    }

    @Override
    public String getApproximateMatchingRule() {
        return "1.3.6.1.4.1.26027.1.4.1";
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.2";
    }

    @Override
    public String getName() {
        return "DeliveryMethod";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.3";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.4";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String stringValue = StaticUtils.toLowerCase(value.toString());
        StringTokenizer tokenizer = new StringTokenizer(stringValue, " $");
        if (!tokenizer.hasMoreTokens()) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_DELIVERY_METHOD_NO_ELEMENTS.get(value.toString()));
            return false;
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (ALLOWED_VALUES.contains(token)) continue;
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_DELIVERY_METHOD_INVALID_ELEMENT.get(value.toString(), token));
            return false;
        }
        return true;
    }
}

