/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Reject;

public final class AttributeType
extends AbstractSchemaElement
implements Comparable<AttributeType> {
    private final String approximateMatchingRuleOID;
    private final AttributeUsage attributeUsage;
    private final String equalityMatchingRuleOID;
    private final boolean isCollective;
    private final boolean isNoUserModification;
    private final boolean isObsolete;
    private final boolean isPlaceHolder;
    private final boolean isSingleValue;
    private final List<String> names;
    private final String oid;
    private final String orderingMatchingRuleOID;
    private final String substringMatchingRuleOID;
    private final String superiorTypeOID;
    private final String syntaxOID;
    private final boolean isObjectClassType;
    private final String normalizedName;
    private AttributeType superiorType;
    private MatchingRule equalityMatchingRule;
    private MatchingRule orderingMatchingRule;
    private MatchingRule substringMatchingRule;
    private MatchingRule approximateMatchingRule;
    private Syntax syntax;
    private boolean needsValidating = true;
    private boolean isValid;

    private AttributeType(Builder builder) {
        super(builder);
        Reject.ifTrue(builder.oid == null || builder.oid.isEmpty(), "An OID must be specified.");
        if (builder.superiorTypeOID == null && builder.syntaxOID == null && !builder.getSchemaBuilder().getOptions().get(SchemaOptions.ALLOW_ATTRIBUTE_TYPES_WITH_NO_SUP_OR_SYNTAX).booleanValue()) {
            throw new IllegalArgumentException("Superior type and/or Syntax must not be null");
        }
        this.oid = builder.oid;
        this.names = SchemaUtils.unmodifiableCopyOfList(builder.names);
        this.attributeUsage = builder.attributeUsage;
        this.isCollective = builder.isCollective;
        this.isNoUserModification = builder.isNoUserModification;
        this.isObjectClassType = "2.5.4.0".equals(this.oid);
        this.isObsolete = builder.isObsolete;
        this.isSingleValue = builder.isSingleValue;
        this.approximateMatchingRuleOID = builder.approximateMatchingRuleOID;
        this.equalityMatchingRuleOID = builder.equalityMatchingRuleOID;
        this.orderingMatchingRuleOID = builder.orderingMatchingRuleOID;
        this.substringMatchingRuleOID = builder.substringMatchingRuleOID;
        this.superiorTypeOID = builder.superiorTypeOID;
        this.syntaxOID = builder.syntaxOID;
        this.isPlaceHolder = false;
        this.normalizedName = StaticUtils.toLowerCase(this.getNameOrOID());
    }

    static AttributeType newPlaceHolder(String name, Syntax syntax, MatchingRule equalityMatchingRule) {
        return new AttributeType(name, syntax, equalityMatchingRule);
    }

    private AttributeType(String name, Syntax syntax, MatchingRule equalityMatchingRule) {
        StringBuilder builder = new StringBuilder(name.length() + 4);
        StaticUtils.toLowerCase(name, builder);
        builder.append("-oid");
        this.oid = builder.toString();
        this.names = Collections.singletonList(name);
        this.isObsolete = false;
        this.superiorTypeOID = null;
        this.superiorType = null;
        this.equalityMatchingRule = equalityMatchingRule;
        this.equalityMatchingRuleOID = equalityMatchingRule.getOID();
        this.orderingMatchingRuleOID = null;
        this.substringMatchingRuleOID = null;
        this.approximateMatchingRuleOID = null;
        this.syntax = syntax;
        this.syntaxOID = syntax.getOID();
        this.isSingleValue = false;
        this.isCollective = false;
        this.isNoUserModification = false;
        this.attributeUsage = null;
        this.isObjectClassType = false;
        this.isPlaceHolder = true;
        this.normalizedName = StaticUtils.toLowerCase(this.getNameOrOID());
    }

    @Override
    public int compareTo(AttributeType type) {
        boolean typeIsOperational;
        if (this.isObjectClassType) {
            return type.isObjectClassType ? 0 : -1;
        }
        if (type.isObjectClassType) {
            return 1;
        }
        boolean isOperational = this.getUsage().isOperational();
        if (isOperational == (typeIsOperational = type.getUsage().isOperational())) {
            int tmp = this.normalizedName.compareTo(type.normalizedName);
            if (tmp == 0) {
                return this.oid.compareTo(type.oid);
            }
            return tmp;
        }
        return isOperational ? 1 : -1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AttributeType) {
            AttributeType other = (AttributeType)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public MatchingRule getApproximateMatchingRule() {
        return this.approximateMatchingRule;
    }

    public MatchingRule getEqualityMatchingRule() {
        return this.equalityMatchingRule;
    }

    public String getNameOrOID() {
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getOID() {
        return this.oid;
    }

    public MatchingRule getOrderingMatchingRule() {
        return this.orderingMatchingRule;
    }

    public MatchingRule getSubstringMatchingRule() {
        return this.substringMatchingRule;
    }

    public AttributeType getSuperiorType() {
        return this.superiorType;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public AttributeUsage getUsage() {
        return this.attributeUsage != null ? this.attributeUsage : AttributeUsage.USER_APPLICATIONS;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOID(String value) {
        return this.hasName(value) || this.getOID().equals(value);
    }

    public boolean isCollective() {
        return this.isCollective;
    }

    public boolean isNoUserModification() {
        return this.isNoUserModification;
    }

    public boolean isObjectClass() {
        return this.isObjectClassType;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public boolean isOperational() {
        return this.getUsage().isOperational();
    }

    public boolean isPlaceHolder() {
        return this.isPlaceHolder;
    }

    public boolean isSingleValue() {
        return this.isSingleValue;
    }

    public boolean isSubTypeOf(AttributeType type) {
        AttributeType tmp = this;
        do {
            if (!tmp.matches(type)) continue;
            return true;
        } while ((tmp = tmp.getSuperiorType()) != null);
        return false;
    }

    public boolean isSuperTypeOf(AttributeType type) {
        return type.isSubTypeOf(this);
    }

    public boolean matches(AttributeType type) {
        if (this == type) {
            return true;
        }
        if (this.oid.equals(type.oid)) {
            return true;
        }
        if (this.isPlaceHolder != type.isPlaceHolder) {
            return this.isPlaceHolder ? type.hasName(this.normalizedName) : this.hasName(type.normalizedName);
        }
        return false;
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            Iterator<String> iterator = this.names.iterator();
            String firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        this.appendDescription(buffer);
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (this.superiorTypeOID != null) {
            buffer.append(" SUP ");
            buffer.append(this.superiorTypeOID);
        }
        if (this.equalityMatchingRuleOID != null) {
            buffer.append(" EQUALITY ");
            buffer.append(this.equalityMatchingRuleOID);
        }
        if (this.orderingMatchingRuleOID != null) {
            buffer.append(" ORDERING ");
            buffer.append(this.orderingMatchingRuleOID);
        }
        if (this.substringMatchingRuleOID != null) {
            buffer.append(" SUBSTR ");
            buffer.append(this.substringMatchingRuleOID);
        }
        if (this.syntaxOID != null) {
            buffer.append(" SYNTAX ");
            buffer.append(this.syntaxOID);
        }
        if (this.isSingleValue()) {
            buffer.append(" SINGLE-VALUE");
        }
        if (this.isCollective()) {
            buffer.append(" COLLECTIVE");
        }
        if (this.isNoUserModification()) {
            buffer.append(" NO-USER-MODIFICATION");
        }
        if (this.attributeUsage != null) {
            buffer.append(" USAGE ");
            buffer.append((Object)this.attributeUsage);
        }
        if (this.approximateMatchingRuleOID != null) {
            buffer.append(" ");
            buffer.append("X-APPROX");
            buffer.append(" '");
            buffer.append(this.approximateMatchingRuleOID);
            buffer.append("'");
        }
    }

    boolean validate(Schema schema, List<AttributeType> invalidSchemaElements, List<LocalizableMessage> warnings) {
        LocalizableMessage message;
        if (!this.needsValidating) {
            return this.isValid;
        }
        this.needsValidating = false;
        if (this.superiorTypeOID != null) {
            try {
                this.superiorType = schema.getAttributeType(this.superiorTypeOID);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message2 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SUPERIOR_TYPE1.get(this.getNameOrOID(), this.superiorTypeOID);
                this.failValidation(invalidSchemaElements, warnings, message2);
                return false;
            }
            if (!this.superiorType.validate(schema, invalidSchemaElements, warnings)) {
                LocalizableMessage message3 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_SUPERIOR_TYPE.get(this.getNameOrOID(), this.superiorTypeOID);
                this.failValidation(invalidSchemaElements, warnings, message3);
                return false;
            }
            if (this.superiorType.getUsage() != this.getUsage()) {
                LocalizableMessage message4 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_SUPERIOR_USAGE.get(this.getNameOrOID(), this.getUsage().toString(), this.superiorType.getNameOrOID());
                this.failValidation(invalidSchemaElements, warnings, message4);
                return false;
            }
            if (this.superiorType.isCollective() != this.isCollective() && !this.isCollective()) {
                LocalizableMessage message5 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_NONCOLLECTIVE_FROM_COLLECTIVE.get(this.getNameOrOID(), this.superiorType.getNameOrOID());
                this.failValidation(invalidSchemaElements, warnings, message5);
                return false;
            }
            if (!this.isObsolete() && this.superiorType.isObsolete()) {
                warnings.add(CoreMessages.WARN_ATTR_TYPE_HAS_OBSOLETE_SUPERIOR_TYPE.get(this.getNameOrOID(), this.oid));
            }
        }
        if (this.syntaxOID != null) {
            if (!schema.hasSyntax(this.syntaxOID)) {
                this.syntax = Schema.getCoreSchema().getSyntax(this.syntaxOID);
                message = CoreMessages.WARN_ATTR_TYPE_NOT_DEFINED1.get(this.getNameOrOID(), this.syntaxOID, this.syntax.getOID());
                warnings.add(message);
            } else {
                this.syntax = schema.getSyntax(this.syntaxOID);
            }
        } else {
            this.syntax = this.getSuperiorType() != null && this.getSuperiorType().getSyntax() != null ? this.getSuperiorType().getSyntax() : schema.getDefaultSyntax();
        }
        if (this.equalityMatchingRuleOID != null) {
            try {
                this.equalityMatchingRule = schema.getMatchingRule(this.equalityMatchingRuleOID);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message6 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_EQUALITY_MR1.get(this.getNameOrOID(), this.equalityMatchingRuleOID);
                this.failValidation(invalidSchemaElements, warnings, message6);
                return false;
            }
        } else if (this.getSuperiorType() != null && this.getSuperiorType().getEqualityMatchingRule() != null) {
            this.equalityMatchingRule = this.getSuperiorType().getEqualityMatchingRule();
        } else if (this.getSyntax() != null && this.getSyntax().getEqualityMatchingRule() != null) {
            this.equalityMatchingRule = this.getSyntax().getEqualityMatchingRule();
        }
        this.checkMatchingRuleIsNotObsolete(this.equalityMatchingRule, warnings);
        if (this.orderingMatchingRuleOID != null) {
            try {
                this.orderingMatchingRule = schema.getMatchingRule(this.orderingMatchingRuleOID);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message7 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_ORDERING_MR1.get(this.getNameOrOID(), this.orderingMatchingRuleOID);
                this.failValidation(invalidSchemaElements, warnings, message7);
                return false;
            }
        } else if (this.getSuperiorType() != null && this.getSuperiorType().getOrderingMatchingRule() != null) {
            this.orderingMatchingRule = this.getSuperiorType().getOrderingMatchingRule();
        } else if (this.getSyntax() != null && this.getSyntax().getOrderingMatchingRule() != null) {
            this.orderingMatchingRule = this.getSyntax().getOrderingMatchingRule();
        }
        this.checkMatchingRuleIsNotObsolete(this.orderingMatchingRule, warnings);
        if (this.substringMatchingRuleOID != null) {
            try {
                this.substringMatchingRule = schema.getMatchingRule(this.substringMatchingRuleOID);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message8 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SUBSTRING_MR1.get(this.getNameOrOID(), this.substringMatchingRuleOID);
                this.failValidation(invalidSchemaElements, warnings, message8);
                return false;
            }
        } else if (this.getSuperiorType() != null && this.getSuperiorType().getSubstringMatchingRule() != null) {
            this.substringMatchingRule = this.getSuperiorType().getSubstringMatchingRule();
        } else if (this.getSyntax() != null && this.getSyntax().getSubstringMatchingRule() != null) {
            this.substringMatchingRule = this.getSyntax().getSubstringMatchingRule();
        }
        this.checkMatchingRuleIsNotObsolete(this.substringMatchingRule, warnings);
        if (this.approximateMatchingRuleOID != null) {
            try {
                this.approximateMatchingRule = schema.getMatchingRule(this.approximateMatchingRuleOID);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message9 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_APPROXIMATE_MR1.get(this.getNameOrOID(), this.approximateMatchingRuleOID);
                this.failValidation(invalidSchemaElements, warnings, message9);
                return false;
            }
        } else if (this.getSuperiorType() != null && this.getSuperiorType().getApproximateMatchingRule() != null) {
            this.approximateMatchingRule = this.getSuperiorType().getApproximateMatchingRule();
        } else if (this.getSyntax() != null && this.getSyntax().getApproximateMatchingRule() != null) {
            this.approximateMatchingRule = this.getSyntax().getApproximateMatchingRule();
        }
        this.checkMatchingRuleIsNotObsolete(this.approximateMatchingRule, warnings);
        if (this.isCollective() && this.getUsage() != AttributeUsage.USER_APPLICATIONS) {
            message = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_COLLECTIVE_IS_OPERATIONAL.get(this.getNameOrOID());
            warnings.add(message);
        }
        if (this.isNoUserModification() && this.getUsage() == AttributeUsage.USER_APPLICATIONS) {
            message = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_NO_USER_MOD_NOT_OPERATIONAL.get(this.getNameOrOID());
            warnings.add(message);
        }
        this.isValid = true;
        return true;
    }

    private void checkMatchingRuleIsNotObsolete(MatchingRule rule, List<LocalizableMessage> warnings) {
        if (!this.isObsolete() && rule != null && rule.isObsolete()) {
            warnings.add(CoreMessages.WARN_ATTR_TYPE_HAS_OBSOLETE_MR.get(this.getNameOrOID(), rule.getOID()));
        }
    }

    private void failValidation(List<AttributeType> invalidSchemaElements, List<LocalizableMessage> warnings, LocalizableMessage message) {
        invalidSchemaElements.add(this);
        warnings.add(CoreMessages.ERR_ATTR_TYPE_VALIDATION_FAIL.get(this.toString(), message));
    }

    public static final class Builder
    extends AbstractSchemaElement.SchemaElementBuilder<Builder> {
        private String oid;
        private final List<String> names = new LinkedList<String>();
        private AttributeUsage attributeUsage;
        private boolean isCollective;
        private boolean isNoUserModification;
        private boolean isObsolete;
        private boolean isSingleValue;
        private String approximateMatchingRuleOID;
        private String equalityMatchingRuleOID;
        private String orderingMatchingRuleOID;
        private String substringMatchingRuleOID;
        private String superiorTypeOID;
        private String syntaxOID;

        Builder(AttributeType at, SchemaBuilder builder) {
            super(builder, at);
            this.oid = at.oid;
            this.attributeUsage = at.attributeUsage;
            this.isCollective = at.isCollective;
            this.isNoUserModification = at.isNoUserModification;
            this.isObsolete = at.isObsolete;
            this.isSingleValue = at.isSingleValue;
            this.names.addAll(at.names);
            this.approximateMatchingRuleOID = at.approximateMatchingRuleOID;
            this.equalityMatchingRuleOID = at.equalityMatchingRuleOID;
            this.orderingMatchingRuleOID = at.orderingMatchingRuleOID;
            this.substringMatchingRuleOID = at.substringMatchingRuleOID;
            this.superiorTypeOID = at.superiorTypeOID;
            this.syntaxOID = at.syntaxOID;
        }

        Builder(String oid, SchemaBuilder builder) {
            super(builder);
            this.oid = oid;
        }

        public SchemaBuilder addToSchema() {
            return this.addToSchema(false);
        }

        public SchemaBuilder addToSchemaOverwrite() {
            return this.addToSchema(true);
        }

        SchemaBuilder addToSchema(boolean overwrite) {
            return this.getSchemaBuilder().addAttributeType(new AttributeType(this), overwrite);
        }

        public Builder approximateMatchingRule(String approximateMatchingRuleOID) {
            this.approximateMatchingRuleOID = approximateMatchingRuleOID;
            return this;
        }

        public Builder collective(boolean isCollective) {
            this.isCollective = isCollective;
            return this;
        }

        @Override
        public Builder description(String description) {
            return (Builder)this.description0(description);
        }

        public Builder equalityMatchingRule(String equalityMatchingRuleOID) {
            this.equalityMatchingRuleOID = equalityMatchingRuleOID;
            return this;
        }

        @Override
        public Builder extraProperties(Map<String, List<String>> extraProperties) {
            return (Builder)this.extraProperties0(extraProperties);
        }

        @Override
        public Builder extraProperties(String extensionName, String ... extensionValues) {
            return (Builder)this.extraProperties0(extensionName, extensionValues);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public Builder names(Collection<String> names) {
            this.names.addAll(names);
            return this;
        }

        public Builder names(String ... names) {
            return this.names(Arrays.asList(names));
        }

        public Builder noUserModification(boolean isNoUserModification) {
            this.isNoUserModification = isNoUserModification;
            return this;
        }

        public Builder obsolete(boolean isObsolete) {
            this.isObsolete = isObsolete;
            return this;
        }

        public Builder oid(String oid) {
            this.oid = oid;
            return this;
        }

        public Builder orderingMatchingRule(String orderingMatchingRuleOID) {
            this.orderingMatchingRuleOID = orderingMatchingRuleOID;
            return this;
        }

        @Override
        public Builder removeAllExtraProperties() {
            return (Builder)this.removeAllExtraProperties0();
        }

        public Builder removeAllNames() {
            this.names.clear();
            return this;
        }

        @Override
        public Builder removeExtraProperty(String extensionName, String ... extensionValues) {
            return (Builder)this.removeExtraProperty0(extensionName, extensionValues);
        }

        public Builder removeName(String name) {
            this.names.remove(name);
            return this;
        }

        public Builder singleValue(boolean isSingleValue) {
            this.isSingleValue = isSingleValue;
            return this;
        }

        public Builder substringMatchingRule(String substringMatchingRuleOID) {
            this.substringMatchingRuleOID = substringMatchingRuleOID;
            return this;
        }

        public Builder superiorType(String superiorTypeOID) {
            this.superiorTypeOID = superiorTypeOID;
            return this;
        }

        public Builder syntax(String syntaxOID) {
            this.syntaxOID = syntaxOID;
            return this;
        }

        public Builder usage(AttributeUsage attributeUsage) {
            this.attributeUsage = attributeUsage;
            return this;
        }
    }
}

