/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.responses.AbstractIntermediateResponse;
import org.forgerock.opendj.ldap.responses.GenericIntermediateResponse;

final class GenericIntermediateResponseImpl
extends AbstractIntermediateResponse<GenericIntermediateResponse>
implements GenericIntermediateResponse {
    private String responseName;
    private ByteString responseValue;

    GenericIntermediateResponseImpl() {
    }

    GenericIntermediateResponseImpl(GenericIntermediateResponse genericIntermediateResponse) {
        super(genericIntermediateResponse);
        this.responseName = genericIntermediateResponse.getOID();
        this.responseValue = genericIntermediateResponse.getValue();
    }

    @Override
    public String getOID() {
        return this.responseName;
    }

    @Override
    public ByteString getValue() {
        return this.responseValue;
    }

    @Override
    public boolean hasValue() {
        return this.responseValue != null;
    }

    @Override
    public GenericIntermediateResponse setOID(String oid) {
        this.responseName = oid;
        return this;
    }

    @Override
    public GenericIntermediateResponse setValue(Object value) {
        this.responseValue = value != null ? ByteString.valueOfObject(value) : null;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GenericIntermediateResponse(responseName=");
        builder.append(this.getOID() == null ? "" : this.getOID());
        if (this.hasValue()) {
            builder.append(", requestValue=");
            builder.append(this.getValue().toHexPlusAsciiString(4));
        }
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }
}

