/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.AbstractRequestImpl;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.util.Reject;

final class SearchRequestImpl
extends AbstractRequestImpl<SearchRequest>
implements SearchRequest {
    private final List<String> attributes = new LinkedList<String>();
    private DereferenceAliasesPolicy dereferenceAliasesPolicy = DereferenceAliasesPolicy.NEVER;
    private Filter filter;
    private DN name;
    private SearchScope scope;
    private int sizeLimit;
    private int timeLimit;
    private boolean typesOnly;

    SearchRequestImpl(DN name, SearchScope scope, Filter filter) {
        this.name = name;
        this.scope = scope;
        this.filter = filter;
    }

    SearchRequestImpl(SearchRequest searchRequest) {
        super(searchRequest);
        this.attributes.addAll(searchRequest.getAttributes());
        this.name = searchRequest.getName();
        this.dereferenceAliasesPolicy = searchRequest.getDereferenceAliasesPolicy();
        this.filter = searchRequest.getFilter();
        this.scope = searchRequest.getScope();
        this.sizeLimit = searchRequest.getSizeLimit();
        this.timeLimit = searchRequest.getTimeLimit();
        this.typesOnly = searchRequest.isTypesOnly();
    }

    @Override
    public SearchRequest addAttribute(String ... attributeDescriptions) {
        for (String attributeDescription : attributeDescriptions) {
            this.attributes.add(Reject.checkNotNull(attributeDescription));
        }
        return this;
    }

    @Override
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public DereferenceAliasesPolicy getDereferenceAliasesPolicy() {
        return this.dereferenceAliasesPolicy;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public DN getName() {
        return this.name;
    }

    @Override
    public SearchScope getScope() {
        return this.scope;
    }

    @Override
    public int getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    public boolean isSingleEntrySearch() {
        return this.sizeLimit == 1 || SearchScope.BASE_OBJECT.equals(this.scope);
    }

    @Override
    public int getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public boolean isTypesOnly() {
        return this.typesOnly;
    }

    @Override
    public SearchRequest setDereferenceAliasesPolicy(DereferenceAliasesPolicy policy) {
        Reject.ifNull(policy);
        this.dereferenceAliasesPolicy = policy;
        return this;
    }

    @Override
    public SearchRequest setFilter(Filter filter) {
        Reject.ifNull(filter);
        this.filter = filter;
        return this;
    }

    @Override
    public SearchRequest setFilter(String filter) {
        this.filter = Filter.valueOf(filter);
        return this;
    }

    @Override
    public SearchRequest setName(DN dn) {
        Reject.ifNull(dn);
        this.name = dn;
        return this;
    }

    @Override
    public SearchRequest setName(String dn) {
        Reject.ifNull(dn);
        this.name = DN.valueOf(dn);
        return this;
    }

    @Override
    public SearchRequest setScope(SearchScope scope) {
        Reject.ifNull(scope);
        this.scope = scope;
        return this;
    }

    @Override
    public SearchRequest setSizeLimit(int limit) {
        Reject.ifFalse(limit >= 0, "negative size limit");
        this.sizeLimit = limit;
        return this;
    }

    @Override
    public SearchRequest setTimeLimit(int limit) {
        Reject.ifFalse(limit >= 0, "negative time limit");
        this.timeLimit = limit;
        return this;
    }

    @Override
    public SearchRequest setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SearchRequest(name=");
        builder.append(this.getName());
        builder.append(", scope=");
        builder.append(this.getScope());
        builder.append(", dereferenceAliasesPolicy=");
        builder.append(this.getDereferenceAliasesPolicy());
        builder.append(", sizeLimit=");
        builder.append(this.getSizeLimit());
        builder.append(", timeLimit=");
        builder.append(this.getTimeLimit());
        builder.append(", typesOnly=");
        builder.append(this.isTypesOnly());
        builder.append(", filter=");
        builder.append(this.getFilter());
        builder.append(", attributes=");
        builder.append(this.getAttributes());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    SearchRequest getThis() {
        return this;
    }
}

