/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.LDAP;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class PreReadResponseControl
implements Control {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "1.3.6.1.1.13.1";
    public static final ControlDecoder<PreReadResponseControl> DECODER = new ControlDecoder<PreReadResponseControl>(){

        @Override
        public PreReadResponseControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Entry entry;
            Reject.ifNull(control);
            if (control instanceof PreReadResponseControl) {
                return (PreReadResponseControl)control;
            }
            if (!control.getOID().equals(PreReadResponseControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_PREREAD_CONTROL_BAD_OID.get(control.getOID(), PreReadResponseControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_PREREADRESP_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                entry = LDAP.readEntry(reader, options);
            }
            catch (IOException le) {
                logger.debug(LocalizableMessage.raw("Unable to read result entry", le));
                LocalizableMessage message = CoreMessages.ERR_PREREADRESP_CANNOT_DECODE_VALUE.get(le.getMessage());
                throw DecodeException.error(message, le);
            }
            return new PreReadResponseControl(control.isCritical(), Entries.unmodifiableEntry(entry));
        }

        @Override
        public String getOID() {
            return PreReadResponseControl.OID;
        }
    };
    private final Entry entry;
    private final boolean isCritical;

    public static PreReadResponseControl newControl(Entry entry) {
        return new PreReadResponseControl(false, Entries.unmodifiableEntry(entry));
    }

    private PreReadResponseControl(boolean isCritical, Entry entry) {
        this.isCritical = isCritical;
        this.entry = entry;
    }

    public Entry getEntry() {
        return this.entry;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        try {
            ByteStringBuilder buffer = new ByteStringBuilder();
            LDAP.writeEntry(ASN1.getWriter(buffer), this.entry);
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PreReadResponseControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", entry=");
        builder.append(this.entry);
        builder.append(")");
        return builder.toString();
    }
}

