/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class PasswordExpiringResponseControl
implements Control {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "2.16.840.1.113730.3.4.5";
    public static final ControlDecoder<PasswordExpiringResponseControl> DECODER = new ControlDecoder<PasswordExpiringResponseControl>(){

        @Override
        public PasswordExpiringResponseControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            int secondsUntilExpiration;
            Reject.ifNull(control);
            if (control instanceof PasswordExpiringResponseControl) {
                return (PasswordExpiringResponseControl)control;
            }
            if (!control.getOID().equals(PasswordExpiringResponseControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_PWEXPIRING_CONTROL_BAD_OID.get(control.getOID(), PasswordExpiringResponseControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_PWEXPIRING_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            try {
                secondsUntilExpiration = Integer.parseInt(control.getValue().toString());
            }
            catch (Exception e) {
                logger.debug(LocalizableMessage.raw("%s", e));
                LocalizableMessage message = CoreMessages.ERR_PWEXPIRING_CANNOT_DECODE_SECONDS_UNTIL_EXPIRATION.get(StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message);
            }
            return new PasswordExpiringResponseControl(control.isCritical(), secondsUntilExpiration);
        }

        @Override
        public String getOID() {
            return PasswordExpiringResponseControl.OID;
        }
    };
    private final int secondsUntilExpiration;
    private final boolean isCritical;

    public static PasswordExpiringResponseControl newControl(int secondsUntilExpiration) {
        return new PasswordExpiringResponseControl(false, secondsUntilExpiration);
    }

    private PasswordExpiringResponseControl(boolean isCritical, int secondsUntilExpiration) {
        this.isCritical = isCritical;
        this.secondsUntilExpiration = secondsUntilExpiration;
    }

    @Override
    public String getOID() {
        return OID;
    }

    public int getSecondsUntilExpiration() {
        return this.secondsUntilExpiration;
    }

    @Override
    public ByteString getValue() {
        return ByteString.valueOfUtf8(String.valueOf(this.secondsUntilExpiration));
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PasswordExpiringResponseControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", secondsUntilExpiration=");
        builder.append(this.secondsUntilExpiration);
        builder.append(")");
        return builder.toString();
    }
}

