/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.util.Reject;

public final class GenericControl
implements Control {
    private final String oid;
    private final boolean isCritical;
    private final ByteString value;

    public static GenericControl newControl(Control control) {
        Reject.ifNull(control);
        if (control instanceof GenericControl) {
            return (GenericControl)control;
        }
        return new GenericControl(control.getOID(), control.isCritical(), control.getValue());
    }

    public static GenericControl newControl(String oid) {
        return new GenericControl(oid, false, null);
    }

    public static GenericControl newControl(String oid, boolean isCritical) {
        return new GenericControl(oid, isCritical, null);
    }

    public static GenericControl newControl(String oid, boolean isCritical, Object value) {
        return new GenericControl(oid, isCritical, value == null ? null : ByteString.valueOfObject(value));
    }

    private GenericControl(String oid, boolean isCritical, ByteString value) {
        Reject.ifNull(oid);
        this.oid = oid;
        this.isCritical = isCritical;
        this.value = value;
    }

    @Override
    public String getOID() {
        return this.oid;
    }

    @Override
    public ByteString getValue() {
        return this.value;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Control(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        if (this.value != null) {
            builder.append(", value=");
            builder.append(this.value.toHexPlusAsciiString(4));
        }
        builder.append(")");
        return builder.toString();
    }
}

