/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.forgerock.opendj.ldap.CommonLDAPOptions;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.spi.LDAPListenerImpl;
import org.forgerock.opendj.ldap.spi.TransportProvider;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;

public final class LDAPListener
extends CommonLDAPOptions
implements Closeable {
    public static final Option<Integer> CONNECT_MAX_BACKLOG = Option.withDefault(50);
    public static final Option<Integer> REQUEST_MAX_SIZE_IN_BYTES = Option.withDefault(0x500000);
    private final LDAPListenerImpl impl;
    private TransportProvider provider;

    public LDAPListener(int port, ServerConnectionFactory<LDAPClientContext, Integer> factory) throws IOException {
        this(port, factory, Options.defaultOptions());
    }

    public LDAPListener(int port, ServerConnectionFactory<LDAPClientContext, Integer> factory, Options options) throws IOException {
        Reject.ifNull(factory, options);
        this.provider = LDAPListener.getTransportProvider(options);
        this.impl = this.provider.getLDAPListener(new InetSocketAddress(port), factory, options);
    }

    public LDAPListener(InetSocketAddress address, ServerConnectionFactory<LDAPClientContext, Integer> factory) throws IOException {
        this(address, factory, Options.defaultOptions());
    }

    public LDAPListener(InetSocketAddress address, ServerConnectionFactory<LDAPClientContext, Integer> factory, Options options) throws IOException {
        Reject.ifNull(address, factory, options);
        this.provider = LDAPListener.getTransportProvider(options);
        this.impl = this.provider.getLDAPListener(address, factory, options);
    }

    public LDAPListener(String host, int port, ServerConnectionFactory<LDAPClientContext, Integer> factory) throws IOException {
        this(host, port, factory, Options.defaultOptions());
    }

    public LDAPListener(String host, int port, ServerConnectionFactory<LDAPClientContext, Integer> factory, Options options) throws IOException {
        Reject.ifNull(host, factory, options);
        InetSocketAddress address = new InetSocketAddress(host, port);
        this.provider = LDAPListener.getTransportProvider(options);
        this.impl = this.provider.getLDAPListener(address, factory, options);
    }

    @Override
    public void close() {
        this.impl.close();
    }

    public InetAddress getAddress() {
        return this.getSocketAddress().getAddress();
    }

    public String getHostName() {
        return Connections.getHostString(this.getSocketAddress());
    }

    public int getPort() {
        return this.getSocketAddress().getPort();
    }

    public InetSocketAddress getSocketAddress() {
        return this.impl.getSocketAddress();
    }

    public String getProviderName() {
        return this.provider.getName();
    }

    public String toString() {
        return this.impl.toString();
    }
}

