/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DereferenceAliasesPolicy {
    private static final DereferenceAliasesPolicy[] ELEMENTS = new DereferenceAliasesPolicy[4];
    private static final List<DereferenceAliasesPolicy> IMMUTABLE_ELEMENTS = Collections.unmodifiableList(Arrays.asList(ELEMENTS));
    public static final DereferenceAliasesPolicy NEVER = DereferenceAliasesPolicy.register(0, "never");
    public static final DereferenceAliasesPolicy IN_SEARCHING = DereferenceAliasesPolicy.register(1, "search");
    public static final DereferenceAliasesPolicy FINDING_BASE = DereferenceAliasesPolicy.register(2, "find");
    public static final DereferenceAliasesPolicy ALWAYS = DereferenceAliasesPolicy.register(3, "always");
    private final int intValue;
    private final String name;

    public static DereferenceAliasesPolicy valueOf(int intValue) {
        if (intValue < 0 || intValue >= ELEMENTS.length) {
            return null;
        }
        return ELEMENTS[intValue];
    }

    public static List<DereferenceAliasesPolicy> values() {
        return IMMUTABLE_ELEMENTS;
    }

    private static DereferenceAliasesPolicy register(int intValue, String name) {
        DereferenceAliasesPolicy t;
        DereferenceAliasesPolicy.ELEMENTS[intValue] = t = new DereferenceAliasesPolicy(intValue, name);
        return t;
    }

    private DereferenceAliasesPolicy(int intValue, String name) {
        this.intValue = intValue;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DereferenceAliasesPolicy) {
            return this.intValue == ((DereferenceAliasesPolicy)obj).intValue;
        }
        return false;
    }

    public int hashCode() {
        return this.intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public String toString() {
        return this.name;
    }
}

