/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.SubstringReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Pair;
import org.forgerock.util.Reject;

public final class DN
implements Iterable<RDN>,
Comparable<DN> {
    static final byte NORMALIZED_RDN_SEPARATOR = 0;
    static final byte NORMALIZED_AVA_SEPARATOR = 1;
    static final byte NORMALIZED_ESC_BYTE = 2;
    static final char RDN_CHAR_SEPARATOR = ',';
    static final char AVA_CHAR_SEPARATOR = '+';
    private static final DN ROOT_DN = new DN(CoreSchema.getInstance(), null, null);
    private static final int DN_CACHE_SIZE = 32;
    private static final ThreadLocal<Map<String, DN>> CACHE = new ThreadLocal<Map<String, DN>>(){

        @Override
        protected Map<String, DN> initialValue() {
            return new LinkedHashMap<String, DN>(32, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, DN> eldest) {
                    return this.size() > 32;
                }
            };
        }
    };
    private final RDN rdn;
    private DN parent;
    private final int size;
    private int hashCode = -1;
    private ByteString normalizedDN;
    private String stringValue;
    private final Schema schema;

    public static String escapeAttributeValue(Object attributeValue) {
        Reject.ifNull(attributeValue);
        String s = String.valueOf(attributeValue);
        StringBuilder builder = new StringBuilder(s.length());
        AVA.escapeAttributeValue(s, builder);
        return builder.toString();
    }

    public static DN format(String template, Object ... attributeValues) {
        return DN.format(template, Schema.getDefaultSchema(), attributeValues);
    }

    public static DN format(String template, Schema schema, Object ... attributeValues) {
        String[] attributeValueStrings = new String[attributeValues.length];
        for (int i = 0; i < attributeValues.length; ++i) {
            attributeValueStrings[i] = DN.escapeAttributeValue(attributeValues[i]);
        }
        String dnString = String.format(template, attributeValueStrings);
        return DN.valueOf(dnString, schema);
    }

    public static DN rootDN() {
        return ROOT_DN;
    }

    public static DN valueOf(String dn) {
        return DN.valueOf(dn, Schema.getDefaultSchema());
    }

    public static DN valueOf(String dn, Schema schema) {
        Reject.ifNull(dn, schema);
        if (dn.length() == 0) {
            return ROOT_DN;
        }
        Map<String, DN> cache = CACHE.get();
        DN cachedDN = cache.get(dn);
        if (cachedDN != null && cachedDN.schema == schema) {
            return cachedDN;
        }
        return DN.decode(new SubstringReader(dn), schema, cache);
    }

    public static DN valueOf(ByteString dn) {
        return DN.valueOf(dn.toString());
    }

    private static DN decode(SubstringReader reader, Schema schema, Map<String, DN> cache) {
        RDN rdn;
        reader.skipWhitespaces();
        if (reader.remaining() == 0) {
            return ROOT_DN;
        }
        try {
            rdn = RDN.decode(reader, schema);
        }
        catch (UnknownSchemaElementException e) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_DN_TYPE_NOT_FOUND.get(reader.getString(), e.getMessageObject()));
        }
        LinkedList<Pair<Integer, RDN>> parentRDNs = null;
        DN parent = null;
        while (reader.remaining() > 0 && reader.read() == ',') {
            reader.skipWhitespaces();
            if (reader.remaining() == 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_NO_NAME.get(reader.getString()));
            }
            reader.mark();
            String parentString = reader.read(reader.remaining());
            parent = cache.get(parentString);
            if (parent != null) break;
            reader.reset();
            if (parentRDNs == null) {
                parentRDNs = new LinkedList<Pair<Integer, RDN>>();
            }
            parentRDNs.add(Pair.of(reader.pos(), RDN.decode(reader, schema)));
        }
        if (parent == null) {
            parent = ROOT_DN;
        }
        if (parentRDNs != null) {
            Iterator iter = parentRDNs.descendingIterator();
            int parentsLeft = parentRDNs.size();
            while (iter.hasNext()) {
                Pair parentRDN = (Pair)iter.next();
                parent = new DN(schema, parent, (RDN)parentRDN.getSecond());
                if (parentsLeft-- >= 32) continue;
                cache.put(reader.getString().substring((Integer)parentRDN.getFirst()), parent);
            }
        }
        return new DN(schema, parent, rdn);
    }

    private DN(Schema schema, DN parent, RDN rdn) {
        this(schema, parent, rdn, parent != null ? parent.size + 1 : 0);
    }

    private DN(Schema schema, DN parent, RDN rdn, int size) {
        this.schema = schema;
        this.parent = parent;
        this.rdn = rdn;
        this.size = size;
        this.stringValue = rdn == null ? "" : null;
    }

    public DN child(DN dn) {
        Reject.ifNull(dn);
        if (dn.isRootDN()) {
            return this;
        }
        if (this.isRootDN()) {
            return dn;
        }
        RDN[] rdns = new RDN[dn.size()];
        int i = rdns.length;
        DN next = dn;
        while (next.rdn != null) {
            rdns[--i] = next.rdn;
            next = next.parent;
        }
        DN newDN = this;
        for (i = 0; i < rdns.length; ++i) {
            newDN = new DN(this.schema, newDN, rdns[i]);
        }
        return newDN;
    }

    public DN child(RDN rdn) {
        Reject.ifNull(rdn);
        return new DN(this.schema, this, rdn);
    }

    public DN child(String dn) {
        Reject.ifNull(dn);
        return this.child(DN.valueOf(dn));
    }

    public DN child(String attributeType, Object attributeValue) {
        return this.child(new RDN(attributeType, attributeValue));
    }

    @Override
    public int compareTo(DN dn) {
        return this.toNormalizedByteString().compareTo(dn.toNormalizedByteString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DN) {
            DN otherDN = (DN)obj;
            return this.toNormalizedByteString().equals(otherDN.toNormalizedByteString());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.toNormalizedByteString().hashCode();
        }
        return this.hashCode;
    }

    public boolean isChildOf(DN dn) {
        return dn.equals(this.parent);
    }

    public boolean isChildOf(String dn) {
        return this.isChildOf(DN.valueOf(dn));
    }

    public boolean isInScopeOf(DN dn, SearchScope scope) {
        switch (scope.asEnum()) {
            case BASE_OBJECT: {
                return this.equals(dn);
            }
            case SINGLE_LEVEL: {
                return this.isChildOf(dn);
            }
            case SUBORDINATES: {
                return this.isSubordinateOrEqualTo(dn) && !this.equals(dn);
            }
            case WHOLE_SUBTREE: {
                return this.isSubordinateOrEqualTo(dn);
            }
        }
        return false;
    }

    public boolean isInScopeOf(String dn, SearchScope scope) {
        return this.isInScopeOf(DN.valueOf(dn), scope);
    }

    public boolean isParentOf(DN dn) {
        return this.equals(dn.parent);
    }

    public boolean isParentOf(String dn) {
        return this.isParentOf(DN.valueOf(dn));
    }

    public boolean isRootDN() {
        return this.size == 0;
    }

    public boolean isSubordinateOrEqualTo(DN dn) {
        if (this.size < dn.size) {
            return false;
        }
        if (this.size == dn.size) {
            return this.equals(dn);
        }
        return this.parent(this.size - dn.size).equals(dn);
    }

    public boolean isSubordinateOrEqualTo(String dn) {
        return this.isSubordinateOrEqualTo(DN.valueOf(dn));
    }

    public boolean isSuperiorOrEqualTo(DN dn) {
        if (this.size > dn.size) {
            return false;
        }
        if (this.size == dn.size) {
            return this.equals(dn);
        }
        return dn.parent(dn.size - this.size).equals(this);
    }

    public boolean isSuperiorOrEqualTo(String dn) {
        return this.isSuperiorOrEqualTo(DN.valueOf(dn));
    }

    @Override
    public Iterator<RDN> iterator() {
        return new Iterator<RDN>(){
            private DN dn;
            {
                this.dn = DN.this;
            }

            @Override
            public boolean hasNext() {
                return this.dn.rdn != null;
            }

            @Override
            public RDN next() {
                if (this.dn.rdn == null) {
                    throw new NoSuchElementException();
                }
                RDN rdn = this.dn.rdn;
                this.dn = this.dn.parent;
                return rdn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public DN localName(int index) {
        DN localName;
        Reject.ifFalse(index >= 0, "index less than zero");
        if (index == 0) {
            return ROOT_DN;
        }
        if (index >= this.size) {
            return this;
        }
        DN nextLocalName = localName = new DN(this.schema, null, this.rdn, index);
        DN lastDN = this.parent;
        for (int i = index - 1; i > 0; --i) {
            nextLocalName = nextLocalName.parent = new DN(this.schema, null, lastDN.rdn, i);
            lastDN = lastDN.parent;
        }
        nextLocalName.parent = ROOT_DN;
        return localName;
    }

    public DN parent() {
        return this.parent;
    }

    public DN parent(int index) {
        Reject.ifTrue(index < 0, "index less than zero");
        if (index > this.size) {
            return null;
        }
        DN parentDN = this;
        for (int i = 0; parentDN != null && i < index; ++i) {
            parentDN = parentDN.parent;
        }
        return parentDN;
    }

    public RDN rdn() {
        return this.rdn;
    }

    public RDN rdn(int index) {
        DN parentDN = this.parent(index);
        return parentDN != null ? parentDN.rdn : null;
    }

    public DN rename(DN fromDN, DN toDN) {
        Reject.ifNull(fromDN, toDN);
        if (!this.isSubordinateOrEqualTo(fromDN)) {
            return this;
        }
        if (this.equals(fromDN)) {
            return toDN;
        }
        return toDN.child(this.localName(this.size - fromDN.size));
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.rdn);
            DN dn = this.parent;
            while (dn.rdn != null) {
                builder.append(',');
                if (dn.stringValue != null) {
                    builder.append(dn.stringValue);
                    break;
                }
                builder.append(dn.rdn);
                dn = dn.parent;
            }
            this.stringValue = builder.toString();
        }
        return this.stringValue;
    }

    public ByteString toNormalizedByteString() {
        if (this.normalizedDN == null) {
            if (this.rdn == null) {
                this.normalizedDN = ByteString.empty();
            } else {
                ByteStringBuilder builder = new ByteStringBuilder(this.size * 8);
                if (this.parent.normalizedDN != null) {
                    builder.appendBytes(this.parent.normalizedDN);
                } else {
                    for (int i = this.size() - 1; i > 0; --i) {
                        this.parent(i).rdn().toNormalizedByteString(builder);
                    }
                }
                this.rdn.toNormalizedByteString(builder);
                this.normalizedDN = builder.toByteString();
            }
        }
        return this.normalizedDN;
    }

    public String toNormalizedUrlSafeString() {
        if (this.rdn() == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = this.size() - 1;
        this.parent(i).rdn().toNormalizedUrlSafeString(builder);
        --i;
        while (i >= 0) {
            RDN rdn = this.parent(i).rdn();
            if (rdn.size() != 0) {
                builder.append(',');
            }
            rdn.toNormalizedUrlSafeString(builder);
            --i;
        }
        return builder.toString();
    }

    public UUID toUUID() {
        ByteString normDN = this.toNormalizedByteString();
        if (!normDN.isEmpty()) {
            normDN = normDN.subSequence(1, normDN.length());
        }
        return UUID.nameUUIDFromBytes(normDN.toByteArray());
    }
}

