/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.Collections2;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Functions;
import org.forgerock.opendj.ldap.GeneralizedTime;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.Function;

public final class AttributeParser {
    private final Attribute attribute;
    private Schema schema;

    public static AttributeParser parseAttribute(Attribute attribute) {
        return new AttributeParser(attribute);
    }

    private static boolean isEmpty(Attribute attribute) {
        return attribute == null || attribute.isEmpty();
    }

    private AttributeParser(Attribute attribute) {
        this.attribute = attribute;
    }

    public <T, E extends Exception> T as(Function<ByteString, ? extends T, E> f) throws E {
        return this.as(f, null);
    }

    public <T, E extends Exception> T as(Function<ByteString, ? extends T, E> f, T defaultValue) throws E {
        if (!AttributeParser.isEmpty(this.attribute)) {
            return f.apply(this.attribute.firstValue());
        }
        return defaultValue;
    }

    public AttributeDescription asAttributeDescription() {
        return this.asAttributeDescription((AttributeDescription)null);
    }

    public AttributeDescription asAttributeDescription(AttributeDescription defaultValue) {
        return this.as(Functions.byteStringToAttributeDescription(this.getSchema()), defaultValue);
    }

    public AttributeDescription asAttributeDescription(String defaultValue) {
        return this.asAttributeDescription(AttributeDescription.valueOf(defaultValue, this.getSchema()));
    }

    public Boolean asBoolean() {
        return AttributeParser.isEmpty(this.attribute) ? null : Boolean.valueOf(this.asBoolean(false));
    }

    public boolean asBoolean(boolean defaultValue) {
        return this.as(Functions.byteStringToBoolean(), defaultValue);
    }

    public ByteString asByteString() {
        return this.asByteString(null);
    }

    public ByteString asByteString(ByteString defaultValue) {
        return this.as(Functions.identityFunction(), defaultValue);
    }

    public X509Certificate asCertificate() {
        return this.asCertificate(null);
    }

    public X509Certificate asCertificate(X509Certificate defaultValue) {
        return this.as(Functions.byteStringToCertificate(), defaultValue);
    }

    public DN asDN() {
        return this.asDN((DN)null);
    }

    public DN asDN(DN defaultValue) {
        return this.as(Functions.byteStringToDN(this.getSchema()), defaultValue);
    }

    public DN asDN(String defaultValue) {
        return this.asDN(DN.valueOf(defaultValue, this.getSchema()));
    }

    public GeneralizedTime asGeneralizedTime() {
        return this.asGeneralizedTime(null);
    }

    public GeneralizedTime asGeneralizedTime(GeneralizedTime defaultValue) {
        return this.as(Functions.byteStringToGeneralizedTime(), defaultValue);
    }

    public Integer asInteger() {
        return AttributeParser.isEmpty(this.attribute) ? null : Integer.valueOf(this.asInteger(0));
    }

    public int asInteger(int defaultValue) {
        return this.as(Functions.byteStringToInteger(), defaultValue);
    }

    public Long asLong() {
        return AttributeParser.isEmpty(this.attribute) ? null : Long.valueOf(this.asLong(0L));
    }

    public long asLong(long defaultValue) {
        return this.as(Functions.byteStringToLong(), defaultValue);
    }

    public <T, E extends Exception> Set<T> asSetOf(Function<ByteString, ? extends T, E> f, Collection<? extends T> defaultValues) throws E {
        if (!AttributeParser.isEmpty(this.attribute)) {
            LinkedHashSet<T> result = new LinkedHashSet<T>(this.attribute.size());
            for (ByteString b : this.attribute) {
                result.add(f.apply(b));
            }
            return result;
        }
        if (defaultValues != null) {
            return new LinkedHashSet<T>(defaultValues);
        }
        return new LinkedHashSet(0);
    }

    @SafeVarargs
    public final <T, E extends Exception> Set<T> asSetOf(Function<ByteString, ? extends T, E> f, T ... defaultValues) throws E {
        return this.asSetOf(f, (Collection<? extends T>)Arrays.asList(defaultValues));
    }

    public Set<AttributeDescription> asSetOfAttributeDescription() {
        return this.asSetOfAttributeDescription(Collections.emptySet());
    }

    public Set<AttributeDescription> asSetOfAttributeDescription(AttributeDescription ... defaultValues) {
        return this.asSetOfAttributeDescription(Arrays.asList(defaultValues));
    }

    public Set<AttributeDescription> asSetOfAttributeDescription(Collection<AttributeDescription> defaultValues) {
        return this.asSetOf(Functions.byteStringToAttributeDescription(), defaultValues);
    }

    public Set<AttributeDescription> asSetOfAttributeDescription(String ... defaultValues) {
        return this.asSetOfAttributeDescription(Collections2.transformedCollection(Arrays.asList(defaultValues), Functions.stringToAttributeDescription(this.getSchema()), null));
    }

    public Set<Boolean> asSetOfBoolean(Boolean ... defaultValues) {
        return this.asSetOfBoolean(Arrays.asList(defaultValues));
    }

    public Set<Boolean> asSetOfBoolean(Collection<Boolean> defaultValues) {
        return this.asSetOf(Functions.byteStringToBoolean(), defaultValues);
    }

    public Set<ByteString> asSetOfByteString(ByteString ... defaultValues) {
        return this.asSetOfByteString(Arrays.asList(defaultValues));
    }

    public Set<ByteString> asSetOfByteString(Collection<ByteString> defaultValues) {
        return this.asSetOf(Functions.identityFunction(), defaultValues);
    }

    public Set<X509Certificate> asSetOfCertificate() {
        return this.asSetOf(Functions.byteStringToCertificate(), new X509Certificate[0]);
    }

    public Set<DN> asSetOfDN() {
        return this.asSetOfDN(Collections.emptySet());
    }

    public Set<DN> asSetOfDN(Collection<DN> defaultValues) {
        return this.asSetOf(Functions.byteStringToDN(), defaultValues);
    }

    public Set<DN> asSetOfDN(DN ... defaultValues) {
        return this.asSetOfDN(Arrays.asList(defaultValues));
    }

    public Set<DN> asSetOfDN(String ... defaultValues) {
        return this.asSetOfDN(Collections2.transformedCollection(Arrays.asList(defaultValues), Functions.stringToDN(this.getSchema()), null));
    }

    public Set<GeneralizedTime> asSetOfGeneralizedTime(Collection<GeneralizedTime> defaultValues) {
        return this.asSetOf(Functions.byteStringToGeneralizedTime(), defaultValues);
    }

    public Set<GeneralizedTime> asSetOfGeneralizedTime(GeneralizedTime ... defaultValues) {
        return this.asSetOfGeneralizedTime(Arrays.asList(defaultValues));
    }

    public Set<Integer> asSetOfInteger(Collection<Integer> defaultValues) {
        return this.asSetOf(Functions.byteStringToInteger(), defaultValues);
    }

    public Set<Integer> asSetOfInteger(Integer ... defaultValues) {
        return this.asSetOfInteger(Arrays.asList(defaultValues));
    }

    public Set<Long> asSetOfLong(Collection<Long> defaultValues) {
        return this.asSetOf(Functions.byteStringToLong(), defaultValues);
    }

    public Set<Long> asSetOfLong(Long ... defaultValues) {
        return this.asSetOfLong(Arrays.asList(defaultValues));
    }

    public Set<String> asSetOfString(Collection<String> defaultValues) {
        return this.asSetOf(Functions.byteStringToString(), defaultValues);
    }

    public Set<String> asSetOfString(String ... defaultValues) {
        return this.asSetOfString(Arrays.asList(defaultValues));
    }

    public String asString() {
        return this.asString(null);
    }

    public String asString(String defaultValue) {
        return this.as(Functions.byteStringToString(), defaultValue);
    }

    public AttributeParser requireValue() {
        if (AttributeParser.isEmpty(this.attribute)) {
            String attributeName = this.attribute.getAttributeDescriptionAsString();
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTRIBUTE_PARSER_MISSING_ATTRIBUTE.get(attributeName));
        }
        return this;
    }

    public AttributeParser usingSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    private Schema getSchema() {
        return this.schema == null ? Schema.getDefaultSchema() : this.schema;
    }
}

