/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.ASN1BufferReader;
import org.forgerock.opendj.grizzly.ASN1BufferWriter;
import org.forgerock.opendj.grizzly.ConnectionSecurityLayerFilter;
import org.forgerock.opendj.grizzly.GrizzlyLDAPListener;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.grizzly.LDAPBaseFilter;
import org.forgerock.opendj.io.AbstractLDAPMessageHandler;
import org.forgerock.opendj.io.LDAPReader;
import org.forgerock.opendj.io.LDAPWriter;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConnectionSecurityLayer;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.ssl.SSLUtils;

final class LDAPServerFilter
extends LDAPBaseFilter {
    private static final LDAPWrite<IntermediateResponse> INTERMEDIATE = new LDAPWrite<IntermediateResponse>(){

        @Override
        public void perform(LDAPWriter<ASN1BufferWriter> writer, int messageID, IntermediateResponse resp) throws IOException {
            writer.writeIntermediateResponse(messageID, resp);
        }
    };
    private static final Object[][] CIPHER_KEY_SIZES = new Object[][]{{"_WITH_AES_256_CBC_", 256}, {"_WITH_CAMELLIA_256_CBC_", 256}, {"_WITH_AES_256_GCM_", 256}, {"_WITH_3DES_EDE_CBC_", 112}, {"_WITH_AES_128_GCM_", 128}, {"_WITH_SEED_CBC_", 128}, {"_WITH_CAMELLIA_128_CBC_", 128}, {"_WITH_AES_128_CBC_", 128}, {"_WITH_IDEA_CBC_", 128}, {"_WITH_RC4_128_", 128}, {"_WITH_FORTEZZA_CBC_", 96}, {"_WITH_DES_CBC_", 56}, {"_WITH_RC4_56_", 56}, {"_WITH_RC2_CBC_40_", 40}, {"_WITH_DES_CBC_40_", 40}, {"_WITH_RC4_40_", 40}, {"_WITH_DES40_CBC_", 40}, {"_WITH_NULL_", 0}};
    private static final int DEFAULT_MAX_REQUEST_SIZE = 0x500000;
    private static final Attribute<ClientContextImpl> LDAP_CONNECTION_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("LDAPServerConnection");
    private static final Attribute<ServerRequestHandler> REQUEST_HANDLER_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("ServerRequestHandler");
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final SSLEngineConfigurator DUMMY_SSL_ENGINE_CONFIGURATOR;
    private final GrizzlyLDAPListener listener;

    LDAPServerFilter(GrizzlyLDAPListener listener, DecodeOptions options, int maxASN1ElementSize) {
        super(options, maxASN1ElementSize <= 0 ? 0x500000 : maxASN1ElementSize);
        this.listener = listener;
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        LDAPServerFilter.exceptionOccurred(ctx.getConnection(), error);
    }

    private static void exceptionOccurred(Connection<?> connection, Throwable error) {
        ClientContextImpl clientContext = LDAP_CONNECTION_ATTR.remove(connection);
        if (clientContext != null) {
            clientContext.handleException(error);
        }
    }

    @Override
    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        Options options = this.listener.getLDAPListenerOptions();
        GrizzlyUtils.configureConnection(connection, logger, options);
        try {
            ClientContextImpl clientContext = new ClientContextImpl(connection);
            ServerConnection<Integer> serverConn = this.listener.getConnectionFactory().handleAccept(clientContext);
            clientContext.setServerConnection(serverConn);
            LDAP_CONNECTION_ATTR.set(connection, clientContext);
        }
        catch (LdapException e) {
            connection.close();
        }
        return ctx.getStopAction();
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        ClientContextImpl clientContext = LDAP_CONNECTION_ATTR.remove(ctx.getConnection());
        if (clientContext != null) {
            clientContext.handleClose(-1, null);
        }
        return ctx.getStopAction();
    }

    @Override
    final void handleReadException(FilterChainContext ctx, IOException e) {
        this.exceptionOccurred(ctx, e);
    }

    @Override
    final LDAPBaseFilter.LDAPBaseHandler getLDAPHandler(FilterChainContext ctx) {
        Connection connection = ctx.getConnection();
        ServerRequestHandler handler = REQUEST_HANDLER_ATTR.get(connection);
        if (handler == null) {
            LDAPReader<ASN1BufferReader> reader = GrizzlyUtils.createReader(this.decodeOptions, this.maxASN1ElementSize, connection.getTransport().getMemoryManager());
            handler = new ServerRequestHandler(connection, reader);
            REQUEST_HANDLER_ATTR.set(connection, handler);
        }
        return handler;
    }

    static {
        try {
            DUMMY_SSL_ENGINE_CONFIGURATOR = new SSLEngineConfigurator(new SSLContextBuilder().setTrustManager(TrustManagers.distrustAll()).getSSLContext());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Unable to create Dummy SSL Engine Configurator", e);
        }
    }

    private static final class ServerRequestHandler
    extends AbstractLDAPMessageHandler
    implements LDAPBaseFilter.LDAPBaseHandler {
        private final Connection<?> connection;
        private final LDAPReader<ASN1BufferReader> reader;

        ServerRequestHandler(Connection<?> connection, LDAPReader<ASN1BufferReader> reader) {
            this.connection = connection;
            this.reader = reader;
        }

        @Override
        public LDAPReader<ASN1BufferReader> getReader() {
            return this.reader;
        }

        @Override
        public void abandonRequest(int messageID, AbandonRequest request) {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get(this.connection);
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                conn.handleAbandon(messageID, request);
            }
        }

        @Override
        public void addRequest(int messageID, AddRequest request) {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get(this.connection);
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                AddHandler handler = new AddHandler(clientContext, messageID);
                conn.handleAdd(messageID, request, handler, handler);
            }
        }

        @Override
        public void bindRequest(int messageID, int version, GenericBindRequest request) {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get(this.connection);
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                BindHandler handler = new BindHandler(clientContext, messageID);
                conn.handleBind(messageID, version, request, handler, handler);
            }
        }

        @Override
        public void compareRequest(int messageID, CompareRequest request) {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get(this.connection);
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                CompareHandler handler = new CompareHandler(clientContext, messageID);
                conn.handleCompare(messageID, request, handler, handler);
            }
        }

        @Override
        public void deleteRequest(int messageID, DeleteRequest request) {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get(this.connection);
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                DeleteHandler handler = new DeleteHandler(clientContext, messageID);
                conn.handleDelete(messageID, request, handler, handler);
            }
        }

        @Override
        public <R extends ExtendedResult> void extendedRequest(int messageID, ExtendedRequest<R> request) {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get(this.connection);
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                ExtendedHandler handler = new ExtendedHandler(clientContext, messageID);
                conn.handleExtendedRequest(messageID, request, handler, handler);
            }
        }

        @Override
        public void modifyDNRequest(int messageID, ModifyDNRequest request) {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get(this.connection);
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                ModifyDNHandler handler = new ModifyDNHandler(clientContext, messageID);
                conn.handleModifyDN(messageID, request, handler, handler);
            }
        }

        @Override
        public void modifyRequest(int messageID, ModifyRequest request) {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get(this.connection);
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                ModifyHandler handler = new ModifyHandler(clientContext, messageID);
                conn.handleModify(messageID, request, handler, handler);
            }
        }

        @Override
        public void searchRequest(int messageID, SearchRequest request) {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get(this.connection);
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                SearchHandler handler = new SearchHandler(clientContext, messageID);
                conn.handleSearch(messageID, request, handler, handler, handler);
            }
        }

        @Override
        public void unbindRequest(int messageID, UnbindRequest request) {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.remove(this.connection);
            if (clientContext != null) {
                clientContext.handleClose(messageID, request);
            }
        }

        @Override
        public void unrecognizedMessage(int messageID, byte messageTag, ByteString messageBytes) {
            LDAPServerFilter.exceptionOccurred(this.connection, this.newUnsupportedMessageException(messageID, messageTag, messageBytes));
        }
    }

    private static final class SearchHandler
    extends AbstractHandler<Result>
    implements SearchResultHandler {
        private SearchHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public boolean handleEntry(SearchResultEntry entry) {
            this.writeMessage(new LDAPWrite<SearchResultEntry>(){

                @Override
                public void perform(LDAPWriter<ASN1BufferWriter> writer, int messageID, SearchResultEntry sre) throws IOException {
                    writer.writeSearchResultEntry(messageID, sre);
                }
            }, entry);
            return true;
        }

        @Override
        public void handleException(LdapException error) {
            this.handleResult(error.getResult());
        }

        @Override
        public boolean handleReference(SearchResultReference reference) {
            this.writeMessage(new LDAPWrite<SearchResultReference>(){

                @Override
                public void perform(LDAPWriter<ASN1BufferWriter> writer, int messageID, SearchResultReference ref) throws IOException {
                    writer.writeSearchResultReference(messageID, ref);
                }
            }, reference);
            return true;
        }

        @Override
        protected void writeResult(LDAPWriter<ASN1BufferWriter> writer, Result result) throws IOException {
            writer.writeSearchResult(this.messageID, result);
        }
    }

    private static final class ModifyHandler
    extends AbstractHandler<Result> {
        private ModifyHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleException(LdapException error) {
            this.handleResult(error.getResult());
        }

        @Override
        protected void writeResult(LDAPWriter<ASN1BufferWriter> writer, Result result) throws IOException {
            writer.writeModifyResult(this.messageID, result);
        }
    }

    private static final class ModifyDNHandler
    extends AbstractHandler<Result> {
        private ModifyDNHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleException(LdapException error) {
            this.handleResult(error.getResult());
        }

        @Override
        protected void writeResult(LDAPWriter<ASN1BufferWriter> writer, Result result) throws IOException {
            writer.writeModifyDNResult(this.messageID, result);
        }
    }

    private static final class ExtendedHandler<R extends ExtendedResult>
    extends AbstractHandler<R> {
        private ExtendedHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleException(LdapException error) {
            Result result = error.getResult();
            if (result instanceof ExtendedResult) {
                this.handleResult((ExtendedResult)result);
            } else {
                GenericExtendedResult newResult = Responses.newGenericExtendedResult(result.getResultCode());
                newResult.setDiagnosticMessage(result.getDiagnosticMessage());
                newResult.setMatchedDN(result.getMatchedDN());
                newResult.setCause(result.getCause());
                for (Control control : result.getControls()) {
                    newResult.addControl(control);
                }
                this.handleResult(newResult);
            }
        }

        @Override
        public void handleResult(ExtendedResult result) {
            this.writeMessage(new LDAPWrite<ExtendedResult>(){

                @Override
                public void perform(LDAPWriter<ASN1BufferWriter> writer, int messageID, ExtendedResult message) throws IOException {
                    writer.writeExtendedResult(messageID, message);
                }
            }, result);
        }

        @Override
        protected void writeResult(LDAPWriter<ASN1BufferWriter> ldapWriter, R result) throws IOException {
        }
    }

    private static final class DeleteHandler
    extends AbstractHandler<Result> {
        private DeleteHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleException(LdapException error) {
            this.handleResult(error.getResult());
        }

        @Override
        protected void writeResult(LDAPWriter<ASN1BufferWriter> writer, Result result) throws IOException {
            writer.writeDeleteResult(this.messageID, result);
        }
    }

    private static final class CompareHandler
    extends AbstractHandler<CompareResult> {
        private CompareHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleException(LdapException error) {
            Result result = error.getResult();
            if (result instanceof CompareResult) {
                this.handleResult((CompareResult)result);
            } else {
                CompareResult newResult = Responses.newCompareResult(result.getResultCode());
                this.populateNewResultFromResult(newResult, result);
                this.handleResult(newResult);
            }
        }

        @Override
        protected void writeResult(LDAPWriter<ASN1BufferWriter> writer, CompareResult result) throws IOException {
            writer.writeCompareResult(this.messageID, result);
        }
    }

    private static final class ClientContextImpl
    implements LDAPClientContext {
        private final Connection<?> connection;
        private final AtomicBoolean isClosed = new AtomicBoolean();
        private ServerConnection<Integer> serverConnection;

        private ClientContextImpl(Connection<?> connection) {
            this.connection = connection;
        }

        @Override
        public void disconnect() {
            this.disconnect0(null, null);
        }

        @Override
        public void disconnect(ResultCode resultCode, String message) {
            Reject.ifNull(resultCode);
            GenericExtendedResult notification = Responses.newGenericExtendedResult(resultCode).setOID("1.3.6.1.4.1.1466.20036").setDiagnosticMessage(message);
            this.sendUnsolicitedNotification(notification);
            this.disconnect0(resultCode, message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enableConnectionSecurityLayer(ConnectionSecurityLayer layer) {
            ClientContextImpl clientContextImpl = this;
            synchronized (clientContextImpl) {
                this.installFilter(new ConnectionSecurityLayerFilter(layer, this.connection.getTransport().getMemoryManager()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enableTLS(SSLContext sslContext, String[] protocols, String[] suites, boolean wantClientAuth, boolean needClientAuth) {
            Reject.ifNull(sslContext);
            ClientContextImpl clientContextImpl = this;
            synchronized (clientContextImpl) {
                if (this.isTLSEnabled()) {
                    throw new IllegalStateException("TLS already enabled");
                }
                SSLEngineConfigurator sslEngineConfigurator = new SSLEngineConfigurator(sslContext, false, false, false);
                sslEngineConfigurator.setEnabledCipherSuites(suites);
                sslEngineConfigurator.setEnabledProtocols(protocols);
                sslEngineConfigurator.setWantClientAuth(wantClientAuth);
                sslEngineConfigurator.setNeedClientAuth(needClientAuth);
                this.installFilter(new SSLFilter(sslEngineConfigurator, DUMMY_SSL_ENGINE_CONFIGURATOR));
            }
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return (InetSocketAddress)this.connection.getLocalAddress();
        }

        @Override
        public InetSocketAddress getPeerAddress() {
            return (InetSocketAddress)this.connection.getPeerAddress();
        }

        @Override
        public int getSecurityStrengthFactor() {
            SSLSession sslSession = this.getSSLSession();
            if (sslSession != null) {
                String cipherString = sslSession.getCipherSuite();
                for (Object[] cipher : CIPHER_KEY_SIZES) {
                    if (!cipherString.contains((String)cipher[0])) continue;
                    return (Integer)cipher[1];
                }
            }
            return 0;
        }

        @Override
        public SSLSession getSSLSession() {
            SSLEngine sslEngine = SSLUtils.getSSLEngine(this.connection);
            return sslEngine != null ? sslEngine.getSession() : null;
        }

        @Override
        public boolean isClosed() {
            return this.isClosed.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendUnsolicitedNotification(ExtendedResult notification) {
            LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter();
            try {
                writer.writeExtendedResult(0, notification);
                this.connection.write(writer.getASN1Writer().getBuffer(), null);
            }
            catch (IOException ioe) {
                this.handleException(ioe);
            }
            finally {
                GrizzlyUtils.recycleWriter(writer);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LDAPClientContext(");
            builder.append(this.getLocalAddress());
            builder.append(',');
            builder.append(this.getPeerAddress());
            builder.append(')');
            return builder.toString();
        }

        public void write(LDAPWriter<ASN1BufferWriter> writer) {
            this.connection.write(writer.getASN1Writer().getBuffer(), null);
        }

        private void disconnect0(ResultCode resultCode, String message) {
            if (this.isClosed.compareAndSet(false, true)) {
                try {
                    if (this.serverConnection != null) {
                        this.serverConnection.handleConnectionDisconnected(resultCode, message);
                    }
                }
                finally {
                    this.connection.closeSilently();
                }
            }
        }

        private ServerConnection<Integer> getServerConnection() {
            return this.serverConnection;
        }

        private void handleClose(int messageID, UnbindRequest unbindRequest) {
            if (this.isClosed.compareAndSet(false, true)) {
                try {
                    if (this.serverConnection != null) {
                        this.serverConnection.handleConnectionClosed(messageID, unbindRequest);
                    }
                }
                finally {
                    if (unbindRequest != null) {
                        return;
                    }
                    this.connection.closeSilently();
                }
            }
        }

        private void handleException(Throwable error) {
            if (this.isClosed.compareAndSet(false, true)) {
                try {
                    if (this.serverConnection != null) {
                        this.serverConnection.handleConnectionError(error);
                    }
                }
                finally {
                    this.connection.closeSilently();
                }
            }
        }

        private void installFilter(Filter filter) {
            GrizzlyUtils.addFilterToConnection(filter, this.connection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isTLSEnabled() {
            ClientContextImpl clientContextImpl = this;
            synchronized (clientContextImpl) {
                FilterChain currentFilterChain = (FilterChain)this.connection.getProcessor();
                for (Filter filter : currentFilterChain) {
                    if (!(filter instanceof SSLFilter)) continue;
                    return true;
                }
                return false;
            }
        }

        private void setServerConnection(ServerConnection<Integer> serverConnection) {
            this.serverConnection = serverConnection;
        }
    }

    private static final class BindHandler
    extends AbstractHandler<BindResult> {
        private BindHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleException(LdapException error) {
            Result result = error.getResult();
            if (result instanceof BindResult) {
                this.handleResult((BindResult)result);
            } else {
                BindResult newResult = Responses.newBindResult(result.getResultCode());
                this.populateNewResultFromResult(newResult, result);
                this.handleResult(newResult);
            }
        }

        @Override
        protected void writeResult(LDAPWriter<ASN1BufferWriter> writer, BindResult result) throws IOException {
            writer.writeBindResult(this.messageID, result);
        }
    }

    private static final class AddHandler
    extends AbstractHandler<Result> {
        private AddHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleException(LdapException error) {
            this.handleResult(error.getResult());
        }

        @Override
        public void writeResult(LDAPWriter<ASN1BufferWriter> writer, Result result) throws IOException {
            writer.writeAddResult(this.messageID, result);
        }
    }

    private static abstract class AbstractHandler<R extends Result>
    implements IntermediateResponseHandler,
    LdapResultHandler<R> {
        protected final ClientContextImpl context;
        protected final int messageID;

        protected AbstractHandler(ClientContextImpl context, int messageID) {
            this.messageID = messageID;
            this.context = context;
        }

        @Override
        public void handleResult(R result) {
            this.defaultHandleResult(result);
        }

        @Override
        public final boolean handleIntermediateResponse(IntermediateResponse response) {
            this.writeMessage(INTERMEDIATE, response);
            return true;
        }

        private void defaultHandleResult(R result) {
            this.writeMessage(new LDAPWrite<R>(){

                @Override
                public void perform(LDAPWriter<ASN1BufferWriter> writer, int messageID, R res) throws IOException {
                    AbstractHandler.this.writeResult(writer, res);
                }
            }, result);
        }

        protected abstract void writeResult(LDAPWriter<ASN1BufferWriter> var1, R var2) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final <T> void writeMessage(LDAPWrite<T> ldapWrite, T message) {
            LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter();
            try {
                ldapWrite.perform(writer, this.messageID, message);
                this.context.write(writer);
            }
            catch (IOException ioe) {
                this.context.handleException(ioe);
            }
            finally {
                GrizzlyUtils.recycleWriter(writer);
            }
        }

        protected final void populateNewResultFromResult(R newResult, Result result) {
            newResult.setDiagnosticMessage(result.getDiagnosticMessage());
            newResult.setMatchedDN(result.getMatchedDN());
            newResult.setCause(result.getCause());
            for (Control control : result.getControls()) {
                newResult.addControl(control);
            }
        }
    }

    private static interface LDAPWrite<T> {
        public void perform(LDAPWriter<ASN1BufferWriter> var1, int var2, T var3) throws IOException;
    }
}

