/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import java.io.IOException;
import org.forgerock.opendj.grizzly.ASN1BufferReader;
import org.forgerock.opendj.io.LDAPMessageHandler;
import org.forgerock.opendj.io.LDAPReader;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

abstract class LDAPBaseFilter
extends BaseFilter {
    final int maxASN1ElementSize;
    final DecodeOptions decodeOptions;

    LDAPBaseFilter(DecodeOptions options, int maxASN1ElementSize) {
        this.decodeOptions = options;
        this.maxASN1ElementSize = maxASN1ElementSize;
    }

    @Override
    public final NextAction handleRead(FilterChainContext ctx) throws IOException {
        LDAPBaseHandler handler = this.getLDAPHandler(ctx);
        LDAPReader<ASN1BufferReader> reader = handler.getReader();
        ASN1BufferReader asn1Reader = reader.getASN1Reader();
        Buffer buffer = (Buffer)ctx.getMessage();
        asn1Reader.appendBytesRead(buffer);
        try {
            while (reader.hasMessageAvailable()) {
                reader.readMessage(handler);
            }
        }
        catch (IOException e) {
            this.handleReadException(ctx, e);
            throw e;
        }
        finally {
            asn1Reader.disposeBytesRead();
        }
        return ctx.getStopAction();
    }

    abstract void handleReadException(FilterChainContext var1, IOException var2);

    abstract LDAPBaseHandler getLDAPHandler(FilterChainContext var1);

    static interface LDAPBaseHandler
    extends LDAPMessageHandler {
        public LDAPReader<ASN1BufferReader> getReader();
    }
}

