/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.ASN1BufferReader;
import org.forgerock.opendj.grizzly.ASN1BufferWriter;
import org.forgerock.opendj.grizzly.ConnectionSecurityLayerFilter;
import org.forgerock.opendj.io.LDAP;
import org.forgerock.opendj.io.LDAPReader;
import org.forgerock.opendj.io.LDAPWriter;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.util.Options;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.ssl.SSLFilter;

final class GrizzlyUtils {
    private static final ThreadCache.CachedTypeIndex<LDAPWriter> WRITER_INDEX = ThreadCache.obtainIndex(LDAPWriter.class, 1);

    static FilterChain buildFilterChain(Processor<?> processor, Filter filter) {
        if (processor instanceof FilterChain) {
            return FilterChainBuilder.stateless().addAll((FilterChain)processor).add(filter).build();
        }
        return FilterChainBuilder.stateless().add(new TransportFilter()).add(filter).build();
    }

    static void addFilterToConnection(Filter filter, Connection<?> connection) {
        FilterChain currentChain = (FilterChain)connection.getProcessor();
        FilterChain newChain = GrizzlyUtils.addFilterToChain(filter, currentChain);
        connection.setProcessor(newChain);
    }

    static FilterChain addFilterToChain(Filter filter, FilterChain chain) {
        int indexToAddFilter = chain.size() - 1;
        if (filter instanceof SSLFilter) {
            for (int i = chain.size() - 2; i >= 0; --i) {
                if (chain.get(i) instanceof ConnectionSecurityLayerFilter) continue;
                indexToAddFilter = i + 1;
                break;
            }
        }
        return FilterChainBuilder.stateless().addAll(chain).add(indexToAddFilter, filter).build();
    }

    static LDAPReader<ASN1BufferReader> createReader(DecodeOptions decodeOptions, int maxASN1ElementSize, MemoryManager<?> memoryManager) {
        ASN1BufferReader asn1Reader = new ASN1BufferReader(maxASN1ElementSize, memoryManager);
        return LDAP.getReader(asn1Reader, decodeOptions);
    }

    static LDAPWriter<ASN1BufferWriter> getWriter() {
        LDAPWriter<ASN1BufferWriter> writer = ThreadCache.takeFromCache(WRITER_INDEX);
        if (writer == null) {
            writer = LDAP.getWriter(new ASN1BufferWriter());
        }
        ((ASN1BufferWriter)writer.getASN1Writer()).reset();
        return writer;
    }

    static void recycleWriter(LDAPWriter<ASN1BufferWriter> writer) {
        writer.getASN1Writer().recycle();
        ThreadCache.putToCache(WRITER_INDEX, writer);
    }

    static void configureConnection(Connection<?> connection, LocalizedLogger logger, Options options) {
        connection.configureBlocking(true);
        SocketChannel channel = (SocketChannel)((TCPNIOConnection)connection).getChannel();
        Socket socket = channel.socket();
        boolean tcpNoDelay = (Boolean)options.get(LDAPConnectionFactory.TCP_NO_DELAY);
        boolean keepAlive = (Boolean)options.get(LDAPConnectionFactory.SO_KEEPALIVE);
        boolean reuseAddress = (Boolean)options.get(LDAPConnectionFactory.SO_REUSE_ADDRESS);
        int linger = (Integer)options.get(LDAPConnectionFactory.SO_LINGER_IN_SECONDS);
        try {
            socket.setTcpNoDelay(tcpNoDelay);
        }
        catch (SocketException e) {
            logger.traceException((Throwable)e, "Unable to set TCP_NODELAY to %d on client connection", (Object)tcpNoDelay);
        }
        try {
            socket.setKeepAlive(keepAlive);
        }
        catch (SocketException e) {
            logger.traceException((Throwable)e, "Unable to set SO_KEEPALIVE to %d on client connection", (Object)keepAlive);
        }
        try {
            socket.setReuseAddress(reuseAddress);
        }
        catch (SocketException e) {
            logger.traceException((Throwable)e, "Unable to set SO_REUSEADDR to %d on client connection", (Object)reuseAddress);
        }
        try {
            if (linger < 0) {
                socket.setSoLinger(false, 0);
            } else {
                socket.setSoLinger(true, linger);
            }
        }
        catch (SocketException e) {
            logger.traceException((Throwable)e, "Unable to set SO_LINGER to %d on client connection", (Object)linger);
        }
    }

    private GrizzlyUtils() {
    }
}

