/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.grizzly.GrizzlyMessages;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.ASN1BufferWriter;
import org.forgerock.opendj.grizzly.GrizzlyLDAPConnectionFactory;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.io.LDAPWriter;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.TimeoutEventListener;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.spi.BindResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.ExtendedResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.LDAPConnectionImpl;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.opendj.ldap.spi.ResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.SearchResultLdapPromiseImpl;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.time.Duration;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;

final class GrizzlyLDAPConnection
implements LDAPConnectionImpl,
TimeoutEventListener {
    private static final SSLEngineConfigurator DUMMY_SSL_ENGINE_CONFIGURATOR;
    private static final LocalizedLogger logger;
    private final AtomicBoolean bindOrStartTLSInProgress = new AtomicBoolean(false);
    private final Connection<?> connection;
    private final AtomicInteger nextMsgID = new AtomicInteger(1);
    private final GrizzlyLDAPConnectionFactory factory;
    private final ConcurrentHashMap<Integer, ResultLdapPromiseImpl<?, ?>> pendingRequests = new ConcurrentHashMap();
    private final long requestTimeoutMS;
    private final Object stateLock = new Object();
    private Result connectionInvalidReason;
    private boolean failedDueToDisconnect;
    private boolean isClosed;
    private boolean isFailed;
    private List<ConnectionEventListener> listeners;

    GrizzlyLDAPConnection(Connection<?> connection, GrizzlyLDAPConnectionFactory factory) {
        this.connection = connection;
        this.factory = factory;
        Duration requestTimeout = factory.getLDAPOptions().get(LDAPConnectionFactory.REQUEST_TIMEOUT);
        this.requestTimeoutMS = requestTimeout.isUnlimited() ? 0L : requestTimeout.to(TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Void> abandonAsync(AbandonRequest request) {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
            }
        }
        catch (LdapException e) {
            return LdapPromises.newFailedLdapPromise(e);
        }
        ResultLdapPromiseImpl<?, ?> pendingRequest = this.pendingRequests.remove(request.getRequestID());
        if (pendingRequest == null) {
            return LdapPromises.newSuccessfulLdapPromise(null);
        }
        pendingRequest.cancel(false);
        return this.sendAbandonRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapPromise<Void> sendAbandonRequest(AbandonRequest request) {
        LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter();
        try {
            int messageID = this.nextMsgID.getAndIncrement();
            writer.writeAbandonRequest(messageID, request);
            this.connection.write(writer.getASN1Writer().getBuffer(), null);
            LdapPromise<Void> ldapPromise = LdapPromises.newSuccessfulLdapPromise(null, messageID);
            return ldapPromise;
        }
        catch (IOException e) {
            LdapPromise<Void> ldapPromise = LdapPromises.newFailedLdapPromise(this.adaptRequestIOException(e));
            return ldapPromise;
        }
        finally {
            GrizzlyUtils.recycleWriter(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        ResultLdapPromiseImpl<AddRequest, Result> promise = LdapPromises.newResultLdapPromise(messageID, request, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, promise);
            }
            try {
                LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter();
                try {
                    writer.writeAddRequest(messageID, request);
                    this.connection.write(writer.getASN1Writer().getBuffer(), null);
                }
                finally {
                    GrizzlyUtils.recycleWriter(writer);
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        boolean notifyErrorOccurred;
        boolean notifyClose;
        Reject.ifNull(listener);
        Object object = this.stateLock;
        synchronized (object) {
            notifyClose = this.isClosed;
            notifyErrorOccurred = this.isFailed;
            if (!this.isClosed) {
                if (this.listeners == null) {
                    this.listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
                }
                this.listeners.add(listener);
            }
        }
        if (notifyErrorOccurred) {
            listener.handleConnectionError(this.failedDueToDisconnect, LdapException.newLdapException(this.connectionInvalidReason));
        }
        if (notifyClose) {
            listener.handleConnectionClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        BindClient context;
        int messageID = this.nextMsgID.getAndIncrement();
        try {
            context = request.createBindClient(Connections.getHostString(this.factory.getSocketAddress()));
        }
        catch (LdapException e) {
            return LdapPromises.newFailedLdapPromise(e, messageID);
        }
        BindResultLdapPromiseImpl promise = LdapPromises.newBindLdapPromise(messageID, request, context, intermediateResponseHandler);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                if (!this.pendingRequests.isEmpty()) {
                    promise.setResultOrError(Responses.newBindResult(ResultCode.OPERATIONS_ERROR).setDiagnosticMessage("There are other operations pending on this connection"));
                    return promise;
                }
                if (!this.bindOrStartTLSInProgress.compareAndSet(false, true)) {
                    promise.setResultOrError(Responses.newBindResult(ResultCode.OPERATIONS_ERROR).setDiagnosticMessage("Bind or Start TLS operation in progress"));
                    return promise;
                }
                this.pendingRequests.put(messageID, promise);
            }
            try {
                LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter();
                try {
                    GenericBindRequest initialRequest = context.nextBindRequest();
                    writer.writeBindRequest(messageID, 3, initialRequest);
                    this.connection.write(writer.getASN1Writer().getBuffer(), null);
                }
                finally {
                    GrizzlyUtils.recycleWriter(writer);
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                this.bindOrStartTLSInProgress.set(false);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    @Override
    public void close() {
        this.close(Requests.newUnbindRequest(), null);
    }

    @Override
    public void close(UnbindRequest request, String reason) {
        Reject.ifNull(request);
        this.close(request, false, Responses.newResult(ResultCode.CLIENT_SIDE_USER_CANCELLED).setDiagnosticMessage(reason != null ? reason : "Connection closed by client"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        ResultLdapPromiseImpl<CompareRequest, CompareResult> promise = LdapPromises.newCompareLdapPromise(messageID, request, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, promise);
            }
            try {
                LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter();
                try {
                    writer.writeCompareRequest(messageID, request);
                    this.connection.write(writer.getASN1Writer().getBuffer(), null);
                }
                finally {
                    GrizzlyUtils.recycleWriter(writer);
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        ResultLdapPromiseImpl<DeleteRequest, Result> promise = LdapPromises.newResultLdapPromise(messageID, request, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, promise);
            }
            try {
                LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter();
                try {
                    writer.writeDeleteRequest(messageID, request);
                    this.connection.write(writer.getASN1Writer().getBuffer(), null);
                }
                finally {
                    GrizzlyUtils.recycleWriter(writer);
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        ExtendedResultLdapPromiseImpl<R> promise = LdapPromises.newExtendedLdapPromise(messageID, request, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                if ("1.3.6.1.4.1.1466.20037".equals(request.getOID())) {
                    if (!this.pendingRequests.isEmpty()) {
                        promise.setResultOrError(request.getResultDecoder().newExtendedErrorResult(ResultCode.OPERATIONS_ERROR, "", "There are pending operations on this connection"));
                        return promise;
                    }
                    if (this.isTLSEnabled()) {
                        promise.setResultOrError(request.getResultDecoder().newExtendedErrorResult(ResultCode.OPERATIONS_ERROR, "", "This connection is already TLS enabled"));
                        return promise;
                    }
                    if (!this.bindOrStartTLSInProgress.compareAndSet(false, true)) {
                        promise.setResultOrError(request.getResultDecoder().newExtendedErrorResult(ResultCode.OPERATIONS_ERROR, "", "Bind or Start TLS operation in progress"));
                        return promise;
                    }
                } else {
                    this.checkBindOrStartTLSInProgress();
                }
                this.pendingRequests.put(messageID, promise);
            }
            try {
                LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter();
                try {
                    writer.writeExtendedRequest(messageID, request);
                    this.connection.write(writer.getASN1Writer().getBuffer(), null);
                }
                finally {
                    GrizzlyUtils.recycleWriter(writer);
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                this.bindOrStartTLSInProgress.set(false);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isValid0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        ResultLdapPromiseImpl<ModifyRequest, Result> promise = LdapPromises.newResultLdapPromise(messageID, request, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, promise);
            }
            try {
                LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter();
                try {
                    writer.writeModifyRequest(messageID, request);
                    this.connection.write(writer.getASN1Writer().getBuffer(), null);
                }
                finally {
                    GrizzlyUtils.recycleWriter(writer);
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        ResultLdapPromiseImpl<ModifyDNRequest, Result> promise = LdapPromises.newResultLdapPromise(messageID, request, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, promise);
            }
            try {
                LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter();
                try {
                    writer.writeModifyDNRequest(messageID, request);
                    this.connection.write(writer.getASN1Writer().getBuffer(), null);
                }
                finally {
                    GrizzlyUtils.recycleWriter(writer);
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        Reject.ifNull(listener);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        SearchResultLdapPromiseImpl promise = LdapPromises.newSearchLdapPromise(messageID, request, entryHandler, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, promise);
            }
            try {
                LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter();
                try {
                    writer.writeSearchRequest(messageID, request);
                    this.connection.write(writer.getASN1Writer().getBuffer(), null);
                }
                finally {
                    GrizzlyUtils.recycleWriter(writer);
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (LdapException e) {
            promise.adaptErrorResult(e.getResult());
        }
        return promise;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.connection.getLocalAddress() + ',' + this.connection.getPeerAddress() + ')';
    }

    @Override
    public long handleTimeout(long currentTime) {
        if (this.requestTimeoutMS <= 0L) {
            return 0L;
        }
        long delay = this.requestTimeoutMS;
        for (ResultLdapPromiseImpl<?, ?> promise : this.pendingRequests.values()) {
            Result result;
            if (promise == null || !promise.checkForTimeout()) continue;
            long diff = promise.getTimestamp() + this.requestTimeoutMS - currentTime;
            if (diff > 0L) {
                delay = Math.min(delay, diff);
                continue;
            }
            if (this.pendingRequests.remove(promise.getRequestID()) == null) continue;
            if (promise.isBindOrStartTLS()) {
                logger.debug(LocalizableMessage.raw("Failing bind or StartTLS request due to timeout %s(connection will be invalidated): ", promise));
                result = Responses.newResult(ResultCode.CLIENT_SIDE_TIMEOUT).setDiagnosticMessage(GrizzlyMessages.LDAP_CONNECTION_BIND_OR_START_TLS_REQUEST_TIMEOUT.get(this.requestTimeoutMS).toString());
                promise.adaptErrorResult(result);
                Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_TIMEOUT).setDiagnosticMessage(GrizzlyMessages.LDAP_CONNECTION_BIND_OR_START_TLS_CONNECTION_TIMEOUT.get(this.requestTimeoutMS).toString());
                this.connectionErrorOccurred(errorResult);
                continue;
            }
            logger.debug(LocalizableMessage.raw("Failing request due to timeout: %s", promise));
            result = Responses.newResult(ResultCode.CLIENT_SIDE_TIMEOUT).setDiagnosticMessage(GrizzlyMessages.LDAP_CONNECTION_REQUEST_TIMEOUT.get(this.requestTimeoutMS).toString());
            promise.adaptErrorResult(result);
        }
        return delay;
    }

    @Override
    public long getTimeout() {
        return this.requestTimeoutMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(UnbindRequest unbindRequest, boolean isDisconnectNotification, Result reason) {
        List<ConnectionEventListener> tmpListeners;
        boolean notifyErrorOccurred;
        boolean notifyClose;
        Iterator<Object> iterator = this.stateLock;
        synchronized (iterator) {
            if (this.isClosed) {
                return;
            }
            if (unbindRequest != null) {
                notifyClose = true;
                notifyErrorOccurred = false;
                this.isClosed = true;
                tmpListeners = this.listeners;
                this.listeners = null;
                if (this.connectionInvalidReason == null) {
                    this.connectionInvalidReason = reason;
                }
            } else {
                if (this.isFailed) {
                    return;
                }
                notifyClose = false;
                notifyErrorOccurred = true;
                this.isFailed = true;
                this.failedDueToDisconnect = isDisconnectNotification;
                this.connectionInvalidReason = reason;
                tmpListeners = this.listeners;
            }
        }
        iterator = ((ConcurrentHashMap.KeySetView)this.pendingRequests.keySet()).iterator();
        while (iterator.hasNext()) {
            int requestID = (Integer)iterator.next();
            ResultLdapPromiseImpl<?, ?> promise = this.pendingRequests.remove(requestID);
            if (promise == null) continue;
            promise.adaptErrorResult(this.connectionInvalidReason);
        }
        if (notifyClose) {
            LDAPWriter<ASN1BufferWriter> writer = GrizzlyUtils.getWriter();
            try {
                writer.writeUnbindRequest(this.nextMsgID.getAndIncrement(), unbindRequest);
                this.connection.write(writer.getASN1Writer().getBuffer(), null);
            }
            catch (Exception requestID) {
            }
            finally {
                GrizzlyUtils.recycleWriter(writer);
            }
            this.factory.getTimeoutChecker().removeListener(this);
            this.connection.closeSilently();
            this.factory.releaseTransportAndTimeoutChecker();
        }
        if (tmpListeners != null) {
            if (notifyErrorOccurred) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleConnectionError(isDisconnectNotification, LdapException.newLdapException(reason));
                }
            }
            if (notifyClose) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleConnectionClosed();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int continuePendingBindRequest(BindResultLdapPromiseImpl promise) throws LdapException {
        int newMsgID = this.nextMsgID.getAndIncrement();
        Object object = this.stateLock;
        synchronized (object) {
            this.checkConnectionIsValid();
            this.pendingRequests.put(newMsgID, promise);
        }
        return newMsgID;
    }

    Options getLDAPOptions() {
        return this.factory.getLDAPOptions();
    }

    ResultLdapPromiseImpl<?, ?> getPendingRequest(Integer messageID) {
        return this.pendingRequests.get(messageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnsolicitedNotification(ExtendedResult result) {
        List<ConnectionEventListener> tmpListeners;
        Iterator<ConnectionEventListener> iterator = this.stateLock;
        synchronized (iterator) {
            tmpListeners = this.listeners;
        }
        if (tmpListeners != null) {
            for (ConnectionEventListener listener : tmpListeners) {
                listener.handleUnsolicitedNotification(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void installFilter(Filter filter) {
        Object object = this.stateLock;
        synchronized (object) {
            GrizzlyUtils.addFilterToConnection(filter, this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTLSEnabled() {
        Object object = this.stateLock;
        synchronized (object) {
            FilterChain currentFilterChain = (FilterChain)this.connection.getProcessor();
            for (Filter filter : currentFilterChain) {
                if (!(filter instanceof SSLFilter)) continue;
                return true;
            }
            return false;
        }
    }

    ResultLdapPromiseImpl<?, ?> removePendingRequest(Integer messageID) {
        return this.pendingRequests.remove(messageID);
    }

    void setBindOrStartTLSInProgress(boolean state) {
        this.bindOrStartTLSInProgress.set(state);
    }

    @Override
    public Promise<Void, LdapException> enableTLS(SSLContext sslContext, List<String> sslEnabledProtocols, List<String> sslEnabledCipherSuites) {
        final PromiseImpl<Void, LdapException> promise = PromiseImpl.create();
        EmptyCompletionHandler<SSLEngine> completionHandler = new EmptyCompletionHandler<SSLEngine>(){

            @Override
            public void completed(SSLEngine result) {
                promise.handleResult(null);
            }

            @Override
            public void failed(Throwable throwable) {
                Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setCause(throwable).setDiagnosticMessage("SSL handshake failed");
                GrizzlyLDAPConnection.this.connectionErrorOccurred(errorResult);
                promise.handleException(LdapException.newLdapException(errorResult));
            }
        };
        try {
            this.startTLS(sslContext, sslEnabledProtocols, sslEnabledCipherSuites, (CompletionHandler<SSLEngine>)completionHandler);
        }
        catch (IOException e) {
            completionHandler.failed(e);
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTLS(SSLContext sslContext, List<String> protocols, List<String> cipherSuites, CompletionHandler<SSLEngine> completionHandler) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isTLSEnabled()) {
                throw new IllegalStateException("TLS already enabled");
            }
            SSLEngineConfigurator sslEngineConfigurator = new SSLEngineConfigurator(sslContext, true, false, false);
            sslEngineConfigurator.setEnabledProtocols(protocols.isEmpty() ? null : protocols.toArray(new String[protocols.size()]));
            sslEngineConfigurator.setEnabledCipherSuites(cipherSuites.isEmpty() ? null : cipherSuites.toArray(new String[cipherSuites.size()]));
            SSLFilter sslFilter = new SSLFilter(DUMMY_SSL_ENGINE_CONFIGURATOR, sslEngineConfigurator);
            this.installFilter(sslFilter);
            sslFilter.handshake(this.connection, completionHandler);
        }
    }

    private LdapException adaptRequestIOException(IOException e) {
        Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_ENCODING_ERROR).setCause(e);
        this.connectionErrorOccurred(errorResult);
        return LdapException.newLdapException(errorResult);
    }

    private void checkBindOrStartTLSInProgress() throws LdapException {
        if (this.bindOrStartTLSInProgress.get()) {
            throw LdapException.newLdapException(ResultCode.OPERATIONS_ERROR, "Bind or Start TLS operation in progress");
        }
    }

    private void checkConnectionIsValid() throws LdapException {
        if (!this.isValid0()) {
            if (this.failedDueToDisconnect) {
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_SERVER_DOWN, "Connection closed by server");
            }
            throw LdapException.newLdapException(this.connectionInvalidReason);
        }
    }

    private void connectionErrorOccurred(Result reason) {
        this.close(null, false, reason);
    }

    private boolean isValid0() {
        return !this.isFailed && !this.isClosed;
    }

    static {
        try {
            DUMMY_SSL_ENGINE_CONFIGURATOR = new SSLEngineConfigurator(new SSLContextBuilder().setTrustManager(TrustManagers.distrustAll()).getSSLContext());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Unable to create Dummy SSL Engine Configurator", e);
        }
        logger = LocalizedLogger.getLoggerForThisClass();
    }
}

