/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

public final class UseSchemaAsync {
    private static Connection connection;
    private static int resultCode;
    private static final CountDownLatch COMPLETION_LATCH;

    public static void main(String[] args) {
        Entry entry;
        if (args.length != 4) {
            System.err.println("Usage: host port bindDN bindPassword");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        final String bindDn = args[2];
        final char[] bindPassword = args[3].toCharArray();
        try {
            System.out.println("Enter entry to add in LDIF format:");
            entry = new LDIFEntryReader(System.in).readEntry();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            return;
        }
        final String entryDn = entry.getName().toString();
        new LDAPConnectionFactory(host, port).getConnectionAsync().thenAsync(new AsyncFunction<Connection, BindResult, LdapException>(){

            @Override
            public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                connection = connection;
                return connection.bindAsync(Requests.newSimpleBindRequest(bindDn, bindPassword));
            }
        }).thenAsync(new AsyncFunction<BindResult, Schema, LdapException>(){

            @Override
            public Promise<Schema, LdapException> apply(BindResult bindResult) throws LdapException {
                return Schema.readSchemaForEntryAsync(connection, DN.rootDN());
            }
        }).thenAsync(new AsyncFunction<Schema, Result, LdapException>(){

            @Override
            public Promise<Result, LdapException> apply(Schema schema) throws LdapException {
                LinkedList<LocalizableMessage> schemaErrors = new LinkedList<LocalizableMessage>();
                boolean isValid = schema.validateEntry(entry, SchemaValidationPolicy.defaultPolicy(), schemaErrors);
                if (isValid) {
                    System.out.println("Processing ADD request for " + entryDn);
                    return connection.addAsync(Requests.newAddRequest(entry));
                }
                for (LocalizableMessage error : schemaErrors) {
                    System.err.println(error);
                }
                return Promises.newExceptionPromise(LdapException.newLdapException(ResultCode.CLIENT_SIDE_PARAM_ERROR, "Entry does not conform to schema."));
            }
        }).thenOnResult(new ResultHandler<Result>(){

            @Override
            public void handleResult(Result result) {
                System.out.println("ADD operation successful for DN " + entryDn);
                resultCode = result.getResultCode().intValue();
                COMPLETION_LATCH.countDown();
            }
        }).thenOnException(new ExceptionHandler<LdapException>(){

            @Override
            public void handleException(LdapException e) {
                System.err.println(e.getMessage());
                resultCode = e.getResult().getResultCode().intValue();
                COMPLETION_LATCH.countDown();
            }
        });
        try {
            COMPLETION_LATCH.await();
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_USER_CANCELLED.intValue());
            return;
        }
        Utils.closeSilently(connection);
        System.exit(resultCode);
    }

    private UseSchemaAsync() {
    }

    static {
        COMPLETION_LATCH = new CountDownLatch(1);
    }
}

