/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.util.LinkedList;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldif.LDIFEntryReader;

public final class UseSchema {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("Usage: host port bindDN bindPassword");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String bindDn = args[2];
        String bindPassword = args[3];
        LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port);
        try (Connection connection = null;){
            connection = factory.getConnection();
            connection.bind(bindDn, bindPassword.toCharArray());
            Schema schema = null;
            try {
                schema = Schema.readSchema(connection, DN.valueOf("cn=schema"));
            }
            catch (EntryNotFoundException e) {
                System.err.println(e.getMessage());
                schema = Schema.getDefaultSchema();
            }
            finally {
                if (schema == null) {
                    System.err.println("Failed to get schema.");
                    System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
                }
            }
            LDIFEntryReader reader = new LDIFEntryReader(System.in);
            Entry entry = reader.readEntry();
            LinkedList<LocalizableMessage> schemaErrors = new LinkedList<LocalizableMessage>();
            boolean conformsToSchema = schema.validateEntry(entry, SchemaValidationPolicy.defaultPolicy(), schemaErrors);
            String entryDn = entry.getName().toString();
            Result result = null;
            if (conformsToSchema) {
                System.out.println("Processing ADD request for " + entryDn);
                result = connection.add(entry);
            } else {
                for (LocalizableMessage error : schemaErrors) {
                    System.err.println(error);
                }
                System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            }
            if (result != null) {
                System.out.println("ADD operation successful for DN " + entryDn);
            }
        }
    }

    private UseSchema() {
    }
}

